/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.api.common.queries;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.java.api.common.SourceRoots;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.queries.SharabilityQueryImplementation;
import org.openide.util.Mutex;

class SharabilityQueryImpl
implements SharabilityQueryImplementation,
PropertyChangeListener {
    private final AntProjectHelper helper;
    private final PropertyEvaluator evaluator;
    private final SourceRoots srcRoots;
    private final SourceRoots testRoots;
    private final List<String> additionalSourceRoots;
    private SharabilityQueryImplementation delegate;

    public SharabilityQueryImpl(AntProjectHelper antProjectHelper, PropertyEvaluator propertyEvaluator, SourceRoots sourceRoots, SourceRoots sourceRoots2, String ... stringArray) {
        assert (antProjectHelper != null);
        assert (propertyEvaluator != null);
        assert (sourceRoots != null);
        assert (sourceRoots2 != null);
        this.helper = antProjectHelper;
        this.evaluator = propertyEvaluator;
        this.srcRoots = sourceRoots;
        this.testRoots = sourceRoots2;
        this.additionalSourceRoots = stringArray != null ? Collections.unmodifiableList(Arrays.asList(stringArray)) : Collections.emptyList();
        this.srcRoots.addPropertyChangeListener(this);
        this.testRoots.addPropertyChangeListener(this);
    }

    public int getSharability(final File file) {
        return (Integer)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<Integer>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Integer run() {
                SharabilityQueryImpl sharabilityQueryImpl = SharabilityQueryImpl.this;
                synchronized (sharabilityQueryImpl) {
                    if (SharabilityQueryImpl.this.delegate == null) {
                        SharabilityQueryImpl.this.delegate = SharabilityQueryImpl.this.createDelegate();
                    }
                    return SharabilityQueryImpl.this.delegate.getSharability(file);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (SourceRoots.PROP_ROOT_PROPERTIES.equals(propertyChangeEvent.getPropertyName())) {
            SharabilityQueryImpl sharabilityQueryImpl = this;
            synchronized (sharabilityQueryImpl) {
                this.delegate = null;
            }
        }
    }

    private SharabilityQueryImplementation createDelegate() {
        String[] stringArray = this.srcRoots.getRootProperties();
        String[] stringArray2 = this.testRoots.getRootProperties();
        String[] stringArray3 = new String[]{"${dist.dir}", "${build.dir}"};
        int n = stringArray.length;
        n += stringArray2.length;
        ArrayList<String> arrayList = new ArrayList<String>(n += this.additionalSourceRoots.size());
        for (String string : stringArray) {
            arrayList.add("${" + string + "}");
        }
        for (String string : stringArray2) {
            arrayList.add("${" + string + "}");
        }
        arrayList.addAll(this.additionalSourceRoots);
        return this.helper.createSharabilityQuery(this.evaluator, arrayList.toArray(new String[arrayList.size()]), stringArray3);
    }
}

