/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.jaxws.nodes;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.jaxws.nodes.JaxWsClientRootNode;
import org.netbeans.modules.maven.jaxws.nodes.JaxWsRootNode;
import org.netbeans.modules.websvc.jaxws.light.api.JAXWSLightSupport;
import org.netbeans.modules.websvc.jaxws.light.api.JaxWsService;
import org.netbeans.modules.websvc.jaxws.light.spi.JAXWSLightSupportProvider;
import org.netbeans.modules.websvc.project.api.WebServiceData;
import org.netbeans.spi.project.ui.support.NodeFactory;
import org.netbeans.spi.project.ui.support.NodeList;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.WeakListeners;

public class JaxWsNodeFactory
implements NodeFactory {
    public NodeList createNodes(Project project) {
        assert (project != null);
        return new WsNodeList(project);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class WsNodeList
    implements NodeList<String>,
    PropertyChangeListener,
    LookupListener {
        private static final String KEY_SERVICES = "web_services";
        private static final String KEY_SERVICE_REFS = "serviceRefs";
        private Project project;
        private JAXWSLightSupport jaxwsSupport;
        private List<ChangeListener> listeners = new ArrayList<ChangeListener>();
        private Lookup.Result<JAXWSLightSupportProvider> lookupResult;

        public WsNodeList(Project project) {
            this.project = project;
        }

        public List<String> keys() {
            ArrayList<String> arrayList = new ArrayList<String>();
            if (this.jaxwsSupport != null) {
                List list = this.jaxwsSupport.getServices();
                boolean bl = false;
                boolean bl2 = false;
                for (JaxWsService jaxWsService : list) {
                    if (!bl && jaxWsService.isServiceProvider()) {
                        bl = true;
                    } else if (!bl2 && !jaxWsService.isServiceProvider()) {
                        bl2 = true;
                    }
                    if (!bl || !bl2) continue;
                    break;
                }
                if (bl) {
                    arrayList.add(KEY_SERVICES);
                }
                if (bl2) {
                    arrayList.add(KEY_SERVICE_REFS);
                }
            }
            return arrayList;
        }

        public synchronized void addChangeListener(ChangeListener changeListener) {
            this.listeners.add(changeListener);
        }

        public synchronized void removeChangeListener(ChangeListener changeListener) {
            this.listeners.remove(changeListener);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void fireChange() {
            ArrayList<ChangeListener> arrayList = new ArrayList<ChangeListener>();
            WsNodeList wsNodeList = this;
            synchronized (wsNodeList) {
                arrayList.addAll(this.listeners);
            }
            for (ChangeListener changeListener : arrayList) {
                changeListener.stateChanged(new ChangeEvent(this));
            }
        }

        public Node node(String string) {
            if (KEY_SERVICES.equals(string)) {
                WebServiceData webServiceData = WebServiceData.getWebServiceData((Project)this.project);
                return new JaxWsRootNode(this.project, webServiceData);
            }
            if (KEY_SERVICE_REFS.equals(string)) {
                WebServiceData webServiceData = WebServiceData.getWebServiceData((Project)this.project);
                return new JaxWsClientRootNode(this.project, webServiceData);
            }
            return null;
        }

        public void addNotify() {
            if (this.jaxwsSupport == null) {
                this.jaxwsSupport = JAXWSLightSupport.getJAXWSLightSupport((FileObject)this.project.getProjectDirectory());
            }
            if (this.jaxwsSupport != null) {
                this.jaxwsSupport.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.jaxwsSupport));
            } else {
                this.lookupResult = this.project.getLookup().lookupResult(JAXWSLightSupportProvider.class);
                if (this.lookupResult.allInstances().size() == 0) {
                    this.lookupResult.addLookupListener((LookupListener)this);
                }
            }
        }

        public void removeNotify() {
            if (this.jaxwsSupport != null) {
                this.jaxwsSupport.removePropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.jaxwsSupport));
                this.jaxwsSupport = null;
            }
            if (this.lookupResult != null) {
                this.lookupResult.removeLookupListener((LookupListener)this);
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            this.fireChange();
        }

        public void resultChanged(LookupEvent lookupEvent) {
            this.jaxwsSupport = JAXWSLightSupport.getJAXWSLightSupport((FileObject)this.project.getProjectDirectory());
            if (this.jaxwsSupport != null) {
                this.jaxwsSupport.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.jaxwsSupport));
            }
        }
    }
}

