/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spring.beans.completion.completors;

import java.io.IOException;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.modules.spring.beans.completion.CompletionContext;
import org.netbeans.modules.spring.beans.completion.Completor;
import org.netbeans.modules.spring.beans.completion.CompletorUtils;
import org.netbeans.modules.spring.beans.completion.SpringXMLConfigCompletionItem;
import org.netbeans.modules.spring.java.JavaUtils;
import org.netbeans.modules.spring.java.Public;
import org.netbeans.modules.spring.java.Static;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JavaMethodCompletor
extends Completor {
    public JavaMethodCompletor(int n) {
        super(n);
    }

    @Override
    protected int initAnchorOffset(CompletionContext completionContext) {
        return completionContext.getCurrentToken().getOffset() + 1;
    }

    @Override
    protected void compute(final CompletionContext completionContext) throws IOException {
        final String string = this.getTypeName(completionContext);
        final Public public_ = this.getPublicFlag(completionContext);
        final Static static_ = this.getStaticFlag(completionContext);
        final int n = this.getArgCount(completionContext);
        if (string == null || string.equals("")) {
            return;
        }
        JavaSource javaSource = JavaUtils.getJavaSource(completionContext.getFileObject());
        if (javaSource == null) {
            return;
        }
        javaSource.runUserActionTask((Task)new Task<CompilationController>(){

            public void run(CompilationController compilationController) throws Exception {
                compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                if (string == null) {
                    return;
                }
                TypeElement typeElement = JavaUtils.findClassElementByBinaryName(string, compilationController);
                if (typeElement == null) {
                    return;
                }
                ElementUtilities elementUtilities = compilationController.getElementUtilities();
                ElementUtilities.ElementAcceptor elementAcceptor = new ElementUtilities.ElementAcceptor(){

                    public boolean accept(Element element, TypeMirror typeMirror) {
                        if (element.getKind() == ElementKind.METHOD) {
                            boolean bl;
                            TypeElement typeElement = (TypeElement)element.getEnclosingElement();
                            if (typeElement.getQualifiedName().contentEquals("java.lang.Object")) {
                                return false;
                            }
                            if (!element.getSimpleName().toString().startsWith(completionContext.getTypedPrefix())) {
                                return false;
                            }
                            ExecutableElement executableElement = (ExecutableElement)element;
                            if (n != -1 && executableElement.getParameters().size() != n) {
                                return false;
                            }
                            if (static_ != Static.DONT_CARE && ((bl = executableElement.getModifiers().contains((Object)Modifier.STATIC)) && static_ == Static.NO || !bl && static_ == Static.YES)) {
                                return false;
                            }
                            return public_ == Public.DONT_CARE || (!(bl = executableElement.getModifiers().contains((Object)Modifier.PUBLIC)) || public_ != Public.NO) && (bl || public_ != Public.YES);
                        }
                        return false;
                    }
                };
                Iterable<? extends Element> iterable = elementUtilities.getMembers(typeElement.asType(), elementAcceptor);
                iterable = JavaMethodCompletor.this.filter(iterable);
                for (Element element : iterable) {
                    SpringXMLConfigCompletionItem springXMLConfigCompletionItem = SpringXMLConfigCompletionItem.createMethodItem(JavaMethodCompletor.this.getAnchorOffset(), (ExecutableElement)element, element.getEnclosingElement() != typeElement, compilationController.getElements().isDeprecated(element));
                    JavaMethodCompletor.this.addCacheItem(springXMLConfigCompletionItem);
                }
            }
        }, false);
    }

    @Override
    public boolean canFilter(CompletionContext completionContext) {
        return CompletorUtils.canFilter(completionContext.getDocument(), this.getInvocationOffset(), completionContext.getCaretOffset(), this.getAnchorOffset(), CompletorUtils.JAVA_IDENTIFIER_ACCEPTOR);
    }

    @Override
    protected List<SpringXMLConfigCompletionItem> doFilter(CompletionContext completionContext) {
        return CompletorUtils.filter(this.getCacheItems(), completionContext.getDocument(), this.getInvocationOffset(), completionContext.getCaretOffset(), this.getAnchorOffset());
    }

    protected abstract Public getPublicFlag(CompletionContext var1);

    protected abstract Static getStaticFlag(CompletionContext var1);

    protected abstract int getArgCount(CompletionContext var1);

    protected abstract String getTypeName(CompletionContext var1);

    protected Iterable<? extends Element> filter(Iterable<? extends Element> iterable) {
        return iterable;
    }
}

