/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spring.beans.editor;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.TokenItem;
import org.netbeans.modules.spring.beans.editor.ContextUtilities;
import org.netbeans.modules.xml.text.syntax.SyntaxElement;
import org.netbeans.modules.xml.text.syntax.XMLSyntaxSupport;
import org.netbeans.modules.xml.text.syntax.dom.EmptyTag;
import org.netbeans.modules.xml.text.syntax.dom.StartTag;
import org.netbeans.modules.xml.text.syntax.dom.Tag;
import org.w3c.dom.Attr;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocumentContext {
    private Document document;
    private XMLSyntaxSupport syntaxSupport;
    private int caretOffset = -1;
    private SyntaxElement element;
    private TokenItem token;
    private HashMap<String, String> declaredNamespaces = new HashMap();

    public static DocumentContext create(Document document, int n) {
        try {
            return new DocumentContext(document, n);
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    private DocumentContext(Document document, int n) throws BadLocationException {
        this.document = document;
        this.syntaxSupport = (XMLSyntaxSupport)((BaseDocument)document).getSyntaxSupport();
        this.caretOffset = n;
        this.initialize();
    }

    private void initialize() throws BadLocationException {
        this.element = this.syntaxSupport.getElementChain(this.caretOffset);
        this.token = this.syntaxSupport.getTokenChain(this.caretOffset, Math.min(this.document.getLength(), this.caretOffset + 1));
        this.populateNamespaces();
    }

    public int getCurrentTokenId() {
        return this.token.getTokenID().getNumericID();
    }

    public TokenItem getCurrentToken() {
        return this.token;
    }

    public String getCurrentTokenImage() {
        return this.token.getImage();
    }

    public SyntaxElement getCurrentElement() {
        return this.element;
    }

    public String lookupNamespacePrefix(String string) {
        return this.declaredNamespaces.get(string);
    }

    public String getNamespacePrefix(String string) {
        for (Map.Entry<String, String> entry : this.declaredNamespaces.entrySet()) {
            if (!entry.getValue().equals(string)) continue;
            return entry.getKey();
        }
        return null;
    }

    public Collection<String> getDeclaredNamespaces() {
        return this.declaredNamespaces.values();
    }

    public Map<String, String> getDeclaredNamespacesMap() {
        return this.declaredNamespaces;
    }

    public int getCaretOffset() {
        return this.caretOffset;
    }

    private void populateNamespaces() {
        SyntaxElement syntaxElement;
        for (syntaxElement = this.element; syntaxElement != null && !(syntaxElement instanceof StartTag) && !(syntaxElement instanceof EmptyTag); syntaxElement = syntaxElement.getPrevious()) {
        }
        if (syntaxElement == null) {
            return;
        }
        for (Node node = (Node)syntaxElement; node != null; node = node.getParentNode()) {
            if (!(node instanceof StartTag) && !(node instanceof EmptyTag)) continue;
            NamedNodeMap namedNodeMap = ((Tag)node).getAttributes();
            for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                String string;
                Attr attr = (Attr)namedNodeMap.item(i);
                String string2 = attr.getName();
                String string3 = attr.getValue();
                if (string2 == null || string3 == null || (string = ContextUtilities.getPrefixFromNamespaceDeclaration(string2)) == null || this.declaredNamespaces.containsKey(string)) continue;
                this.declaredNamespaces.put(string, string3);
            }
        }
    }
}

