/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spring.beans.refactoring;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.text.BadLocationException;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.modules.spring.api.Action;
import org.netbeans.modules.spring.api.beans.SpringScope;
import org.netbeans.modules.spring.api.beans.model.SpringConfigModel;
import org.netbeans.modules.spring.beans.refactoring.JavaElementRefFinder;
import org.netbeans.modules.spring.beans.refactoring.PropertyRefFinder;
import org.netbeans.modules.spring.beans.refactoring.SpringRefactorings;
import org.openide.filesystems.FileObject;
import org.openide.text.PositionBounds;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Occurrences {
    public static List<Occurrence> getPropertyOccurrences(final SpringRefactorings.RenamedProperty renamedProperty, JavaSource javaSource, final SpringScope springScope) throws IOException {
        final ArrayList<Occurrence> arrayList = new ArrayList<Occurrence>();
        final HashSet hashSet = new HashSet();
        javaSource.runUserActionTask((Task)new Task<CompilationController>(){

            public void run(final CompilationController compilationController) throws Exception {
                for (SpringConfigModel springConfigModel : springScope.getAllConfigModels()) {
                    springConfigModel.runDocumentAction(new Action<SpringConfigModel.DocumentAccess>(){

                        @Override
                        public void run(SpringConfigModel.DocumentAccess documentAccess) {
                            File file = documentAccess.getFile();
                            if (hashSet.contains(file)) {
                                return;
                            }
                            hashSet.add(file);
                            try {
                                new PropertyRefFinder(documentAccess, compilationController, renamedProperty).addOccurrences(arrayList);
                            }
                            catch (BadLocationException badLocationException) {
                                Exceptions.printStackTrace((Throwable)badLocationException);
                            }
                        }
                    });
                }
            }
        }, true);
        return arrayList;
    }

    public static List<Occurrence> getJavaClassOccurrences(final String string, SpringScope springScope) throws IOException {
        final ArrayList<Occurrence> arrayList = new ArrayList<Occurrence>();
        final HashSet hashSet = new HashSet();
        for (SpringConfigModel springConfigModel : springScope.getAllConfigModels()) {
            springConfigModel.runDocumentAction(new Action<SpringConfigModel.DocumentAccess>(){

                @Override
                public void run(SpringConfigModel.DocumentAccess documentAccess) {
                    File file = documentAccess.getFile();
                    if (hashSet.contains(file)) {
                        return;
                    }
                    hashSet.add(file);
                    try {
                        new JavaElementRefFinder(documentAccess).addOccurrences(new JavaClassRefMatcher(string), arrayList);
                    }
                    catch (BadLocationException badLocationException) {
                        Exceptions.printStackTrace((Throwable)badLocationException);
                    }
                }
            });
        }
        return arrayList;
    }

    public static List<Occurrence> getJavaPackageOccurrences(final String string, final boolean bl, SpringScope springScope) throws IOException {
        final ArrayList<Occurrence> arrayList = new ArrayList<Occurrence>();
        final HashSet hashSet = new HashSet();
        for (SpringConfigModel springConfigModel : springScope.getAllConfigModels()) {
            springConfigModel.runDocumentAction(new Action<SpringConfigModel.DocumentAccess>(){

                @Override
                public void run(SpringConfigModel.DocumentAccess documentAccess) {
                    File file = documentAccess.getFile();
                    if (hashSet.contains(file)) {
                        return;
                    }
                    hashSet.add(file);
                    try {
                        new JavaElementRefFinder(documentAccess).addOccurrences(new JavaPackageRefMatcher(string, bl), arrayList);
                    }
                    catch (BadLocationException badLocationException) {
                        Exceptions.printStackTrace((Throwable)badLocationException);
                    }
                }
            });
        }
        return arrayList;
    }

    public static abstract class Occurrence {
        private final FileObject fo;
        private final PositionBounds position;

        Occurrence(FileObject fileObject, PositionBounds positionBounds) {
            this.fo = fileObject;
            this.position = positionBounds;
        }

        public FileObject getFileObject() {
            return this.fo;
        }

        public PositionBounds getPosition() {
            return this.position;
        }

        public abstract String getDisplayText();
    }

    static final class JavaPackageRefMatcher
    implements JavaElementRefFinder.Matcher {
        private final String packageName;
        private final boolean subpackages;

        public JavaPackageRefMatcher(String string, boolean bl) {
            this.packageName = string;
            this.subpackages = bl;
        }

        public String accept(String string) {
            if (!string.startsWith(this.packageName) || string.length() == this.packageName.length()) {
                return null;
            }
            if (this.subpackages) {
                return this.packageName;
            }
            int n = this.packageName.length() + 1;
            if (n < string.length() && string.indexOf(46, n) == -1) {
                return this.packageName;
            }
            return null;
        }
    }

    static final class JavaClassRefMatcher
    implements JavaElementRefFinder.Matcher {
        private final String className;

        public JavaClassRefMatcher(String string) {
            this.className = string;
        }

        public String accept(String string) {
            if (!string.startsWith(this.className)) {
                return null;
            }
            if (string.length() == this.className.length()) {
                return this.className;
            }
            if (string.charAt(this.className.length()) == '$') {
                return this.className;
            }
            return null;
        }
    }
}

