/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spring.beans.wizards;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.modules.spring.api.SpringUtilities;
import org.openide.awt.Mnemonics;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public final class SpringXMLConfigNamespacesVisual
extends JPanel {
    private Library springLibrary;
    private ClassPath classPath;
    private boolean addSpringToClassPath;
    private JButton addSpringButton;
    private JScrollPane includesScrollPane;
    private JTable includesTable;
    private JLabel springNotOnClassPathLabel;

    public SpringXMLConfigNamespacesVisual() {
        this.initComponents();
        this.includesTable.getParent().setBackground(this.includesTable.getBackground());
        TableColumn tableColumn = this.includesTable.getColumnModel().getColumn(0);
        tableColumn.setMaxWidth(0);
        this.includesTable.getSelectionModel().setSelectionMode(0);
        this.includesTable.revalidate();
        this.springLibrary = SpringUtilities.findSpringLibrary();
    }

    public String getName() {
        return NbBundle.getMessage(SpringXMLConfigNamespacesVisual.class, (String)"LBL_Namespaces_Include_Step");
    }

    public void setClassPath(ClassPath classPath) {
        this.classPath = classPath;
        this.updateClassPathWarning();
    }

    private void updateClassPathWarning() {
        boolean bl = this.classPath != null && SpringUtilities.containsSpring(this.classPath);
        boolean bl2 = !bl && !this.addSpringToClassPath && this.springLibrary != null;
        this.springNotOnClassPathLabel.setVisible(bl2);
        this.addSpringButton.setVisible(bl2);
    }

    private void initComponents() {
        this.includesScrollPane = new JScrollPane();
        this.includesTable = new JTable();
        this.addSpringButton = new JButton();
        this.springNotOnClassPathLabel = new JLabel();
        this.includesTable.setModel(new DefaultTableModel(new Object[][]{{null, "aop - http://www.springframework.org/schema/aop/spring-aop-2.5.xsd"}, {null, "context - http://www.springframework.org/schema/context/spring-context-2.5.xsd"}, {null, "flow - http://www.springframework.org/schema/webflow-config/spring-webflow-config-1.0.xsd"}, {null, "jms - http://www.springframework.org/schema/jms/spring-jms-2.5.xsd"}, {null, "jee - http://www.springframework.org/schema/jee/spring-jee-2.5.xsd"}, {null, "lang - http://www.springframework.org/schema/lang/spring-lang-2.5.xsd"}, {null, "osgi - http://www.springframework.org/schema/osgi/spring-osgi.xsd"}, {null, "tx - http://www.springframework.org/schema/tx/spring-tx-2.5.xsd"}, {null, "util - http://www.springframework.org/schema/util/spring-util-2.5.xsd"}, {null, "p - http://www.springframework.org/schema/p"}}, new String[]{"", ""}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{Boolean.class, String.class};
                this.canEdit = new boolean[]{true, false};
            }

            public Class getColumnClass(int n) {
                return this.types[n];
            }

            public boolean isCellEditable(int n, int n2) {
                return this.canEdit[n2];
            }
        });
        this.includesTable.setShowHorizontalLines(false);
        this.includesTable.setShowVerticalLines(false);
        this.includesTable.setTableHeader(null);
        this.includesTable.setShowGrid(false);
        this.includesTable.setDragEnabled(false);
        this.includesTable.setIntercellSpacing(new Dimension(0, 0));
        this.includesScrollPane.setViewportView(this.includesTable);
        Mnemonics.setLocalizedText((AbstractButton)this.addSpringButton, (String)NbBundle.getMessage(SpringXMLConfigNamespacesVisual.class, (String)"LBL_AddSpringFramework"));
        this.addSpringButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SpringXMLConfigNamespacesVisual.this.addSpringButtonActionPerformed(actionEvent);
            }
        });
        this.springNotOnClassPathLabel.setIcon(ImageUtilities.loadImageIcon((String)"org/netbeans/modules/spring/beans/resources/warning.gif", (boolean)false));
        Mnemonics.setLocalizedText((JLabel)this.springNotOnClassPathLabel, (String)NbBundle.getMessage(SpringXMLConfigNamespacesVisual.class, (String)"LBL_SpringNotOnClassPath"));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.includesScrollPane, -1, 447, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.addSpringButton).addContainerGap()).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.springNotOnClassPathLabel).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.includesScrollPane, -2, 196, -2).addPreferredGap(0, 36, Short.MAX_VALUE).add((Component)this.springNotOnClassPathLabel).addPreferredGap(0).add((Component)this.addSpringButton)));
    }

    private void addSpringButtonActionPerformed(ActionEvent actionEvent) {
        this.addSpringToClassPath = true;
        this.updateClassPathWarning();
    }

    public String[] getIncludedNamespaces() {
        ArrayList<String> arrayList = new ArrayList<String>();
        TableModel tableModel = this.includesTable.getModel();
        for (int i = 0; i < tableModel.getRowCount(); ++i) {
            Boolean bl = (Boolean)tableModel.getValueAt(i, 0);
            if (bl == null || bl != Boolean.TRUE) continue;
            String string = (String)tableModel.getValueAt(i, 1);
            arrayList.add(string);
        }
        return arrayList.toArray(new String[0]);
    }

    public boolean getAddSpringToClassPath() {
        return this.addSpringToClassPath;
    }

    public Library getSpringLibrary() {
        return this.springLibrary;
    }
}

