/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spring.java;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.modules.spring.beans.utils.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FieldNamesCalculator {
    private final String typeName;
    private final Set<String> forbidden;
    private static Pattern pattern = Pattern.compile("(\\p{javaUpperCase}(?:\\p{javaLowerCase}|\\d|\\-)*)");

    public FieldNamesCalculator(String string, Set<String> set) {
        this.typeName = string;
        this.forbidden = set;
    }

    public List<String> calculate() {
        ArrayList<String> arrayList = new ArrayList<String>();
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        Matcher matcher = pattern.matcher(this.typeName);
        if (matcher.find()) {
            String string;
            int n = matcher.start();
            if (n > 0) {
                string = this.typeName.substring(0, n);
                arrayList.add(string);
            }
            string = matcher.group();
            arrayList.add(string);
            while (matcher.find()) {
                string = matcher.group();
                arrayList.add(string);
            }
            String[] stringArray = arrayList.toArray(new String[0]);
            for (int i = 0; i < stringArray.length; ++i) {
                StringBuilder stringBuilder = new StringBuilder(StringUtils.toLowerCamelCase(stringArray[i]));
                for (int j = i + 1; j < stringArray.length; ++j) {
                    linkedHashSet.add(this.findFreeFieldName(stringBuilder.toString()));
                    stringBuilder.append(stringArray[j]);
                }
                linkedHashSet.add(this.findFreeFieldName(stringBuilder.toString()));
            }
        } else {
            linkedHashSet.add(this.findFreeFieldName(this.typeName));
        }
        return Collections.unmodifiableList(new ArrayList(linkedHashSet));
    }

    private String findFreeFieldName(String string) {
        if (!this.forbidden.contains(string)) {
            return string;
        }
        for (int i = 1; i < Integer.MAX_VALUE; ++i) {
            String string2 = string + Integer.toString(i);
            if (this.forbidden.contains(string2)) continue;
            return string2;
        }
        return null;
    }
}

