/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.mobility.activesync;

public class RemoteFile {
    public static final String FILE_SEPARATOR = "\\";
    private String parentDir;
    private String name;
    private boolean isRoot;

    public RemoteFile(String string, String string2) {
        this(string, string2, false);
    }

    private RemoteFile(String string, String string2, boolean bl) {
        if (bl) {
            this.parentDir = string;
            string2 = "";
            this.isRoot = bl;
        } else {
            try {
                StringBuilder stringBuilder = new StringBuilder(FILE_SEPARATOR);
                stringBuilder.append(string.trim());
                if (string2.trim().length() > 0) {
                    stringBuilder.append(FILE_SEPARATOR);
                    stringBuilder.append(string2.trim());
                }
                String string3 = stringBuilder.toString();
                int n = 0;
                while ((n = stringBuilder.indexOf("\\\\", n)) >= 0) {
                    stringBuilder.deleteCharAt(n);
                }
                this.parentDir = stringBuilder.lastIndexOf(FILE_SEPARATOR) == 0 ? FILE_SEPARATOR : stringBuilder.substring(0, stringBuilder.lastIndexOf(FILE_SEPARATOR));
                this.name = stringBuilder.substring(stringBuilder.lastIndexOf(FILE_SEPARATOR) + 1);
                this.isRoot = false;
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("bad parentDir or file name: " + string + " , " + string2);
            }
        }
    }

    public boolean canRead() {
        if (this.isRoot) {
            return true;
        }
        return this.nCanRead(this.getFullPath());
    }

    public boolean canWrite() {
        if (this.isRoot) {
            return true;
        }
        return this.nCanWrite(this.getFullPath());
    }

    public boolean isDirectory() {
        if (this.isRoot) {
            return true;
        }
        return this.nIsDirectory(this.getFullPath());
    }

    public boolean exists() {
        if (this.isRoot) {
            return true;
        }
        return this.nExists(this.getFullPath());
    }

    public String getName() {
        if (this.isRoot) {
            return this.parentDir;
        }
        return this.name;
    }

    public String getParentDirName() {
        if (this.isRoot) {
            return null;
        }
        return this.parentDir;
    }

    public RemoteFile getParentDir() {
        if (this.isRoot) {
            return null;
        }
        if (this.parentDir.equals(FILE_SEPARATOR)) {
            return new RemoteFile(FILE_SEPARATOR, "", true);
        }
        return new RemoteFile(this.parentDir, "");
    }

    public int getLength() {
        if (this.isDirectory()) {
            return 0;
        }
        return this.nGetLength(this.getFullPath());
    }

    public long getLastModified() {
        return this.nLastModified(this.getFullPath());
    }

    public String getFullPath() {
        if (this.isRoot) {
            return this.parentDir;
        }
        if (this.parentDir.equals(FILE_SEPARATOR)) {
            return this.parentDir + this.getName();
        }
        return this.getParentDirName() + FILE_SEPARATOR + this.getName();
    }

    public static boolean isRemoteDirName(String string) {
        return string != null && string.trim().length() > 0;
    }

    public static boolean isRemoteFileName(String string) {
        return RemoteFile.isRemoteDirName(string) && string.indexOf(92) < 0;
    }

    private native boolean nCanRead(String var1);

    private native boolean nCanWrite(String var1);

    private native boolean nExists(String var1);

    private native boolean nIsDirectory(String var1);

    private native int nGetLength(String var1);

    private native long nLastModified(String var1);
}

