/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.junit;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePathScanner;
import com.sun.source.util.Trees;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.swing.JEditorPane;
import javax.swing.text.StyledDocument;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.queries.UnitTestForSourceQuery;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.modules.junit.TestAction;
import org.netbeans.modules.junit.TestUtil;
import org.netbeans.spi.java.classpath.PathResourceImplementation;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.LineCookie;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.text.Line;
import org.openide.text.NbDocument;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenTestAction
extends TestAction {
    public OpenTestAction() {
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    protected void performAction(Node[] nodeArray) {
        for (int i = 0; i < nodeArray.length; ++i) {
            Object[] objectArray;
            String string;
            boolean bl;
            FileObject fileObject = TestUtil.getFileObjectFromNode(nodeArray[i]);
            if (fileObject == null) {
                TestUtil.notifyUser(NbBundle.getMessage(OpenTestAction.class, (String)"MSG_file_from_node_failed"));
                continue;
            }
            ClassPath classPath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source");
            if (classPath == null) {
                TestUtil.notifyUser(NbBundle.getMessage(OpenTestAction.class, (String)"MSG_no_project", (Object)fileObject));
                continue;
            }
            FileObject fileObject2 = classPath.findOwnerRoot(fileObject);
            URL[] uRLArray = UnitTestForSourceQuery.findUnitTests((FileObject)fileObject2);
            FileObject fileObject3 = null;
            for (int j = 0; j < uRLArray.length && (fileObject3 = OpenTestAction.findUnitTestInTestRoot(classPath, fileObject, uRLArray[j])) == null; ++j) {
            }
            if (fileObject3 != null) {
                OpenTestAction.openFile(fileObject3);
                continue;
            }
            String string2 = OpenTestAction.getTestName(classPath, fileObject).replace('/', '.');
            String string3 = classPath.getResourceName(fileObject, '.', false);
            boolean bl2 = fileObject.isFolder();
            boolean bl3 = bl = bl2 && string3.length() == 0;
            String string4 = !bl2 ? "MSG_test_class_not_found" : (string = bl ? "MSG_testsuite_class_not_found_def_pkg" : "MSG_testsuite_class_not_found");
            if (bl) {
                Object[] objectArray2 = new String[1];
                objectArray = objectArray2;
                objectArray2[0] = string2;
            } else {
                String[] stringArray = new String[2];
                stringArray[0] = string2;
                objectArray = stringArray;
                stringArray[1] = string3;
            }
            Object[] objectArray3 = objectArray;
            TestUtil.notifyUser(NbBundle.getMessage(OpenTestAction.class, (String)string, (Object[])objectArray3), 1);
        }
    }

    private static FileObject findUnitTestInTestRoot(ClassPath classPath, FileObject fileObject, URL uRL) {
        Object object;
        ClassPath classPath2 = null;
        if (uRL == null) {
            classPath2 = classPath;
        } else {
            try {
                object = new ArrayList<PathResourceImplementation>();
                object.add(ClassPathSupport.createResource((URL)uRL));
                classPath2 = ClassPathSupport.createClassPath((List)object);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                ErrorManager.getDefault().notify(1, (Throwable)illegalArgumentException);
                classPath2 = classPath;
            }
        }
        object = OpenTestAction.getTestName(classPath, fileObject);
        return classPath2.findResource((String)object + ".java");
    }

    private static String getTestName(ClassPath classPath, FileObject fileObject) {
        String string = classPath.getResourceName(fileObject, '/', false);
        String string2 = null;
        string2 = fileObject.isFolder() ? TestUtil.convertPackage2SuiteName(string) : TestUtil.convertClass2TestName(string);
        return string2;
    }

    public static boolean openFile(FileObject fileObject) {
        DataObject dataObject;
        try {
            dataObject = DataObject.find((FileObject)fileObject);
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            OpenTestAction.getLogger().log(Level.WARNING, null, dataObjectNotFoundException);
            return false;
        }
        assert (dataObject != null);
        EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
        if (editorCookie != null) {
            editorCookie.open();
            return true;
        }
        OpenCookie openCookie = (OpenCookie)dataObject.getCookie(OpenCookie.class);
        if (openCookie != null) {
            openCookie.open();
            return true;
        }
        return false;
    }

    static boolean openFileAtElement(FileObject fileObject, ElementHandle<Element> elementHandle) {
        DataObject dataObject;
        try {
            dataObject = DataObject.find((FileObject)fileObject);
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            OpenTestAction.getLogger().log(Level.INFO, null, dataObjectNotFoundException);
            return false;
        }
        assert (dataObject != null);
        EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
        if (editorCookie != null) {
            StyledDocument styledDocument;
            try {
                styledDocument = editorCookie.openDocument();
            }
            catch (IOException iOException) {
                String string = iOException.getLocalizedMessage();
                if (string == null) {
                    string = iOException.getMessage();
                }
                OpenTestAction.getLogger().log(Level.SEVERE, string, iOException);
                return false;
            }
            editorCookie.open();
            LineCookie lineCookie = (LineCookie)dataObject.getCookie(LineCookie.class);
            if (lineCookie != null && elementHandle != null && styledDocument != null) {
                int n;
                int n2;
                int n3 = -1;
                JEditorPane[] jEditorPaneArray = editorCookie.getOpenedPanes();
                if (jEditorPaneArray != null && jEditorPaneArray.length != 0) {
                    n3 = jEditorPaneArray[0].getCaretPosition();
                }
                int[] nArray = null;
                try {
                    nArray = OpenTestAction.getPositionRange(fileObject, elementHandle);
                }
                catch (IOException iOException) {
                    OpenTestAction.getLogger().log(Level.WARNING, null, iOException);
                }
                if ((n3 == -1 || nArray != null && (n3 < nArray[0] || n3 >= nArray[1])) && (n2 = NbDocument.findLineNumber((StyledDocument)styledDocument, (int)(n = nArray[0]))) != -1) {
                    Line line = lineCookie.getLineSet().getCurrent(n2);
                    try {
                        int n4 = NbDocument.findLineOffset((StyledDocument)styledDocument, (int)n2);
                        int n5 = n - n4;
                        line.show(Line.ShowOpenType.OPEN, Line.ShowVisibilityType.FOCUS, n5);
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        Logger.getLogger(OpenTestAction.class.getName()).log(Level.INFO, null, indexOutOfBoundsException);
                        line.show(Line.ShowOpenType.OPEN, Line.ShowVisibilityType.FOCUS);
                    }
                }
            }
            return true;
        }
        OpenCookie openCookie = (OpenCookie)dataObject.getCookie(OpenCookie.class);
        if (openCookie != null) {
            openCookie.open();
            return true;
        }
        return false;
    }

    private static Logger getLogger() {
        return Logger.getLogger(OpenTestAction.class.getName());
    }

    private static int[] getPositionRange(FileObject fileObject, ElementHandle<Element> elementHandle) throws IOException {
        PositionRangeFinder positionRangeFinder = new PositionRangeFinder(fileObject, elementHandle);
        JavaSource.forFileObject((FileObject)fileObject).runUserActionTask((Task)positionRangeFinder, true);
        return positionRangeFinder.getPositionRange();
    }

    public String getName() {
        return NbBundle.getMessage(OpenTestAction.class, (String)"LBL_Action_OpenTest");
    }

    protected String iconResource() {
        return "org/netbeans/modules/junit/resources/OpenTestActionIcon.gif";
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(OpenTestAction.class);
    }

    protected void initialize() {
        super.initialize();
        this.putProperty("ShortDescription", NbBundle.getMessage(OpenTestAction.class, (String)"HINT_Action_OpenTest"));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DeclarationTreeFinder
    extends TreePathScanner<Void, Void> {
        private final Element element;
        private final Trees trees;
        private Tree declTree;

        private DeclarationTreeFinder(Element element, Trees trees) {
            this.element = element;
            this.trees = trees;
        }

        @Override
        public Void visitClass(ClassTree classTree, Void void_) {
            if (this.declTree == null) {
                this.handleDeclaration();
                super.visitClass(classTree, void_);
            }
            return null;
        }

        @Override
        public Void visitMethod(MethodTree methodTree, Void void_) {
            if (this.declTree == null) {
                this.handleDeclaration();
                super.visitMethod(methodTree, void_);
            }
            return null;
        }

        public void handleDeclaration() {
            Element element = this.trees.getElement(this.getCurrentPath());
            if (((Object)this.element).equals(element)) {
                this.declTree = this.getCurrentPath().getLeaf();
            }
        }

        Tree getDeclarationTree() {
            return this.declTree;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PositionRangeFinder
    implements CancellableTask<CompilationController> {
        private final FileObject fileObj;
        private final ElementHandle<Element> elemHandle;
        private int[] positionRange = null;
        private volatile boolean cancelled;

        private PositionRangeFinder(FileObject fileObject, ElementHandle<Element> elementHandle) {
            this.fileObj = fileObject;
            this.elemHandle = elementHandle;
        }

        public void run(CompilationController compilationController) throws IOException {
            try {
                compilationController.toPhase(JavaSource.Phase.RESOLVED);
            }
            catch (IOException iOException) {
                Logger.getLogger("global").log(Level.SEVERE, null, iOException);
            }
            if (this.cancelled) {
                return;
            }
            Element element = this.elemHandle.resolve((CompilationInfo)compilationController);
            if (this.cancelled || element == null) {
                return;
            }
            Trees trees = compilationController.getTrees();
            CompilationUnitTree compilationUnitTree = compilationController.getCompilationUnit();
            DeclarationTreeFinder declarationTreeFinder = new DeclarationTreeFinder(element, trees);
            declarationTreeFinder.scan(compilationUnitTree, null);
            Tree tree = declarationTreeFinder.getDeclarationTree();
            if (tree != null) {
                SourcePositions sourcePositions = trees.getSourcePositions();
                long l = sourcePositions.getStartPosition(compilationUnitTree, tree);
                long l2 = sourcePositions.getEndPosition(compilationUnitTree, tree);
                if (l >= 0L && l <= Integer.MAX_VALUE && l2 >= 0L && l2 <= Integer.MAX_VALUE) {
                    this.positionRange = new int[2];
                    this.positionRange[0] = (int)l;
                    this.positionRange[1] = (int)l2;
                }
            }
        }

        public void cancel() {
            this.cancelled = true;
        }

        int[] getPositionRange() {
            return this.positionRange;
        }
    }
}

