/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.core;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.modules.websvc.core.ProjectWebServiceView;
import org.netbeans.modules.websvc.core.ProjectWebServiceViewImpl;
import org.openide.util.ChangeSupport;

public abstract class AbstractProjectWebServiceViewImpl
implements ProjectWebServiceViewImpl {
    private ChangeSupport serviceListeners;
    private ChangeSupport clientListeners;
    private Reference<Project> project;

    protected AbstractProjectWebServiceViewImpl(Project project) {
        this.project = new WeakReference<Project>(project);
        this.serviceListeners = new ChangeSupport((Object)this);
        this.clientListeners = new ChangeSupport((Object)this);
    }

    public void addChangeListener(ChangeListener changeListener, ProjectWebServiceView.ViewType viewType) {
        switch (viewType) {
            case SERVICE: {
                this.serviceListeners.addChangeListener(changeListener);
                break;
            }
            case CLIENT: {
                this.clientListeners.addChangeListener(changeListener);
            }
        }
    }

    public void removeChangeListener(ChangeListener changeListener, ProjectWebServiceView.ViewType viewType) {
        switch (viewType) {
            case SERVICE: {
                if (this.serviceListeners == null) break;
                this.serviceListeners.removeChangeListener(changeListener);
                break;
            }
            case CLIENT: {
                if (this.clientListeners == null) break;
                this.clientListeners.removeChangeListener(changeListener);
            }
        }
    }

    protected void fireChange(ProjectWebServiceView.ViewType viewType) {
        switch (viewType) {
            case SERVICE: {
                this.serviceListeners.fireChange();
                return;
            }
            case CLIENT: {
                this.clientListeners.fireChange();
                return;
            }
        }
    }

    public boolean equals(Object object) {
        if (this.getClass() == object.getClass()) {
            AbstractProjectWebServiceViewImpl abstractProjectWebServiceViewImpl = (AbstractProjectWebServiceViewImpl)object;
            return abstractProjectWebServiceViewImpl.getProject() == this.getProject();
        }
        return false;
    }

    public int hashCode() {
        super.hashCode();
        int n = 3;
        n = 23 * n + (this.getProject() != null ? this.getProject().hashCode() : 0);
        return n;
    }

    protected Project getProject() {
        return this.project.get();
    }
}

