/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.highlight.error;

import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.services.CsmFileReferences;
import org.netbeans.modules.cnd.api.model.services.CsmReferenceContext;
import org.netbeans.modules.cnd.api.model.syntaxerr.CsmErrorInfo;
import org.netbeans.modules.cnd.api.model.syntaxerr.CsmErrorProvider;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceKind;
import org.netbeans.modules.cnd.api.model.xref.CsmTemplateBasedReferencedObject;
import org.netbeans.modules.cnd.highlight.semantic.SemanticHighlighter;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.openide.util.NbBundle;

public class IdentifierErrorProvider
extends CsmErrorProvider {
    private static final boolean ENABLED = CndUtils.getBoolean((String)"cnd.identifier.error.provider", (boolean)true);
    private static final boolean SHOW_TIMES = Boolean.getBoolean("cnd.identifier.error.provider.times");
    private static final int MAX_ERROR_LIMIT;

    protected boolean validate(CsmErrorProvider.Request request) {
        return super.validate(request) && ENABLED && !IdentifierErrorProvider.disableAsLibraryHeaderFile((CsmFile)request.getFile()) && request.getFile().isParsed();
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    protected void doGetErrors(CsmErrorProvider.Request request, CsmErrorProvider.Response response) {
        long l = System.currentTimeMillis();
        if (SemanticHighlighter.isVeryBigDocument(request.getDocument())) {
            return;
        }
        if (SHOW_TIMES) {
            System.err.println("#@# Error Highlighting update() have started for file " + request.getFile().getAbsolutePath());
        }
        CsmFileReferences.getDefault().accept((CsmScope)request.getFile(), (CsmFileReferences.Visitor)new ReferenceVisitor(request, response), CsmReferenceKind.ANY_REFERENCE_IN_ACTIVE_CODE);
        if (SHOW_TIMES) {
            System.err.println("#@# Error Highlighting update() done in " + (System.currentTimeMillis() - l) + "ms for file " + request.getFile().getAbsolutePath());
        }
    }

    public String getName() {
        return "unresolved-identifier";
    }

    static {
        String string = System.getProperty("cnd.highlighting.error.limit");
        int n = 100;
        if (string != null) {
            try {
                n = Integer.parseInt(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        MAX_ERROR_LIMIT = n;
    }

    private static class IdentifierDeclarationAfterUsageInfo
    implements CsmErrorInfo {
        private final int startOffset;
        private final int endOffset;
        private final String message;
        private final CsmErrorInfo.Severity severity;

        public IdentifierDeclarationAfterUsageInfo(int n, int n2, String string, CsmErrorInfo.Severity severity) {
            this.startOffset = n;
            this.endOffset = n2;
            this.message = NbBundle.getMessage(IdentifierDeclarationAfterUsageInfo.class, (String)"HighlightProvider_DeclarationAfterUsage", (Object)string);
            this.severity = severity;
        }

        public String getMessage() {
            return this.message;
        }

        public CsmErrorInfo.Severity getSeverity() {
            return this.severity;
        }

        public int getStartOffset() {
            return this.startOffset;
        }

        public int getEndOffset() {
            return this.endOffset;
        }
    }

    private static class IdentifierErrorInfo
    implements CsmErrorInfo {
        private final int startOffset;
        private final int endOffset;
        private final String message;
        private final CsmErrorInfo.Severity severity;

        public IdentifierErrorInfo(int n, int n2, String string, CsmErrorInfo.Severity severity) {
            this.startOffset = n;
            this.endOffset = n2;
            this.message = NbBundle.getMessage(IdentifierErrorProvider.class, (String)"HighlightProvider_IdentifierMissed", (Object)string);
            this.severity = severity;
        }

        public String getMessage() {
            return this.message;
        }

        public CsmErrorInfo.Severity getSeverity() {
            return this.severity;
        }

        public int getStartOffset() {
            return this.startOffset;
        }

        public int getEndOffset() {
            return this.endOffset;
        }
    }

    private static class ReferenceVisitor
    implements CsmFileReferences.Visitor {
        private final CsmErrorProvider.Request request;
        private final CsmErrorProvider.Response response;
        private int foundError = 0;

        public ReferenceVisitor(CsmErrorProvider.Request request, CsmErrorProvider.Response response) {
            this.request = request;
            this.response = response;
        }

        public void visit(CsmReferenceContext csmReferenceContext) {
            if (MAX_ERROR_LIMIT >= 0 && this.foundError >= MAX_ERROR_LIMIT) {
                return;
            }
            CsmReference csmReference = csmReferenceContext.getReference();
            CsmObject csmObject = csmReference.getReferencedObject();
            if (!this.request.isCancelled()) {
                if (csmObject == null) {
                    if (CsmFileReferences.isAfterUnresolved((CsmReferenceContext)csmReferenceContext)) {
                        return;
                    }
                    if (CsmFileReferences.isBuiltInBased((CsmReference)csmReference) || CsmFileReferences.isMacroBased((CsmReferenceContext)csmReferenceContext)) {
                        return;
                    }
                    CsmErrorInfo.Severity severity = CsmErrorInfo.Severity.ERROR;
                    if (CsmFileReferences.isTemplateBased((CsmReferenceContext)csmReferenceContext)) {
                        severity = CsmErrorInfo.Severity.WARNING;
                    } else if (CsmKindUtilities.isClassForwardDeclaration((CsmObject)csmReference.getOwner())) {
                        severity = CsmErrorInfo.Severity.WARNING;
                    }
                    ++this.foundError;
                    this.response.addError((CsmErrorInfo)new IdentifierErrorInfo(csmReference.getStartOffset(), csmReference.getEndOffset(), ((Object)csmReference.getText()).toString(), severity));
                } else if (csmObject instanceof CsmTemplateBasedReferencedObject) {
                    if (CsmFileReferences.isAfterUnresolved((CsmReferenceContext)csmReferenceContext)) {
                        return;
                    }
                    if (CsmFileReferences.isBuiltInBased((CsmReference)csmReference) || CsmFileReferences.isMacroBased((CsmReferenceContext)csmReferenceContext)) {
                        return;
                    }
                    CsmErrorInfo.Severity severity = CsmErrorInfo.Severity.WARNING;
                    ++this.foundError;
                    this.response.addError((CsmErrorInfo)new IdentifierErrorInfo(csmReference.getStartOffset(), csmReference.getEndOffset(), ((Object)csmReference.getText()).toString(), severity));
                }
            }
        }
    }
}

