/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.editing;

import java.util.ArrayList;
import java.util.List;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.javascript.editing.lexer.JsCommentTokenId;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsCommentFormatter {
    private static final String PARAM_TAG = "@param";
    private static final String RETURN_TAG = "@return";
    private static final String TYPE_TAG = "@type";
    private static final String THROWS_TAG = "@throws";
    private static final String DEPRECATED_TAG = "@deprecated";
    private static final String CODE_TAG = "@code";
    private static final String EXAMPLE_TAG = "@example";
    private static final String DESCRIPTION_TAG = "@description";
    private final TokenSequence<? extends JsCommentTokenId> ts;
    private final StringBuilder summary = new StringBuilder();
    private String returnTag;
    private String returnType;
    private String deprecation;
    private String code;
    private final List<String> params;
    private final List<String> exceptions;
    private boolean formattedComment;
    private final StringBuilder rest = new StringBuilder();

    public JsCommentFormatter(List<String> list) {
        this.params = new ArrayList<String>();
        this.exceptions = new ArrayList<String>();
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : list) {
            stringBuilder.append(string);
            stringBuilder.append("\n");
        }
        boolean bl = false;
        boolean bl2 = false;
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            String string = list.get(i);
            if (string.indexOf("MDC:Copyrights") != -1) {
                bl2 = true;
                break;
            }
            if (string.indexOf(64) == -1) continue;
            bl = true;
        }
        if (bl2) {
            this.formattedComment = true;
        } else if (!bl) {
            this.formattedComment = true;
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.setLength(stringBuilder.length() - 1);
        }
        TokenHierarchy tokenHierarchy = TokenHierarchy.create((CharSequence)stringBuilder.toString(), JsCommentTokenId.language());
        this.ts = tokenHierarchy.tokenSequence(JsCommentTokenId.language());
        this.process();
    }

    void setSeqName(String string) {
    }

    String toHtml() {
        StringBuilder stringBuilder = new StringBuilder();
        if (!this.formattedComment && this.summary.length() > 0) {
            String string = this.summary.toString().trim();
            if (string.length() > 0) {
                stringBuilder.append("<b>");
                stringBuilder.append(NbBundle.getMessage(JsCommentFormatter.class, (String)"Summary"));
                stringBuilder.append("</b><blockquote>").append(string).append("</blockquote>");
            }
        } else {
            stringBuilder.append((CharSequence)this.summary);
        }
        if (this.deprecation != null) {
            boolean bl = this.deprecation.trim().length() > 0;
            stringBuilder.append("<b");
            if (!bl) {
                stringBuilder.append(" style=\"background:#ffcccc\"");
            }
            stringBuilder.append(">");
            stringBuilder.append(NbBundle.getMessage(JsCommentFormatter.class, (String)"Deprecated"));
            stringBuilder.append("</b>");
            stringBuilder.append("<blockquote");
            if (bl) {
                stringBuilder.append(" style=\"background:#ffcccc\">");
                stringBuilder.append(this.deprecation);
            } else {
                stringBuilder.append(">");
            }
            stringBuilder.append("</blockquote>");
        }
        if (this.params.size() > 0) {
            stringBuilder.append("<b>");
            stringBuilder.append(NbBundle.getMessage(JsCommentFormatter.class, (String)"Parameters"));
            stringBuilder.append("</b><blockquote>");
            int n = this.params.size();
            for (int i = 0; i < n; ++i) {
                if (i > 0) {
                    stringBuilder.append("<br><br>");
                }
                String string = this.params.get(i);
                stringBuilder.append(string);
            }
            stringBuilder.append("</blockquote>");
        }
        if (this.returnTag != null || this.returnType != null) {
            stringBuilder.append("<b>");
            stringBuilder.append(NbBundle.getMessage(JsCommentFormatter.class, (String)"Returns"));
            stringBuilder.append("</b><blockquote>");
            if (this.returnTag != null) {
                stringBuilder.append(this.returnTag);
                if (this.returnType != null) {
                    stringBuilder.append("<br>");
                }
            }
            if (this.returnType != null) {
                stringBuilder.append(NbBundle.getMessage(JsCommentFormatter.class, (String)"ReturnType"));
                stringBuilder.append(" <i>");
                stringBuilder.append(this.returnType);
                stringBuilder.append("</i>");
            }
            stringBuilder.append("</blockquote>");
        }
        if (this.exceptions.size() > 0) {
            stringBuilder.append("<b>");
            stringBuilder.append(NbBundle.getMessage(JsCommentFormatter.class, (String)"Throws"));
            stringBuilder.append("</b><blockquote>");
            for (String string : this.exceptions) {
                stringBuilder.append(string);
                stringBuilder.append("<br>");
            }
            stringBuilder.append("</blockquote>");
        }
        if (this.code != null) {
            stringBuilder.append("<b>");
            stringBuilder.append(NbBundle.getMessage(JsCommentFormatter.class, (String)"CodeExample"));
            stringBuilder.append("</b><blockquote>");
            stringBuilder.append("<pre>").append(this.code).append("</pre></blockquote>");
        }
        if (this.rest.length() > 0) {
            stringBuilder.append("<b>");
            stringBuilder.append(NbBundle.getMessage(JsCommentFormatter.class, (String)"Miscellaneous"));
            stringBuilder.append("</b><blockquote>");
            stringBuilder.append((CharSequence)this.rest);
            stringBuilder.append("</blockquote>");
        }
        return stringBuilder.toString();
    }

    String getSummary() {
        return this.summary.toString().trim();
    }

    List<String> getParams() {
        return this.params;
    }

    List<String> getExceptions() {
        return this.exceptions;
    }

    String getReturn() {
        return this.returnTag;
    }

    private void process() {
        while (this.ts.moveNext() && this.ts.token().id() != JsCommentTokenId.COMMENT_TAG) {
            this.summary.append(this.ts.token().text());
        }
        this.ts.movePrevious();
        StringBuilder stringBuilder = null;
        while (this.ts.moveNext()) {
            if (this.ts.token().id() == JsCommentTokenId.COMMENT_TAG) {
                if (stringBuilder != null) {
                    this.processTag(stringBuilder.toString().trim());
                }
                stringBuilder = new StringBuilder();
            }
            if (stringBuilder == null) continue;
            stringBuilder.append(this.ts.token().text());
        }
        if (stringBuilder != null) {
            this.processTag(stringBuilder.toString().trim());
        }
    }

    private void processTag(String string) {
        if (string.startsWith(PARAM_TAG)) {
            int n;
            String string2 = string.substring(PARAM_TAG.length()).trim();
            if (string2.length() == 0) {
                return;
            }
            StringBuilder stringBuilder = new StringBuilder();
            int n2 = 0;
            if (string2.charAt(0) == '{') {
                n = string2.indexOf(125);
                if (n != -1) {
                    stringBuilder.append("<i>");
                    stringBuilder.append(string2.substring(0, ++n));
                    stringBuilder.append("</i>");
                }
                for (n2 = n; n2 < string2.length() && Character.isWhitespace(string2.charAt(n2)); ++n2) {
                }
            }
            if (n2 < string2.length()) {
                for (n = n2; n < string2.length() && !Character.isWhitespace(string2.charAt(n)); ++n) {
                }
                if (n < string2.length()) {
                    stringBuilder.append(" <b>");
                    stringBuilder.append(string2.substring(n2, n));
                    stringBuilder.append("</b>");
                    stringBuilder.append(string2.substring(n));
                    this.params.add(stringBuilder.toString());
                    return;
                }
            }
            this.params.add(string2);
        } else if (string.startsWith(DESCRIPTION_TAG)) {
            String string3 = string.substring(DESCRIPTION_TAG.length()).trim();
            this.summary.insert(0, string3);
        } else if (string.startsWith(RETURN_TAG)) {
            this.returnTag = string.substring(RETURN_TAG.length()).trim();
        } else if (string.startsWith(TYPE_TAG)) {
            this.returnType = string.substring(TYPE_TAG.length()).trim();
        } else if (string.startsWith(THROWS_TAG)) {
            this.exceptions.add(string.substring(THROWS_TAG.length()).trim());
        } else if (string.startsWith(DEPRECATED_TAG)) {
            this.deprecation = string.substring(DEPRECATED_TAG.length()).trim();
        } else if (string.startsWith(CODE_TAG)) {
            this.code = string.substring(CODE_TAG.length()).trim();
            this.code = this.code.replace("&", "&amp;");
            this.code = this.code.replace("<", "&lt;");
            this.code = this.code.replace(">", "&gt;");
        } else if (string.startsWith(EXAMPLE_TAG)) {
            this.code = string.substring(EXAMPLE_TAG.length()).trim();
            this.code = this.code.replace("&", "&amp;");
            this.code = this.code.replace("<", "&lt;");
            this.code = this.code.replace(">", "&gt;");
        } else if (!(string.startsWith("@id ") || string.startsWith("@name ") || string.startsWith("@attribute") || string.startsWith("@compat") || string.startsWith("@method") || string.startsWith("@property"))) {
            this.rest.append(string);
            this.rest.append("<br>");
        }
    }
}

