/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.editing;

import java.util.EnumSet;
import java.util.Set;
import java.util.prefs.Preferences;
import org.netbeans.modules.javascript.editing.BrowserVersion;
import org.netbeans.modules.javascript.editing.options.JsOptionsController;
import org.openide.util.NbPreferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SupportedBrowsers {
    private static final String SUPPORTED_KEY = "supported";
    private static final String LANGUAGE_KEY = "language";
    private static final String BROWSERS = "browsers";
    private Set<BrowserVersion> supported;
    private int languageVersion;
    static SupportedBrowsers instance;

    public static SupportedBrowsers getInstance() {
        return instance;
    }

    SupportedBrowsers() {
        Preferences preferences = this.getPreferences();
        String string = preferences.get(SUPPORTED_KEY, null);
        this.supported = string == null || string.length() == 0 ? EnumSet.allOf(BrowserVersion.class) : BrowserVersion.fromFlags(string);
        String string2 = preferences.get(LANGUAGE_KEY, null);
        this.languageVersion = string2 == null || "default".equals(string2) ? 0 : ("1.0".equals(string2) ? 100 : ("1.1".equals(string2) ? 110 : ("1.2".equals(string2) ? 120 : ("1.3".equals(string2) ? 130 : ("1.4".equals(string2) ? 140 : ("1.5".equals(string2) ? 150 : ("1.6".equals(string2) ? 160 : ("1.7".equals(string2) ? 170 : ("1.8".equals(string2) ? 180 : 0)))))))));
    }

    private Preferences getPreferences() {
        return NbPreferences.forModule(SupportedBrowsers.class).node(BROWSERS);
    }

    public boolean isSupported(BrowserVersion browserVersion) {
        return this.supported.contains((Object)browserVersion);
    }

    public boolean isSupported(EnumSet<BrowserVersion> enumSet) {
        return enumSet.containsAll(this.supported);
    }

    void setSupported(EnumSet<BrowserVersion> enumSet) {
        if (((Object)this.supported).equals(enumSet)) {
            return;
        }
        this.supported = enumSet;
        String string = BrowserVersion.toFlags(enumSet);
        this.getPreferences().put(SUPPORTED_KEY, string);
    }

    public int getLanguageVersion() {
        return this.languageVersion;
    }

    public static String getLanguageVersionString(int n) {
        String string;
        switch (n) {
            case 100: {
                string = "1.0";
                break;
            }
            case 110: {
                string = "1.1";
                break;
            }
            case 120: {
                string = "1.2";
                break;
            }
            case 130: {
                string = "1.3";
                break;
            }
            case 140: {
                string = "1.4";
                break;
            }
            case 150: {
                string = "1.5";
                break;
            }
            case 160: {
                string = "1.6";
                break;
            }
            case 170: {
                string = "1.7";
                break;
            }
            case 180: {
                string = "1.8";
                break;
            }
            case 0: {
                string = "default";
                break;
            }
            default: {
                assert (false) : n;
                string = "default";
            }
        }
        return string;
    }

    public void setLanguageVersion(int n) {
        this.languageVersion = n;
        String string = SupportedBrowsers.getLanguageVersionString(n);
        this.getPreferences().put(LANGUAGE_KEY, string);
    }

    static {
        JsOptionsController.Accessor.DEFAULT = new JsOptionsController.Accessor(){

            @Override
            public void setLanguageVersion(SupportedBrowsers supportedBrowsers, int n) {
                supportedBrowsers.setLanguageVersion(n);
            }

            @Override
            public void setSupported(SupportedBrowsers supportedBrowsers, EnumSet<BrowserVersion> enumSet) {
                supportedBrowsers.setSupported(enumSet);
            }
        };
        instance = new SupportedBrowsers();
    }
}

