/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.java.source;

import com.sun.tools.javac.api.JavacTaskImpl;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.jvm.Target;
import com.sun.tools.javac.model.JavacElements;
import com.sun.tools.javac.util.Context;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.util.Elements;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.TypeMirrorHandle;
import org.netbeans.modules.java.source.ElementHandleAccessor;
import org.netbeans.modules.java.source.usages.ClassFileUtil;
import org.openide.util.Parameters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ElementHandle<T extends Element> {
    private static Logger log = Logger.getLogger(ElementHandle.class.getName());
    private final ElementKind kind;
    private final String[] signatures;

    private ElementHandle(ElementKind elementKind, String[] stringArray) {
        assert (elementKind != null);
        assert (stringArray != null);
        this.kind = elementKind;
        this.signatures = stringArray;
    }

    @CheckForNull
    public T resolve(@NonNull CompilationInfo compilationInfo) {
        Parameters.notNull((CharSequence)"compilationInfo", (Object)compilationInfo);
        T t = this.resolveImpl(compilationInfo.impl.getJavacTask());
        if (t == null) {
            if (log.isLoggable(Level.INFO)) {
                log.log(Level.INFO, "Cannot resolve: " + this.toString());
            }
        } else if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Resolved element = " + t);
        }
        return t;
    }

    private T resolveImpl(JavacTaskImpl javacTaskImpl) {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Resolving element kind: " + (Object)((Object)this.kind));
        }
        switch (this.kind) {
            case PACKAGE: {
                assert (this.signatures.length == 1);
                return (T)((JavacElements)javacTaskImpl.getElements()).getPackageElement(this.signatures[0]);
            }
            case CLASS: 
            case INTERFACE: 
            case ENUM: 
            case ANNOTATION_TYPE: 
            case OTHER: {
                assert (this.signatures.length == 1);
                return (T)ElementHandle.getTypeElementByBinaryName(this.signatures[0], javacTaskImpl);
            }
            case METHOD: 
            case CONSTRUCTOR: {
                assert (this.signatures.length == 3);
                TypeElement typeElement = ElementHandle.getTypeElementByBinaryName(this.signatures[0], javacTaskImpl);
                if (typeElement != null) {
                    List<? extends Element> list = typeElement.getEnclosedElements();
                    for (Element element : list) {
                        if (this.kind != element.getKind()) continue;
                        String[] stringArray = ClassFileUtil.createExecutableDescriptor((ExecutableElement)element);
                        assert (stringArray.length == 3);
                        if (!this.signatures[1].equals(stringArray[1]) || !this.signatures[2].equals(stringArray[2])) continue;
                        return (T)element;
                    }
                    break;
                }
                if (!log.isLoggable(Level.FINE)) break;
                log.log(Level.FINE, "Resolved type is null for kind=" + (Object)((Object)this.kind));
                break;
            }
            case INSTANCE_INIT: 
            case STATIC_INIT: {
                assert (this.signatures.length == 2);
                TypeElement typeElement = ElementHandle.getTypeElementByBinaryName(this.signatures[0], javacTaskImpl);
                if (typeElement != null) {
                    List<? extends Element> list = typeElement.getEnclosedElements();
                    for (Element element : list) {
                        if (this.kind != element.getKind()) continue;
                        String[] stringArray = ClassFileUtil.createExecutableDescriptor((ExecutableElement)element);
                        assert (stringArray.length == 2);
                        if (!this.signatures[1].equals(stringArray[1])) continue;
                        return (T)element;
                    }
                    break;
                }
                if (!log.isLoggable(Level.FINE)) break;
                log.log(Level.FINE, "Resolved type is null for kind=" + (Object)((Object)this.kind));
                break;
            }
            case FIELD: 
            case ENUM_CONSTANT: {
                assert (this.signatures.length == 3);
                TypeElement typeElement = ElementHandle.getTypeElementByBinaryName(this.signatures[0], javacTaskImpl);
                if (typeElement != null) {
                    List<? extends Element> list = typeElement.getEnclosedElements();
                    for (Element element : list) {
                        if (this.kind != element.getKind()) continue;
                        String[] stringArray = ClassFileUtil.createFieldDescriptor((VariableElement)element);
                        assert (stringArray.length == 3);
                        if (!this.signatures[1].equals(stringArray[1]) || !this.signatures[2].equals(stringArray[2])) continue;
                        return (T)element;
                    }
                    break;
                }
                if (!log.isLoggable(Level.FINE)) break;
                log.log(Level.FINE, "Resolved type is null for kind=" + (Object)((Object)this.kind));
                break;
            }
            case TYPE_PARAMETER: {
                if (this.signatures.length == 2) {
                    TypeElement typeElement = ElementHandle.getTypeElementByBinaryName(this.signatures[0], javacTaskImpl);
                    if (typeElement != null) {
                        List<? extends TypeParameterElement> list = typeElement.getTypeParameters();
                        for (TypeParameterElement typeParameterElement : list) {
                            if (!typeParameterElement.getSimpleName().contentEquals(this.signatures[1])) continue;
                            return (T)typeParameterElement;
                        }
                        break;
                    }
                    if (!log.isLoggable(Level.FINE)) break;
                    log.log(Level.FINE, "Resolved type is null for kind=" + (Object)((Object)this.kind) + " signatures.length = " + this.signatures.length);
                    break;
                }
                if (this.signatures.length == 4) {
                    TypeElement typeElement = ElementHandle.getTypeElementByBinaryName(this.signatures[0], javacTaskImpl);
                    if (typeElement != null) {
                        List<? extends Element> list = typeElement.getEnclosedElements();
                        for (Element element : list) {
                            if (element.getKind() != ElementKind.METHOD && element.getKind() != ElementKind.CONSTRUCTOR) continue;
                            String[] stringArray = ClassFileUtil.createExecutableDescriptor((ExecutableElement)element);
                            assert (stringArray.length == 3);
                            if (!this.signatures[1].equals(stringArray[1]) || !this.signatures[2].equals(stringArray[2])) continue;
                            assert (element instanceof ExecutableElement);
                            List<? extends TypeParameterElement> list2 = ((ExecutableElement)element).getTypeParameters();
                            for (TypeParameterElement typeParameterElement : list2) {
                                if (!typeParameterElement.getSimpleName().contentEquals(this.signatures[3])) continue;
                                return (T)typeParameterElement;
                            }
                        }
                        break;
                    }
                    if (!log.isLoggable(Level.FINE)) break;
                    log.log(Level.FINE, "Resolved type is null for kind=" + (Object)((Object)this.kind) + " signatures.length = " + this.signatures.length);
                    break;
                }
                throw new IllegalStateException();
            }
            default: {
                throw new IllegalStateException();
            }
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "All resolvings failed. Returning null.");
        }
        return null;
    }

    public boolean signatureEquals(@NonNull ElementHandle<? extends Element> elementHandle) {
        if (!ElementHandle.isSameKind(this.kind, elementHandle.kind) || this.signatures.length != elementHandle.signatures.length) {
            return false;
        }
        for (int i = 0; i < this.signatures.length; ++i) {
            if (this.signatures[i].equals(elementHandle.signatures[i])) continue;
            return false;
        }
        return true;
    }

    private static boolean isSameKind(ElementKind elementKind, ElementKind elementKind2) {
        return elementKind == elementKind2 || elementKind == ElementKind.OTHER && (elementKind2.isClass() || elementKind2.isInterface()) || elementKind2 == ElementKind.OTHER && (elementKind.isClass() || elementKind.isInterface());
    }

    @NonNull
    public String getBinaryName() throws IllegalStateException {
        if (this.kind.isClass() && !ElementHandle.isArray(this.signatures[0]) || this.kind.isInterface() || this.kind == ElementKind.OTHER) {
            return this.signatures[0];
        }
        throw new IllegalStateException();
    }

    @NonNull
    public String getQualifiedName() throws IllegalStateException {
        if (this.kind.isClass() && !ElementHandle.isArray(this.signatures[0]) || this.kind.isInterface() || this.kind == ElementKind.OTHER) {
            return this.signatures[0].replace(Target.DEFAULT.syntheticNameChar(), '.');
        }
        throw new IllegalStateException();
    }

    public boolean signatureEquals(@NonNull T t) {
        ElementKind elementKind;
        ElementKind elementKind2 = t.getKind();
        if (elementKind2 != (elementKind = this.getKind()) && (elementKind != ElementKind.OTHER || !elementKind2.isClass() && !elementKind2.isInterface())) {
            return false;
        }
        ElementHandle<T> elementHandle = ElementHandle.create(t);
        return this.signatureEquals((T)elementHandle);
    }

    @NonNull
    public ElementKind getKind() {
        return this.kind;
    }

    @NonNull
    public static <T extends Element> ElementHandle<T> create(@NonNull T t) throws IllegalArgumentException {
        String[] stringArray;
        Parameters.notNull((CharSequence)"element", t);
        ElementKind elementKind = t.getKind();
        switch (elementKind) {
            case PACKAGE: {
                assert (t instanceof PackageElement);
                stringArray = new String[]{((PackageElement)t).getQualifiedName().toString()};
                break;
            }
            case CLASS: 
            case INTERFACE: 
            case ENUM: 
            case ANNOTATION_TYPE: {
                assert (t instanceof TypeElement);
                stringArray = new String[]{ClassFileUtil.encodeClassNameOrArray((TypeElement)t)};
                break;
            }
            case METHOD: 
            case CONSTRUCTOR: 
            case INSTANCE_INIT: 
            case STATIC_INIT: {
                assert (t instanceof ExecutableElement);
                stringArray = ClassFileUtil.createExecutableDescriptor((ExecutableElement)t);
                break;
            }
            case FIELD: 
            case ENUM_CONSTANT: {
                assert (t instanceof VariableElement);
                stringArray = ClassFileUtil.createFieldDescriptor((VariableElement)t);
                break;
            }
            case TYPE_PARAMETER: {
                assert (t instanceof TypeParameterElement);
                TypeParameterElement typeParameterElement = (TypeParameterElement)t;
                Element element = typeParameterElement.getGenericElement();
                ElementKind elementKind2 = element.getKind();
                if (elementKind2.isClass() || elementKind2.isInterface()) {
                    assert (element instanceof TypeElement);
                    stringArray = new String[]{ClassFileUtil.encodeClassNameOrArray((TypeElement)element), typeParameterElement.getSimpleName().toString()};
                    break;
                }
                if (elementKind2 == ElementKind.METHOD || elementKind2 == ElementKind.CONSTRUCTOR) {
                    assert (element instanceof ExecutableElement);
                    String[] stringArray2 = ClassFileUtil.createExecutableDescriptor((ExecutableElement)element);
                    stringArray = new String[stringArray2.length + 1];
                    System.arraycopy(stringArray2, 0, stringArray, 0, stringArray2.length);
                    stringArray[stringArray2.length] = typeParameterElement.getSimpleName().toString();
                    break;
                }
                throw new IllegalArgumentException(elementKind2.toString());
            }
            default: {
                throw new IllegalArgumentException(elementKind.toString());
            }
        }
        return new ElementHandle<T>(elementKind, stringArray);
    }

    @NonNull
    public static ElementHandle<? extends TypeElement> from(@NonNull TypeMirrorHandle<? extends DeclaredType> typeMirrorHandle) {
        Parameters.notNull((CharSequence)"typeMirrorHandle", typeMirrorHandle);
        if (typeMirrorHandle.getKind() != TypeKind.DECLARED) {
            throw new IllegalStateException("Incorrect kind: " + (Object)((Object)typeMirrorHandle.getKind()));
        }
        return typeMirrorHandle.getElementHandle();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getClass().getSimpleName());
        stringBuilder.append('[');
        stringBuilder.append("kind=" + this.kind.toString());
        stringBuilder.append("; sigs=");
        for (String string : this.signatures) {
            stringBuilder.append(string);
            stringBuilder.append(' ');
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public int hashCode() {
        int n = 0;
        for (String string : this.signatures) {
            n ^= string != null ? string.hashCode() : 0;
        }
        return n;
    }

    public boolean equals(Object object) {
        if (object instanceof ElementHandle) {
            return this.signatureEquals((T)((ElementHandle)object));
        }
        return false;
    }

    String[] getSignature() {
        return this.signatures;
    }

    private static TypeElement getTypeElementByBinaryName(String string, JavacTaskImpl javacTaskImpl) {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Calling getTypeElementByBinaryName: signature=" + string);
        }
        if (ElementHandle.isArray(string)) {
            return Symtab.instance((Context)javacTaskImpl.getContext()).arrayClass;
        }
        Elements elements = javacTaskImpl.getElements();
        return elements.getTypeElementByBinaryName(string);
    }

    private static boolean isArray(String string) {
        return string.length() == 1 && string.charAt(0) == '[';
    }

    static {
        ElementHandleAccessor.INSTANCE = new ElementHandleAccessorImpl();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ElementHandleAccessorImpl
    extends ElementHandleAccessor {
        private ElementHandleAccessorImpl() {
        }

        @Override
        public ElementHandle create(ElementKind elementKind, String ... stringArray) {
            assert (elementKind != null);
            assert (stringArray != null);
            switch (elementKind) {
                case PACKAGE: {
                    if (stringArray.length != 1) {
                        throw new IllegalArgumentException();
                    }
                    return new ElementHandle(elementKind, stringArray);
                }
                case CLASS: 
                case INTERFACE: 
                case ENUM: 
                case ANNOTATION_TYPE: 
                case OTHER: {
                    if (stringArray.length != 1) {
                        throw new IllegalArgumentException();
                    }
                    return new ElementHandle(elementKind, stringArray);
                }
                case METHOD: 
                case CONSTRUCTOR: {
                    if (stringArray.length != 3) {
                        throw new IllegalArgumentException();
                    }
                    return new ElementHandle(elementKind, stringArray);
                }
                case INSTANCE_INIT: 
                case STATIC_INIT: {
                    if (stringArray.length != 2) {
                        throw new IllegalArgumentException();
                    }
                    return new ElementHandle(elementKind, stringArray);
                }
                case FIELD: 
                case ENUM_CONSTANT: {
                    if (stringArray.length != 3) {
                        throw new IllegalArgumentException();
                    }
                    return new ElementHandle(elementKind, stringArray);
                }
            }
            throw new IllegalArgumentException();
        }

        @Override
        public <T extends Element> T resolve(ElementHandle<T> elementHandle, JavacTaskImpl javacTaskImpl) {
            return (T)((ElementHandle)elementHandle).resolveImpl(javacTaskImpl);
        }
    }
}

