/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.indexing;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.Tree;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.TypeElement;
import javax.tools.JavaFileObject;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.modules.java.source.indexing.JavaCustomIndexer;
import org.netbeans.modules.java.source.indexing.JavaParsingContext;
import org.netbeans.modules.java.source.parsing.FileObjects;
import org.netbeans.modules.parsing.spi.indexing.Context;
import org.netbeans.modules.parsing.spi.indexing.Indexable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class CompileWorker {
    CompileWorker() {
    }

    abstract ParsingOutput compile(ParsingOutput var1, Context var2, JavaParsingContext var3, Iterable<? extends JavaCustomIndexer.CompileTuple> var4);

    public void computeFQNs(Map<JavaFileObject, List<String>> map, CompilationUnitTree compilationUnitTree, JavaCustomIndexer.CompileTuple compileTuple) {
        String string = compilationUnitTree.getPackageName() != null ? compilationUnitTree.getPackageName().toString() + "." : "";
        String string2 = compileTuple.indexable.getRelativePath();
        int n = string2.lastIndexOf(46);
        if (n >= 0) {
            string2 = string2.substring(0, n);
        }
        string2 = FileObjects.convertFolder2Package(string2);
        LinkedList<String> linkedList = new LinkedList<String>();
        boolean bl = false;
        for (Tree tree : compilationUnitTree.getTypeDecls()) {
            if (tree.getKind() != Tree.Kind.CLASS) continue;
            String string3 = string + ((ClassTree)tree).getSimpleName().toString();
            linkedList.add(string3);
            if (string2.equals(string3)) continue;
            bl = true;
        }
        if (bl) {
            map.put(compileTuple.jfo, linkedList);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ParsingOutput {
        final boolean success;
        final Map<JavaFileObject, List<String>> file2FQNs;
        final Set<ElementHandle<TypeElement>> addedTypes;
        final Set<File> createdFiles;
        final Set<Indexable> finishedFiles;
        final Set<ElementHandle<TypeElement>> modifiedTypes;

        public ParsingOutput(boolean bl, Map<JavaFileObject, List<String>> map, Set<ElementHandle<TypeElement>> set, Set<File> set2, Set<Indexable> set3, Set<ElementHandle<TypeElement>> set4) {
            this.success = bl;
            this.file2FQNs = map;
            this.addedTypes = set;
            this.createdFiles = set2;
            this.finishedFiles = set3;
            this.modifiedTypes = set4;
        }
    }
}

