/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.parsing;

import java.io.IOException;
import java.net.URL;
import java.util.logging.Logger;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.JavaParserResultTask;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.modules.java.source.JavaSourceAccessor;
import org.netbeans.modules.java.source.parsing.ClasspathInfoListener;
import org.netbeans.modules.java.source.parsing.CompilationInfoImpl;
import org.netbeans.modules.java.source.parsing.JavacParserResult;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.Task;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.ParserResultTask;
import org.netbeans.modules.parsing.spi.SourceModificationEvent;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.filesystems.FileObject;
import org.openide.util.ChangeSupport;
import org.openide.util.Parameters;
import org.openide.util.WeakListeners;

class ClassParser
extends Parser {
    private static final Logger LOGGER = Logger.getLogger(Parser.class.getName());
    private final ClasspathInfo info;
    private CompilationInfoImpl ciImpl;
    private final ChangeSupport changeSupport;
    private final ClasspathInfoListener cpInfoListener;

    public ClassParser(ClasspathInfo classpathInfo) {
        assert (classpathInfo != null);
        this.info = classpathInfo;
        this.changeSupport = new ChangeSupport((Object)this);
        this.cpInfoListener = new ClasspathInfoListener(this.changeSupport);
        classpathInfo.addChangeListener(WeakListeners.change((ChangeListener)this.cpInfoListener, (Object)classpathInfo));
    }

    public void parse(Snapshot snapshot, Task task, SourceModificationEvent sourceModificationEvent) throws ParseException {
        ClassPath classPath;
        assert (snapshot != null);
        Source source = snapshot.getSource();
        assert (source != null);
        FileObject fileObject = source.getFileObject();
        assert (fileObject != null);
        ClassPath classPath2 = this.info.getClassPath(ClasspathInfo.PathKind.BOOT);
        assert (classPath2 != null);
        ClassPath classPath3 = this.info.getClassPath(ClasspathInfo.PathKind.COMPILE);
        if (classPath3 == null) {
            classPath3 = ClassPathSupport.createClassPath((URL[])new URL[0]);
        }
        if ((classPath = this.info.getClassPath(ClasspathInfo.PathKind.SOURCE)) == null) {
            classPath = ClassPathSupport.createClassPath((URL[])new URL[0]);
        }
        FileObject fileObject2 = ClassPathSupport.createProxyClassPath((ClassPath[])new ClassPath[]{classPath2, classPath3, classPath}).findOwnerRoot(fileObject);
        try {
            this.ciImpl = new CompilationInfoImpl(this.info, fileObject, fileObject2);
        }
        catch (IOException iOException) {
            throw new ParseException("ClassParser failure", (Throwable)iOException);
        }
    }

    public Parser.Result getResult(Task task) throws ParseException {
        assert (this.ciImpl != null);
        boolean bl = task instanceof ParserResultTask;
        boolean bl2 = task instanceof JavaParserResultTask;
        boolean bl3 = task instanceof UserTask;
        JavacParserResult javacParserResult = null;
        if (bl) {
            JavaSource.Phase phase;
            JavaSource.Phase phase2 = this.ciImpl.getPhase();
            if (phase2.compareTo(phase = bl2 ? ((JavaParserResultTask)task).getPhase() : JavaSource.Phase.RESOLVED) < 0) {
                this.ciImpl.setPhase(phase);
            }
            javacParserResult = new JavacParserResult(JavaSourceAccessor.getINSTANCE().createCompilationInfo(this.ciImpl));
        } else if (bl3) {
            javacParserResult = new JavacParserResult(JavaSourceAccessor.getINSTANCE().createCompilationController(this.ciImpl));
        } else {
            LOGGER.warning("Ignoring unknown task: " + task);
        }
        return javacParserResult;
    }

    public void cancel() {
    }

    public void addChangeListener(ChangeListener changeListener) {
        Parameters.notNull((CharSequence)"changeListener", (Object)changeListener);
        this.changeSupport.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        Parameters.notNull((CharSequence)"changeListener", (Object)changeListener);
        this.changeSupport.removeChangeListener(changeListener);
    }
}

