/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.usages;

import com.sun.tools.javac.api.JavacTaskImpl;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.model.JavacElements;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.ElementFilter;
import javax.swing.JComponent;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticListener;
import javax.tools.JavaFileObject;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.modules.classfile.Annotation;
import org.netbeans.modules.classfile.AnnotationComponent;
import org.netbeans.modules.classfile.ArrayElementValue;
import org.netbeans.modules.classfile.CPClassInfo;
import org.netbeans.modules.classfile.CPFieldInfo;
import org.netbeans.modules.classfile.CPInterfaceMethodInfo;
import org.netbeans.modules.classfile.CPMethodInfo;
import org.netbeans.modules.classfile.ClassElementValue;
import org.netbeans.modules.classfile.ClassFile;
import org.netbeans.modules.classfile.ClassName;
import org.netbeans.modules.classfile.ConstantPool;
import org.netbeans.modules.classfile.ElementValue;
import org.netbeans.modules.classfile.EnumElementValue;
import org.netbeans.modules.classfile.InvalidClassFormatException;
import org.netbeans.modules.classfile.LocalVariableTableEntry;
import org.netbeans.modules.classfile.Method;
import org.netbeans.modules.classfile.NestedElementValue;
import org.netbeans.modules.java.source.ElementHandleAccessor;
import org.netbeans.modules.java.source.TreeLoader;
import org.netbeans.modules.java.source.parsing.FileObjects;
import org.netbeans.modules.java.source.parsing.JavacParser;
import org.netbeans.modules.java.source.usages.ClassFileUtil;
import org.netbeans.modules.java.source.usages.ClassIndexImpl;
import org.netbeans.modules.java.source.usages.DocumentUtil;
import org.netbeans.modules.java.source.usages.Index;
import org.netbeans.modules.java.source.usages.Pair;
import org.netbeans.modules.java.source.util.LMListener;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BinaryAnalyser {
    private static final Logger LOGGER = Logger.getLogger(BinaryAnalyser.class.getName());
    static final String OBJECT = Object.class.getName();
    private static boolean FULL_INDEX = Boolean.getBoolean("org.netbeans.modules.java.source.usages.BinaryAnalyser.fullIndex");
    private final Index index;
    private final File cacheRoot;
    private final Map<Pair<String, String>, Object[]> refs = new HashMap<Pair<String, String>, Object[]>();
    private final Set<Pair<String, String>> toDelete = new HashSet<Pair<String, String>>();
    private final LMListener lmListener;
    private Continuation cont;

    public BinaryAnalyser(Index index, File file) {
        assert (index != null);
        this.index = index;
        this.cacheRoot = file;
        this.lmListener = new LMListener();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final Result start(URL uRL, AtomicBoolean atomicBoolean, AtomicBoolean atomicBoolean2) throws IOException, IllegalArgumentException {
        File[] fileArray;
        assert (uRL != null);
        assert (this.cont == null);
        String string = uRL.getProtocol();
        if ("jar".equals(string)) {
            URL uRL2 = FileUtil.getArchiveFile((URL)uRL);
            if (!"file".equals(uRL2.getProtocol())) {
                FileObject fileObject = URLMapper.findFileObject((URL)uRL);
                if (fileObject == null) return this.deleted();
                if (this.isUpToDate(null, fileObject.lastModified().getTime())) return Result.FINISHED;
                this.index.clear();
                Enumeration enumeration = fileObject.getData(true);
                this.cont = new FileObjectContinuation(enumeration, atomicBoolean, atomicBoolean2);
                return this.cont.execute();
            }
            File file = new File(URI.create(uRL2.toExternalForm()));
            if (!file.exists()) return this.deleted();
            if (!file.canRead()) return this.deleted();
            if (this.isUpToDate(null, file.lastModified())) return Result.FINISHED;
            this.index.clear();
            try {
                ZipFile zipFile = new ZipFile(file);
                BinaryAnalyser.prebuildArgs(zipFile, uRL);
                Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
                this.cont = new ZipContinuation(zipFile, enumeration, atomicBoolean, atomicBoolean2);
                return this.cont.execute();
            }
            catch (ZipException zipException) {
                LOGGER.warning("Broken zip file: " + file.getAbsolutePath());
                return Result.FINISHED;
            }
        }
        if (!"file".equals(string)) {
            FileObject fileObject = URLMapper.findFileObject((URL)uRL);
            if (fileObject == null) return this.deleted();
            this.index.clear();
            Enumeration enumeration = fileObject.getData(true);
            this.cont = new FileObjectContinuation(enumeration, atomicBoolean, atomicBoolean2);
            return this.cont.execute();
        }
        File file = new File(URI.create(uRL.toExternalForm()));
        if (!file.isDirectory()) return Result.FINISHED;
        String string2 = file.getAbsolutePath();
        if (string2.charAt(string2.length() - 1) != File.separatorChar) {
            string2 = string2 + File.separatorChar;
        }
        LinkedList<File> linkedList = new LinkedList<File>();
        if (file.isDirectory() && file.canRead() && (fileArray = file.listFiles()) != null) {
            linkedList.addAll(Arrays.asList(fileArray));
        }
        this.cont = new FolderContinuation(linkedList, string2, atomicBoolean, atomicBoolean2);
        return this.cont.execute();
    }

    public Result resume() throws IOException {
        assert (this.cont != null);
        return this.cont.execute();
    }

    public Changes finish() throws IOException {
        if (this.cont == null) {
            return new Changes(Changes.NO_CHANGES, Changes.NO_CHANGES, Changes.NO_CHANGES);
        }
        List<Pair<ElementHandle<TypeElement>, Long>> list = this.cont.finish();
        List<Pair<ElementHandle<TypeElement>, Long>> list2 = this.loadCRCs(this.cacheRoot);
        this.cont = null;
        this.store();
        this.storeCRCs(this.cacheRoot, list);
        return BinaryAnalyser.diff(list2, list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Pair<ElementHandle<TypeElement>, Long>> loadCRCs(File file) throws IOException {
        LinkedList<Pair<ElementHandle<TypeElement>, Long>> linkedList;
        block8: {
            linkedList = new LinkedList<Pair<ElementHandle<TypeElement>, Long>>();
            File file2 = new File(file, "crc.properties");
            if (file2.canRead()) {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file2), "UTF-8"));
                block5: while (true) {
                    String string;
                    while ((string = bufferedReader.readLine()) != null) {
                        String[] stringArray = string.split("=");
                        if (stringArray.length != 2) continue;
                        try {
                            ElementHandle elementHandle = ElementHandleAccessor.INSTANCE.create(ElementKind.CLASS, stringArray[0]);
                            Long l = Long.parseLong(stringArray[1]);
                            linkedList.add(Pair.of(elementHandle, l));
                            continue block5;
                        }
                        catch (NumberFormatException numberFormatException) {
                        }
                    }
                    break block8;
                    {
                        continue block5;
                        break;
                    }
                    break;
                }
                finally {
                    bufferedReader.close();
                }
            }
        }
        return linkedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeCRCs(File file, List<Pair<ElementHandle<TypeElement>, Long>> list) throws IOException {
        File file2 = new File(file, "crc.properties");
        PrintWriter printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file2), "UTF-8"));
        try {
            for (Pair<ElementHandle<TypeElement>, Long> pair : list) {
                StringBuilder stringBuilder = new StringBuilder(((ElementHandle)pair.first).getQualifiedName());
                stringBuilder.append('=');
                stringBuilder.append((Long)pair.second);
                printWriter.println(stringBuilder.toString());
            }
        }
        finally {
            printWriter.close();
        }
    }

    static Changes diff(List<Pair<ElementHandle<TypeElement>, Long>> list, List<Pair<ElementHandle<TypeElement>, Long>> list2) {
        LinkedList linkedList = new LinkedList();
        LinkedList linkedList2 = new LinkedList();
        LinkedList linkedList3 = new LinkedList();
        Iterator<Pair<ElementHandle<TypeElement>, Long>> iterator = list.iterator();
        Iterator<Pair<ElementHandle<TypeElement>, Long>> iterator2 = list2.iterator();
        Pair<ElementHandle<TypeElement>, Long> pair = null;
        Pair<ElementHandle<TypeElement>, Long> pair2 = null;
        while (iterator.hasNext() && iterator2.hasNext()) {
            int n;
            if (pair == null) {
                pair = iterator.next();
            }
            if (pair2 == null) {
                pair2 = iterator2.next();
            }
            if ((n = ((ElementHandle)pair.first).getQualifiedName().compareTo(((ElementHandle)pair2.first).getQualifiedName())) == 0) {
                if ((Long)pair.second == 0L || ((Long)pair.second).longValue() != ((Long)pair2.second).longValue()) {
                    linkedList.add(pair.first);
                }
                pair2 = null;
                pair = null;
                continue;
            }
            if (n < 0) {
                linkedList2.add(pair.first);
                pair = null;
                continue;
            }
            if (n <= 0) continue;
            linkedList3.add(pair2.first);
            pair2 = null;
        }
        if (pair != null) {
            linkedList2.add(pair.first);
        }
        while (iterator.hasNext()) {
            linkedList2.add(iterator.next().first);
        }
        if (pair2 != null) {
            linkedList3.add(pair2.first);
        }
        while (iterator2.hasNext()) {
            linkedList3.add(iterator2.next().first);
        }
        return new Changes(linkedList3, linkedList2, linkedList);
    }

    private Result deleted() throws IOException {
        this.cont = new DeletedContinuation();
        return this.cont.execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Result analyseFolder(LinkedList<File> linkedList, String string, AtomicBoolean atomicBoolean, AtomicBoolean atomicBoolean2, Continuation continuation) throws IOException {
        while (!linkedList.isEmpty()) {
            Object object;
            File file = linkedList.removeFirst();
            if (file.isDirectory() && file.canRead()) {
                object = file.listFiles();
                if (object != null) {
                    linkedList.addAll(Arrays.asList(object));
                }
            } else if (this.accepts(file.getName())) {
                int n;
                object = file.getAbsolutePath();
                long l = file.lastModified();
                int n2 = ((String)object).lastIndexOf(46);
                int n3 = n2 > (n = ((String)object).lastIndexOf(47)) ? n2 : ((String)object).length();
                String string2 = FileObjects.convertFolder2Package(((String)object).substring(string.length(), n3));
                continuation.report(ElementHandleAccessor.INSTANCE.create(ElementKind.CLASS, string2), 0L);
                if (this.accepts(file.getName()) && !this.isUpToDate(string2, l)) {
                    this.toDelete.add(Pair.of(string2, null));
                    try {
                        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
                        try {
                            this.analyse(bufferedInputStream);
                        }
                        catch (InvalidClassFormatException invalidClassFormatException) {
                            LOGGER.warning("Invalid class file format: " + file.getAbsolutePath());
                        }
                        finally {
                            ((InputStream)bufferedInputStream).close();
                        }
                    }
                    catch (IOException iOException) {
                        LOGGER.warning("Cannot read file: " + file.getAbsolutePath());
                        LOGGER.log(Level.FINE, null, iOException);
                    }
                    if (this.lmListener.isLowMemory()) {
                        this.store();
                    }
                }
            }
            if (atomicBoolean.getAndSet(false)) {
                this.store();
                return Result.CANCELED;
            }
            if (!atomicBoolean2.get()) continue;
            return Result.CLOSED;
        }
        return Result.FINISHED;
    }

    private Result analyseArchive(ZipFile zipFile, Enumeration<? extends ZipEntry> enumeration, AtomicBoolean atomicBoolean, AtomicBoolean atomicBoolean2, Continuation continuation) throws IOException {
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry;
            try {
                zipEntry = enumeration.nextElement();
            }
            catch (InternalError internalError) {
                LOGGER.log(Level.INFO, "Broken zip file: " + zipFile.getName(), internalError);
                return Result.FINISHED;
            }
            if (!zipEntry.isDirectory() && this.accepts(zipEntry.getName())) {
                continuation.report(ElementHandleAccessor.INSTANCE.create(ElementKind.CLASS, FileObjects.convertFolder2Package(FileObjects.stripExtension(zipEntry.getName()))), zipEntry.getCrc());
                BufferedInputStream bufferedInputStream = new BufferedInputStream(zipFile.getInputStream(zipEntry));
                try {
                    this.analyse(bufferedInputStream);
                }
                catch (InvalidClassFormatException invalidClassFormatException) {
                    LOGGER.warning("Invalid class file format: " + new File(zipFile.getName()).toURI() + "!/" + zipEntry.getName());
                }
                catch (IOException iOException) {
                    Exceptions.attachMessage((Throwable)iOException, (String)("While scanning: " + zipEntry.getName()));
                    throw iOException;
                }
                finally {
                    ((InputStream)bufferedInputStream).close();
                }
                if (this.lmListener.isLowMemory()) {
                    this.store();
                }
            }
            if (atomicBoolean.getAndSet(false)) {
                this.store();
                return Result.CANCELED;
            }
            if (!atomicBoolean2.get()) continue;
            return Result.CLOSED;
        }
        return Result.FINISHED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Result analyseFileObjects(Enumeration<? extends FileObject> enumeration, FileObject fileObject, AtomicBoolean atomicBoolean, AtomicBoolean atomicBoolean2, Continuation continuation) throws IOException {
        while (enumeration.hasMoreElements()) {
            FileObject fileObject2 = enumeration.nextElement();
            if (this.accepts(fileObject2.getName())) {
                String string = FileObjects.stripExtension(FileUtil.getRelativePath((FileObject)fileObject, (FileObject)fileObject2));
                continuation.report(ElementHandleAccessor.INSTANCE.create(ElementKind.CLASS, FileObjects.convertFolder2Package(string)), 0L);
                BufferedInputStream bufferedInputStream = new BufferedInputStream(fileObject2.getInputStream());
                try {
                    this.analyse(bufferedInputStream);
                }
                catch (InvalidClassFormatException invalidClassFormatException) {
                    LOGGER.warning("Invalid class file format: " + FileUtil.getFileDisplayName((FileObject)fileObject2));
                }
                finally {
                    ((InputStream)bufferedInputStream).close();
                }
                if (this.lmListener.isLowMemory()) {
                    this.store();
                }
            }
            if (atomicBoolean.getAndSet(false)) {
                this.store();
                return Result.CANCELED;
            }
            if (!atomicBoolean2.get()) continue;
            return Result.CLOSED;
        }
        return Result.FINISHED;
    }

    private final void delete(String string) throws IOException {
        assert (string != null);
        this.toDelete.add(Pair.of(string, null));
    }

    private boolean accepts(String string) {
        int n = string.lastIndexOf(46);
        if (n == -1 || n + 1 == string.length()) {
            return false;
        }
        return "CLASS".equalsIgnoreCase(string.substring(n + 1));
    }

    private void analyse(InputStream inputStream) throws IOException {
        ClassFile classFile = new ClassFile(inputStream);
        ClassName className = classFile.getName();
        String string = BinaryAnalyser.nameToString(className);
        this.delete(string);
        Map<ClassName, Set<ClassIndexImpl.UsageType>> map = this.performAnalyse(classFile, string);
        ElementKind elementKind = ElementKind.CLASS;
        if (classFile.isEnum()) {
            elementKind = ElementKind.ENUM;
        } else if (classFile.isAnnotation()) {
            elementKind = ElementKind.ANNOTATION_TYPE;
        } else if ((classFile.getAccess() & 0x200) == 512) {
            elementKind = ElementKind.INTERFACE;
        }
        String string2 = string + DocumentUtil.encodeKind(elementKind);
        Pair<String, Object> pair = Pair.of(string2, null);
        List<String> list = this.getClassReferences(pair);
        for (Map.Entry<ClassName, Set<ClassIndexImpl.UsageType>> entry : map.entrySet()) {
            ClassName className2 = entry.getKey();
            Set<ClassIndexImpl.UsageType> set = entry.getValue();
            list.add(DocumentUtil.encodeUsage(BinaryAnalyser.nameToString(className2), set));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void store() throws IOException {
        try {
            if (this.refs.size() > 0 || this.toDelete.size() > 0) {
                this.index.store(this.refs, this.toDelete);
            }
        }
        finally {
            this.refs.clear();
            this.toDelete.clear();
        }
    }

    private final boolean isUpToDate(String string, long l) throws IOException {
        return this.index.isUpToDate(string, l);
    }

    private Map<ClassName, Set<ClassIndexImpl.UsageType>> performAnalyse(ClassFile classFile, String string) throws IOException {
        Object object;
        ClassName[] classNameArray;
        HashMap<ClassName, Set<ClassIndexImpl.UsageType>> hashMap = new HashMap<ClassName, Set<ClassIndexImpl.UsageType>>();
        String string2 = classFile.getTypeSignature();
        if (string2 != null) {
            try {
                classNameArray = ClassFileUtil.getTypesFromClassTypeSignature(string2);
                for (ClassName className : classNameArray) {
                    BinaryAnalyser.addUsage(hashMap, className, ClassIndexImpl.UsageType.TYPE_REFERENCE);
                }
            }
            catch (RuntimeException runtimeException) {
                StackTraceElement[] stackTraceElementArray;
                object = new StringBuilder("BinaryAnalyser: Cannot read type: " + string2 + " cause: " + runtimeException.getLocalizedMessage() + '\n');
                for (StackTraceElement object2 : stackTraceElementArray = runtimeException.getStackTrace()) {
                    ((StringBuilder)object).append(object2.toString());
                    ((StringBuilder)object).append('\n');
                }
                LOGGER.warning(((StringBuilder)object).toString());
            }
        }
        if ((classNameArray = classFile.getSuperClass()) != null) {
            BinaryAnalyser.addUsage(hashMap, (ClassName)classNameArray, ClassIndexImpl.UsageType.SUPER_CLASS);
        }
        object = classFile.getInterfaces();
        ConstantPool constantPool = object.iterator();
        while (constantPool.hasNext()) {
            ClassName className = (ClassName)constantPool.next();
            BinaryAnalyser.addUsage(hashMap, className, ClassIndexImpl.UsageType.SUPER_INTERFACE);
        }
        if (!FULL_INDEX) {
            this.handleAnnotations(hashMap, classFile.getAnnotations(), true);
        }
        if (FULL_INDEX) {
            ClassName[] classNameArray2;
            List list;
            Object object2;
            Object object32;
            Object object4;
            this.handleAnnotations(hashMap, classFile.getAnnotations(), false);
            constantPool = classFile.getConstantPool();
            Collection collection = constantPool.getAllConstants(CPFieldInfo.class);
            for (CPFieldInfo cPFieldInfo : collection) {
                ClassName className = ClassFileUtil.getType(constantPool.getClass(cPFieldInfo.getClassID()));
                if (className == null) continue;
                BinaryAnalyser.addUsage(hashMap, className, ClassIndexImpl.UsageType.FIELD_REFERENCE);
            }
            Object object6 = constantPool.getAllConstants(CPMethodInfo.class);
            Object object7 = object6.iterator();
            while (object7.hasNext()) {
                CPMethodInfo cPMethodInfo = (CPMethodInfo)object7.next();
                object4 = ClassFileUtil.getType(constantPool.getClass(cPMethodInfo.getClassID()));
                if (object4 == null) continue;
                BinaryAnalyser.addUsage(hashMap, (ClassName)object4, ClassIndexImpl.UsageType.METHOD_REFERENCE);
            }
            object6 = constantPool.getAllConstants(CPInterfaceMethodInfo.class);
            object7 = object6.iterator();
            while (object7.hasNext()) {
                CPMethodInfo cPMethodInfo = (CPMethodInfo)object7.next();
                object4 = ClassFileUtil.getType(constantPool.getClass(cPMethodInfo.getClassID()));
                if (object4 == null) continue;
                BinaryAnalyser.addUsage(hashMap, (ClassName)object4, ClassIndexImpl.UsageType.METHOD_REFERENCE);
            }
            object7 = classFile.getMethods();
            Iterator iterator = object7.iterator();
            while (iterator.hasNext()) {
                int n;
                LocalVariableTableEntry[] localVariableTableEntryArray;
                int n2;
                ClassName[] classNameArray3;
                object4 = (Method)iterator.next();
                this.handleAnnotations(hashMap, object4.getAnnotations(), false);
                object32 = object4.getReturnType();
                object2 = ClassFileUtil.getType((String)object32);
                if (object2 != null) {
                    BinaryAnalyser.addUsage(hashMap, object2, ClassIndexImpl.UsageType.TYPE_REFERENCE);
                }
                list = object4.getParameters();
                classNameArray2 = list.iterator();
                while (classNameArray2.hasNext()) {
                    classNameArray3 = (ClassName[])classNameArray2.next();
                    object32 = classNameArray3.getDescriptor();
                    object2 = ClassFileUtil.getType((String)object32);
                    if (object2 == null) continue;
                    BinaryAnalyser.addUsage(hashMap, object2, ClassIndexImpl.UsageType.TYPE_REFERENCE);
                }
                classNameArray3 = classNameArray2 = object4.getExceptionClasses();
                int n3 = classNameArray3.length;
                for (n2 = 0; n2 < n3; ++n2) {
                    CPClassInfo cPClassInfo = classNameArray3[n2];
                    object2 = cPClassInfo.getClassName();
                    if (object2 == null) continue;
                    BinaryAnalyser.addUsage(hashMap, object2, ClassIndexImpl.UsageType.TYPE_REFERENCE);
                }
                object32 = object4.getTypeSignature();
                if (object32 != null) {
                    try {
                        ClassName[] classNameArray4 = classNameArray3 = ClassFileUtil.getTypesFromMethodTypeSignature((String)object32);
                        n2 = classNameArray4.length;
                        for (int i = 0; i < n2; ++i) {
                            ClassName className = classNameArray4[i];
                            BinaryAnalyser.addUsage(hashMap, className, ClassIndexImpl.UsageType.TYPE_REFERENCE);
                        }
                    }
                    catch (IllegalStateException illegalStateException) {
                        LOGGER.warning("Invalid method signature: " + string + "::" + object4.getName() + " signature is:" + (String)object32);
                    }
                }
                if ((classNameArray3 = object4.getCode()) == null) continue;
                LocalVariableTableEntry[] localVariableTableEntryArray2 = localVariableTableEntryArray = classNameArray3.getLocalVariableTable();
                int n4 = localVariableTableEntryArray2.length;
                for (n = 0; n < n4; ++n) {
                    LocalVariableTableEntry localVariableTableEntry = localVariableTableEntryArray2[n];
                    object2 = ClassFileUtil.getType(localVariableTableEntry.getDescription());
                    if (object2 == null) continue;
                    BinaryAnalyser.addUsage(hashMap, object2, ClassIndexImpl.UsageType.TYPE_REFERENCE);
                }
                LocalVariableTableEntry[] localVariableTableEntryArray3 = localVariableTableEntryArray2 = object4.getCode().getLocalVariableTypeTable();
                n = localVariableTableEntryArray3.length;
                for (int i = 0; i < n; ++i) {
                    LocalVariableTableEntry localVariableTableEntry = localVariableTableEntryArray3[i];
                    try {
                        ClassName[] classNameArray5;
                        for (ClassName className : classNameArray5 = ClassFileUtil.getTypesFromFiledTypeSignature(localVariableTableEntry.getSignature())) {
                            BinaryAnalyser.addUsage(hashMap, className, ClassIndexImpl.UsageType.TYPE_REFERENCE);
                        }
                        continue;
                    }
                    catch (IllegalStateException illegalStateException) {
                        LOGGER.warning("Invalid local variable signature: " + string + "::" + object4.getName());
                    }
                }
            }
            Collection collection2 = classFile.getVariables();
            for (Object object32 : collection2) {
                this.handleAnnotations(hashMap, object32.getAnnotations(), false);
                object2 = object32.getDescriptor();
                list = ClassFileUtil.getType((String)object2);
                if (list != null) {
                    BinaryAnalyser.addUsage(hashMap, (ClassName)list, ClassIndexImpl.UsageType.TYPE_REFERENCE);
                }
                if ((object2 = object32.getTypeSignature()) == null) continue;
                try {
                    for (ClassName className : classNameArray2 = ClassFileUtil.getTypesFromFiledTypeSignature((String)object2)) {
                        BinaryAnalyser.addUsage(hashMap, className, ClassIndexImpl.UsageType.TYPE_REFERENCE);
                    }
                }
                catch (IllegalStateException illegalStateException) {
                    LOGGER.warning("Invalid field signature: " + string + "::" + object32.getName() + " signature is: " + (String)object2);
                }
            }
            object4 = constantPool.getAllConstants(CPClassInfo.class);
            object32 = object4.iterator();
            while (object32.hasNext()) {
                object2 = (CPClassInfo)object32.next();
                list = ClassFileUtil.getType((CPClassInfo)object2);
                if (list == null || hashMap.keySet().contains(list)) continue;
                BinaryAnalyser.addUsage(hashMap, (ClassName)list, ClassIndexImpl.UsageType.TYPE_REFERENCE);
            }
        }
        return hashMap;
    }

    private List<String> getClassReferences(Pair<String, String> pair) {
        assert (pair != null);
        Object[] objectArray = this.refs.get(pair);
        if (objectArray == null) {
            objectArray = new Object[]{new ArrayList(), null, null};
            this.refs.put(pair, objectArray);
        }
        return (ArrayList)objectArray[0];
    }

    private void handleAnnotations(Map<ClassName, Set<ClassIndexImpl.UsageType>> map, Iterable<? extends Annotation> iterable, boolean bl) {
        for (Annotation annotation : iterable) {
            BinaryAnalyser.addUsage(map, annotation.getType(), ClassIndexImpl.UsageType.TYPE_REFERENCE);
            if (bl) continue;
            LinkedList<ElementValue> linkedList = new LinkedList<ElementValue>();
            for (AnnotationComponent annotationComponent : annotation.getComponents()) {
                linkedList.add(annotationComponent.getValue());
            }
            while (!linkedList.isEmpty()) {
                String string;
                ClassName className;
                ElementValue elementValue = (ElementValue)linkedList.remove(0);
                if (elementValue instanceof ArrayElementValue) {
                    linkedList.addAll(Arrays.asList(((ArrayElementValue)elementValue).getValues()));
                }
                if (elementValue instanceof NestedElementValue) {
                    Annotation annotation2 = ((NestedElementValue)elementValue).getNestedValue();
                    BinaryAnalyser.addUsage(map, annotation2.getType(), ClassIndexImpl.UsageType.TYPE_REFERENCE);
                    for (AnnotationComponent annotationComponent : annotation2.getComponents()) {
                        linkedList.add(annotationComponent.getValue());
                    }
                }
                if (elementValue instanceof ClassElementValue) {
                    BinaryAnalyser.addUsage(map, ((ClassElementValue)elementValue).getClassName(), ClassIndexImpl.UsageType.TYPE_REFERENCE);
                }
                if (!(elementValue instanceof EnumElementValue) || (className = ClassFileUtil.getType(string = ((EnumElementValue)elementValue).getEnumType())) == null) continue;
                BinaryAnalyser.addUsage(map, className, ClassIndexImpl.UsageType.TYPE_REFERENCE);
            }
        }
    }

    private static String nameToString(ClassName className) {
        return className.getInternalName().replace('/', '.');
    }

    private static void addUsage(Map<ClassName, Set<ClassIndexImpl.UsageType>> map, ClassName className, ClassIndexImpl.UsageType usageType) {
        if (OBJECT.equals(className.getExternalName())) {
            return;
        }
        Set<ClassIndexImpl.UsageType> set = map.get(className);
        if (set == null) {
            set = EnumSet.noneOf(ClassIndexImpl.UsageType.class);
            map.put(className, set);
        }
        set.add(usageType);
    }

    private static void prebuildArgs(ZipFile zipFile, URL uRL) {
        ZipEntry zipEntry;
        ZipEntry zipEntry2 = zipFile.getEntry(FileObjects.convertPackage2Folder(JComponent.class.getName()) + '.' + "class");
        if (zipEntry2 != null && (zipEntry = zipFile.getEntry(FileObjects.convertPackage2Folder(Object.class.getName()) + '.' + "class")) != null) {
            ClasspathInfo classpathInfo = ClasspathInfo.create(ClassPathSupport.createClassPath((URL[])new URL[]{uRL}), ClassPathSupport.createClassPath((URL[])new URL[0]), ClassPathSupport.createClassPath((URL[])new URL[0]));
            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            class DevNullDiagnosticListener
            implements DiagnosticListener<JavaFileObject> {
                DevNullDiagnosticListener() {
                }

                @Override
                public void report(Diagnostic<? extends JavaFileObject> diagnostic) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.log(Level.FINE, "Diagnostic reported during prebuilding args: {0}", diagnostic.toString());
                    }
                }
            }
            JavacTaskImpl javacTaskImpl = JavacParser.createJavacTask(classpathInfo, new DevNullDiagnosticListener(), null, null, null);
            TreeLoader.preRegister(javacTaskImpl.getContext(), classpathInfo);
            Symbol.ClassSymbol classSymbol = ((JavacElements)javacTaskImpl.getElements()).getTypeElement(JComponent.class.getName());
            if (classSymbol != null) {
                List<ExecutableElement> list = ElementFilter.methodsIn(classSymbol.getEnclosedElements());
                for (ExecutableElement executableElement : list) {
                    List<? extends VariableElement> list2 = executableElement.getParameters();
                    if (list2.isEmpty()) continue;
                    list2.get(0).getSimpleName();
                    break;
                }
            }
        }
    }

    private class DeletedContinuation
    extends Continuation {
        private DeletedContinuation() {
        }

        protected Result doExecute() throws IOException {
            BinaryAnalyser.this.index.clear();
            return Result.FINISHED;
        }

        protected void doFinish() throws IOException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FileObjectContinuation
    extends Continuation {
        private final Enumeration<? extends FileObject> todo;
        private FileObject root;
        private final AtomicBoolean cancel;
        private final AtomicBoolean closed;

        public FileObjectContinuation(Enumeration<? extends FileObject> enumeration, AtomicBoolean atomicBoolean, AtomicBoolean atomicBoolean2) {
            assert (enumeration != null);
            assert (atomicBoolean != null);
            this.todo = enumeration;
            this.cancel = atomicBoolean;
            this.closed = atomicBoolean2;
        }

        @Override
        public Result doExecute() throws IOException {
            return BinaryAnalyser.this.analyseFileObjects(this.todo, this.root, this.cancel, this.closed, this);
        }

        @Override
        public void doFinish() throws IOException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FolderContinuation
    extends Continuation {
        private final LinkedList<File> todo;
        private final String rootPath;
        private final AtomicBoolean cancel;
        private final AtomicBoolean closed;

        public FolderContinuation(LinkedList<File> linkedList, String string, AtomicBoolean atomicBoolean, AtomicBoolean atomicBoolean2) {
            assert (linkedList != null);
            assert (string != null);
            assert (atomicBoolean != null);
            this.todo = linkedList;
            this.rootPath = string;
            this.cancel = atomicBoolean;
            this.closed = atomicBoolean2;
        }

        @Override
        public Result doExecute() throws IOException {
            return BinaryAnalyser.this.analyseFolder(this.todo, this.rootPath, this.cancel, this.closed, this);
        }

        @Override
        public void doFinish() throws IOException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ZipContinuation
    extends Continuation {
        private final ZipFile zipFile;
        private final Enumeration<? extends ZipEntry> entries;
        private final AtomicBoolean cancel;
        private final AtomicBoolean closed;

        public ZipContinuation(ZipFile zipFile, Enumeration<? extends ZipEntry> enumeration, AtomicBoolean atomicBoolean, AtomicBoolean atomicBoolean2) {
            assert (zipFile != null);
            assert (enumeration != null);
            assert (atomicBoolean != null);
            this.zipFile = zipFile;
            this.entries = enumeration;
            this.cancel = atomicBoolean;
            this.closed = atomicBoolean2;
        }

        @Override
        protected Result doExecute() throws IOException {
            return BinaryAnalyser.this.analyseArchive(this.zipFile, this.entries, this.cancel, this.closed, this);
        }

        @Override
        protected void doFinish() throws IOException {
            this.zipFile.close();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class Continuation {
        private List<Pair<ElementHandle<TypeElement>, Long>> result = new ArrayList<Pair<ElementHandle<TypeElement>, Long>>();

        protected Continuation() {
        }

        protected abstract Result doExecute() throws IOException;

        protected abstract void doFinish() throws IOException;

        protected final void report(ElementHandle<TypeElement> elementHandle, long l) {
            this.result.add(Pair.of(elementHandle, l));
        }

        public final Result execute() throws IOException {
            return this.doExecute();
        }

        public final List<Pair<ElementHandle<TypeElement>, Long>> finish() throws IOException {
            this.doFinish();
            Collections.sort(this.result, new Comparator(){

                public int compare(Object object, Object object2) {
                    Pair pair = (Pair)object;
                    Pair pair2 = (Pair)object2;
                    return ((ElementHandle)pair.first).getQualifiedName().compareTo(((ElementHandle)pair2.first).getQualifiedName());
                }
            });
            return this.result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Changes {
        static final List<ElementHandle<TypeElement>> NO_CHANGES = Collections.emptyList();
        public final List<ElementHandle<TypeElement>> added;
        public final List<ElementHandle<TypeElement>> removed;
        public final List<ElementHandle<TypeElement>> changed;

        private Changes(List<ElementHandle<TypeElement>> list, List<ElementHandle<TypeElement>> list2, List<ElementHandle<TypeElement>> list3) {
            this.added = list;
            this.removed = list2;
            this.changed = list3;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Result {
        FINISHED,
        CANCELED,
        CLOSED;

    }
}

