/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor.api;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.im.InputContext;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.List;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPasswordField;
import javax.swing.TransferHandler;
import javax.swing.plaf.UIResource;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.TextAction;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.ext.ExtKit;
import org.netbeans.modules.csl.api.KeystrokeHandler;
import org.netbeans.modules.csl.core.Language;
import org.netbeans.modules.csl.core.LanguageRegistry;
import org.netbeans.modules.csl.core.SelectCodeElementAction;
import org.netbeans.modules.csl.editor.InstantRenameAction;
import org.netbeans.modules.csl.editor.ToggleBlockCommentAction;
import org.netbeans.modules.csl.spi.CommentHandler;
import org.netbeans.modules.editor.NbEditorKit;
import org.netbeans.modules.html.editor.gsf.HtmlCommentHandler;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;

public class HtmlKit
extends NbEditorKit
implements HelpCtx.Provider {
    static final long serialVersionUID = -1381945567613910297L;
    public static final String HTML_MIME_TYPE = "text/html";

    public HelpCtx getHelpCtx() {
        return new HelpCtx(HtmlKit.class);
    }

    public HtmlKit() {
        this(HTML_MIME_TYPE);
    }

    public HtmlKit(String string) {
    }

    public String getContentType() {
        return HTML_MIME_TYPE;
    }

    public Object clone() {
        return new HtmlKit();
    }

    public void install(JEditorPane jEditorPane) {
        super.install(jEditorPane);
        jEditorPane.setTransferHandler(new HtmlTransferHandler());
    }

    protected BaseKit.DeleteCharAction createDeletePrevAction() {
        return new HtmlDeleteCharAction("delete-previous", false);
    }

    protected ExtKit.ExtDefaultKeyTypedAction createDefaultKeyTypedAction() {
        return new HtmlDefaultKeyTypedAction();
    }

    protected BaseKit.InsertBreakAction createInsertBreakAction() {
        return new HtmlInsertBreakAction();
    }

    protected Action[] createActions() {
        Action[] actionArray = new Action[]{this.createInsertBreakAction(), this.createDefaultKeyTypedAction(), this.createDeletePrevAction(), new HtmlDeleteCharAction("delete-next", true), new SelectCodeElementAction("select-element-next", true), new SelectCodeElementAction("select-element-previous", false), new InstantRenameAction(), new ToggleBlockCommentAction((CommentHandler)new HtmlCommentHandler()), new ExtKit.CommentAction(""), new ExtKit.UncommentAction("")};
        return TextAction.augmentList(super.createActions(), actionArray);
    }

    static KeystrokeHandler getBracketCompletion(Document document, int n) {
        BaseDocument baseDocument = (BaseDocument)document;
        List list = LanguageRegistry.getInstance().getEmbeddedLanguages(baseDocument, n);
        for (Language language : list) {
            if (language.getBracketCompletion() == null) continue;
            return language.getBracketCompletion();
        }
        return null;
    }

    private static boolean completionSettingEnabled() {
        return true;
    }

    private static class BasicTransferable
    implements Transferable,
    UIResource {
        protected String plainData;
        protected String htmlData;
        private static DataFlavor[] htmlFlavors;
        private static DataFlavor[] stringFlavors;
        private static DataFlavor[] plainFlavors;

        public BasicTransferable(String string, String string2) {
            this.plainData = string;
            this.htmlData = string2;
        }

        public DataFlavor[] getTransferDataFlavors() {
            DataFlavor[] dataFlavorArray = this.getRicherFlavors();
            int n = dataFlavorArray != null ? dataFlavorArray.length : 0;
            int n2 = this.isHTMLSupported() ? htmlFlavors.length : 0;
            int n3 = this.isPlainSupported() ? plainFlavors.length : 0;
            int n4 = this.isPlainSupported() ? stringFlavors.length : 0;
            int n5 = n + n2 + n3 + n4;
            DataFlavor[] dataFlavorArray2 = new DataFlavor[n5];
            int n6 = 0;
            if (n > 0) {
                System.arraycopy(dataFlavorArray, 0, dataFlavorArray2, n6, n);
                n6 += n;
            }
            if (n2 > 0) {
                System.arraycopy(htmlFlavors, 0, dataFlavorArray2, n6, n2);
                n6 += n2;
            }
            if (n3 > 0) {
                System.arraycopy(plainFlavors, 0, dataFlavorArray2, n6, n3);
                n6 += n3;
            }
            if (n4 > 0) {
                System.arraycopy(stringFlavors, 0, dataFlavorArray2, n6, n4);
                n6 += n4;
            }
            return dataFlavorArray2;
        }

        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            DataFlavor[] dataFlavorArray = this.getTransferDataFlavors();
            for (int i = 0; i < dataFlavorArray.length; ++i) {
                if (!dataFlavorArray[i].equals(dataFlavor)) continue;
                return true;
            }
            return false;
        }

        public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
            DataFlavor[] dataFlavorArray = this.getRicherFlavors();
            if (this.isRicherFlavor(dataFlavor)) {
                return this.getRicherData(dataFlavor);
            }
            if (this.isHTMLFlavor(dataFlavor)) {
                String string = this.getHTMLData();
                String string2 = string = string == null ? "" : string;
                if (String.class.equals(dataFlavor.getRepresentationClass())) {
                    return string;
                }
                if (Reader.class.equals(dataFlavor.getRepresentationClass())) {
                    return new StringReader(string);
                }
                if (InputStream.class.equals(dataFlavor.getRepresentationClass())) {
                    return new ByteArrayInputStream(string.getBytes());
                }
            } else if (this.isPlainFlavor(dataFlavor)) {
                String string = this.getPlainData();
                String string3 = string = string == null ? "" : string;
                if (String.class.equals(dataFlavor.getRepresentationClass())) {
                    return string;
                }
                if (Reader.class.equals(dataFlavor.getRepresentationClass())) {
                    return new StringReader(string);
                }
                if (InputStream.class.equals(dataFlavor.getRepresentationClass())) {
                    return new ByteArrayInputStream(string.getBytes());
                }
            } else if (this.isStringFlavor(dataFlavor)) {
                String string = this.getPlainData();
                string = string == null ? "" : string;
                return string;
            }
            throw new UnsupportedFlavorException(dataFlavor);
        }

        protected boolean isRicherFlavor(DataFlavor dataFlavor) {
            DataFlavor[] dataFlavorArray = this.getRicherFlavors();
            int n = dataFlavorArray != null ? dataFlavorArray.length : 0;
            for (int i = 0; i < n; ++i) {
                if (!dataFlavorArray[i].equals(dataFlavor)) continue;
                return true;
            }
            return false;
        }

        protected DataFlavor[] getRicherFlavors() {
            return null;
        }

        protected Object getRicherData(DataFlavor dataFlavor) throws UnsupportedFlavorException {
            return null;
        }

        protected boolean isHTMLFlavor(DataFlavor dataFlavor) {
            DataFlavor[] dataFlavorArray = htmlFlavors;
            for (int i = 0; i < dataFlavorArray.length; ++i) {
                if (!dataFlavorArray[i].equals(dataFlavor)) continue;
                return true;
            }
            return false;
        }

        protected boolean isHTMLSupported() {
            return this.htmlData != null;
        }

        protected String getHTMLData() {
            return this.htmlData;
        }

        protected boolean isPlainFlavor(DataFlavor dataFlavor) {
            DataFlavor[] dataFlavorArray = plainFlavors;
            for (int i = 0; i < dataFlavorArray.length; ++i) {
                if (!dataFlavorArray[i].equals(dataFlavor)) continue;
                return true;
            }
            return false;
        }

        protected boolean isPlainSupported() {
            return this.plainData != null;
        }

        protected String getPlainData() {
            return this.plainData;
        }

        protected boolean isStringFlavor(DataFlavor dataFlavor) {
            DataFlavor[] dataFlavorArray = stringFlavors;
            for (int i = 0; i < dataFlavorArray.length; ++i) {
                if (!dataFlavorArray[i].equals(dataFlavor)) continue;
                return true;
            }
            return false;
        }

        static {
            try {
                htmlFlavors = new DataFlavor[3];
                BasicTransferable.htmlFlavors[0] = new DataFlavor("text/html;class=java.lang.String");
                BasicTransferable.htmlFlavors[1] = new DataFlavor("text/html;class=java.io.Reader");
                BasicTransferable.htmlFlavors[2] = new DataFlavor("text/html;charset=unicode;class=java.io.InputStream");
                plainFlavors = new DataFlavor[3];
                BasicTransferable.plainFlavors[0] = new DataFlavor("text/plain;class=java.lang.String");
                BasicTransferable.plainFlavors[1] = new DataFlavor("text/plain;class=java.io.Reader");
                BasicTransferable.plainFlavors[2] = new DataFlavor("text/plain;charset=unicode;class=java.io.InputStream");
                stringFlavors = new DataFlavor[2];
                BasicTransferable.stringFlavors[0] = new DataFlavor("application/x-java-jvm-local-objectref;class=java.lang.String");
                BasicTransferable.stringFlavors[1] = DataFlavor.stringFlavor;
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.err.println("error initializing javax.swing.plaf.basic.BasicTranserable");
            }
        }
    }

    static class HtmlTransferHandler
    extends TransferHandler
    implements UIResource {
        private JTextComponent exportComp;
        private boolean shouldRemove;
        private int p0;
        private int p1;

        HtmlTransferHandler() {
        }

        protected DataFlavor getImportFlavor(DataFlavor[] dataFlavorArray, JTextComponent jTextComponent) {
            DataFlavor dataFlavor = null;
            DataFlavor dataFlavor2 = null;
            DataFlavor dataFlavor3 = null;
            if (jTextComponent instanceof JEditorPane) {
                for (int i = 0; i < dataFlavorArray.length; ++i) {
                    String string = dataFlavorArray[i].getMimeType();
                    if (string.startsWith(((JEditorPane)jTextComponent).getEditorKit().getContentType())) continue;
                    if (dataFlavor == null && string.startsWith("text/plain")) {
                        dataFlavor = dataFlavorArray[i];
                        continue;
                    }
                    if (dataFlavor2 == null && string.startsWith("application/x-java-jvm-local-objectref") && dataFlavorArray[i].getRepresentationClass() == String.class) {
                        dataFlavor2 = dataFlavorArray[i];
                        continue;
                    }
                    if (dataFlavor3 != null || !dataFlavorArray[i].equals(DataFlavor.stringFlavor)) continue;
                    dataFlavor3 = dataFlavorArray[i];
                }
                if (dataFlavor != null) {
                    return dataFlavor;
                }
                if (dataFlavor2 != null) {
                    return dataFlavor2;
                }
                if (dataFlavor3 != null) {
                    return dataFlavor3;
                }
                return null;
            }
            for (int i = 0; i < dataFlavorArray.length; ++i) {
                String string = dataFlavorArray[i].getMimeType();
                if (string.startsWith("text/plain")) {
                    return dataFlavorArray[i];
                }
                if (dataFlavor2 == null && string.startsWith("application/x-java-jvm-local-objectref") && dataFlavorArray[i].getRepresentationClass() == String.class) {
                    dataFlavor2 = dataFlavorArray[i];
                    continue;
                }
                if (dataFlavor3 != null || !dataFlavorArray[i].equals(DataFlavor.stringFlavor)) continue;
                dataFlavor3 = dataFlavorArray[i];
            }
            if (dataFlavor2 != null) {
                return dataFlavor2;
            }
            if (dataFlavor3 != null) {
                return dataFlavor3;
            }
            return null;
        }

        protected void handleReaderImport(Reader reader, JTextComponent jTextComponent, boolean bl) throws BadLocationException, IOException {
            if (bl) {
                int n = jTextComponent.getSelectionStart();
                int n2 = jTextComponent.getSelectionEnd();
                int n3 = n2 - n;
                EditorKit editorKit = jTextComponent.getUI().getEditorKit(jTextComponent);
                Document document = jTextComponent.getDocument();
                if (n3 > 0) {
                    document.remove(n, n3);
                }
                editorKit.read(reader, document, n);
            } else {
                int n;
                char[] cArray = new char[1024];
                boolean bl2 = false;
                StringBuffer stringBuffer = null;
                while ((n = reader.read(cArray, 0, cArray.length)) != -1) {
                    if (stringBuffer == null) {
                        stringBuffer = new StringBuffer(n);
                    }
                    int n4 = 0;
                    block5: for (int i = 0; i < n; ++i) {
                        switch (cArray[i]) {
                            case '\r': {
                                if (bl2) {
                                    if (i == 0) {
                                        stringBuffer.append('\n');
                                        continue block5;
                                    }
                                    cArray[i - 1] = 10;
                                    continue block5;
                                }
                                bl2 = true;
                                continue block5;
                            }
                            case '\n': {
                                if (!bl2) continue block5;
                                if (i > n4 + 1) {
                                    stringBuffer.append(cArray, n4, i - n4 - 1);
                                }
                                bl2 = false;
                                n4 = i;
                                continue block5;
                            }
                            default: {
                                if (!bl2) continue block5;
                                if (i == 0) {
                                    stringBuffer.append('\n');
                                } else {
                                    cArray[i - 1] = 10;
                                }
                                bl2 = false;
                            }
                        }
                    }
                    if (n4 >= n) continue;
                    if (bl2) {
                        if (n4 >= n - 1) continue;
                        stringBuffer.append(cArray, n4, n - n4 - 1);
                        continue;
                    }
                    stringBuffer.append(cArray, n4, n - n4);
                }
                if (bl2) {
                    stringBuffer.append('\n');
                }
                jTextComponent.replaceSelection(stringBuffer != null ? stringBuffer.toString() : "");
            }
        }

        public int getSourceActions(JComponent jComponent) {
            int n = 0;
            if (!(jComponent instanceof JPasswordField)) {
                n = ((JTextComponent)jComponent).isEditable() ? 3 : 1;
            }
            return n;
        }

        protected Transferable createTransferable(JComponent jComponent) {
            this.exportComp = (JTextComponent)jComponent;
            this.shouldRemove = true;
            this.p0 = this.exportComp.getSelectionStart();
            this.p1 = this.exportComp.getSelectionEnd();
            return this.p0 != this.p1 ? new HtmlTransferable(this.exportComp, this.p0, this.p1) : null;
        }

        protected void exportDone(JComponent jComponent, Transferable transferable, int n) {
            if (this.shouldRemove && n == 2) {
                HtmlTransferable htmlTransferable = (HtmlTransferable)transferable;
                htmlTransferable.removeText();
            }
            this.exportComp = null;
        }

        public boolean importData(JComponent jComponent, Transferable transferable) {
            JTextComponent jTextComponent = (JTextComponent)jComponent;
            if (jTextComponent == this.exportComp && jTextComponent.getCaretPosition() >= this.p0 && jTextComponent.getCaretPosition() <= this.p1) {
                this.shouldRemove = false;
                return true;
            }
            boolean bl = false;
            DataFlavor dataFlavor = this.getImportFlavor(transferable.getTransferDataFlavors(), jTextComponent);
            if (dataFlavor != null) {
                try {
                    Object object;
                    boolean bl2 = false;
                    if (jComponent instanceof JEditorPane && !((JEditorPane)(object = (JEditorPane)jComponent)).getContentType().startsWith("text/plain") && dataFlavor.getMimeType().startsWith(((JEditorPane)object).getContentType())) {
                        bl2 = true;
                    }
                    if ((object = jTextComponent.getInputContext()) != null) {
                        ((InputContext)object).endComposition();
                    }
                    Reader reader = dataFlavor.getReaderForText(transferable);
                    this.handleReaderImport(reader, jTextComponent, bl2);
                    bl = true;
                }
                catch (UnsupportedFlavorException unsupportedFlavorException) {
                }
                catch (BadLocationException badLocationException) {
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return bl;
        }

        public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
            JTextComponent jTextComponent = (JTextComponent)jComponent;
            if (!jTextComponent.isEditable() || !jTextComponent.isEnabled()) {
                return false;
            }
            return this.getImportFlavor(dataFlavorArray, jTextComponent) != null;
        }

        static class HtmlTransferable
        extends BasicTransferable {
            Position p0;
            Position p1;
            String mimeType;
            String richText;
            JTextComponent c;

            HtmlTransferable(JTextComponent jTextComponent, int n, int n2) {
                super(null, null);
                this.c = jTextComponent;
                Document document = jTextComponent.getDocument();
                try {
                    this.p0 = document.createPosition(n);
                    this.p1 = document.createPosition(n2);
                    this.plainData = jTextComponent.getSelectedText();
                    if (jTextComponent instanceof JEditorPane) {
                        JEditorPane jEditorPane = (JEditorPane)jTextComponent;
                        this.mimeType = jEditorPane.getContentType();
                        if (this.mimeType.startsWith("text/plain")) {
                            return;
                        }
                        StringWriter stringWriter = new StringWriter(this.p1.getOffset() - this.p0.getOffset());
                        jEditorPane.getEditorKit().write(stringWriter, document, this.p0.getOffset(), this.p1.getOffset() - this.p0.getOffset());
                        if (this.mimeType.startsWith(HtmlKit.HTML_MIME_TYPE)) {
                            this.htmlData = stringWriter.toString();
                        } else {
                            this.richText = stringWriter.toString();
                        }
                    }
                }
                catch (BadLocationException badLocationException) {
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }

            void removeText() {
                if (this.p0 != null && this.p1 != null && this.p0.getOffset() != this.p1.getOffset()) {
                    try {
                        Document document = this.c.getDocument();
                        document.remove(this.p0.getOffset(), this.p1.getOffset() - this.p0.getOffset());
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
            }

            protected DataFlavor[] getRicherFlavors() {
                if (this.richText == null) {
                    return null;
                }
                try {
                    DataFlavor[] dataFlavorArray = new DataFlavor[]{new DataFlavor(this.mimeType + ";class=java.lang.String"), new DataFlavor(this.mimeType + ";class=java.io.Reader"), new DataFlavor(this.mimeType + ";class=java.io.InputStream;charset=unicode")};
                    return dataFlavorArray;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    return null;
                }
            }

            protected Object getRicherData(DataFlavor dataFlavor) throws UnsupportedFlavorException {
                if (this.richText == null) {
                    return null;
                }
                if (String.class.equals(dataFlavor.getRepresentationClass())) {
                    return this.richText;
                }
                if (Reader.class.equals(dataFlavor.getRepresentationClass())) {
                    return new StringReader(this.richText);
                }
                if (InputStream.class.equals(dataFlavor.getRepresentationClass())) {
                    return new ByteArrayInputStream(this.richText.getBytes());
                }
                throw new UnsupportedFlavorException(dataFlavor);
            }
        }
    }

    public static class HtmlDeleteCharAction
    extends BaseKit.DeleteCharAction {
        private JTextComponent currentTarget;

        public HtmlDeleteCharAction(String string, boolean bl) {
            super(string, bl);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            try {
                this.currentTarget = jTextComponent;
                super.actionPerformed(actionEvent, jTextComponent);
            }
            finally {
                this.currentTarget = null;
            }
        }

        protected void charBackspaced(BaseDocument baseDocument, int n, Caret caret, char c) throws BadLocationException {
            KeystrokeHandler keystrokeHandler;
            if (HtmlKit.completionSettingEnabled() && (keystrokeHandler = HtmlKit.getBracketCompletion((Document)baseDocument, n)) != null) {
                boolean bl = keystrokeHandler.charBackspaced((Document)baseDocument, n, this.currentTarget, c);
                return;
            }
            super.charBackspaced(baseDocument, n, caret, c);
        }

        public boolean getNextChar() {
            return this.nextChar;
        }
    }

    public static class HtmlDefaultKeyTypedAction
    extends ExtKit.ExtDefaultKeyTypedAction {
        private JTextComponent currentTarget;

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            this.currentTarget = jTextComponent;
            super.actionPerformed(actionEvent, jTextComponent);
            this.currentTarget = null;
        }

        protected void insertString(BaseDocument baseDocument, int n, Caret caret, String string, boolean bl) throws BadLocationException {
            KeystrokeHandler keystrokeHandler;
            if (HtmlKit.completionSettingEnabled() && (keystrokeHandler = HtmlKit.getBracketCompletion((Document)baseDocument, n)) != null) {
                boolean bl2 = keystrokeHandler.beforeCharInserted((Document)baseDocument, n, this.currentTarget, string.charAt(0));
                if (!bl2) {
                    super.insertString(baseDocument, n, caret, string, bl);
                    bl2 = keystrokeHandler.afterCharInserted((Document)baseDocument, n, this.currentTarget, string.charAt(0));
                }
                return;
            }
            super.insertString(baseDocument, n, caret, string, bl);
        }

        protected void replaceSelection(JTextComponent jTextComponent, int n, Caret caret, String string, boolean bl) throws BadLocationException {
            char c = string.charAt(0);
            Document document = jTextComponent.getDocument();
            if (document instanceof BaseDocument) {
                KeystrokeHandler keystrokeHandler;
                BaseDocument baseDocument = (BaseDocument)document;
                if (HtmlKit.completionSettingEnabled() && (keystrokeHandler = HtmlKit.getBracketCompletion((Document)baseDocument, n)) != null) {
                    try {
                        int n2 = caret.getDot();
                        boolean bl2 = keystrokeHandler.beforeCharInserted((Document)baseDocument, n2, jTextComponent, c);
                        int n3 = Math.min(caret.getDot(), caret.getMark());
                        int n4 = Math.max(caret.getDot(), caret.getMark());
                        if (n3 != n4) {
                            baseDocument.remove(n3, n4 - n3);
                        }
                        if (!bl2) {
                            if (string != null && string.length() > 0) {
                                baseDocument.insertString(n3, string, null);
                            }
                            keystrokeHandler.afterCharInserted((Document)baseDocument, caret.getDot() - 1, jTextComponent, c);
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        badLocationException.printStackTrace();
                    }
                    return;
                }
            }
            super.replaceSelection(jTextComponent, n, caret, string, bl);
        }
    }

    public class HtmlInsertBreakAction
    extends BaseKit.InsertBreakAction {
        static final long serialVersionUID = -1506173310438326380L;

        protected Object beforeBreak(JTextComponent jTextComponent, BaseDocument baseDocument, Caret caret) {
            KeystrokeHandler keystrokeHandler;
            if (HtmlKit.completionSettingEnabled() && (keystrokeHandler = HtmlKit.getBracketCompletion((Document)baseDocument, caret.getDot())) != null) {
                try {
                    int n = keystrokeHandler.beforeBreak((Document)baseDocument, caret.getDot(), jTextComponent);
                    if (n >= 0) {
                        return new Integer(n);
                    }
                }
                catch (BadLocationException badLocationException) {
                    Exceptions.printStackTrace((Throwable)badLocationException);
                }
            }
            return null;
        }

        protected void afterBreak(JTextComponent jTextComponent, BaseDocument baseDocument, Caret caret, Object object) {
            if (HtmlKit.completionSettingEnabled() && object != null && object instanceof Integer) {
                int n = (Integer)object;
                if (n != -1) {
                    caret.setDot(n);
                } else {
                    int n2 = caret.getDot();
                    caret.setDot(n2 + 1);
                }
            }
        }
    }
}

