/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.editor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.logging.Logger;
import org.netbeans.modules.css.editor.Property;
import org.netbeans.modules.css.editor.PropertyModel;
import org.netbeans.modules.css.editor.properties.Acceptors;
import org.netbeans.modules.css.editor.properties.CssPropertyValueAcceptor;
import org.netbeans.modules.css.editor.properties.KeywordUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CssPropertyValue {
    final PropertyModel.GroupElement groupElement;
    private final String text;
    private final List<ResolvedToken> resolved = new ArrayList<ResolvedToken>();
    private Set<PropertyModel.Element> resolvedAlternatives;
    private Set<PropertyModel.Element> visibleAlternatives = new HashSet<PropertyModel.Element>();
    private final Stack<String> stack = new Stack();
    private final String propertyDefinition;
    Stack<String> originalStack;
    final StringBuffer log = new StringBuffer();

    public CssPropertyValue(Property property, String string) {
        this.groupElement = property.values();
        this.text = string;
        this.propertyDefinition = null;
        this.consume();
    }

    CssPropertyValue(String string, String string2) {
        this.groupElement = PropertyModel.instance().parse(string);
        this.text = string2;
        this.propertyDefinition = string;
        this.consume();
    }

    private void log(String string) {
        this.log.append(string);
    }

    String log() {
        return this.log.toString();
    }

    String inputText() {
        return this.text;
    }

    String propertyDefinition() {
        return this.propertyDefinition;
    }

    public List<String> left() {
        return this.stack;
    }

    public List<ResolvedToken> resolved() {
        return this.resolved;
    }

    public boolean success() {
        return this.stack.isEmpty();
    }

    public Set<PropertyModel.Element> alternatives() {
        if (this.resolvedAlternatives == null) {
            this.initAlternatives();
        }
        return this.resolvedAlternatives;
    }

    public Set<PropertyModel.Element> visibleAlternatives() {
        if (this.resolvedAlternatives == null) {
            this.initAlternatives();
        }
        return this.visibleAlternatives;
    }

    private void computeVisibleAlts() {
        for (PropertyModel.Element element : this.alternatives()) {
            if (element instanceof PropertyModel.ValueElement && ((PropertyModel.ValueElement)element).isUnit()) continue;
            this.visibleAlternatives.add(element);
        }
    }

    private void consume() {
        CssPropertyValue.fillStack(this.stack, this.text);
        this.originalStack = (Stack)this.stack.clone();
        this.resolve(this.groupElement, this.stack, this.resolved);
    }

    private void initAlternatives() {
        this.resolvedAlternatives = this.resolveElement(this.groupElement, new ArrayList<ResolvedToken>(this.resolved)).alternatives();
        this.eliminateDuplicatedAlternatives();
        this.computeVisibleAlts();
    }

    private void eliminateDuplicatedAlternatives() {
        this.log("\nEliminated duplicate alternatives:\n");
        HashMap<String, PropertyModel.Element> hashMap = new HashMap<String, PropertyModel.Element>();
        for (PropertyModel.Element element : this.alternatives()) {
            if (hashMap.put(element.toString(), element) == null) continue;
            this.log(element.path() + "\n");
        }
        this.log("-----------------\n");
        this.alternatives().retainAll(hashMap.values());
    }

    private ResolveContext resolveElement(PropertyModel.Element element, List<ResolvedToken> list) {
        int n;
        ResolveContext.ResolveType resolveType = ResolveContext.ResolveType.UNEVALUATED;
        HashSet<PropertyModel.Element> hashSet = new HashSet<PropertyModel.Element>();
        block0: for (n = 0; n < element.getMaximumOccurances(); ++n) {
            Object object;
            ResolveContext.ResolveType resolveType2 = resolveType;
            if (resolveType == ResolveContext.ResolveType.UNRESOLVED) break;
            resolveType = ResolveContext.ResolveType.UNRESOLVED;
            if (element instanceof PropertyModel.ValueElement) {
                if (!this.consume(element, list)) break;
                resolveType = ResolveContext.ResolveType.PARTIALLY_RESOLVED;
                continue;
            }
            if (!(element instanceof PropertyModel.GroupElement)) continue;
            PropertyModel.GroupElement groupElement = (PropertyModel.GroupElement)element;
            if (!groupElement.isList() && !groupElement.isSequence()) {
                for (PropertyModel.Element element2 : groupElement.elements()) {
                    object = this.resolveElement(element2, list);
                    if (((ResolveContext)object).resolveType() == ResolveContext.ResolveType.PARTIALLY_RESOLVED_SEQUENCE) {
                        resolveType = ResolveContext.ResolveType.PARTIALLY_RESOLVED_SEQUENCE;
                        hashSet.clear();
                        hashSet.addAll(((ResolveContext)object).alternatives());
                        break block0;
                    }
                    if (((ResolveContext)object).resolved()) {
                        resolveType = ResolveContext.ResolveType.FULLY_RESOLVED;
                        hashSet.clear();
                        hashSet.addAll(((ResolveContext)object).alternatives());
                        continue block0;
                    }
                    hashSet.addAll(((ResolveContext)object).alternatives());
                }
                continue;
            }
            if (groupElement.isList()) {
                for (PropertyModel.Element element3 : groupElement.elements()) {
                    object = this.resolveElement(element3, list);
                    hashSet.addAll(((ResolveContext)object).alternatives());
                    if (((ResolveContext)object).resolveType() == ResolveContext.ResolveType.PARTIALLY_RESOLVED_SEQUENCE) {
                        resolveType = ResolveContext.ResolveType.PARTIALLY_RESOLVED_SEQUENCE;
                        hashSet.clear();
                        hashSet.addAll(((ResolveContext)object).alternatives());
                        break block0;
                    }
                    if (!((ResolveContext)object).resolved()) continue;
                    resolveType = ResolveContext.ResolveType.FULLY_RESOLVED;
                }
                continue;
            }
            if (!groupElement.isSequence()) continue;
            this.log("<S> " + groupElement.path() + "\n");
            Object object3 = null;
            HashSet<PropertyModel.Element> hashSet2 = new HashSet<PropertyModel.Element>();
            for (PropertyModel.Element element4 : groupElement.elements()) {
                ResolveContext resolveContext = this.resolveElement(element4, list);
                this.log("trying " + element4.path() + " (MIN=" + element4.getMinimumOccurances() + "; MAX=" + element4.getMaximumOccurances() + "; resolved=" + (Object)((Object)resolveContext.resolveType()) + "; alts=" + resolveContext.alternatives().size() + ")\n");
                if (resolveContext.resolveType() == ResolveContext.ResolveType.UNRESOLVED) {
                    hashSet2.addAll(resolveContext.alternatives());
                    if (element4.getMinimumOccurances() <= 0) continue;
                    object3 = element4;
                    break;
                }
                if (resolveContext.resolveType() == ResolveContext.ResolveType.FULLY_RESOLVED) {
                    resolveType = ResolveContext.ResolveType.PARTIALLY_RESOLVED_SEQUENCE;
                    hashSet2.clear();
                    continue;
                }
                if (resolveContext.resolveType() != ResolveContext.ResolveType.PARTIALLY_RESOLVED_SEQUENCE) continue;
                resolveType = ResolveContext.ResolveType.PARTIALLY_RESOLVED_SEQUENCE;
                hashSet2.clear();
                hashSet2.addAll(resolveContext.alternatives());
                object3 = element4;
                this.log("break on " + element4.path() + "\n");
                break;
            }
            hashSet.addAll(hashSet2);
            if (object3 == null) {
                resolveType = ResolveContext.ResolveType.FULLY_RESOLVED;
            } else if (resolveType2 == ResolveContext.ResolveType.FULLY_RESOLVED) {
                resolveType = ResolveContext.ResolveType.PARTIALLY_RESOLVED_SEQUENCE;
            }
            this.log("sequence " + (Object)((Object)resolveType) + "\n");
            if (resolveType == ResolveContext.ResolveType.PARTIALLY_RESOLVED_SEQUENCE) break;
        }
        int n2 = element.getMaximumOccurances() - n;
        if (element instanceof PropertyModel.ValueElement) {
            if (resolveType == ResolveContext.ResolveType.UNRESOLVED || resolveType == ResolveContext.ResolveType.PARTIALLY_RESOLVED && n2 > 0) {
                hashSet.add(element);
            }
            if (resolveType == ResolveContext.ResolveType.PARTIALLY_RESOLVED && n2 == 0) {
                resolveType = ResolveContext.ResolveType.FULLY_RESOLVED;
            }
        }
        return ResolveContext.resolveContext(resolveType, hashSet);
    }

    private boolean consume(PropertyModel.Element element, List<ResolvedToken> list) {
        for (ResolvedToken resolvedToken : list) {
            if (!resolvedToken.element().equals(element)) continue;
            list.remove(resolvedToken);
            return true;
        }
        return false;
    }

    static void fillStack(Stack<String> stack, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\'' || c == '\"') {
                stringBuffer.append(c);
                ++i;
                while (i < string.length() && (c = string.charAt(i)) != '\'' && c != '\"') {
                    stringBuffer.append(c);
                    ++i;
                }
                stringBuffer.append(c);
                stack.add(0, stringBuffer.toString());
                stringBuffer = new StringBuffer();
                continue;
            }
            if (stringBuffer.toString().equalsIgnoreCase("url") && c == '(') {
                stack.add(0, stringBuffer.toString());
                stack.add(0, "" + c);
                stringBuffer = new StringBuffer();
                ++i;
                while (i < string.length() && (c = string.charAt(i)) != ')') {
                    stringBuffer.append(c);
                    ++i;
                }
                stack.add(0, stringBuffer.toString());
                stack.add(0, "" + c);
                stringBuffer = new StringBuffer();
                continue;
            }
            if (c == ' ' || c == '\t' || c == '\n') {
                if (stringBuffer.length() > 0) {
                    stack.add(0, stringBuffer.toString());
                    stringBuffer = new StringBuffer();
                }
                while (i < string.length() && (c = string.charAt(i)) == ' ' && c == '\t') {
                    ++i;
                }
                continue;
            }
            if (c == ',' || c == '/' || c == '(' || c == ')') {
                if (stringBuffer.length() > 0) {
                    stack.add(0, stringBuffer.toString());
                }
                stack.add(0, "" + c);
                stringBuffer = new StringBuffer();
                continue;
            }
            stringBuffer.append(c);
        }
        if (stringBuffer.length() > 0) {
            stack.add(0, stringBuffer.toString());
        }
    }

    private boolean resolve(PropertyModel.Element element, Stack<String> stack, List<ResolvedToken> list) {
        this.log.append(element.path() + "\n");
        boolean bl = false;
        if (stack.isEmpty()) {
            return true;
        }
        if (element instanceof PropertyModel.GroupElement) {
            PropertyModel.GroupElement groupElement = (PropertyModel.GroupElement)element;
            boolean bl2 = false;
            for (int i = 0; i < element.getMaximumOccurances(); ++i) {
                ArrayList<PropertyModel.Element> arrayList = new ArrayList<PropertyModel.Element>(groupElement.elements());
                block1: do {
                    for (PropertyModel.Element element2 : arrayList) {
                        bl2 = this.resolve(element2, stack, list);
                        if (bl2) {
                            bl = true;
                            if (groupElement.isSequence()) continue;
                            if (!groupElement.isList()) break block1;
                            this.log.append("sg resolved in " + element2.path() + "\n");
                            arrayList.remove(element2);
                            continue block1;
                        }
                        if (!groupElement.isSequence() || element2.getMinimumOccurances() <= 0) continue;
                        continue block1;
                    }
                } while (!stack.isEmpty() && bl2 && !arrayList.isEmpty() && groupElement.isList());
                if (bl2 && !stack.isEmpty()) {
                    continue;
                }
                break;
            }
        } else if (element instanceof PropertyModel.ValueElement) {
            String string = stack.peek();
            PropertyModel.ValueElement valueElement = (PropertyModel.ValueElement)element;
            if (valueElement.isUnit() && !KeywordUtil.isKeyword(string)) {
                String string2 = valueElement.value();
                CssPropertyValueAcceptor cssPropertyValueAcceptor = Acceptors.instance().getAcceptor(string2);
                if (cssPropertyValueAcceptor != null) {
                    if (cssPropertyValueAcceptor.accepts(string)) {
                        stack.pop();
                        list.add(new ResolvedToken(string, element));
                        this.log.append("eaten UNIT '" + string + "'\n");
                        return true;
                    }
                } else {
                    Logger.global.warning("ERROR - no acceptor for unit property value " + valueElement.value());
                }
            } else if (string.equalsIgnoreCase(valueElement.value())) {
                stack.pop();
                list.add(new ResolvedToken(string, element));
                this.log.append("eaten '" + string + "'\n");
                return true;
            }
        }
        return bl;
    }

    public class ResolvedToken {
        private String token;
        private PropertyModel.Element element;

        private ResolvedToken(String string, PropertyModel.Element element) {
            this.token = string;
            this.element = element;
        }

        public String token() {
            return this.token;
        }

        public PropertyModel.Element element() {
            return this.element;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ResolveContext {
        private ResolveType type;
        private Set<PropertyModel.Element> alternatives;

        public static ResolveContext resolveContext(ResolveType resolveType, Set<PropertyModel.Element> set) {
            return new ResolveContext(resolveType, set);
        }

        private ResolveContext(ResolveType resolveType, Set<PropertyModel.Element> set) {
            this.type = resolveType;
            this.alternatives = set;
        }

        public boolean resolved() {
            return this.type == ResolveType.PARTIALLY_RESOLVED || this.type == ResolveType.FULLY_RESOLVED;
        }

        public ResolveType resolveType() {
            return this.type;
        }

        public Set<PropertyModel.Element> alternatives() {
            return this.alternatives;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum ResolveType {
            UNEVALUATED,
            UNRESOLVED,
            PARTIALLY_RESOLVED,
            FULLY_RESOLVED,
            PARTIALLY_RESOLVED_SEQUENCE;

        }
    }
}

