/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.indexer.api;

import java.util.ArrayList;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public final class RepositoryInfo {
    private String id;
    private String type;
    private String name;
    private String repositoryPath;
    private String repositoryUrl;
    private String indexUpdateUrl;
    private final List<ChangeListener> changeListeners = new ArrayList<ChangeListener>();

    public RepositoryInfo(String string, String string2, String string3, String string4, String string5, String string6) {
        this.id = string;
        this.type = string2;
        this.name = string3;
        this.repositoryPath = string4;
        this.repositoryUrl = string5;
        this.indexUpdateUrl = string6;
        assert (!(this.isLocal() && this.isRemoteDownloadable())) : "Cannot have both local and remote index fields filled in. Repository: " + string + " Path=" + string4 + " Remote URL:" + string6;
    }

    public static RepositoryInfo createRepositoryInfo(FileObject fileObject) {
        String string;
        Object object;
        String string2;
        String string3 = (String)fileObject.getAttribute("provider");
        if (string3 == null) {
            string3 = "nexus";
        }
        String string4 = string2 = fileObject.getName();
        String string5 = (String)fileObject.getAttribute("SystemFileSystem.localizingBundle");
        if (string5 != null) {
            try {
                object = NbBundle.getBundle((String)string5);
                string = ((ResourceBundle)object).getString(fileObject.getPath());
                if (string != null) {
                    string4 = string;
                }
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        object = (String)fileObject.getAttribute("path");
        string = (String)fileObject.getAttribute("repoUrl");
        String string6 = (String)fileObject.getAttribute("repoIndexUrl");
        return new RepositoryInfo(string2, string3, string4, (String)object, string, string6);
    }

    public String getId() {
        return this.id;
    }

    public String getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String getRepositoryPath() {
        return this.repositoryPath;
    }

    public String getRepositoryUrl() {
        return this.repositoryUrl;
    }

    public String getIndexUpdateUrl() {
        return this.indexUpdateUrl;
    }

    public boolean isRemoteDownloadable() {
        return this.indexUpdateUrl != null;
    }

    public boolean isLocal() {
        return this.repositoryPath != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChangeListener(ChangeListener changeListener) {
        List<ChangeListener> list = this.changeListeners;
        synchronized (list) {
            this.changeListeners.add(changeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChangeListener(ChangeListener changeListener) {
        List<ChangeListener> list = this.changeListeners;
        synchronized (list) {
            this.changeListeners.remove(changeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireChangeIndex() {
        List<ChangeListener> list = this.changeListeners;
        synchronized (list) {
            for (ChangeListener changeListener : this.changeListeners) {
                changeListener.stateChanged(new ChangeEvent(this));
            }
        }
    }
}

