/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.mapper;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.netbeans.modules.cnd.api.remote.HostInfoProvider;
import org.netbeans.modules.cnd.remote.mapper.HostMappingProvider;
import org.netbeans.modules.cnd.remote.support.RunFacade;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HostMappingProviderUnixAbstract
implements HostMappingProvider {
    private static final String NET = "/net/";
    private static final Pattern pattern = Pattern.compile("\t+| +");

    protected abstract String getShareCommand();

    protected abstract String fetchPath(String[] var1);

    @Override
    public Map<String, String> findMappings(ExecutionEnvironment executionEnvironment, ExecutionEnvironment executionEnvironment2) {
        RunFacade runFacade;
        String string;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string2 = string = executionEnvironment.isLocal() ? HostMappingProviderUnixAbstract.getLocalHostName() : executionEnvironment.getHost();
        if (string != null && (runFacade = RunFacade.getInstance(executionEnvironment)).run(this.getShareCommand())) {
            List<String> list = this.parseOutput(executionEnvironment, new StringReader(runFacade.getOutput()));
            for (String string3 : list) {
                assert (string3 != null && string3.length() > 0 && string3.charAt(0) == '/');
                String string4 = NET + string + string3;
                if (!HostInfoProvider.fileExists((ExecutionEnvironment)executionEnvironment2, (String)string4)) continue;
                if (executionEnvironment.isLocal()) {
                    hashMap.put(string3, string4);
                    continue;
                }
                hashMap.put(string4, string3);
            }
        }
        return hashMap;
    }

    private List<String> parseOutput(ExecutionEnvironment executionEnvironment, Reader reader) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            BufferedReader bufferedReader = new BufferedReader(reader);
            String string = bufferedReader.readLine();
            while (string != null) {
                String string2 = this.fetchPath(pattern.split(string));
                if (string2 != null && HostInfoProvider.fileExists((ExecutionEnvironment)executionEnvironment, (String)string2)) {
                    arrayList.add(string2);
                }
                string = bufferedReader.readLine();
            }
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        return arrayList;
    }

    private static String getLocalHostName() {
        String[] stringArray;
        String string;
        String string2 = null;
        RunFacade runFacade = RunFacade.getInstance(ExecutionEnvironmentFactory.getLocal());
        if (runFacade.run("uname -a") && (string = runFacade.getOutput()) != null && (stringArray = string.split(" +")).length > 1) {
            string2 = stringArray[1];
        }
        return string2;
    }
}

