/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.mapper;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.netbeans.modules.cnd.api.remote.PathMap;
import org.netbeans.modules.cnd.api.remote.ServerList;
import org.netbeans.modules.cnd.api.utils.PlatformInfo;
import org.netbeans.modules.cnd.remote.mapper.HostMappingsAnalyzer;
import org.netbeans.modules.cnd.remote.support.RemoteCommandSupport;
import org.netbeans.modules.cnd.remote.ui.EditPathMapDialog;
import org.netbeans.modules.cnd.spi.remote.setup.MirrorPathProvider;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.nativeexecution.api.util.WindowsSupport;
import org.openide.util.Lookup;
import org.openide.util.NbPreferences;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RemotePathMap
extends PathMap {
    private static final Map<ExecutionEnvironment, Map<String, RemotePathMap>> pmtable = new HashMap<ExecutionEnvironment, Map<String, RemotePathMap>>();
    protected final HashMap<String, String> map = new HashMap();
    protected final ExecutionEnvironment execEnv;
    private static final String REMOTE_PATH_MAP = "remote-path-map";
    private static final String DELIMITER = "\n";
    private static final String NO_MAPPING_PREFIX = "///";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RemotePathMap getPathMap(ExecutionEnvironment executionEnvironment) {
        String string = RemotePathMap.getEnvSyncID(executionEnvironment);
        Map<String, RemotePathMap> map = pmtable.get(executionEnvironment);
        RemotePathMap remotePathMap = null;
        if (map == null) {
            Map<ExecutionEnvironment, Map<String, RemotePathMap>> map2 = pmtable;
            synchronized (map2) {
                map = new HashMap<String, RemotePathMap>();
                pmtable.put(executionEnvironment, map);
            }
        }
        if ((remotePathMap = map.get(string)) == null) {
            boolean bl = ServerList.get((ExecutionEnvironment)executionEnvironment).getSyncFactory().isPathMappingCustomizable();
            Map<ExecutionEnvironment, Map<String, RemotePathMap>> map3 = pmtable;
            synchronized (map3) {
                remotePathMap = bl ? new CustomizableRemotePathMap(executionEnvironment) : new FixedRemotePathMap(executionEnvironment);
                remotePathMap.init();
                map.put(string, remotePathMap);
            }
        }
        return remotePathMap;
    }

    public static boolean isReady(ExecutionEnvironment executionEnvironment) {
        return pmtable.get(executionEnvironment) != null;
    }

    protected RemotePathMap(ExecutionEnvironment executionEnvironment) {
        this.execEnv = executionEnvironment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final boolean loadFromPrefs() {
        HashMap<String, String> hashMap = this.map;
        synchronized (hashMap) {
            String string = RemotePathMap.getPreferences(this.execEnv);
            if (string == null) {
                String string2 = System.getProperty("cnd.remote.pmap");
                if (string2 == null) {
                    return false;
                }
                File file = new File(string2);
                if (file.exists() && file.canRead()) {
                    try {
                        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
                        try {
                            String string3;
                            while ((string3 = bufferedReader.readLine()) != null) {
                                int n = string3.indexOf(32);
                                if (n <= 0) continue;
                                this.map.put(string3.substring(0, n), string3.substring(n + 1).trim());
                            }
                        }
                        finally {
                            bufferedReader.close();
                        }
                    }
                    catch (IOException iOException) {}
                }
            } else {
                String[] stringArray = string.split(DELIMITER);
                for (int i = 0; i < stringArray.length; i += 2) {
                    if (i + 1 < stringArray.length) {
                        this.map.put(stringArray[i], stringArray[i + 1]);
                        continue;
                    }
                    System.err.println("mapping serialization flaw. Was found: " + string);
                }
            }
            return true;
        }
    }

    public abstract void init();

    public String getRemotePath(String string, boolean bl) {
        CndUtils.assertNotNull((Object)string, (String)"local path should not be null");
        if (string == null) {
            return null;
        }
        String string2 = RemotePathMap.unifySeparators(string);
        String string3 = null;
        int n = 0;
        for (Map.Entry<String, String> entry : this.map.entrySet()) {
            String string4 = RemotePathMap.unifySeparators(entry.getKey());
            if (!string2.startsWith(string4) || string3 != null && string4.length() <= n) continue;
            n = string4.length();
            String string5 = entry.getValue();
            string3 = string5 + string.substring(string4.length()).replace('\\', '/');
        }
        if (string3 != null) {
            return string3;
        }
        return bl ? string : null;
    }

    public String getLocalPath(String string, boolean bl) {
        CndUtils.assertNotNull((Object)string, (String)"remote path should not be null");
        if (string == null) {
            return null;
        }
        String string2 = RemotePathMap.unifySeparators(string);
        for (Map.Entry<String, String> entry : this.map.entrySet()) {
            String string3 = RemotePathMap.unifySeparators(entry.getValue());
            if (!string2.startsWith(string3)) continue;
            String string4 = entry.getKey();
            return string4 + string.substring(string3.length());
        }
        return bl ? string : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkRemotePath(String string, boolean bl) {
        block9: {
            CndUtils.assertNotNull((Object)string, (String)"local path should not be null");
            if (string == null) {
                return false;
            }
            String string2 = RemotePathMap.unifySeparators(string);
            for (Map.Entry<String, String> object : this.map.entrySet()) {
                String string3 = RemotePathMap.unifySeparators(object.getValue());
                if (!string2.startsWith(string3)) continue;
                return true;
            }
            for (String string4 : this.map.keySet()) {
                if (!string2.startsWith(RemotePathMap.unifySeparators(string4))) continue;
                return true;
            }
            try {
                if (!RemotePathMap.validateMapping(this.execEnv, string, new File(string))) break block9;
                HashMap<String, String> hashMap = this.map;
                synchronized (hashMap) {
                    this.map.put(string, string);
                }
                return true;
            }
            catch (InterruptedException interruptedException) {
                return false;
            }
        }
        if (bl) {
            return EditPathMapDialog.showMe(this.execEnv, string) && this.checkRemotePath(string, false);
        }
        return false;
    }

    public void addMapping(String string, String string2) {
        this.addMappingImpl(string, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addMappingImpl(String string, String string2) {
        CndUtils.assertNotNull((Object)string, (String)"local path shouldn't be null");
        CndUtils.assertNotNull((Object)string2, (String)"remote path shouldn't be null");
        if (string == null || string2 == null) {
            return;
        }
        HashMap<String, String> hashMap = this.map;
        synchronized (hashMap) {
            LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>(this.map);
            linkedHashMap.put(string, string2);
            this.updatePathMapImpl(linkedHashMap);
        }
    }

    public void updatePathMap(Map<String, String> map) {
        this.updatePathMapImpl(map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updatePathMapImpl(Map<String, String> map) {
        HashMap<String, String> hashMap = this.map;
        synchronized (hashMap) {
            this.map.clear();
            StringBuilder stringBuilder = new StringBuilder();
            for (Map.Entry<String, String> entry : map.entrySet()) {
                String string = RemotePathMap.fixEnding(entry.getValue());
                String string2 = RemotePathMap.fixEnding(entry.getKey());
                this.map.put(string2, string);
                stringBuilder.append(RemotePathMap.fixEnding(string2));
                stringBuilder.append(DELIMITER);
                stringBuilder.append(string);
                stringBuilder.append(DELIMITER);
            }
            this.setPreferences(stringBuilder.toString());
        }
    }

    public Map<String, String> getMap() {
        return (Map)this.map.clone();
    }

    private static String fixEnding(String string) {
        if (string.charAt(string.length() - 1) != '/' && string.charAt(string.length() - 1) != '\\') {
            return string + "/";
        }
        return string;
    }

    private static String unifySeparators(String string) {
        String string2 = string.replace('\\', '/');
        if (!CndFileUtils.isSystemCaseSensitive()) {
            string2 = string2.toLowerCase();
        }
        return string2;
    }

    public static boolean isSubPath(String string, String string2) {
        CndUtils.assertNotNull((Object)string, (String)"path should not be null");
        CndUtils.assertNotNull((Object)string2, (String)"pathToValidate should not be null");
        if (string == null || string2 == null) {
            return false;
        }
        return RemotePathMap.unifySeparators(string2).startsWith(RemotePathMap.unifySeparators(string));
    }

    private static String getEnvSyncID(ExecutionEnvironment executionEnvironment) {
        return ServerList.get((ExecutionEnvironment)executionEnvironment).getSyncFactory().getID();
    }

    private static String getPreferences(ExecutionEnvironment executionEnvironment) {
        return NbPreferences.forModule(RemotePathMap.class).get(REMOTE_PATH_MAP + ExecutionEnvironmentFactory.toUniqueID((ExecutionEnvironment)executionEnvironment) + RemotePathMap.getEnvSyncID(executionEnvironment), null);
    }

    private void setPreferences(String string) {
        NbPreferences.forModule(RemotePathMap.class).put(REMOTE_PATH_MAP + ExecutionEnvironmentFactory.toUniqueID((ExecutionEnvironment)this.execEnv) + RemotePathMap.getEnvSyncID(this.execEnv), string);
    }

    private static boolean validateMapping(ExecutionEnvironment executionEnvironment, String string, File file) throws InterruptedException {
        if (!PlatformInfo.getDefault((ExecutionEnvironment)executionEnvironment).isWindows() && !PlatformInfo.getDefault((ExecutionEnvironment)ExecutionEnvironmentFactory.getLocal()).isWindows()) {
            return RemotePathMap.isTheSame(executionEnvironment, string, file);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isTheSame(ExecutionEnvironment executionEnvironment, String string, File file) throws InterruptedException {
        if (file.exists() && file.isDirectory()) {
            File file2 = null;
            try {
                file2 = File.createTempFile("cnd", "tmp", file);
                if (file2.exists()) {
                    BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file2));
                    String string2 = Double.toString(Math.random());
                    bufferedWriter.write(string2);
                    bufferedWriter.close();
                    RemoteCommandSupport remoteCommandSupport = new RemoteCommandSupport(executionEnvironment, "grep", null, string2, string + "/" + file2.getName());
                    if (remoteCommandSupport.run() == 0) {
                        boolean bl = true;
                        return bl;
                    }
                    if (remoteCommandSupport.isCancelled() || remoteCommandSupport.isInterrupted()) {
                        throw new InterruptedException();
                    }
                }
            }
            catch (IOException iOException) {
            }
            finally {
                if (file2 != null && file2.exists()) {
                    file2.delete();
                }
            }
        }
        return false;
    }

    public static String getRemoteSyncRoot(ExecutionEnvironment executionEnvironment) {
        for (MirrorPathProvider mirrorPathProvider : Lookup.getDefault().lookupAll(MirrorPathProvider.class)) {
            String string = mirrorPathProvider.getRemoteMirror(executionEnvironment);
            if (string == null) continue;
            return string;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class FixedRemotePathMap
    extends RemotePathMap {
        private volatile String remoteBase;

        private FixedRemotePathMap(ExecutionEnvironment executionEnvironment) {
            super(executionEnvironment);
            this.initRemoteBase(false);
        }

        @Override
        public void init() {
            if (!this.loadFromPrefs() && this.remoteBase != null) {
                super.addMappingImpl("/", this.remoteBase);
            }
        }

        @Override
        public String getRemotePath(String string, boolean bl) {
            CndUtils.assertNotNull((Object)string, (String)"local path should not be null");
            if (string == null) {
                return null;
            }
            this.initRemoteBase(true);
            if (this.remoteBase == null) {
                return bl ? string : null;
            }
            String string2 = string;
            if (string2.startsWith(RemotePathMap.NO_MAPPING_PREFIX)) {
                return string2;
            }
            if (!FixedRemotePathMap.isSubPath(this.remoteBase, string)) {
                if (string != null && Utilities.isWindows() && !"/".equals(string)) {
                    string = WindowsSupport.getInstance().convertToMSysPath(string);
                }
                string2 = super.getRemotePath(string, bl);
            }
            return string2;
        }

        @Override
        public String getLocalPath(String string, boolean bl) {
            this.initRemoteBase(true);
            if (string.startsWith(RemotePathMap.NO_MAPPING_PREFIX)) {
                return string;
            }
            String string2 = super.getLocalPath(string, bl);
            if (string2 != null && Utilities.isWindows() && !"/".equals(string2)) {
                string2 = WindowsSupport.getInstance().convertFromMSysPath(string2);
            }
            return string2;
        }

        private void initRemoteBase(boolean bl) {
            if (this.remoteBase == null) {
                this.remoteBase = FixedRemotePathMap.getRemoteSyncRoot(this.execEnv);
                if (bl && this.remoteBase != null) {
                    this.addMappingImpl("/", this.remoteBase);
                }
            }
        }

        @Override
        public void addMapping(String string, String string2) {
            CndUtils.assertTrue((boolean)false, (String)("Should never be called for " + ((Object)((Object)this)).getClass().getSimpleName()));
        }

        @Override
        public void updatePathMap(Map<String, String> map) {
            CndUtils.assertTrue((boolean)false, (String)("Should never be called for " + ((Object)((Object)this)).getClass().getSimpleName()));
        }
    }

    private static final class CustomizableRemotePathMap
    extends RemotePathMap {
        private CustomizableRemotePathMap(ExecutionEnvironment executionEnvironment) {
            super(executionEnvironment);
        }

        public void init() {
            if (!this.loadFromPrefs()) {
                HostMappingsAnalyzer hostMappingsAnalyzer = new HostMappingsAnalyzer(this.execEnv);
                this.map.putAll(hostMappingsAnalyzer.getMappings());
            }
        }
    }
}

