/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.server;

import java.awt.Dialog;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.concurrent.CancellationException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.netbeans.modules.cnd.api.compilers.CompilerSetManager;
import org.netbeans.modules.cnd.api.remote.ServerList;
import org.netbeans.modules.cnd.api.remote.ServerRecord;
import org.netbeans.modules.cnd.remote.ui.EditServerListDialog;
import org.netbeans.modules.cnd.spi.remote.RemoteSyncFactory;
import org.netbeans.modules.cnd.ui.options.ServerListUIEx;
import org.netbeans.modules.cnd.ui.options.ToolsCacheManager;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteServerListUI
extends ServerListUIEx {
    protected boolean showServerListDialogImpl() {
        return this.showServerListDialogImpl(null);
    }

    protected boolean showServerListDialogImpl(AtomicReference<ExecutionEnvironment> atomicReference) {
        ToolsCacheManager toolsCacheManager = new ToolsCacheManager();
        for (ServerRecord serverRecord : ServerList.getRecords()) {
            CompilerSetManager compilerSetManager = CompilerSetManager.getDefault((ExecutionEnvironment)serverRecord.getExecutionEnvironment());
            toolsCacheManager.addCompilerSetManager(compilerSetManager);
        }
        if (RemoteServerListUI.showServerListDialog((ToolsCacheManager)toolsCacheManager, atomicReference)) {
            toolsCacheManager.applyChanges();
            return true;
        }
        return false;
    }

    protected JComponent getServerListComponentImpl(ToolsCacheManager toolsCacheManager, AtomicReference<ExecutionEnvironment> atomicReference) {
        EditServerListDialog editServerListDialog = new EditServerListDialog(toolsCacheManager, atomicReference);
        return editServerListDialog;
    }

    protected boolean showServerListDialogImpl(ToolsCacheManager toolsCacheManager, AtomicReference<ExecutionEnvironment> atomicReference) {
        EditServerListDialog editServerListDialog = new EditServerListDialog(toolsCacheManager, atomicReference);
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)editServerListDialog, NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"TITLE_EditServerList"), true, 2, DialogDescriptor.OK_OPTION, null);
        editServerListDialog.setDialogDescriptor(dialogDescriptor);
        dialogDescriptor.addPropertyChangeListener((PropertyChangeListener)editServerListDialog);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.setMinimumSize(dialog.getPreferredSize());
        dialog.setVisible(true);
        if (dialogDescriptor.getValue() == DialogDescriptor.OK_OPTION) {
            toolsCacheManager.setHosts(editServerListDialog.getHosts());
            toolsCacheManager.setDefaultRecord(editServerListDialog.getDefaultRecord());
            return true;
        }
        return false;
    }

    public static boolean showConfirmDialog(final String string, final String string2) {
        final AtomicBoolean atomicBoolean = new AtomicBoolean(false);
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    int n = JOptionPane.showConfirmDialog(WindowManager.getDefault().getMainWindow(), string, string2, 0);
                    if (n == 0) {
                        atomicBoolean.set(true);
                    }
                }
            });
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return atomicBoolean.get();
    }

    public static void revalidate(ExecutionEnvironment executionEnvironment) {
        ServerRecord serverRecord = ServerList.get((ExecutionEnvironment)executionEnvironment);
        if (serverRecord.isDeleted()) {
            ServerList.addServer((ExecutionEnvironment)serverRecord.getExecutionEnvironment(), (String)serverRecord.getDisplayName(), (RemoteSyncFactory)serverRecord.getSyncFactory(), (boolean)false, (boolean)true);
        } else if (!serverRecord.isOnline()) {
            serverRecord.validate(true);
        }
    }

    protected boolean ensureRecordOnlineImpl(ExecutionEnvironment executionEnvironment, String string) {
        CndUtils.assertNonUiThread();
        if (executionEnvironment.isLocal()) {
            return true;
        }
        ServerRecord serverRecord = ServerList.get((ExecutionEnvironment)executionEnvironment);
        boolean bl = false;
        if (serverRecord.isDeleted()) {
            String string2 = MessageFormat.format(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"ERR_RequestingDeletedConnection"), serverRecord.getDisplayName());
            boolean bl2 = RemoteServerListUI.showConfirmDialog(string2, NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"DLG_TITLE_DeletedConnection"));
            if (bl2) {
                ServerList.addServer((ExecutionEnvironment)serverRecord.getExecutionEnvironment(), (String)serverRecord.getDisplayName(), (RemoteSyncFactory)serverRecord.getSyncFactory(), (boolean)false, (boolean)true);
                bl = true;
            }
        } else if (serverRecord.isOnline()) {
            bl = true;
        } else {
            String string3 = MessageFormat.format(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"ERR_NeedToConnectToRemoteHost"), serverRecord.getDisplayName());
            boolean bl3 = RemoteServerListUI.showConfirmDialog(string3, NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"DLG_TITLE_Connect"));
            if (bl3) {
                try {
                    if (ConnectionManager.getInstance().isConnectedTo(serverRecord.getExecutionEnvironment())) {
                        ConnectionManager.getInstance().connectTo(serverRecord.getExecutionEnvironment());
                    }
                    serverRecord.validate(true);
                    bl = true;
                }
                catch (CancellationException cancellationException) {
                }
                catch (InterruptedIOException interruptedIOException) {
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        return bl;
    }

    protected boolean ensureRecordOnlineImpl(ExecutionEnvironment executionEnvironment) {
        return this.ensureRecordOnlineImpl(executionEnvironment, null);
    }
}

