/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.server;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.logging.Level;
import org.netbeans.modules.cnd.api.remote.HostInfoProvider;
import org.netbeans.modules.cnd.api.remote.SetupProvider;
import org.netbeans.modules.cnd.remote.support.RemoteCommandSupport;
import org.netbeans.modules.cnd.remote.support.RemoteCopySupport;
import org.netbeans.modules.cnd.remote.support.RemoteUtil;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteServerSetup {
    private final Map<String, String> binarySetupMap;
    private final Map<ExecutionEnvironment, List<String>> updateMap;
    private final ExecutionEnvironment executionEnvironment;
    private final Set<String> checkedDirs = new HashSet<String>();
    private boolean cancelled;
    private boolean failed;
    private String reason;
    private String libDir;

    RemoteServerSetup(ExecutionEnvironment executionEnvironment) {
        this.executionEnvironment = executionEnvironment;
        Lookup.Result result = Lookup.getDefault().lookup(new Lookup.Template(SetupProvider.class));
        Collection collection = result.allInstances();
        SetupProvider[] setupProviderArray = collection.toArray(new SetupProvider[collection.size()]);
        this.libDir = HostInfoProvider.getLibDir((ExecutionEnvironment)executionEnvironment);
        if (!this.libDir.endsWith("/")) {
            this.libDir = this.libDir + "/";
        }
        this.binarySetupMap = new HashMap<String, String>();
        for (SetupProvider setupProvider : setupProviderArray) {
            Map map = setupProvider.getBinaryFiles(executionEnvironment);
            if (map == null) continue;
            for (Map.Entry entry : map.entrySet()) {
                this.binarySetupMap.put(this.libDir + (String)entry.getKey(), (String)entry.getValue());
            }
        }
        this.updateMap = new HashMap<ExecutionEnvironment, List<String>>();
    }

    boolean needsSetupOrUpdate() {
        List<Object> list = new ArrayList();
        this.updateMap.clear();
        if (!this.isFailedOrCanceled()) {
            list = this.getBinaryUpdates();
        }
        if (this.isFailedOrCanceled()) {
            return false;
        }
        if (!list.isEmpty()) {
            this.updateMap.put(this.executionEnvironment, list);
            return true;
        }
        return false;
    }

    protected void setup() {
        List<String> list = this.updateMap.remove(this.executionEnvironment);
        for (String string : list) {
            RemoteUtil.LOGGER.fine("RSS.setup: Updating \"" + string + "\" on " + this.executionEnvironment);
            if (!this.binarySetupMap.containsKey(string)) continue;
            String string2 = this.binarySetupMap.get(string);
            File file = InstalledFileLocator.getDefault().locate(string2, null, false);
            String string3 = string;
            if (file != null && file.exists() && this.copyTo(file, string3)) continue;
            this.setFailed(NbBundle.getMessage(RemoteServerSetup.class, (String)"ERR_UpdateSetupFailure", (Object)this.executionEnvironment, (Object)string));
        }
    }

    private boolean copyTo(File file, String string) {
        String string2;
        int n = string.lastIndexOf(47);
        if (n >= 0 && !this.checkedDirs.contains(string2 = string.substring(0, n))) {
            this.checkedDirs.add(string2);
            String string3 = String.format("sh -c \"if [ ! -d %s ]; then mkdir -p %s; fi\"", string2, string2);
            RemoteCommandSupport.run(this.executionEnvironment, string3);
        }
        return RemoteCopySupport.copyTo(this.executionEnvironment, file.getAbsolutePath(), string);
    }

    private List<String> getBinaryUpdates() {
        try {
            return this.getBinaryUpdatesByChecksum();
        }
        catch (CancellationException cancellationException) {
            this.cancelled = true;
            return Collections.emptyList();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            RemoteUtil.LOGGER.warning(noSuchAlgorithmException.getMessage());
        }
        catch (IOException iOException) {
            RemoteUtil.LOGGER.log(Level.WARNING, iOException.getMessage(), iOException);
        }
        catch (CheckSumException checkSumException) {
            RemoteUtil.LOGGER.warning(checkSumException.getMessage());
        }
        return new ArrayList<String>(this.binarySetupMap.keySet());
    }

    private String getMd5command(List<String> list) throws NoSuchAlgorithmException, IOException, CheckSumException {
        HostInfo hostInfo = HostInfoUtils.getHostInfo((ExecutionEnvironment)this.executionEnvironment);
        if (hostInfo == null) {
            throw new CheckSumException("Can not get HostInfo for " + this.executionEnvironment);
        }
        HostInfo.OSFamily oSFamily = hostInfo.getOSFamily();
        switch (oSFamily) {
            case LINUX: {
                StringBuilder stringBuilder = new StringBuilder("/usr/bin/md5sum -b");
                for (String string : list) {
                    stringBuilder.append(' ');
                    stringBuilder.append(string);
                }
                return stringBuilder.toString();
            }
            case SUNOS: {
                StringBuilder stringBuilder = new StringBuilder("sh -c \"");
                for (String string : list) {
                    stringBuilder.append("/usr/bin/digest -a md5 ");
                    stringBuilder.append(string);
                    stringBuilder.append(";");
                }
                stringBuilder.append("\"");
                return stringBuilder.toString();
            }
        }
        throw new NoSuchAlgorithmException("Unexpected OS: " + oSFamily);
    }

    private List<String> getBinaryUpdatesByChecksum() throws NoSuchAlgorithmException, CancellationException, IOException, CheckSumException {
        ArrayList<String> arrayList = new ArrayList<String>(this.binarySetupMap.size());
        for (String object2 : this.binarySetupMap.keySet()) {
            arrayList.add(object2);
        }
        String string = this.getMd5command(arrayList);
        RemoteCommandSupport remoteCommandSupport = new RemoteCommandSupport(this.executionEnvironment, string);
        remoteCommandSupport.run();
        RemoteUtil.LOGGER.fine("RSS.getBinaryUpdatesByChecksum: RC " + remoteCommandSupport.getExitStatus());
        if (remoteCommandSupport.isFailed() || remoteCommandSupport.getExitStatus() != 0) {
            RemoteUtil.LOGGER.fine("Running " + (String)string + " failed on remote host: " + remoteCommandSupport.getFailureReason());
            return new ArrayList<String>(arrayList);
        }
        if (remoteCommandSupport.isCancelled()) {
            throw new CancellationException();
        }
        String string2 = remoteCommandSupport.getOutput();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        int n = 0;
        String[] stringArray = string2.split("\n");
        if (stringArray[stringArray.length - 1].equals("")) {
            String[] stringArray2 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 0, stringArray2, 0, stringArray2.length);
            stringArray = stringArray2;
        }
        if (arrayList.size() != stringArray.length) {
            throw new CheckSumException(String.format("Incorrect line count: %d, should equal to the amount of files to check: %d", stringArray.length, arrayList.size()));
        }
        for (String string3 : stringArray) {
            if (string3.length() <= 0) continue;
            String[] stringArray3 = string3.split(" ");
            if (stringArray3.length == 0) {
                throw new CheckSumException("Line shouldn't be empty");
            }
            String string4 = (String)arrayList.get(n++);
            String string5 = stringArray3[0];
            String string6 = this.getLocalChecksum(string4);
            RemoteUtil.LOGGER.fine(String.format("Checking %s: remote: %s local: %s", string4, string6, string5));
            if (string5.equals(string6)) continue;
            arrayList2.add(string4);
        }
        return arrayList2;
    }

    private String getLocalChecksum(String string) throws NoSuchAlgorithmException, FileNotFoundException, IOException {
        String string2 = this.binarySetupMap.get(string);
        File file = InstalledFileLocator.getDefault().locate(string2, null, false);
        if (file != null || file.exists()) {
            int n;
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            byte[] byArray = new byte[8192];
            while ((n = ((InputStream)bufferedInputStream).read(byArray)) != -1) {
                messageDigest.update(byArray, 0, n);
            }
            byte[] byArray2 = messageDigest.digest();
            return RemoteServerSetup.toHexString(byArray2);
        }
        return null;
    }

    private static String toHexString(byte[] byArray) {
        char[] cArray = new char[byArray.length * 2];
        for (int i = 0; i < byArray.length; ++i) {
            for (int j = 0; j < 2; ++j) {
                int n = j == 0 ? (byArray[i] & 0xF0) >>> 4 : byArray[i] & 0xF;
                cArray[2 * i + j] = 0 <= n && n <= 9 ? (char)(48 + n) : (char)(97 + (n - 10));
            }
        }
        return new String(cArray);
    }

    public String getReason() {
        return this.reason;
    }

    protected boolean isCancelled() {
        return this.cancelled;
    }

    private void setFailed(String string) {
        this.failed = true;
        this.reason = string;
    }

    protected boolean isFailed() {
        return this.failed;
    }

    private boolean isFailedOrCanceled() {
        return this.failed || this.cancelled;
    }

    private static class CheckSumException
    extends Exception {
        public CheckSumException(String string) {
            super(string);
        }
    }
}

