/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.support;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.Map;
import java.util.logging.Level;
import org.netbeans.modules.cnd.remote.mapper.RemotePathMap;
import org.netbeans.modules.cnd.remote.support.RemoteConnectionSupport;
import org.netbeans.modules.cnd.remote.support.RemoteUtil;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.NativeProcess;
import org.netbeans.modules.nativeexecution.api.NativeProcessBuilder;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteNativeExecutionSupport
extends RemoteConnectionSupport {
    private NativeProcess process;
    private final Object procLock = new Object();
    private final File dirf;
    private final String cmd;
    private final String args;
    private final Map<String, String> env;
    private final boolean x11forwarding;

    public RemoteNativeExecutionSupport(ExecutionEnvironment executionEnvironment, File file, String string, String string2, Map<String, String> map) {
        this(executionEnvironment, file, string, string2, map, false);
    }

    public RemoteNativeExecutionSupport(ExecutionEnvironment executionEnvironment, File file, String string, String string2, Map<String, String> map, boolean bl) {
        super(executionEnvironment);
        this.args = string2;
        this.dirf = file;
        this.cmd = string;
        this.env = map;
        this.x11forwarding = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(PrintWriter printWriter, Reader reader) {
        CndUtils.assertTrue((this.process == null ? 1 : 0) != 0, (String)("Instance of " + this.getClass().getSimpleName() + " should not be reused"));
        try {
            int n;
            NativeProcessBuilder nativeProcessBuilder = NativeProcessBuilder.newProcessBuilder((ExecutionEnvironment)this.executionEnvironment);
            nativeProcessBuilder.setExecutable(this.cmd);
            nativeProcessBuilder.getEnvironment().putAll(this.env);
            if (this.args != null) {
                nativeProcessBuilder.setArguments(Utilities.parseParameters((String)this.args));
            }
            nativeProcessBuilder.redirectError();
            nativeProcessBuilder.setX11Forwarding(this.x11forwarding);
            String string = null;
            if (this.dirf != null) {
                string = RemotePathMap.getPathMap(this.executionEnvironment).getRemotePath(this.dirf.getAbsolutePath(), true);
                if (RemoteUtil.LOGGER.isLoggable(Level.FINEST) && string.contains(" ")) {
                    RemoteUtil.LOGGER.finest("A PATH WITH A SPACE\n");
                }
                nativeProcessBuilder = nativeProcessBuilder.setWorkingDirectory(string);
            }
            RemoteUtil.LOGGER.fine("RNES<Init>: Running [" + this.cmd + "] on " + this.executionEnvironment + " in " + string);
            Object object = this.procLock;
            synchronized (object) {
                this.process = nativeProcessBuilder.call();
            }
            object = this.process.getInputStream();
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)object);
            if (reader != null) {
                InputReaderThread inputReaderThread = new InputReaderThread(this.process.getOutputStream(), new ReaderInputStream(reader));
                inputReaderThread.start();
            }
            while ((n = ((Reader)inputStreamReader).read()) != -1) {
                if (n == 10) {
                    printWriter.append('\n');
                    continue;
                }
                printWriter.append((char)n);
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            int n2 = this.process.waitFor();
            if (n2 != 0 && RemoteUtil.LOGGER.isLoggable(Level.FINEST)) {
                Object object2;
                Object object3;
                RemoteUtil.LOGGER.finest("RNES: " + this.cmd + " on " + this.executionEnvironment + " in " + string + " finished; rc=" + n2);
                if (this.env == null) {
                    RemoteUtil.LOGGER.finest("RNES: env == null");
                } else {
                    object3 = this.env.entrySet().iterator();
                    while (object3.hasNext()) {
                        object2 = object3.next();
                        RemoteUtil.LOGGER.finest("\tRNES: " + (String)object2.getKey() + "=" + (String)object2.getValue());
                    }
                }
                object2 = new BufferedReader(new InputStreamReader(this.process.getErrorStream()));
                while ((object3 = ((BufferedReader)object2).readLine()) != null) {
                    RemoteUtil.LOGGER.finest("RNES ERROR: " + (String)object3);
                }
            }
            this.setExitStatus(n2);
            printWriter.flush();
            ((InputStream)object).close();
            ((Reader)inputStreamReader).close();
        }
        catch (InterruptedException interruptedException) {
            RemoteUtil.LOGGER.fine("RNES: interrupted (1)");
            this.kill();
        }
        catch (InterruptedIOException interruptedIOException) {
            RemoteUtil.LOGGER.fine("RNES: interrupted (2)");
            this.kill();
        }
        catch (IOException iOException) {
            RemoteUtil.LOGGER.log(Level.WARNING, iOException.getMessage(), iOException);
        }
        catch (Exception exception) {
            RemoteUtil.LOGGER.log(Level.WARNING, exception.getMessage(), exception);
        }
        finally {
            RemoteUtil.LOGGER.finest("RNES return value: " + this.getExitStatus());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void kill() {
        NativeProcess nativeProcess = null;
        Object object = this.procLock;
        synchronized (object) {
            nativeProcess = this.process;
        }
        if (nativeProcess == null) {
            RemoteUtil.LOGGER.fine("RNES: process is null, can't kill");
        } else {
            RemoteUtil.LOGGER.fine("RNES: killing " + nativeProcess);
            nativeProcess.destroy();
        }
    }

    public void stop() {
        RemoteUtil.LOGGER.fine("RNES: stop " + this.process);
        this.kill();
    }

    private static final class ReaderInputStream
    extends InputStream {
        private final Reader reader;

        public ReaderInputStream(Reader reader) {
            this.reader = reader;
        }

        public int read() throws IOException {
            int n = this.reader.read();
            return n;
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            if (byArray == null) {
                throw new NullPointerException();
            }
            if (n < 0 || n > byArray.length || n2 < 0 || n + n2 > byArray.length || n + n2 < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (n2 == 0) {
                return 0;
            }
            int n3 = this.read();
            if (n3 == -1) {
                return -1;
            }
            byArray[n] = (byte)n3;
            return 1;
        }
    }

    private static final class InputReaderThread
    extends Thread {
        private InputStream in;
        private OutputStream pout;

        public InputReaderThread(OutputStream outputStream, InputStream inputStream) {
            this.pout = outputStream;
            this.in = inputStream;
            this.setName("inputReaderThread");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                int n;
                while ((n = this.in.read()) != -1) {
                    this.pout.write((char)n);
                    this.pout.flush();
                }
            }
            catch (IOException iOException) {
            }
            finally {
                try {
                    this.pout.flush();
                    this.pout.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }
}

