/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.sync;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import java.util.logging.Level;
import org.netbeans.modules.cnd.remote.support.RemoteUtil;
import org.netbeans.modules.cnd.remote.sync.FileState;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.openide.util.Exceptions;

public final class FileData {
    private final Properties data = new Properties();
    private final File dataFile;
    private static final String VERSION = "1.1";
    private static final String VERSION_KEY = "VERSION";

    public FileData(File file, ExecutionEnvironment executionEnvironment) {
        String string = "timestamps-" + executionEnvironment.getHost() + '-' + executionEnvironment.getUser() + '-' + executionEnvironment.getSSHPort();
        this.dataFile = new File(file, string);
        if (!Boolean.getBoolean("cnd.remote.timestamps.clear")) {
            try {
                this.load();
                if (!VERSION.equals(this.data.get(VERSION_KEY))) {
                    this.data.clear();
                }
            }
            catch (IOException iOException) {
                this.data.clear();
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
    }

    public FileState getState(File file) {
        FileInfo fileInfo = this.getFileInfo(file);
        return fileInfo == null ? FileState.UNCONTROLLED : fileInfo.state;
    }

    public void setState(File file, FileState fileState) {
        this.setFileInfo(file, fileState);
    }

    public FileInfo getFileInfo(File file) {
        return this.getFileInfo(this.getFileKey(file));
    }

    public void store() {
        File file = this.dataFile.getParentFile();
        if (!file.exists()) {
            file.mkdirs();
        }
        try {
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(this.dataFile));
            this.data.setProperty(VERSION_KEY, VERSION);
            this.data.store(bufferedOutputStream, null);
            ((OutputStream)bufferedOutputStream).close();
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
            this.dataFile.delete();
        }
    }

    public void clear() {
        this.data.clear();
    }

    private void load() throws IOException {
        if (this.dataFile.exists()) {
            long l = System.currentTimeMillis();
            FileInputStream fileInputStream = new FileInputStream(this.dataFile);
            this.data.load(new BufferedInputStream(fileInputStream));
            fileInputStream.close();
            if (RemoteUtil.LOGGER.isLoggable(Level.FINEST)) {
                l = System.currentTimeMillis() - l;
                System.out.printf("reading %d timestamps from %s took %d ms\n", this.data.size(), this.dataFile.getAbsolutePath(), l);
            }
        }
    }

    private FileInfo getFileInfo(String string) {
        String string2 = this.data.getProperty(string, null);
        if (string2 != null && string2.length() > 0) {
            char c = string2.charAt(0);
            FileState fileState = FileState.fromId(c);
            string2 = string2.substring(1);
            try {
                long l = Long.parseLong(string2);
                return new FileInfo(fileState, l);
            }
            catch (NumberFormatException numberFormatException) {
                RemoteUtil.LOGGER.warning(String.format("Incorrect status/timestamp format \"%s\" for %s", string2, string));
            }
        }
        return null;
    }

    private void setFileInfo(File file, FileState fileState) {
        String string = this.getFileKey(file);
        char c = fileState.id;
        this.data.put(string, String.format("%c%d", Character.valueOf(c), file.lastModified()));
    }

    private String getFileKey(File file) {
        String string = file.getAbsolutePath();
        if (!CndFileUtils.isSystemCaseSensitive()) {
            string = string.toLowerCase();
        }
        return string;
    }

    public static final class FileInfo {
        public final long timestamp;
        public final FileState state;

        public FileInfo(FileState fileState, long l) {
            this.state = fileState;
            this.timestamp = l;
        }

        public String toString() {
            return this.state.toString() + this.timestamp;
        }
    }
}

