/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.sync;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.netbeans.modules.cnd.remote.mapper.RemotePathMap;
import org.netbeans.modules.cnd.remote.support.RemoteUtil;
import org.netbeans.modules.cnd.remote.sync.FileData;
import org.netbeans.modules.cnd.remote.sync.FileState;
import org.netbeans.modules.cnd.remote.sync.SharabilityFilter;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.util.CommonTasksSupport;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RfsLocalController
implements Runnable {
    private final BufferedReader requestReader;
    private final PrintWriter responseStream;
    private final String remoteDir;
    private final File[] files;
    private final ExecutionEnvironment execEnv;
    private final PrintWriter err;
    private final FileData fileData;
    private final RemotePathMap mapper;

    public RfsLocalController(ExecutionEnvironment executionEnvironment, File[] fileArray, String string, BufferedReader bufferedReader, PrintWriter printWriter, PrintWriter printWriter2, FileData fileData) {
        this.execEnv = executionEnvironment;
        this.files = fileArray;
        this.remoteDir = string;
        this.requestReader = bufferedReader;
        this.responseStream = printWriter;
        this.err = printWriter2;
        this.fileData = fileData;
        this.mapper = RemotePathMap.getPathMap(this.execEnv);
    }

    private void respond_ok() {
        this.responseStream.printf("1\n", new Object[0]);
        this.responseStream.flush();
    }

    private void respond_err(String string) {
        this.responseStream.printf("0 %s\n", string);
        this.responseStream.flush();
    }

    private RequestKind getRequestKind(String string) {
        if (string.charAt(1) != ' ') {
            throw new IllegalArgumentException("Protocol error: " + string);
        }
        switch (string.charAt(0)) {
            case 'r': {
                return RequestKind.REQUEST;
            }
            case 'w': {
                return RequestKind.WRITTEN;
            }
        }
        throw new IllegalArgumentException("Protocol error: " + string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        long l = 0L;
        block9: while (true) {
            try {
                while (true) {
                    String string = this.requestReader.readLine();
                    RemoteUtil.LOGGER.finest("LC: REQ " + string);
                    if (string == null) break block9;
                    String string2 = string.substring(2);
                    RequestKind requestKind = this.getRequestKind(string);
                    String string3 = this.mapper.getLocalPath(string2);
                    if (string3 != null) {
                        File file = new File(string3);
                        if (requestKind == RequestKind.WRITTEN) {
                            this.fileData.setState(file, FileState.UNCONTROLLED);
                            RemoteUtil.LOGGER.finest("LC: uncontrolled " + file);
                            continue;
                        }
                        CndUtils.assertTrue((requestKind == RequestKind.REQUEST ? 1 : 0) != 0, (String)("kind should be RequestKind.REQUEST, but is " + (Object)((Object)requestKind)));
                        if (file.exists() && !file.isDirectory()) {
                            RemoteUtil.LOGGER.finest("LC: uploading " + file + " to " + string2 + " started");
                            long l2 = System.currentTimeMillis();
                            Future future = CommonTasksSupport.uploadFile((String)file.getAbsolutePath(), (ExecutionEnvironment)this.execEnv, (String)string2, (int)511, (Writer)this.err);
                            try {
                                int n = (Integer)future.get();
                                l2 = System.currentTimeMillis() - l2;
                                System.err.printf("LC: uploading %s to %s finished; rc=%d time =%d total time = %d ms \n", file, string2, n, l2, l += l2);
                                if (n == 0) {
                                    this.fileData.setState(file, FileState.COPIED);
                                    this.respond_ok();
                                    continue;
                                }
                                this.respond_err("1");
                                continue;
                            }
                            catch (InterruptedException interruptedException) {
                                Exceptions.printStackTrace((Throwable)interruptedException);
                                break block9;
                            }
                            catch (ExecutionException executionException) {
                                Exceptions.printStackTrace((Throwable)executionException);
                                this.respond_err("2 execution exception\n");
                                continue;
                            }
                            finally {
                                this.responseStream.flush();
                                continue;
                            }
                        }
                        this.respond_ok();
                        continue;
                    }
                    this.respond_ok();
                }
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
                continue;
            }
            break;
        }
        this.fileData.store();
    }

    void shutdown() {
        this.fileData.store();
    }

    void feedFiles(SharabilityFilter sharabilityFilter) {
        ArrayList<FileGatheringInfo> arrayList = new ArrayList<FileGatheringInfo>(512);
        HashSet<Object> hashSet = new HashSet<Object>();
        for (File file : this.files) {
            Object object;
            Object object2;
            if ((file = CndFileUtils.normalizeFile((File)file)).isDirectory()) {
                object2 = this.mapper.getRemotePath(file.getAbsolutePath());
                object = file.listFiles(sharabilityFilter);
                if (object == null) continue;
                for (File file2 : object) {
                    RfsLocalController.gatherFiles(file2, (String)object2, sharabilityFilter, arrayList);
                }
                continue;
            }
            object2 = file.getAbsoluteFile().getParentFile();
            object = this.mapper.getRemotePath(((File)object2).getAbsolutePath());
            if (!hashSet.contains(object2)) {
                hashSet.add(object2);
                RfsLocalController.addFileGatheringInfo(arrayList, (File)object2, (String)object);
            }
            RfsLocalController.gatherFiles(file, (String)object, sharabilityFilter, arrayList);
        }
        Collections.sort(arrayList, new Comparator<FileGatheringInfo>(){

            @Override
            public int compare(FileGatheringInfo fileGatheringInfo, FileGatheringInfo fileGatheringInfo2) {
                if (fileGatheringInfo.file.isDirectory() || fileGatheringInfo2.file.isDirectory()) {
                    if (fileGatheringInfo.file.isDirectory() && fileGatheringInfo2.file.isDirectory()) {
                        return fileGatheringInfo.relPath.compareTo(fileGatheringInfo2.relPath);
                    }
                    return fileGatheringInfo.file.isDirectory() ? -1 : 1;
                }
                long l = fileGatheringInfo.file.lastModified() - fileGatheringInfo2.file.lastModified();
                return l == 0L ? 0 : (l < 0L ? -1 : 1);
            }
        });
        for (FileGatheringInfo fileGatheringInfo : arrayList) {
            this.sendFileInitRequest(fileGatheringInfo.file, fileGatheringInfo.relPath);
        }
        this.responseStream.printf("\n", new Object[0]);
        this.responseStream.flush();
        try {
            this.readFileInitResponse();
        }
        catch (IOException iOException) {
            this.err.printf("%s\n", iOException.getMessage());
        }
        this.fileData.store();
    }

    private void readFileInitResponse() throws IOException {
        String string;
        while ((string = this.requestReader.readLine()) != null && string.length() != 0) {
            if (string.length() < 3 || !string.startsWith("t ")) {
                throw new IllegalArgumentException("Protocol error: " + string);
            }
            String string2 = string.substring(2);
            String string3 = this.mapper.getLocalPath(string2);
            if (string3 != null) {
                File file = new File(string3);
                this.fileData.setState(file, FileState.TOUCHED);
                continue;
            }
            RemoteUtil.LOGGER.finest("LC: ERROR no local file for " + string2);
        }
    }

    private void sendFileInitRequest(File file, String string) {
        if (file.isDirectory()) {
            this.responseStream.printf("D %s\n", string);
            this.responseStream.flush();
        } else {
            FileState fileState;
            FileData.FileInfo fileInfo = this.fileData.getFileInfo(file);
            switch (fileInfo == null ? FileState.INITIAL : fileInfo.state) {
                case COPIED: 
                case TOUCHED: {
                    if (fileInfo.timestamp == file.lastModified()) {
                        fileState = fileInfo.state;
                        break;
                    }
                    fileState = FileState.INITIAL;
                    break;
                }
                case ERROR: 
                case INITIAL: {
                    fileState = FileState.INITIAL;
                    break;
                }
                case UNCONTROLLED: {
                    return;
                }
                default: {
                    CndUtils.assertTrue((boolean)false, (String)("Unexpected state: " + (Object)((Object)fileInfo.state)));
                    return;
                }
            }
            CndUtils.assertTrue((fileState == FileState.INITIAL || fileState == FileState.COPIED || fileState == FileState.TOUCHED ? 1 : 0) != 0, (String)("State shouldn't be " + (Object)((Object)fileState)));
            this.responseStream.printf("%c %d %s\n", Character.valueOf(fileState.id), file.length(), string);
            this.responseStream.flush();
            if (fileState == FileState.INITIAL) {
                fileState = FileState.TOUCHED;
            }
            this.fileData.setState(file, fileState);
        }
    }

    private static void gatherFiles(File file, String string, FileFilter fileFilter, List<FileGatheringInfo> list) {
        String string2 = RfsLocalController.isEmpty(string) ? file.getName() : string + '/' + file.getName();
        RfsLocalController.addFileGatheringInfo(list, file, string2);
        if (file.isDirectory()) {
            File[] fileArray;
            for (File file2 : fileArray = file.listFiles(fileFilter)) {
                String string3 = RfsLocalController.isEmpty(string) ? file.getName() : string + "/" + file.getName();
                RfsLocalController.gatherFiles(file2, string3, fileFilter, list);
            }
        }
    }

    private static void addFileGatheringInfo(List<FileGatheringInfo> list, File file, String string) {
        if (file.exists()) {
            list.add(new FileGatheringInfo(file, string));
        }
    }

    private static boolean isEmpty(String string) {
        return string == null || string.length() == 0;
    }

    private static class FileGatheringInfo {
        public final File file;
        public final String relPath;

        public FileGatheringInfo(File file, String string) {
            this.file = file;
            this.relPath = string;
        }

        public String toString() {
            return this.relPath;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum RequestKind {
        REQUEST,
        WRITTEN;

    }
}

