/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.sync;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.text.ParseException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.CancellationException;
import org.netbeans.modules.cnd.api.remote.HostInfoProvider;
import org.netbeans.modules.cnd.api.remote.SetupProvider;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.netbeans.modules.nativeexecution.api.util.MacroExpanderFactory;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RfsSetupProvider
implements SetupProvider {
    public static final String POSTFIX_64 = "_64";
    private Map<String, String> binarySetupMap;
    private static final String CONTROLLER = "rfs_controller";
    private static final String PRELOAD = "rfs_preload.so";

    public RfsSetupProvider() {
        String[] stringArray = new String[]{"SunOS-x86", "SunOS-x86_64", "Linux-x86", "Linux-x86_64", "SunOS-sparc", "SunOS-sparc_64"};
        this.binarySetupMap = new HashMap<String, String>();
        for (String string : stringArray) {
            this.binarySetupMap.put(string + "/" + PRELOAD, "bin/" + string + "/" + PRELOAD);
            this.binarySetupMap.put(string + "/" + CONTROLLER, "bin/" + string + "/" + CONTROLLER);
        }
    }

    public Map<String, String> getBinaryFiles(ExecutionEnvironment executionEnvironment) {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        try {
            HostInfo hostInfo = HostInfoUtils.getHostInfo((ExecutionEnvironment)executionEnvironment);
            String string = RfsSetupProvider.getOsName(executionEnvironment);
            String string2 = string + '/';
            String string3 = RfsSetupProvider.getOsName(executionEnvironment) + POSTFIX_64 + '/';
            for (Map.Entry<String, String> entry : this.binarySetupMap.entrySet()) {
                boolean bl = false;
                if (entry.getKey().startsWith(string2)) {
                    bl = true;
                } else if (entry.getKey().startsWith(string3)) {
                    boolean bl2 = bl = hostInfo.getOS().getBitness() == HostInfo.Bitness._64;
                }
                if (!bl) continue;
                linkedHashMap.put(entry.getKey(), entry.getValue());
            }
        }
        catch (InterruptedIOException interruptedIOException) {
        }
        catch (CancellationException cancellationException) {
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        catch (ParseException parseException) {
            Exceptions.printStackTrace((Throwable)parseException);
        }
        return linkedHashMap;
    }

    public static String getPreloadName(ExecutionEnvironment executionEnvironment) {
        return PRELOAD;
    }

    public static String getControllerPath(ExecutionEnvironment executionEnvironment) throws ParseException, CancellationException, IOException {
        String string = RfsSetupProvider.getLibDir(executionEnvironment);
        HostInfo hostInfo = HostInfoUtils.getHostInfo((ExecutionEnvironment)executionEnvironment);
        if (hostInfo.getOS().getBitness() == HostInfo.Bitness._64) {
            string = string + POSTFIX_64;
        }
        string = string + "/rfs_controller";
        return string;
    }

    public static String getLdLibraryPath(ExecutionEnvironment executionEnvironment) throws ParseException {
        String string = RfsSetupProvider.getLibDir(executionEnvironment);
        return string + ':' + string + POSTFIX_64;
    }

    private static String getLibDir(ExecutionEnvironment executionEnvironment) throws ParseException {
        String string = HostInfoProvider.getLibDir((ExecutionEnvironment)executionEnvironment);
        String string2 = RfsSetupProvider.getOsName(executionEnvironment);
        return string + '/' + string2;
    }

    private static String getOsName(ExecutionEnvironment executionEnvironment) throws ParseException {
        MacroExpanderFactory.MacroExpander macroExpander = MacroExpanderFactory.getExpander((ExecutionEnvironment)executionEnvironment);
        String string = macroExpander.expandPredefinedMacros("${osname}-${platform}");
        return string;
    }
}

