/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.cnd.api.remote.ServerRecord;
import org.netbeans.modules.cnd.remote.server.RemoteServerList;
import org.netbeans.modules.cnd.remote.server.RemoteServerRecord;
import org.netbeans.modules.cnd.remote.sync.SyncUtils;
import org.netbeans.modules.cnd.spi.remote.RemoteSyncFactory;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class HostPropertiesDialog
extends JPanel {
    private final ServerRecord serverRecord;
    private JComboBox cbSync;
    private JCheckBox cbX11;
    private JLabel lblHost;
    private JLabel lblName;
    private JLabel lblPort;
    private JLabel lblSync;
    private JLabel lblUser;
    private JTextField tfHost;
    private JTextField tfName;
    private JTextField tfPort;
    private JTextField tfUser;

    public static boolean invokeMe(RemoteServerRecord remoteServerRecord) {
        HostPropertiesDialog hostPropertiesDialog = new HostPropertiesDialog(remoteServerRecord);
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)hostPropertiesDialog, NbBundle.getMessage(HostPropertiesDialog.class, (String)"TITLE_HostProperties"), true, 2, DialogDescriptor.OK_OPTION, null);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.setVisible(true);
        if (dialogDescriptor.getValue() == DialogDescriptor.OK_OPTION) {
            boolean bl;
            RemoteSyncFactory remoteSyncFactory;
            String string = hostPropertiesDialog.tfName.getText();
            boolean bl2 = false;
            if (!string.equals(remoteServerRecord.getDisplayName())) {
                remoteServerRecord.setDisplayName(string);
                bl2 = true;
            }
            if (!(remoteSyncFactory = (RemoteSyncFactory)hostPropertiesDialog.cbSync.getSelectedItem()).equals(remoteServerRecord.getSyncFactory())) {
                remoteServerRecord.setSyncFactory(remoteSyncFactory);
                bl2 = true;
            }
            if ((bl = hostPropertiesDialog.cbX11.isSelected()) != remoteServerRecord.getX11Forwarding()) {
                remoteServerRecord.setX11Forwarding(bl);
                bl2 = true;
            }
            if (bl2) {
                RemoteServerList.storePreferences(remoteServerRecord);
                return true;
            }
        }
        return false;
    }

    private HostPropertiesDialog(RemoteServerRecord remoteServerRecord) {
        this.serverRecord = remoteServerRecord;
        this.initComponents();
        this.tfHost.setBackground(this.getBackground());
        this.tfPort.setBackground(this.getBackground());
        this.tfUser.setBackground(this.getBackground());
        this.tfName.setText(remoteServerRecord.getDisplayName());
        this.tfHost.setText(remoteServerRecord.getServerName());
        this.tfUser.setText(remoteServerRecord.getUserName());
        this.tfPort.setText("" + remoteServerRecord.getExecutionEnvironment().getSSHPort());
        SyncUtils.arrangeComboBox(this.cbSync, remoteServerRecord.getExecutionEnvironment());
        this.cbSync.setSelectedItem(remoteServerRecord.getSyncFactory());
        this.cbX11.setSelected(remoteServerRecord.getX11Forwarding());
        this.addAncestorListener(new AncestorListener(){

            public void ancestorAdded(AncestorEvent ancestorEvent) {
                HostPropertiesDialog.this.tfName.requestFocus();
            }

            public void ancestorRemoved(AncestorEvent ancestorEvent) {
            }

            public void ancestorMoved(AncestorEvent ancestorEvent) {
            }
        });
    }

    private void initComponents() {
        this.lblHost = new JLabel();
        this.tfHost = new JTextField();
        this.lblPort = new JLabel();
        this.tfPort = new JTextField();
        this.lblUser = new JLabel();
        this.tfUser = new JTextField();
        this.lblName = new JLabel();
        this.tfName = new JTextField();
        this.lblSync = new JLabel();
        this.cbSync = new JComboBox();
        this.cbX11 = new JCheckBox();
        this.setFocusCycleRoot(true);
        this.lblHost.setLabelFor(this.tfHost);
        Mnemonics.setLocalizedText((JLabel)this.lblHost, (String)NbBundle.getMessage(HostPropertiesDialog.class, (String)"HostPropertiesDialog.lblHost.text"));
        this.tfHost.setEditable(false);
        this.tfHost.setText(NbBundle.getMessage(HostPropertiesDialog.class, (String)"HostPropertiesDialog.tfHost.text"));
        this.lblPort.setLabelFor(this.tfPort);
        Mnemonics.setLocalizedText((JLabel)this.lblPort, (String)NbBundle.getMessage(HostPropertiesDialog.class, (String)"HostPropertiesDialog.lblPort.text"));
        this.tfPort.setEditable(false);
        this.tfPort.setText(NbBundle.getMessage(HostPropertiesDialog.class, (String)"HostPropertiesDialog.tfPort.text"));
        this.lblUser.setLabelFor(this.tfUser);
        Mnemonics.setLocalizedText((JLabel)this.lblUser, (String)NbBundle.getMessage(HostPropertiesDialog.class, (String)"HostPropertiesDialog.lblUser.text"));
        this.tfUser.setEditable(false);
        this.tfUser.setText(NbBundle.getMessage(HostPropertiesDialog.class, (String)"HostPropertiesDialog.tfUser.text"));
        this.lblName.setLabelFor(this.tfName);
        Mnemonics.setLocalizedText((JLabel)this.lblName, (String)NbBundle.getMessage(HostPropertiesDialog.class, (String)"HostPropertiesDialog.lblName.text"));
        this.tfName.setText(NbBundle.getMessage(HostPropertiesDialog.class, (String)"HostPropertiesDialog.tfName.text"));
        this.lblSync.setLabelFor(this.cbSync);
        Mnemonics.setLocalizedText((JLabel)this.lblSync, (String)NbBundle.getMessage(HostPropertiesDialog.class, (String)"HostPropertiesDialog.lblSync.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.cbX11, (String)NbBundle.getMessage(HostPropertiesDialog.class, (String)"HostPropertiesDialog.cbX11.text"));
        this.cbX11.setMargin(new Insets(0, 0, 0, 0));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.lblName).add((Component)this.lblUser).add((Component)this.lblHost).add((Component)this.lblSync)).add(12, 12, 12).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().addPreferredGap(0).add((Component)this.cbX11, -1, 301, Short.MAX_VALUE)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.tfHost, -1, 194, Short.MAX_VALUE).addPreferredGap(1).add((Component)this.lblPort).addPreferredGap(0).add((Component)this.tfPort, -2, 54, -2)).add((Component)this.tfUser, -1, 301, Short.MAX_VALUE).add(2, (Component)this.tfName, -1, 301, Short.MAX_VALUE).add(2, (Component)this.cbSync, 0, 301, Short.MAX_VALUE)).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.lblHost).add((Component)this.tfHost, -2, -1, -2).add((Component)this.tfPort, -2, -1, -2).add((Component)this.lblPort)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.lblUser).add((Component)this.tfUser, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.lblName).add((Component)this.tfName, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.lblSync).add((Component)this.cbSync, -2, -1, -2)).add(18, 18, 18).add((Component)this.cbX11).addContainerGap(-1, Short.MAX_VALUE)));
    }
}

