/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hibernate.loaders.cfg;

import java.awt.Image;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import javax.swing.SwingUtilities;
import org.netbeans.core.spi.multiview.MultiViewElement;
import org.netbeans.modules.hibernate.cfg.model.HibernateConfiguration;
import org.netbeans.modules.hibernate.cfg.model.Security;
import org.netbeans.modules.hibernate.cfg.model.SessionFactory;
import org.netbeans.modules.hibernate.loaders.HbXmlMultiViewEditorSupport;
import org.netbeans.modules.hibernate.loaders.cfg.HibernateCfgDataLoader;
import org.netbeans.modules.hibernate.loaders.cfg.HibernateCfgDataNode;
import org.netbeans.modules.hibernate.loaders.cfg.HibernateCfgMetadata;
import org.netbeans.modules.hibernate.loaders.cfg.multiview.HibernateCfgToolBarMVElement;
import org.netbeans.modules.schema2beans.Schema2BeansException;
import org.netbeans.modules.xml.multiview.DesignMultiViewDesc;
import org.netbeans.modules.xml.multiview.ToolBarMultiViewElement;
import org.netbeans.modules.xml.multiview.Utils;
import org.netbeans.modules.xml.multiview.XmlMultiViewDataObject;
import org.netbeans.modules.xml.multiview.XmlMultiViewDataSynchronizer;
import org.netbeans.modules.xml.multiview.XmlMultiViewEditorSupport;
import org.netbeans.spi.xml.cookies.CheckXMLSupport;
import org.netbeans.spi.xml.cookies.DataObjectAdapters;
import org.netbeans.spi.xml.cookies.ValidateXMLSupport;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.MultiFileLoader;
import org.openide.nodes.CookieSet;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.xml.sax.InputSource;

public class HibernateCfgDataObject
extends XmlMultiViewDataObject {
    private static final int TYPE_TOOLBAR = 0;
    public static final int UPDATE_DELAY = 200;
    private static final String DESIGN_VIEW_ID = "hibernate_configuration_multiview_design";
    private HibernateConfiguration configuration;
    private ModelSynchronizer modelSynchronizer;
    private static final String SECURITY_ADDED_OR_REMOVED = "security_added_or_removed";

    public HibernateCfgDataObject(FileObject fileObject, HibernateCfgDataLoader hibernateCfgDataLoader) throws DataObjectExistsException, IOException {
        super(fileObject, (MultiFileLoader)hibernateCfgDataLoader);
        this.getEditorSupport().setMIMEType("text/x-hibernate-cfg+xml");
        this.modelSynchronizer = new ModelSynchronizer(this);
        CookieSet cookieSet = this.getCookieSet();
        InputSource inputSource = DataObjectAdapters.inputSource((DataObject)this);
        CheckXMLSupport checkXMLSupport = new CheckXMLSupport(inputSource);
        cookieSet.add((Node.Cookie)checkXMLSupport);
        ValidateXMLSupport validateXMLSupport = new ValidateXMLSupport(inputSource);
        cookieSet.add((Node.Cookie)validateXMLSupport);
        this.parseDocument();
    }

    public boolean parseDocument() {
        block9: {
            if (this.configuration == null) {
                try {
                    this.configuration = this.getHibernateConfiguration();
                }
                catch (RuntimeException runtimeException) {
                    return false;
                }
            }
            try {
                InputStream inputStream = this.getEditorSupport().getInputStream();
                HibernateConfiguration hibernateConfiguration = null;
                try {
                    hibernateConfiguration = HibernateConfiguration.createGraph(inputStream);
                }
                catch (RuntimeException runtimeException) {
                    return false;
                }
                if (hibernateConfiguration == null) break block9;
                try {
                    this.configuration.merge(hibernateConfiguration, 3);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    return false;
                }
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify(1, (Throwable)iOException);
                return false;
            }
        }
        return true;
    }

    public boolean viewCanBeDisplayed() {
        boolean bl = false;
        NotifyDescriptor.Message message = null;
        if (!this.parseDocument() && this.getSelectedPerspective().preferredID().startsWith(DESIGN_VIEW_ID)) {
            message = new NotifyDescriptor.Message((Object)NbBundle.getMessage(HibernateCfgDataObject.class, (String)"TXT_DocumentUnparsable", (Object)this.getPrimaryFile().getNameExt()), 2);
            bl = true;
        }
        if (bl) {
            DialogDisplayer.getDefault().notify(message);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    HibernateCfgDataObject.this.goToXmlView();
                }
            });
        }
        return !bl;
    }

    public HibernateConfiguration getHibernateConfiguration() {
        if (this.configuration == null) {
            try {
                this.configuration = HibernateCfgMetadata.getDefault().getRoot(this.getPrimaryFile());
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify(1, (Throwable)iOException);
            }
        }
        assert (this.configuration != null);
        return this.configuration;
    }

    public void addSessionFactory(SessionFactory sessionFactory) {
        this.getHibernateConfiguration().setSessionFactory(sessionFactory);
        this.modelUpdatedFromUI();
    }

    public void save() {
        EditorCookie editorCookie = (EditorCookie)this.getCookie(EditorCookie.class);
        if (editorCookie != null) {
            try {
                editorCookie.saveDocument();
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify(1, (Throwable)iOException);
            }
        }
    }

    protected synchronized XmlMultiViewEditorSupport getEditorSupport() {
        if (this.editorSupport == null) {
            this.editorSupport = new HbXmlMultiViewEditorSupport(this);
            this.editorSupport.getMultiViewDescriptions();
        }
        return this.editorSupport;
    }

    protected Node createNodeDelegate() {
        return new HibernateCfgDataNode(this);
    }

    protected String getPrefixMark() {
        return null;
    }

    public void modelUpdatedFromUI() {
        this.setModified(true);
        this.modelSynchronizer.requestUpdateData();
    }

    protected Image getXmlViewIcon() {
        return ImageUtilities.loadImage((String)"org/netbeans/modules/hibernate/resources/hibernate-configuration.png");
    }

    public void showElement(Object object) {
        Object object2 = null;
        if (object instanceof SessionFactory || object instanceof Security) {
            this.openView(0);
            object2 = object;
        }
        if (object2 != null) {
            final Object object3 = object2;
            Utils.runInAwtDispatchThread((Runnable)new Runnable(){

                public void run() {
                    HibernateCfgDataObject.this.getActiveMultiViewElement0().getSectionView().openPanel(object3);
                }
            });
        }
    }

    public ToolBarMultiViewElement getActiveMultiViewElement0() {
        return (ToolBarMultiViewElement)super.getActiveMultiViewElement();
    }

    protected DesignMultiViewDesc[] getMultiViewDesc() {
        return new DesignMultiViewDesc[]{new DesignView(this, 0)};
    }

    private class ModelSynchronizer
    extends XmlMultiViewDataSynchronizer {
        public ModelSynchronizer(XmlMultiViewDataObject xmlMultiViewDataObject) {
            super(xmlMultiViewDataObject, 200);
        }

        protected boolean mayUpdateData(boolean bl) {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void updateDataFromModel(Object object, FileLock fileLock, boolean bl) {
            if (object == null) {
                return;
            }
            try {
                StringWriter stringWriter = new StringWriter();
                ((HibernateConfiguration)((Object)object)).write(stringWriter);
                ((Writer)stringWriter).close();
                HibernateCfgDataObject.this.getDataCache().setData(fileLock, ((Object)stringWriter).toString(), bl);
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify(1, (Throwable)iOException);
            }
            catch (Schema2BeansException schema2BeansException) {
                ErrorManager.getDefault().notify(1, (Throwable)schema2BeansException);
            }
            finally {
                if (fileLock != null) {
                    fileLock.releaseLock();
                }
            }
        }

        protected Object getModel() {
            return HibernateCfgDataObject.this.getHibernateConfiguration();
        }

        protected void reloadModelFromData() {
            HibernateCfgDataObject.this.parseDocument();
        }
    }

    private static class DesignView
    extends DesignMultiViewDesc {
        private static final long serialVersionUID = 1L;
        private int type;

        DesignView(HibernateCfgDataObject hibernateCfgDataObject, int n) {
            super((XmlMultiViewDataObject)hibernateCfgDataObject, NbBundle.getMessage(HibernateCfgDataObject.class, (String)"LBL_Design"));
            this.type = n;
        }

        public MultiViewElement createElement() {
            HibernateCfgDataObject hibernateCfgDataObject = (HibernateCfgDataObject)this.getDataObject();
            return new HibernateCfgToolBarMVElement(hibernateCfgDataObject);
        }

        public Image getIcon() {
            return ImageUtilities.loadImage((String)"org/netbeans/modules/hibernate/resources/hibernate-configuration.png");
        }

        public String preferredID() {
            return HibernateCfgDataObject.DESIGN_VIEW_ID + String.valueOf(this.type);
        }

        public HelpCtx getHelpCtx() {
            return null;
        }
    }
}

