/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hibernate.refactoring;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.TokenID;
import org.netbeans.editor.TokenItem;
import org.netbeans.modules.hibernate.editor.HibernateEditorUtil;
import org.netbeans.modules.hibernate.service.api.HibernateEnvironment;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.xml.text.api.XMLDefaultTokenContext;
import org.netbeans.modules.xml.text.syntax.SyntaxElement;
import org.netbeans.modules.xml.text.syntax.XMLSyntaxSupport;
import org.netbeans.modules.xml.text.syntax.dom.EmptyTag;
import org.netbeans.modules.xml.text.syntax.dom.StartTag;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.PositionBounds;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateRefactoringUtil {
    private static final Logger LOGGER = Logger.getLogger(HibernateRefactoringUtil.class.getName());
    private static final String JAVA_MIME_TYPE = "text/x-java";

    public static boolean isJavaFile(FileObject fileObject) {
        return JAVA_MIME_TYPE.equals(fileObject.getMIMEType());
    }

    public static RenamedClassName getRenamedClassName(final TreePathHandle treePathHandle, JavaSource javaSource, final String string) throws IOException {
        final RenamedClassName[] renamedClassNameArray = new RenamedClassName[]{null};
        javaSource.runUserActionTask((Task)new Task<CompilationController>(){

            public void run(CompilationController compilationController) throws IOException {
                compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                Element element = treePathHandle.resolveElement((CompilationInfo)compilationController);
                if (element == null || element.getKind() != ElementKind.CLASS) {
                    return;
                }
                String string5 = ElementUtilities.getBinaryName((TypeElement)((TypeElement)element));
                String string2 = element.getSimpleName().toString();
                String string3 = null;
                if ((element = element.getEnclosingElement()).getKind() == ElementKind.CLASS) {
                    string3 = ElementUtilities.getBinaryName((TypeElement)((TypeElement)element)) + '$' + string;
                } else if (element.getKind() == ElementKind.PACKAGE) {
                    String string4 = ((PackageElement)element).getQualifiedName().toString();
                    string3 = HibernateRefactoringUtil.createQualifiedName(string4, string);
                } else {
                    LOGGER.log(Level.WARNING, "Enclosing element of {0} was neither class nor package", treePathHandle);
                }
                renamedClassNameArray[0] = new RenamedClassName(string2, string5, string3);
            }
        }, true);
        return renamedClassNameArray[0];
    }

    public static List<String> getTopLevelClassNames(FileObject fileObject) throws IOException {
        JavaSource javaSource = JavaSource.forFileObject((FileObject)fileObject);
        if (javaSource == null) {
            return Collections.emptyList();
        }
        final ArrayList<String> arrayList = new ArrayList<String>(1);
        javaSource.runUserActionTask((Task)new Task<CompilationController>(){

            public void run(CompilationController compilationController) throws IOException {
                compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                for (TypeElement typeElement : compilationController.getTopLevelElements()) {
                    arrayList.add(ElementUtilities.getBinaryName((TypeElement)typeElement));
                }
            }
        }, true);
        return arrayList;
    }

    public static String getPackageName(FileObject fileObject) {
        ClassPath classPath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source");
        if (classPath != null) {
            return classPath.getResourceName(fileObject, '.', false);
        }
        return null;
    }

    public static String getRenamedPackageName(FileObject fileObject, String string) {
        FileObject fileObject2 = fileObject.getParent();
        if (fileObject2 == null) {
            return null;
        }
        ClassPath classPath = ClassPath.getClassPath((FileObject)fileObject2, (String)"classpath/source");
        if (classPath == null) {
            return null;
        }
        String string2 = classPath.getResourceName(fileObject2, '.', false);
        if (string2 == null) {
            return null;
        }
        if (string2.length() > 0) {
            return string2 + '.' + string;
        }
        return string;
    }

    public static String getPackageName(URL uRL) {
        String string;
        File file = null;
        try {
            string = URLDecoder.decode(uRL.getPath(), "UTF-8");
            file = FileUtil.normalizeFile((File)new File(string));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalArgumentException("Cannot create package name for URL " + uRL);
        }
        string = "";
        do {
            FileObject fileObject;
            if ((fileObject = FileUtil.toFileObject((File)file)) != null) {
                if ("".equals(string)) {
                    return HibernateRefactoringUtil.getPackageName(fileObject);
                }
                String string2 = HibernateRefactoringUtil.getPackageName(fileObject);
                return string2 + ("".equals(string2) ? "" : ".") + string;
            }
            if (!"".equals(string)) {
                string = "." + string;
            }
            try {
                string = URLDecoder.decode(file.getPath().substring(file.getPath().lastIndexOf(File.separatorChar) + 1), "UTF-8") + string;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new IllegalArgumentException("Cannot create package name for URL " + uRL);
            }
        } while ((file = file.getParentFile()) != null);
        throw new IllegalArgumentException("Cannot create package name for URL " + uRL);
    }

    public static String getSimpleElementName(String string) {
        int n;
        while (true) {
            if (string.length() == 0) {
                return string;
            }
            n = string.lastIndexOf(46);
            if (n == -1) {
                return string;
            }
            if (n != string.length() - 1) break;
            string = string.substring(0, n);
        }
        return string.substring(n + 1);
    }

    public static String createQualifiedName(String string, String string2) {
        if (string.length() == 0) {
            return string2;
        }
        if (string2.length() == 0) {
            return string;
        }
        return string + '.' + string2;
    }

    public static Map<FileObject, List<OccurrenceItem>> getJavaClassOccurrences(List<FileObject> list, String string) {
        HashMap<FileObject, List<OccurrenceItem>> hashMap = new HashMap<FileObject, List<OccurrenceItem>>();
        for (FileObject fileObject : list) {
            hashMap.put(fileObject, HibernateRefactoringUtil.getOccurPlaces(fileObject, string, false));
        }
        return hashMap;
    }

    public static Map<FileObject, List<OccurrenceItem>> getJavaPackageOccurrences(List<FileObject> list, String string) {
        HashMap<FileObject, List<OccurrenceItem>> hashMap = new HashMap<FileObject, List<OccurrenceItem>>();
        for (FileObject fileObject : list) {
            hashMap.put(fileObject, HibernateRefactoringUtil.getOccurPlaces(fileObject, string, true));
        }
        return hashMap;
    }

    public static Map<FileObject, List<OccurrenceItem>> getJavaFieldOccurrences(List<FileObject> list, String string, String string2) {
        HashMap<FileObject, List<OccurrenceItem>> hashMap = new HashMap<FileObject, List<OccurrenceItem>>();
        for (FileObject fileObject : list) {
            hashMap.put(fileObject, HibernateRefactoringUtil.getJavaFieldOccurPlaces(fileObject, string, string2));
        }
        return hashMap;
    }

    private static List<OccurrenceItem> getOccurPlaces(FileObject fileObject, String string, boolean bl) {
        ArrayList<OccurrenceItem> arrayList = new ArrayList<OccurrenceItem>();
        try {
            int n;
            DataObject dataObject = DataObject.find((FileObject)fileObject);
            EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
            if (editorCookie == null) {
                throw new IllegalStateException("File " + fileObject + " does not have an EditorCookie.");
            }
            CloneableEditorSupport cloneableEditorSupport = (CloneableEditorSupport)editorCookie;
            BaseDocument baseDocument = (BaseDocument)cloneableEditorSupport.openDocument();
            XMLSyntaxSupport xMLSyntaxSupport = (XMLSyntaxSupport)baseDocument.getSyntaxSupport();
            TokenItem tokenItem = xMLSyntaxSupport.getTokenChain(n = baseDocument.getStartPosition().getOffset(), Math.min(n + 1, baseDocument.getLength()));
            if (tokenItem == null) {
                return null;
            }
            while (tokenItem != null) {
                TokenID tokenID = tokenItem.getTokenID();
                if (tokenID == XMLDefaultTokenContext.TAG) {
                    SyntaxElement syntaxElement = xMLSyntaxSupport.getElementChain(tokenItem.getOffset() + 1);
                    String[] stringArray = null;
                    boolean bl2 = false;
                    if (syntaxElement instanceof StartTag || syntaxElement instanceof EmptyTag) {
                        Node node = (Node)syntaxElement;
                        String string2 = node.getNodeName();
                        String string3 = tokenItem.getImage();
                        if (bl && string2.equalsIgnoreCase("hibernate-mapping") && string3.contains("hibernate-mapping")) {
                            stringArray = new String[]{HibernateRefactoringUtil.getAttributeValue(node, "package")};
                            bl2 = true;
                        } else if (string2.equalsIgnoreCase("class") && string3.contains("class")) {
                            stringArray = new String[]{HibernateRefactoringUtil.getAttributeValue(node, "name")};
                        } else if (string2.equalsIgnoreCase("one-to-many") && string3.contains("one-to-many")) {
                            stringArray = new String[]{HibernateRefactoringUtil.getAttributeValue(node, "class")};
                        } else if (string2.equalsIgnoreCase("composite-id") && string3.contains("composite-id")) {
                            stringArray = new String[]{HibernateRefactoringUtil.getAttributeValue(node, "class")};
                        } else if (string2.equalsIgnoreCase("key-many-to-one") && string3.contains("key-many-to-one")) {
                            stringArray = new String[]{HibernateRefactoringUtil.getAttributeValue(node, "class")};
                        } else if (string2.equalsIgnoreCase("many-to-one") && string3.contains("many-to-one")) {
                            stringArray = new String[]{HibernateRefactoringUtil.getAttributeValue(node, "class")};
                        } else if (string2.equalsIgnoreCase("one-to-one") && string3.contains("one-to-one")) {
                            stringArray = new String[]{HibernateRefactoringUtil.getAttributeValue(node, "class")};
                        } else if (string2.equalsIgnoreCase("component") && string3.contains("component")) {
                            stringArray = new String[]{HibernateRefactoringUtil.getAttributeValue(node, "class")};
                        } else if (string2.equalsIgnoreCase("subclass") && string3.contains("subclass")) {
                            stringArray = new String[]{HibernateRefactoringUtil.getAttributeValue(node, "name"), HibernateRefactoringUtil.getAttributeValue(node, "extends")};
                        } else if (string2.equalsIgnoreCase("joined-subclass") && string3.contains("joined-subclass")) {
                            stringArray = new String[]{HibernateRefactoringUtil.getAttributeValue(node, "name"), HibernateRefactoringUtil.getAttributeValue(node, "extends"), HibernateRefactoringUtil.getAttributeValue(node, "persister")};
                        } else if (string2.equalsIgnoreCase("union-subclass") && string3.contains("union-subclass")) {
                            stringArray = new String[]{HibernateRefactoringUtil.getAttributeValue(node, "name"), HibernateRefactoringUtil.getAttributeValue(node, "extends"), HibernateRefactoringUtil.getAttributeValue(node, "persister")};
                        } else if (string2.equalsIgnoreCase("import") && string3.contains("import")) {
                            stringArray = new String[]{HibernateRefactoringUtil.getAttributeValue(node, "class")};
                        } else if (string2.equalsIgnoreCase("many-to-many") && string3.contains("many-to-many")) {
                            stringArray = new String[]{HibernateRefactoringUtil.getAttributeValue(node, "class")};
                        }
                        if (stringArray != null) {
                            for (int i = 0; i < stringArray.length; ++i) {
                                String string4 = baseDocument.getText(tokenItem.getOffset(), syntaxElement.getElementLength());
                                String string5 = stringArray[i];
                                if (bl && !bl2) {
                                    string5 = HibernateRefactoringUtil.getPackageName(string5);
                                }
                                if (string5 == null || !string5.equals(string) || string4.indexOf(string) == -1) continue;
                                int n2 = tokenItem.getOffset() + string4.indexOf(string);
                                int n3 = n2 + string.length();
                                PositionBounds positionBounds = new PositionBounds(cloneableEditorSupport.createPositionRef(n2, Position.Bias.Forward), cloneableEditorSupport.createPositionRef(n3, Position.Bias.Forward));
                                arrayList.add(new OccurrenceItem(positionBounds, string4));
                            }
                        }
                    }
                }
                tokenItem = tokenItem.getNext();
            }
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify(1, (Throwable)iOException);
        }
        catch (BadLocationException badLocationException) {
            ErrorManager.getDefault().notify(1, (Throwable)badLocationException);
        }
        return arrayList;
    }

    private static List<OccurrenceItem> getJavaFieldOccurPlaces(FileObject fileObject, String string, String string2) {
        ArrayList<OccurrenceItem> arrayList = new ArrayList<OccurrenceItem>();
        try {
            int n;
            DataObject dataObject = DataObject.find((FileObject)fileObject);
            EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
            if (editorCookie == null) {
                throw new IllegalStateException("File " + fileObject + " does not have an EditorCookie.");
            }
            CloneableEditorSupport cloneableEditorSupport = (CloneableEditorSupport)editorCookie;
            BaseDocument baseDocument = (BaseDocument)cloneableEditorSupport.openDocument();
            XMLSyntaxSupport xMLSyntaxSupport = (XMLSyntaxSupport)baseDocument.getSyntaxSupport();
            TokenItem tokenItem = xMLSyntaxSupport.getTokenChain(n = baseDocument.getStartPosition().getOffset(), Math.min(n + 1, baseDocument.getLength()));
            if (tokenItem == null) {
                return null;
            }
            String string3 = null;
            while (tokenItem != null) {
                TokenID tokenID = tokenItem.getTokenID();
                if (tokenID == XMLDefaultTokenContext.TAG) {
                    SyntaxElement syntaxElement = xMLSyntaxSupport.getElementChain(tokenItem.getOffset() + 1);
                    String string4 = null;
                    if (syntaxElement instanceof StartTag || syntaxElement instanceof EmptyTag) {
                        Node node = (Node)syntaxElement;
                        String string5 = node.getNodeName();
                        String string6 = tokenItem.getImage();
                        if ((string5.equalsIgnoreCase("property") && string6.contains("property") || string5.equalsIgnoreCase("id") && string6.contains("id") || string5.equalsIgnoreCase("set") && string6.contains("set") || string5.equalsIgnoreCase("composite-id") && string6.contains("composite-id") || string5.equalsIgnoreCase("key-property") && string6.contains("key-property") || string5.equalsIgnoreCase("key-many-to-one") && string6.contains("key-many-to-one") || string5.equalsIgnoreCase("version") && string6.contains("version") || string5.equalsIgnoreCase("timestamp") && string6.contains("timestamp") || string5.equalsIgnoreCase("many-to-one") && string6.contains("many-to-one") || string5.equalsIgnoreCase("one-to-one") && string6.contains("one-to-one") || string5.equalsIgnoreCase("component") && string6.contains("component") || string5.equalsIgnoreCase("any") && string6.contains("any") || string5.equalsIgnoreCase("map") && string6.contains("map") || string5.equalsIgnoreCase("list") && string6.contains("list")) && (string4 = HibernateRefactoringUtil.getAttributeValue(node, "name")) != null && string4.equals(string2) && HibernateEditorUtil.getClassName(node).equals(string)) {
                            string3 = baseDocument.getText(tokenItem.getOffset(), syntaxElement.getElementLength());
                            int n2 = string3.indexOf(string2);
                            int n3 = tokenItem.getOffset() + n2;
                            int n4 = n3 + string2.length();
                            PositionBounds positionBounds = new PositionBounds(cloneableEditorSupport.createPositionRef(n3, Position.Bias.Forward), cloneableEditorSupport.createPositionRef(n4, Position.Bias.Forward));
                            arrayList.add(new OccurrenceItem(positionBounds, string3));
                        }
                    }
                }
                tokenItem = tokenItem.getNext();
            }
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify(1, (Throwable)iOException);
        }
        catch (BadLocationException badLocationException) {
            ErrorManager.getDefault().notify(1, (Throwable)badLocationException);
        }
        return arrayList;
    }

    public static Map<FileObject, List<OccurrenceItem>> getMappingResourceOccurrences(List<FileObject> list, String string, boolean bl) {
        HashMap<FileObject, List<OccurrenceItem>> hashMap = new HashMap<FileObject, List<OccurrenceItem>>();
        for (FileObject fileObject : list) {
            hashMap.put(fileObject, HibernateRefactoringUtil.getMappingResourceOccurPlaces(fileObject, string, bl));
        }
        return hashMap;
    }

    private static List<OccurrenceItem> getMappingResourceOccurPlaces(FileObject fileObject, String string, boolean bl) {
        ArrayList<OccurrenceItem> arrayList = new ArrayList<OccurrenceItem>();
        try {
            int n;
            DataObject dataObject = DataObject.find((FileObject)fileObject);
            EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
            if (editorCookie == null) {
                throw new IllegalStateException("File " + fileObject + " does not have an EditorCookie.");
            }
            CloneableEditorSupport cloneableEditorSupport = (CloneableEditorSupport)editorCookie;
            BaseDocument baseDocument = (BaseDocument)cloneableEditorSupport.openDocument();
            XMLSyntaxSupport xMLSyntaxSupport = (XMLSyntaxSupport)baseDocument.getSyntaxSupport();
            TokenItem tokenItem = xMLSyntaxSupport.getTokenChain(n = baseDocument.getStartPosition().getOffset(), Math.min(n + 1, baseDocument.getLength()));
            if (tokenItem == null) {
                return null;
            }
            String string2 = null;
            while (tokenItem != null) {
                TokenID tokenID = tokenItem.getTokenID();
                if (tokenID == XMLDefaultTokenContext.TAG) {
                    SyntaxElement syntaxElement = xMLSyntaxSupport.getElementChain(tokenItem.getOffset() + 1);
                    String string3 = null;
                    if (syntaxElement instanceof StartTag || syntaxElement instanceof EmptyTag) {
                        Node node = (Node)syntaxElement;
                        String string4 = node.getNodeName();
                        String string5 = tokenItem.getImage();
                        if (string4.equalsIgnoreCase("mapping") && string5.contains("mapping") && (string3 = HibernateRefactoringUtil.getAttributeValue(node, "resource")) != null) {
                            int n2;
                            if (bl) {
                                n2 = string3.lastIndexOf(47);
                                string3 = n2 > -1 ? string3.substring(0, n2) : "";
                            }
                            if (string3.equals(string)) {
                                string2 = baseDocument.getText(tokenItem.getOffset(), syntaxElement.getElementLength());
                                n2 = string2.indexOf(string);
                                int n3 = tokenItem.getOffset() + n2;
                                int n4 = n3 + string.length();
                                PositionBounds positionBounds = new PositionBounds(cloneableEditorSupport.createPositionRef(n3, Position.Bias.Forward), cloneableEditorSupport.createPositionRef(n4, Position.Bias.Forward));
                                arrayList.add(new OccurrenceItem(positionBounds, string2));
                            }
                        }
                    }
                }
                tokenItem = tokenItem.getNext();
            }
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify(1, (Throwable)iOException);
        }
        catch (BadLocationException badLocationException) {
            ErrorManager.getDefault().notify(1, (Throwable)badLocationException);
        }
        return arrayList;
    }

    public static boolean anyHibernateMappingFiles(FileObject fileObject) {
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        HibernateEnvironment hibernateEnvironment = (HibernateEnvironment)project.getLookup().lookup(HibernateEnvironment.class);
        if (hibernateEnvironment == null) {
            return false;
        }
        List<FileObject> list = hibernateEnvironment.getAllHibernateMappingFileObjects();
        return list != null && list.size() != 0;
    }

    private static String getAttributeValue(Node node, String string) {
        if (node == null) {
            return null;
        }
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap != null && namedNodeMap.getNamedItem(string) != null) {
            return namedNodeMap.getNamedItem(string).getNodeValue();
        }
        return null;
    }

    public static String getPackageName(String string) {
        if (string == null) {
            return null;
        }
        int n = string.lastIndexOf(".");
        if (n == -1) {
            return null;
        }
        return string.substring(0, n);
    }

    public static final Problem createProblem(Problem problem, boolean bl, String string) {
        Problem problem2 = new Problem(bl, string);
        if (problem == null) {
            return problem2;
        }
        if (bl) {
            problem2.setNext(problem);
            return problem2;
        }
        Problem problem3 = problem;
        while (problem3.getNext() != null) {
            problem3 = problem3.getNext();
        }
        problem3.setNext(problem2);
        return problem;
    }

    public static final boolean isValidMappingFileName(String string) {
        if (string == null) {
            return false;
        }
        if (string.equals("")) {
            return false;
        }
        return string.endsWith(".hbm");
    }

    public static boolean nameNotUnique(String string, Project project) {
        HibernateEnvironment hibernateEnvironment = (HibernateEnvironment)project.getLookup().lookup(HibernateEnvironment.class);
        if (hibernateEnvironment == null) {
            return false;
        }
        List<String> list = hibernateEnvironment.getAllHibernateMappings();
        return list.contains(string);
    }

    public static final class OccurrenceItem {
        private String text;
        private PositionBounds location;

        public OccurrenceItem(PositionBounds positionBounds, String string) {
            this.location = positionBounds;
            this.text = string;
        }

        public String getText() {
            return this.text;
        }

        public PositionBounds getLocation() {
            return this.location;
        }
    }

    public static final class RenamedClassName {
        private final String oldSimpleName;
        private final String oldBinaryName;
        private final String newBinaryName;

        public RenamedClassName(String string, String string2, String string3) {
            this.oldSimpleName = string;
            this.oldBinaryName = string2;
            this.newBinaryName = string3;
        }

        public String getOldSimpleName() {
            return this.oldSimpleName;
        }

        public String getOldBinaryName() {
            return this.oldBinaryName;
        }

        public String getNewBinaryName() {
            return this.newBinaryName;
        }
    }
}

