/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.project.ant;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ant.AntBuildExtenderAccessorImpl;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.modules.project.ant.AntBuildExtenderAccessor;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.netbeans.spi.project.ant.AntBuildExtenderImplementation;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.Parameters;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AntBuildExtender {
    private HashMap<String, Extension> extensions;
    private AntBuildExtenderImplementation implementation;
    private ReferenceHelper refHelper;
    public static final String ANT_CUSTOMTASKS_LIBS_PROPNAME = "ant.customtasks.libs";
    private static final DocumentBuilder db;

    AntBuildExtender(AntBuildExtenderImplementation antBuildExtenderImplementation) {
        this.implementation = antBuildExtenderImplementation;
    }

    AntBuildExtender(AntBuildExtenderImplementation antBuildExtenderImplementation, ReferenceHelper referenceHelper) {
        this.implementation = antBuildExtenderImplementation;
        this.refHelper = referenceHelper;
    }

    public List<String> getExtensibleTargets() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(this.implementation.getExtensibleTargets());
        arrayList = Collections.unmodifiableList(arrayList);
        return arrayList;
    }

    public synchronized Extension addExtension(String string, FileObject fileObject) {
        assert (fileObject != null);
        assert (fileObject.isValid() && fileObject.isData());
        assert (FileOwnerQuery.getOwner((FileObject)fileObject) == this.implementation.getOwningProject());
        FileObject fileObject2 = this.implementation.getOwningProject().getProjectDirectory().getFileObject("nbproject/project.xml").getParent();
        assert (FileUtil.isParentOf((FileObject)fileObject2, (FileObject)fileObject));
        if (this.extensions == null) {
            this.readProjectMetadata();
        }
        if (this.extensions.get(string) != null) {
            throw new IllegalStateException("Extension with id '" + string + "' already exists.");
        }
        Extension extension = new Extension(string, fileObject, FileUtil.getRelativePath((FileObject)fileObject2, (FileObject)fileObject));
        this.extensions.put(string, extension);
        this.updateProjectMetadata();
        return extension;
    }

    public synchronized void removeExtension(String string) {
        if (this.extensions == null) {
            this.readProjectMetadata();
        }
        if (this.extensions.get(string) == null) {
            return;
        }
        this.extensions.remove(string);
        this.updateProjectMetadata();
    }

    public synchronized Extension getExtension(String string) {
        if (this.extensions == null) {
            this.readProjectMetadata();
        }
        return this.extensions.get(string);
    }

    synchronized Set<Extension> getExtensions() {
        HashSet<Extension> hashSet = new HashSet<Extension>();
        if (this.extensions == null) {
            this.readProjectMetadata();
        }
        hashSet.addAll(this.extensions.values());
        return hashSet;
    }

    public void addLibrary(Library library) throws IOException {
        Parameters.notNull((CharSequence)"library", (Object)library);
        this.setValueOfProperty(ANT_CUSTOMTASKS_LIBS_PROPNAME, library.getName(), true);
        if (this.refHelper != null && this.refHelper.getProjectLibraryManager() != null && this.refHelper.getProjectLibraryManager().getLibrary(library.getName()) == null) {
            try {
                this.refHelper.copyLibrary(library);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
    }

    public void removeLibrary(Library library) throws IOException {
        Parameters.notNull((CharSequence)"library", (Object)library);
        this.setValueOfProperty(ANT_CUSTOMTASKS_LIBS_PROPNAME, library.getName(), false);
    }

    private void setValueOfProperty(final String string, final String string2, final boolean bl) throws IOException {
        try {
            final FileObject fileObject = this.implementation.getOwningProject().getProjectDirectory().getFileObject("nbproject/project.properties");
            final InputStream inputStream = fileObject.getInputStream();
            ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Void run() throws Exception {
                    EditableProperties editableProperties = new EditableProperties(true);
                    try {
                        editableProperties.load(inputStream);
                    }
                    finally {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                    }
                    String[] stringArray = new String[]{};
                    String string3 = editableProperties.getProperty(string);
                    if (string3 != null) {
                        stringArray = string3.split(",");
                    }
                    TreeSet<String> treeSet = new TreeSet<String>(Arrays.asList(stringArray));
                    if (bl) {
                        treeSet.add(string2);
                    } else {
                        treeSet.remove(string2);
                    }
                    String[] stringArray2 = treeSet.toArray(new String[treeSet.size()]);
                    StringBuilder stringBuilder = new StringBuilder();
                    for (String string22 : stringArray2) {
                        stringBuilder.append(string22);
                        stringBuilder.append(",");
                    }
                    stringBuilder.delete(stringBuilder.length() - 1, stringBuilder.length());
                    editableProperties.setProperty(string, stringBuilder.toString());
                    OutputStream outputStream = fileObject.getOutputStream();
                    try {
                        editableProperties.store(outputStream);
                    }
                    finally {
                        outputStream.close();
                    }
                    return null;
                }
            });
        }
        catch (MutexException mutexException) {
            throw (IOException)mutexException.getException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Document createNewDocument() {
        DocumentBuilder documentBuilder = db;
        synchronized (documentBuilder) {
            return db.newDocument();
        }
    }

    private void updateProjectMetadata() {
        AuxiliaryConfiguration auxiliaryConfiguration;
        Document document = AntBuildExtender.createNewDocument();
        Element element = document.createElementNS(AntBuildExtenderAccessor.AUX_NAMESPACE, AntBuildExtenderAccessor.ELEMENT_ROOT);
        if (this.extensions != null) {
            auxiliaryConfiguration = this.implementation.getOwningProject().getProjectDirectory().getFileObject("nbproject/project.xml").getParent();
            for (Extension extension : this.extensions.values()) {
                Element element2 = document.createElementNS(AntBuildExtenderAccessor.AUX_NAMESPACE, AntBuildExtenderAccessor.ELEMENT_EXTENSION);
                element2.setAttribute(AntBuildExtenderAccessor.ATTR_ID, extension.id);
                String string = FileUtil.getRelativePath((FileObject)auxiliaryConfiguration, (FileObject)extension.file);
                assert (string != null);
                element2.setAttribute(AntBuildExtenderAccessor.ATTR_FILE, string);
                element.appendChild(element2);
                for (String string2 : extension.dependencies.keySet()) {
                    for (String string3 : extension.dependencies.get(string2)) {
                        Element element3 = document.createElementNS(AntBuildExtenderAccessor.AUX_NAMESPACE, AntBuildExtenderAccessor.ELEMENT_DEPENDENCY);
                        element3.setAttribute(AntBuildExtenderAccessor.ATTR_TARGET, string2);
                        element3.setAttribute(AntBuildExtenderAccessor.ATTR_DEPENDSON, string3);
                        element2.appendChild(element3);
                    }
                }
            }
        }
        auxiliaryConfiguration = ProjectUtils.getAuxiliaryConfiguration((Project)this.implementation.getOwningProject());
        auxiliaryConfiguration.putConfigurationFragment(element, true);
    }

    private void readProjectMetadata() {
        AuxiliaryConfiguration auxiliaryConfiguration = ProjectUtils.getAuxiliaryConfiguration((Project)this.implementation.getOwningProject());
        Element element = auxiliaryConfiguration.getConfigurationFragment(AntBuildExtenderAccessor.ELEMENT_ROOT, AntBuildExtenderAccessor.AUX_NAMESPACE, true);
        FileObject fileObject = this.implementation.getOwningProject().getProjectDirectory().getFileObject("nbproject/project.xml");
        assert (fileObject != null) : "Missing project.xml for project " + this.implementation.getOwningProject();
        FileObject fileObject2 = fileObject.getParent();
        this.extensions = new HashMap();
        if (element != null) {
            String string = element.getNamespaceURI();
            NodeList nodeList = element.getElementsByTagNameNS(string, AntBuildExtenderAccessor.ELEMENT_EXTENSION);
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element element2 = (Element)nodeList.item(i);
                String string2 = element2.getAttribute(AntBuildExtenderAccessor.ATTR_ID);
                assert (string2.length() > 0) : "Illegal project.xml";
                String string3 = element2.getAttribute(AntBuildExtenderAccessor.ATTR_FILE);
                FileObject fileObject3 = fileObject2.getFileObject(string3);
                if (fileObject3 == null) {
                    Logger.getLogger(AntBuildExtender.class.getName()).severe("Missing file " + string3 + " for build script extension " + string2 + ". The extension is skipped.");
                    continue;
                }
                Extension extension = new Extension(string2, fileObject3, string3);
                this.extensions.put(string2, extension);
                NodeList nodeList2 = element2.getElementsByTagNameNS(string, AntBuildExtenderAccessor.ELEMENT_DEPENDENCY);
                for (int j = 0; j < nodeList2.getLength(); ++j) {
                    Element element3 = (Element)nodeList2.item(j);
                    String string4 = element3.getAttribute(AntBuildExtenderAccessor.ATTR_TARGET);
                    String string5 = element3.getAttribute(AntBuildExtenderAccessor.ATTR_DEPENDSON);
                    assert (string4 != null);
                    assert (string5 != null);
                    extension.loadDependency(string4, string5);
                }
            }
        }
    }

    static {
        AntBuildExtenderAccessorImpl.createAccesor();
        try {
            db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new AssertionError((Object)parserConfigurationException);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class Extension {
        String id;
        FileObject file;
        String path;
        TreeMap<String, Collection<String>> dependencies;

        Extension(String string, FileObject fileObject, String string2) {
            this.id = string;
            this.file = fileObject;
            this.path = string2;
            this.dependencies = new TreeMap();
        }

        String getPath() {
            return this.path;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addDependency(String string, String string2) {
            assert (AntBuildExtender.this.implementation.getExtensibleTargets().contains(string)) : "The target '" + string + "' is not designated by the project type as extensible.";
            Extension extension = this;
            synchronized (extension) {
                if (this.loadDependency(string, string2)) {
                    AntBuildExtender.this.updateProjectMetadata();
                }
            }
        }

        private synchronized boolean loadDependency(String string, String string2) {
            Collection<String> collection = this.dependencies.get(string);
            boolean bl = false;
            if (collection == null) {
                collection = new ArrayList<String>();
                this.dependencies.put(string, collection);
                bl = true;
            }
            if (!collection.contains(string2)) {
                collection.add(string2);
                bl = true;
            }
            return bl;
        }

        public void removeDependency(String string, String string2) {
            Collection<String> collection = this.dependencies.get(string);
            if (collection != null && collection.remove(string2)) {
                AntBuildExtender.this.updateProjectMetadata();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Map<String, Collection<String>> getDependencies() {
            TreeMap<String, Collection<String>> treeMap = new TreeMap<String, Collection<String>>();
            Extension extension = this;
            synchronized (extension) {
                for (String string : this.dependencies.keySet()) {
                    ArrayList<String> arrayList = new ArrayList<String>();
                    arrayList.addAll(this.dependencies.get(string));
                    treeMap.put(string, arrayList);
                }
            }
            return treeMap;
        }
    }
}

