/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ant;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VariablesModel {
    private static final String VARIABLE_PREFIX = "var.";
    private List<Variable> vars = this.readVariables();

    VariablesModel() {
    }

    public List<Variable> getVariables() {
        return this.vars;
    }

    public Variable find(String string) {
        return VariablesModel.find(string, this.vars);
    }

    private static Variable find(String string, List<Variable> list) {
        for (Variable variable : list) {
            if (!variable.getName().equals(string)) continue;
            return variable;
        }
        return null;
    }

    void remove(Variable variable) {
        this.vars.remove(variable);
    }

    void save() {
        ProjectManager.mutex().writeAccess(new Runnable(){

            public void run() {
                EditableProperties editableProperties = PropertyUtils.getGlobalProperties();
                boolean bl = false;
                List list = VariablesModel.this.readVariables();
                for (Variable variable : VariablesModel.this.vars) {
                    Variable variable2 = VariablesModel.find(variable.getName(), list);
                    if (variable2 == null || !variable2.getValue().equals(variable.getValue())) {
                        editableProperties.put(VariablesModel.VARIABLE_PREFIX + variable.getName(), variable.getValue().getAbsolutePath());
                        bl = true;
                    }
                    if (variable2 == null) continue;
                    list.remove(variable2);
                }
                for (Variable variable : list) {
                    editableProperties.remove(VariablesModel.VARIABLE_PREFIX + variable.getName());
                    bl = true;
                }
                if (bl) {
                    try {
                        PropertyUtils.putGlobalProperties(editableProperties);
                    }
                    catch (IOException iOException) {
                        Exceptions.printStackTrace((Throwable)iOException);
                    }
                }
            }
        });
    }

    private List<Variable> readVariables() {
        ArrayList<Variable> arrayList = new ArrayList<Variable>();
        EditableProperties editableProperties = PropertyUtils.getGlobalProperties();
        for (Map.Entry<String, String> entry : editableProperties.entrySet()) {
            if (!entry.getKey().startsWith(VARIABLE_PREFIX)) continue;
            arrayList.add(new Variable(entry.getKey().substring(VARIABLE_PREFIX.length()), FileUtil.normalizeFile((File)new File(entry.getValue()))));
        }
        return arrayList;
    }

    public void add(String string, File file) {
        assert (this.find(string) == null) : string;
        this.vars.add(new Variable(string, file));
    }

    public String getRelativePath(File file, boolean bl) {
        for (Variable variable : this.vars) {
            if (!file.getAbsolutePath().startsWith(variable.getValue().getAbsolutePath())) continue;
            String string = bl ? variable.name : "${var." + variable.name + "}";
            String string2 = file.getAbsolutePath().substring(variable.getValue().getAbsolutePath().length()).replace('\\', '/');
            if (string2.startsWith("/")) {
                string2 = string2.substring(1);
            }
            return string + "/" + string2;
        }
        return null;
    }

    public static class Variable {
        private String name;
        private File value;

        public Variable(String string, File file) {
            this.name = string;
            this.value = file;
        }

        public String getName() {
            return this.name;
        }

        public File getValue() {
            return this.value;
        }

        public boolean equals(Object object) {
            return this.name.equals(((Variable)object).name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public void setValue(File file) {
            this.value = file;
        }

        public String toString() {
            return "var[" + this.getName() + "=" + this.getValue().getAbsolutePath() + "]";
        }
    }
}

