/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.javaee;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.glassfish.javaee.Hk2DeploymentManager;
import org.netbeans.modules.glassfish.spi.GlassfishModule;
import org.netbeans.modules.glassfish.spi.ServerCommand;
import org.netbeans.modules.glassfish.spi.TreeParser;
import org.netbeans.modules.j2ee.deployment.common.api.ConfigurationException;
import org.netbeans.modules.j2ee.deployment.common.api.SourceFileMap;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceRegistrationHelper {
    private static final TimeUnit TIMEOUT_UNIT = TimeUnit.MILLISECONDS;
    private static final int TIMEOUT = 2000;

    private ResourceRegistrationHelper() {
    }

    public static void deployResources(File file, Hk2DeploymentManager hk2DeploymentManager) {
        Set<File> set = ResourceRegistrationHelper.getResourceDirs(file);
        ResourceRegistrationHelper.deployResources(set, hk2DeploymentManager);
    }

    private static void deployResources(Set<File> set, Hk2DeploymentManager hk2DeploymentManager) {
        for (File file : set) {
            try {
                ResourceRegistrationHelper.registerResourceDir(file, hk2DeploymentManager);
            }
            catch (ConfigurationException configurationException) {
                Logger.getLogger("glassfish-javaee").log(Level.INFO, "some data sources may not be deployed", configurationException);
            }
        }
    }

    private static Set<File> getResourceDirs(File file) {
        TreeSet<File> treeSet = new TreeSet<File>();
        FileObject fileObject = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file));
        SourceFileMap sourceFileMap = SourceFileMap.findSourceMap((FileObject)fileObject);
        if (sourceFileMap != null) {
            treeSet.addAll(Arrays.asList(sourceFileMap.getEnterpriseResourceDirs()));
        }
        return treeSet;
    }

    private static boolean registerResourceDir(File file, Hk2DeploymentManager hk2DeploymentManager) throws ConfigurationException {
        boolean bl = false;
        File file2 = new File(file, "sun-resources.xml");
        if (file2.exists()) {
            ResourceRegistrationHelper.checkUpdateServerResources(file2, hk2DeploymentManager);
            GlassfishModule glassfishModule = hk2DeploymentManager.getCommonServerSupport();
            AddResourcesCommand addResourcesCommand = new AddResourcesCommand(file2.getAbsolutePath());
            Future future = glassfishModule.execute((ServerCommand)addResourcesCommand);
            try {
                if (future.get(2000L, TIMEOUT_UNIT) == GlassfishModule.OperationState.COMPLETED) {
                    bl = true;
                }
            }
            catch (TimeoutException timeoutException) {
                Logger.getLogger("glassfish-javaee").log(Level.INFO, timeoutException.getLocalizedMessage(), timeoutException);
                throw new ConfigurationException(timeoutException.getLocalizedMessage(), (Throwable)timeoutException);
            }
            catch (InterruptedException interruptedException) {
                Logger.getLogger("glassfish-javaee").log(Level.INFO, interruptedException.getLocalizedMessage(), interruptedException);
                throw new ConfigurationException(interruptedException.getLocalizedMessage(), (Throwable)interruptedException);
            }
            catch (ExecutionException executionException) {
                Logger.getLogger("glassfish-javaee").log(Level.INFO, executionException.getLocalizedMessage(), executionException);
                throw new ConfigurationException(executionException.getLocalizedMessage(), (Throwable)executionException);
            }
        }
        return bl;
    }

    private static void checkUpdateServerResources(File file, Hk2DeploymentManager hk2DeploymentManager) {
        Map<String, String> map = new HashMap<String, String>();
        ArrayList<TreeParser.Path> arrayList = new ArrayList<TreeParser.Path>();
        ResourceFinder resourceFinder = new ResourceFinder("name");
        arrayList.add(new TreeParser.Path("/resources/jdbc-connection-pool", (TreeParser.NodeReader)resourceFinder));
        ResourceFinder resourceFinder2 = new ResourceFinder("jndi-name");
        arrayList.add(new TreeParser.Path("/resources/jdbc-resource", (TreeParser.NodeReader)resourceFinder2));
        ResourceFinder resourceFinder3 = new ResourceFinder("name");
        arrayList.add(new TreeParser.Path("/resources/connector-connection-pool", (TreeParser.NodeReader)resourceFinder3));
        ResourceFinder resourceFinder4 = new ResourceFinder("jndi-name");
        arrayList.add(new TreeParser.Path("/resources/connector-resource", (TreeParser.NodeReader)resourceFinder4));
        ResourceFinder resourceFinder5 = new ResourceFinder("jndi-name");
        arrayList.add(new TreeParser.Path("/resources/admin-object-resource", (TreeParser.NodeReader)resourceFinder5));
        ResourceFinder resourceFinder6 = new ResourceFinder("jndi-name");
        arrayList.add(new TreeParser.Path("/resources/mail-resource", (TreeParser.NodeReader)resourceFinder6));
        try {
            TreeParser.readXml((File)file, arrayList);
        }
        catch (IllegalStateException illegalStateException) {
            Logger.getLogger("glassfish-javaee").log(Level.INFO, illegalStateException.getLocalizedMessage(), illegalStateException);
        }
        Map<String, String> map2 = ResourceRegistrationHelper.getResourceData("resources.*", hk2DeploymentManager);
        map = ResourceRegistrationHelper.checkResources(resourceFinder, "resources.jdbc-connection-pool.", map2, map, hk2DeploymentManager);
        map = ResourceRegistrationHelper.checkResources(resourceFinder2, "resources.jdbc-resource.", map2, map, hk2DeploymentManager);
        map = ResourceRegistrationHelper.checkResources(resourceFinder3, "resources.connector-connection-pool.", map2, map, hk2DeploymentManager);
        map = ResourceRegistrationHelper.checkResources(resourceFinder4, "resources.connector-resource.", map2, map, hk2DeploymentManager);
        map = ResourceRegistrationHelper.checkResources(resourceFinder5, "resources.admin-object-resource.", map2, map, hk2DeploymentManager);
        map = ResourceRegistrationHelper.checkResources(resourceFinder6, "resources.mail-resource.", map2, map, hk2DeploymentManager);
        if (map.size() > 0) {
            ResourceRegistrationHelper.putResourceData(map, hk2DeploymentManager);
        }
    }

    private static Map<String, String> checkResources(ResourceFinder resourceFinder, String string, Map<String, String> map, Map<String, String> map2, Hk2DeploymentManager hk2DeploymentManager) {
        List<String> list = resourceFinder.getResourceNames();
        for (int i = 0; i < list.size(); ++i) {
            String string2 = list.get(i);
            Map<String, String> map3 = resourceFinder.getResourceData().get(string2);
            String string3 = string + string2 + ".";
            HashMap<String, String> hashMap = new HashMap<String, String>();
            for (String string4 : map.keySet()) {
                if (!string4.startsWith(string3)) continue;
                hashMap.put(string4, map.get(string4));
            }
            if (hashMap.size() <= 0) continue;
            map2 = ResourceRegistrationHelper.getChangedData(hashMap, map3, map2, string3);
        }
        return map2;
    }

    private static Map<String, String> getChangedData(Map<String, String> map, Map<String, String> map2, Map<String, String> map3, String string) {
        String string2;
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator<String> iterator = map.keySet().iterator();
        Set<String> set = map2.keySet();
        while (iterator.hasNext()) {
            String string3;
            String string4 = iterator.next();
            string2 = map.get(string4);
            String[] stringArray = string4.split(string);
            String string5 = stringArray[1];
            if (string5.indexOf("property.") != -1) {
                arrayList.add(string5);
            }
            if ((string3 = map2.get(string5)) != null) {
                if (string2 != null && (string2 == null || string3.equals(string2))) continue;
                map3.put(string4, string3);
                continue;
            }
            if (!set.contains(string5) || string2 == null) continue;
            map3.put(string4, string3);
        }
        for (String string4 : map2.keySet()) {
            if (string4.indexOf("property.") == -1 || arrayList.contains(string4)) continue;
            string2 = string + string4;
            map3.put(string2, map2.get(string4));
        }
        return map3;
    }

    public static Map<String, String> getResourceData(String string, Hk2DeploymentManager hk2DeploymentManager) {
        try {
            ServerCommand.GetPropertyCommand getPropertyCommand = new ServerCommand.GetPropertyCommand(string);
            Future future = hk2DeploymentManager.getCommonServerSupport().execute((ServerCommand)getPropertyCommand);
            GlassfishModule.OperationState operationState = (GlassfishModule.OperationState)future.get();
            if (operationState == GlassfishModule.OperationState.COMPLETED) {
                Map map = getPropertyCommand.getData();
                if (map.isEmpty()) {
                    Logger.getLogger("glassfish-javaee").log(Level.INFO, null, new IllegalStateException(string + " has no data"));
                }
                return map;
            }
        }
        catch (InterruptedException interruptedException) {
            Logger.getLogger("glassfish-javaee").log(Level.INFO, interruptedException.getMessage(), interruptedException);
        }
        catch (ExecutionException executionException) {
            Logger.getLogger("glassfish-javaee").log(Level.INFO, executionException.getMessage(), executionException);
        }
        return new HashMap<String, String>();
    }

    public static void putResourceData(Map<String, String> map, Hk2DeploymentManager hk2DeploymentManager) {
        Set<String> set = map.keySet();
        Iterator<String> iterator = set.iterator();
        while (iterator.hasNext()) {
            String string;
            String string2 = string = iterator.next();
            String string3 = map.get(string);
            try {
                GlassfishModule glassfishModule = hk2DeploymentManager.getCommonServerSupport();
                ServerCommand.SetPropertyCommand setPropertyCommand = glassfishModule.getCommandFactory().getSetPropertyCommand(string2, string3);
                Future future = glassfishModule.execute((ServerCommand)setPropertyCommand);
                GlassfishModule.OperationState operationState = (GlassfishModule.OperationState)future.get();
            }
            catch (InterruptedException interruptedException) {
                Logger.getLogger("glassfish-javaee").log(Level.INFO, interruptedException.getMessage(), interruptedException);
            }
            catch (ExecutionException executionException) {
                Logger.getLogger("glassfish-javaee").log(Level.INFO, executionException.getMessage(), executionException);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ResourceFinder
    extends TreeParser.NodeReader {
        private Map<String, String> properties = null;
        private Map<String, Map<String, String>> resourceData = new HashMap<String, Map<String, String>>();
        private final String nameKey;

        public ResourceFinder(String string) {
            this.nameKey = string;
        }

        public void readAttributes(String string, Attributes attributes) throws SAXException {
            this.properties = new HashMap<String, String>();
            String string2 = attributes.getValue(this.nameKey);
            this.properties.put(this.nameKey, string2);
            int n = attributes.getLength();
            for (int i = 0; i < n; ++i) {
                String string3 = attributes.getLocalName(i);
                String string4 = attributes.getValue(i);
                if (string3 == null || string3.length() <= 0 || string4 == null || string4.length() <= 0) continue;
                this.properties.put(string3, string4);
            }
        }

        public void readChildren(String string, Attributes attributes) throws SAXException {
            String string2 = string + "." + attributes.getValue("name");
            this.properties.put(string2, attributes.getValue("value"));
        }

        public void endNode(String string) throws SAXException {
            String string2 = this.properties.get(this.nameKey);
            this.resourceData.put(string2, this.properties);
        }

        public List<String> getResourceNames() {
            return new ArrayList<String>(this.resourceData.keySet());
        }

        public Map<String, Map<String, String>> getResourceData() {
            return Collections.unmodifiableMap(this.resourceData);
        }
    }

    public static final class AddResourcesCommand
    extends ServerCommand {
        public AddResourcesCommand(String string) {
            super("add-resources");
            this.query = "xml_file_name=" + string;
        }
    }
}

