/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.javaee.ide;

import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.enterprise.deploy.spi.status.ProgressEvent;
import javax.enterprise.deploy.spi.status.ProgressListener;
import org.netbeans.api.server.ServerInstance;
import org.netbeans.modules.glassfish.javaee.ide.Hk2TargetModuleID;
import org.netbeans.modules.glassfish.javaee.ide.MonitorProgressObject;
import org.netbeans.modules.glassfish.spi.GlassfishModule;
import org.netbeans.modules.glassfish.spi.ServerCommand;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;

public class UpdateContextRoot
implements ProgressListener {
    private MonitorProgressObject returnProgress;
    private Hk2TargetModuleID moduleId;
    private ServerInstance si;
    private boolean needToDo;

    public UpdateContextRoot(MonitorProgressObject monitorProgressObject, Hk2TargetModuleID hk2TargetModuleID, ServerInstance serverInstance, boolean bl) {
        this.returnProgress = monitorProgressObject;
        this.moduleId = hk2TargetModuleID;
        this.si = serverInstance;
        this.needToDo = bl;
    }

    public void handleProgressEvent(ProgressEvent progressEvent) {
        if (progressEvent.getDeploymentStatus().isCompleted()) {
            if (this.needToDo) {
                this.returnProgress.operationStateChanged(GlassfishModule.OperationState.RUNNING, progressEvent.getDeploymentStatus().getMessage());
                RequestProcessor.getDefault().post(new Runnable(){

                    public void run() {
                        ServerCommand.GetPropertyCommand getPropertyCommand = new ServerCommand.GetPropertyCommand("applications.application.*.context-root");
                        Future future = ((GlassfishModule)UpdateContextRoot.this.si.getBasicNode().getLookup().lookup(GlassfishModule.class)).execute((ServerCommand)getPropertyCommand);
                        try {
                            if (future.get(60L, TimeUnit.SECONDS) == GlassfishModule.OperationState.COMPLETED) {
                                Map map = getPropertyCommand.getData();
                                String string = (String)map.get("applications.application." + UpdateContextRoot.this.moduleId.getModuleID() + ".context-root");
                                if (null != string) {
                                    UpdateContextRoot.this.moduleId.setPath(string);
                                    UpdateContextRoot.this.returnProgress.operationStateChanged(GlassfishModule.OperationState.COMPLETED, "updated the moduleid");
                                    return;
                                }
                                UpdateContextRoot.this.returnProgress.operationStateChanged(GlassfishModule.OperationState.COMPLETED, "no moduleid update necessary");
                            } else {
                                UpdateContextRoot.this.returnProgress.operationStateChanged(GlassfishModule.OperationState.COMPLETED, "no moduleid update necessary");
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            UpdateContextRoot.this.returnProgress.operationStateChanged(GlassfishModule.OperationState.FAILED, "failed updating the moduleid..");
                            Exceptions.printStackTrace((Throwable)interruptedException);
                        }
                        catch (ExecutionException executionException) {
                            UpdateContextRoot.this.returnProgress.operationStateChanged(GlassfishModule.OperationState.FAILED, "failed updating the moduleid...");
                            Exceptions.printStackTrace((Throwable)executionException);
                        }
                        catch (TimeoutException timeoutException) {
                            UpdateContextRoot.this.returnProgress.operationStateChanged(GlassfishModule.OperationState.FAILED, "failed updating the moduleid....");
                            Exceptions.printStackTrace((Throwable)timeoutException);
                        }
                    }
                });
            } else {
                this.returnProgress.operationStateChanged(GlassfishModule.OperationState.COMPLETED, progressEvent.getDeploymentStatus().getMessage());
            }
        } else if (progressEvent.getDeploymentStatus().isFailed()) {
            this.returnProgress.operationStateChanged(GlassfishModule.OperationState.FAILED, progressEvent.getDeploymentStatus().getMessage());
        } else {
            this.returnProgress.operationStateChanged(GlassfishModule.OperationState.RUNNING, progressEvent.getDeploymentStatus().getMessage());
        }
    }
}

