/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.saas.codegen.php;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.websvc.saas.codegen.Constants;
import org.netbeans.modules.websvc.saas.codegen.SaasClientCodeGenerator;
import org.netbeans.modules.websvc.saas.codegen.model.ParameterInfo;
import org.netbeans.modules.websvc.saas.codegen.model.RestClientSaasBean;
import org.netbeans.modules.websvc.saas.codegen.model.SaasBean;
import org.netbeans.modules.websvc.saas.codegen.php.SaasClientPhpAuthenticationGenerator;
import org.netbeans.modules.websvc.saas.codegen.php.util.PhpUtil;
import org.netbeans.modules.websvc.saas.codegen.util.Util;
import org.netbeans.modules.websvc.saas.model.SaasMethod;
import org.netbeans.modules.websvc.saas.model.WadlSaasMethod;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RestClientPhpCodeGenerator
extends SaasClientCodeGenerator {
    public static final String INDENT = "             ";
    private FileObject saasServiceFile = null;
    private FileObject serviceFolder = null;
    private FileObject saasFolder = null;
    private SaasClientPhpAuthenticationGenerator authGen;

    public RestClientPhpCodeGenerator() {
        this.setDropFileType(Constants.DropFileType.PHP);
    }

    public boolean canAccept(SaasMethod saasMethod, Document document) {
        return SaasBean.canAccept((SaasMethod)saasMethod, WadlSaasMethod.class, (Constants.DropFileType)this.getDropFileType()) && PhpUtil.isPhp(document);
    }

    public void init(SaasMethod saasMethod, Document document) throws IOException {
        super.init(saasMethod, document);
        this.setBean((SaasBean)new RestClientSaasBean((WadlSaasMethod)saasMethod, true));
        this.serviceFolder = null;
        this.saasFolder = null;
        this.authGen = new SaasClientPhpAuthenticationGenerator((SaasBean)this.getBean(), this.getProject());
        this.authGen.setLoginArguments(this.getLoginArguments());
        this.authGen.setAuthenticatorMethodParameters(this.getAuthenticatorMethodParameters());
        this.authGen.setSaasServiceFolder(this.getSaasServiceFolder());
        this.getBean();
        this.authGen.setAuthenticationProfile(RestClientSaasBean.getProfile((SaasMethod)saasMethod, (Constants.DropFileType)this.getDropFileType()));
        this.authGen.setDropFileType(this.getDropFileType());
    }

    public RestClientSaasBean getBean() {
        return (RestClientSaasBean)super.getBean();
    }

    public SaasClientPhpAuthenticationGenerator getAuthenticationGenerator() {
        return this.authGen;
    }

    public FileObject getSaasServiceFolder() throws IOException {
        if (this.serviceFolder == null) {
            FileObject fileObject = this.getSourceRootFolder();
            String string = this.getBean().getSaasServicePackageName().replace(".", "_");
            this.serviceFolder = fileObject.getFileObject(string);
            if (this.serviceFolder == null) {
                this.serviceFolder = FileUtil.createFolder((FileObject)fileObject, (String)string);
            }
        }
        return this.serviceFolder;
    }

    public FileObject getSaasFolder() throws IOException {
        if (this.saasFolder == null) {
            FileObject fileObject = this.getSourceRootFolder();
            String string = "org.netbeans.saas".replace(".", "_");
            this.saasFolder = fileObject.getFileObject(string);
            if (this.saasFolder == null) {
                this.saasFolder = FileUtil.createFolder((FileObject)fileObject, (String)string);
            }
        }
        return this.saasFolder;
    }

    private FileObject getSourceRootFolder() {
        Sources sources = ProjectUtils.getSources((Project)this.getProject());
        SourceGroup[] sourceGroupArray = sources.getSourceGroups("PHPSOURCE");
        FileObject fileObject = this.getProject().getProjectDirectory();
        if (sourceGroupArray != null && sourceGroupArray.length > 0 && sourceGroupArray[0] != null && sourceGroupArray[0].getRootFolder() != null) {
            fileObject = sourceGroupArray[0].getRootFolder();
        }
        return fileObject;
    }

    public Set<FileObject> generate() throws IOException {
        this.preGenerate();
        this.getAuthenticationGenerator().createAuthenticatorClass();
        this.getAuthenticationGenerator().createAuthorizationClasses();
        this.createSaasServiceClass();
        this.addSaasServiceMethod();
        this.addImportsToSaasService();
        this.getAuthenticationGenerator().modifyAuthenticationClass();
        this.insertSaasServiceAccessCode(this.isInBlock(this.getTargetDocument()));
        this.addImportsToTargetFile();
        this.finishProgressReporting();
        return new HashSet<FileObject>(Collections.emptySet());
    }

    protected void preGenerate() throws IOException {
        super.preGenerate();
        this.createRestConnectionFile(this.getProject());
    }

    protected void createRestConnectionFile(Project project) throws IOException {
        Util.createDataObjectFromTemplate((String)"Templates/SaaSServices/RestConnection.php", (FileObject)this.getSaasFolder(), null);
        Util.createDataObjectFromTemplate((String)"Templates/SaaSServices/RestResponse.php", (FileObject)this.getSaasFolder(), null);
    }

    protected String getServiceMethodBody() throws IOException {
        String string = "";
        string = string + INDENT + this.getFixedParameterDeclaration();
        string = string + this.getAuthenticationGenerator().getPreAuthenticationCode() + "\n";
        string = string + INDENT + this.getTemplateParameterDefinition(this.getBean().getTemplateParameters(), "pathParams", false);
        string = string + INDENT + this.getHeaderOrParameterDefinition(this.getBean().getQueryParameters(), "queryParams", false);
        string = string + "             $conn = new RestConnection(\"" + this.getBean().getUrl() + "\"";
        string = string + ", $pathParams";
        string = string + ", " + (!Util.isPutPostFormParams((RestClientSaasBean)this.getBean()) ? "$queryParams" : "array()");
        string = string + ");\n";
        string = string + INDENT + this.getAuthenticationGenerator().getPostAuthenticationCode() + "\n";
        Constants.HttpMethodType httpMethodType = this.getBean().getHttpMethod();
        if (this.getBean().getHeaderParameters() != null && this.getBean().getHeaderParameters().size() > 0) {
            string = string + "        " + this.getHeaderOrParameterDefinition(this.getBean().getHeaderParameters(), "headerParams", false, httpMethodType);
            string = string + "             $conn->setHeaders($headerParams);\n";
        }
        string = string + "             sleep(1);\n";
        string = string + "             return $conn->" + httpMethodType.prefix() + "(";
        if (httpMethodType == Constants.HttpMethodType.PUT || httpMethodType == Constants.HttpMethodType.POST) {
            string = Util.isPutPostFormParams((RestClientSaasBean)this.getBean()) ? string + "$queryParams" : (Util.hasInputRepresentations((RestClientSaasBean)this.getBean()) ? string + "$content" : string + "null");
        }
        string = string + ");\n";
        return string;
    }

    protected String getFixedParameterDeclaration() {
        String string = "";
        List list = this.getBean().getInputParameters();
        List list2 = null;
        Constants.SaasAuthenticationType saasAuthenticationType = this.getBean().getAuthenticationType();
        if (saasAuthenticationType == Constants.SaasAuthenticationType.SESSION_KEY) {
            SaasBean.SessionKeyAuthentication sessionKeyAuthentication = (SaasBean.SessionKeyAuthentication)this.getBean().getAuthentication();
            list2 = sessionKeyAuthentication.getParameters();
        } else {
            list2 = Collections.emptyList();
        }
        for (ParameterInfo parameterInfo : this.getBean().getInputParameters()) {
            if (!parameterInfo.isFixed() || Util.isContains((ParameterInfo)parameterInfo, (List)list2)) continue;
            string = string + "     $" + this.getVariableName(parameterInfo.getName()) + " = \"" + PhpUtil.findParamValue(parameterInfo) + "\";\n";
        }
        return string;
    }

    protected List<ParameterInfo> getServiceMethodParameters() {
        List list = this.getBean().filterParametersByAuth(this.getBean().filterParameters(new ParameterInfo.ParamFilter[]{ParameterInfo.ParamFilter.FIXED}));
        Constants.HttpMethodType httpMethodType = this.getBean().getHttpMethod();
        if (httpMethodType == Constants.HttpMethodType.PUT || httpMethodType == Constants.HttpMethodType.POST) {
            ParameterInfo parameterInfo = Util.findParameter((List)this.getBean().getInputParameters(), (String)"Content-Type");
            Class clazz = InputStream.class;
            if (parameterInfo != null) {
                if (!parameterInfo.isFixed() && !list.contains(parameterInfo)) {
                    list.add(parameterInfo);
                } else {
                    String string = PhpUtil.findParamValue(parameterInfo);
                    if (string.equals("text/plain") || string.equals("application/xml") || string.equals("text/xml")) {
                        clazz = String.class;
                    }
                }
                this.getBean();
                if (!RestClientSaasBean.findInputRepresentations((WadlSaasMethod)this.getBean().getMethod()).isEmpty()) {
                    list.add(new ParameterInfo("content", clazz));
                }
            }
        }
        return list;
    }

    protected List<ParameterInfo> getAuthenticatorMethodParameters() {
        return Collections.emptyList();
    }

    protected String getLoginArguments() {
        return "";
    }

    protected void addImportsToTargetFile() throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(this.getBean().getSaasServicePackageName() + "->" + this.getBean().getSaasServiceName());
        arrayList.add("org.netbeans.saas->RestResponse");
        this.addImportsToPhp(this.getTargetFile(), arrayList);
    }

    protected void addImportsToSaasService() throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("org.netbeans.saas->RestConnection");
        arrayList.add("org.netbeans.saas->RestResponse");
        this.addImportsToPhp(this.saasServiceFile, arrayList);
    }

    protected void insertSaasServiceAccessCode(boolean bl) throws IOException {
        try {
            String string = "\ninclude_once \"" + this.getSaasServiceFolder().getName() + "/" + this.getBean().getSaasServiceName() + ".php\";\n";
            String string2 = PhpUtil.wrapWithTag(string + this.getCustomMethodBody(), this.getTargetDocument(), this.getStartPosition()) + "\n";
            this.insert(string2, true);
        }
        catch (BadLocationException badLocationException) {
            throw new IOException(badLocationException.getMessage());
        }
    }

    public void createSaasServiceClass() throws IOException {
        DataObject dataObject = Util.createDataObjectFromTemplate((String)(this.getBean().getSaasServiceTemplate() + "." + "php"), (FileObject)this.getSaasServiceFolder(), (String)this.getBean().getSaasServiceName());
        if (dataObject != null) {
            this.saasServiceFile = dataObject.getPrimaryFile();
            try {
                Document document = Util.getDocument((FileObject)this.saasServiceFile);
                this.replaceDocument(document, "__SAAS_FOLDER__", this.getSaasFolder().getName());
                this.replaceDocument(document, "__CONSTRUCT__", "__construct");
            }
            catch (BadLocationException badLocationException) {
                throw new IOException(badLocationException.getMessage());
            }
        }
    }

    protected void addSaasServiceMethod() throws IOException {
        int n;
        String string = "        ";
        List<ParameterInfo> list = this.getServiceMethodParameters();
        String[] stringArray = this.getGetParamNames(list);
        Object[] objectArray = this.getGetParamTypes(list);
        String string2 = RestClientPhpCodeGenerator.getHeaderOrParameterUsage(list);
        if (this.isContainsMethod(this.saasServiceFile, this.getBean().getSaasServiceMethodName(), stringArray, objectArray)) {
            return;
        }
        String string3 = "RestResponse";
        String string4 = "{ \n" + this.getServiceMethodBody() + "\n" + string + "}";
        String string5 = "\n";
        String[] object = stringArray;
        int document = object.length;
        for (n = 0; n < document; ++n) {
            String n2 = object[n];
            string5 = string5 + string + "@param $PARAM$ resource URI parameter\n".replace("$PARAM$", n2);
        }
        string5 = string5 + string + "@return an instance of " + string3;
        string5 = "/*" + string5 + "*/";
        String string6 = "\n" + string + string5 + "\n" + string + "public static function " + this.getBean().getSaasServiceMethodName() + "(" + string2 + ")" + string4 + "\n";
        try {
            Document badLocationException = Util.getDocument((FileObject)this.saasServiceFile);
            int n2 = n = PhpUtil.findText(badLocationException, "}", false);
            this.insert(string6, n, n2, badLocationException, true);
        }
        catch (BadLocationException badLocationException) {
            throw new IOException(badLocationException.getMessage());
        }
    }

    public ParameterInfo findParameter(String string) {
        List list = this.getBean().getInputParameters();
        if (list != null) {
            for (ParameterInfo parameterInfo : list) {
                if (!parameterInfo.getName().equals(string)) continue;
                return parameterInfo;
            }
        }
        return null;
    }

    protected String getHeaderOrParameterDeclaration(List<ParameterInfo> list, String string) {
        if (string == null) {
            string = " ";
        }
        String string2 = "";
        for (ParameterInfo parameterInfo : list) {
            String string3 = this.getVariableName(parameterInfo.getName());
            String string4 = PhpUtil.findParamValue(parameterInfo);
            if (parameterInfo.getType() != String.class) {
                string2 = string2 + string + "$" + string3 + " = " + string4 + ";\n";
                continue;
            }
            if (string4 != null) {
                string2 = string2 + string + "$" + string3 + " = \"" + string4 + "\";\n";
                continue;
            }
            string2 = string2 + string + "$" + string3 + " = null;\n";
        }
        return string2;
    }

    protected String getHeaderOrParameterDeclaration(List<ParameterInfo> list) {
        String string = "                 ";
        return this.getHeaderOrParameterDeclaration(list, string);
    }

    private void addImportsToPhp(FileObject fileObject, List<String> list) {
    }

    private String getTemplateParameterDefinition(List<ParameterInfo> list, String string, boolean bl) {
        String string2 = "$" + string + " = array();\n";
        if (this.getBean().getTemplateParameters() != null && this.getBean().getTemplateParameters().size() > 0) {
            StringBuffer stringBuffer = new StringBuffer();
            for (ParameterInfo parameterInfo : list) {
                stringBuffer.append(RestClientPhpCodeGenerator.getHeaderOrParameterDefinitionPart(parameterInfo, string, bl, true));
            }
            string2 = string2 + stringBuffer.toString() + "\n";
        }
        return string2;
    }

    private boolean isContainsMethod(FileObject fileObject, String string, String[] stringArray, Object[] objectArray) throws IOException {
        try {
            return PhpUtil.findText(Util.getDocument((FileObject)fileObject), "public static function " + string, true) != -1;
        }
        catch (BadLocationException badLocationException) {
            throw new IOException(badLocationException.getMessage());
        }
    }

    protected String getCustomMethodBody() throws IOException {
        String string = "";
        String string2 = "";
        List<ParameterInfo> list = this.getServiceMethodParameters();
        string = string + RestClientPhpCodeGenerator.getHeaderOrParameterUsage(list);
        string2 = string2 + this.getHeaderOrParameterDeclaration(list);
        String string3 = "";
        string3 = string3 + "             try {\n";
        string3 = string3 + string2 + "\n";
        string3 = string3 + "             $result = " + this.getBean().getSaasServiceName() + "::" + this.getBean().getSaasServiceMethodName() + "(" + string + ");\n";
        string3 = string3 + "             echo $result->getResponseBody();\n";
        string3 = string3 + "             } catch(Exception $e) {\n";
        string3 = string3 + "                 echo \"Exception occured: \".$e;\n";
        string3 = string3 + "             }\n";
        return string3;
    }

    public static String getHeaderOrParameterUsage(List<ParameterInfo> list) {
        String string = "";
        for (ParameterInfo parameterInfo : list) {
            String string2 = Util.getParameterName((ParameterInfo)parameterInfo, (boolean)true, (boolean)true, (boolean)true);
            string = string + "$" + string2 + ", ";
        }
        if (list.size() > 0) {
            string = string.substring(0, string.length() - 2);
        }
        return string;
    }

    public static String getHeaderOrParameterDefinitionPart(List<ParameterInfo> list, String string, boolean bl) {
        return RestClientPhpCodeGenerator.getHeaderOrParameterDefinitionPart(list, string, bl, false);
    }

    public static String getHeaderOrParameterDefinitionPart(List<ParameterInfo> list, String string, boolean bl, boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer();
        for (ParameterInfo parameterInfo : list) {
            stringBuffer.append(RestClientPhpCodeGenerator.getHeaderOrParameterDefinitionPart(parameterInfo, string, bl || parameterInfo.isApiKey(), bl2));
        }
        return stringBuffer.toString();
    }

    public static String getHeaderOrParameterDefinitionPart(ParameterInfo parameterInfo, String string, boolean bl, boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = Util.getParameterName((ParameterInfo)parameterInfo);
        if (bl2) {
            string2 = "{" + string2 + "}";
        }
        String string3 = null;
        String string4 = INDENT;
        if (bl) {
            string3 = PhpUtil.findParamValue(parameterInfo);
            if (parameterInfo.getType() != String.class) {
                stringBuffer.append(string4 + "$" + string + "[\"" + string2 + "\"] = $" + string3 + ";\n");
            } else if (string3 != null) {
                stringBuffer.append(string4 + "$" + string + "[\"" + string2 + "\"] = $" + string3 + ";\n");
            } else {
                stringBuffer.append(string4 + "$" + string + "[\"" + string2 + "\"] = null;\n");
            }
        } else if (parameterInfo.getType() != String.class) {
            stringBuffer.append(string4 + "$" + string + "[\"" + string2 + "\"] = $" + Util.getVariableName((String)parameterInfo.getName()) + ";\n");
        } else {
            stringBuffer.append(string4 + "$" + string + "[\"" + string2 + "\"] = $" + Util.getVariableName((String)parameterInfo.getName()) + ";\n");
        }
        return stringBuffer.toString();
    }

    public String getHeaderOrParameterDefinition(List<ParameterInfo> list, String string, boolean bl) {
        String string2 = "             $" + string + " = array();\n";
        if (this.getBean().getQueryParameters() != null && this.getBean().getQueryParameters().size() > 0) {
            string2 = string2 + RestClientPhpCodeGenerator.getHeaderOrParameterDefinitionPart(list, string, bl) + "\n";
        }
        return string2;
    }

    public String getHeaderOrParameterDefinition(List<ParameterInfo> list, String string, boolean bl, Constants.HttpMethodType httpMethodType) {
        String string2 = RestClientPhpCodeGenerator.getHeaderOrParameterDefinitionPart(list, string, bl);
        if (!(httpMethodType != Constants.HttpMethodType.PUT && httpMethodType != Constants.HttpMethodType.POST || Util.isContains(list, (ParameterInfo)new ParameterInfo("Content-Type", String.class)))) {
            string2 = string2 + "             $" + string + "[\"" + "Content-Type" + "\"] = $" + Util.getVariableName((String)"Content-Type") + ";\n";
        }
        String string3 = "";
        string3 = string3 + "$" + string + " = array();\n";
        if (this.getBean().getAuthenticationType() == Constants.SaasAuthenticationType.SIGNED_URL) {
            string3 = string3 + "             $headerParams[\"Date\"] =  $date;\n";
        }
        string3 = string3 + string2 + "\n";
        return string3;
    }

    private void replaceDocument(Document document, String string, String string2) throws BadLocationException {
        int n = document.getLength();
        String string3 = document.getText(0, n);
        string3 = string3.replace(string, string2);
        this.insert(string3, 0, n, document, true);
    }
}

