/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.indicators.graph;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.netbeans.modules.dlight.api.storage.DataTableMetadata;
import org.netbeans.modules.dlight.indicators.DetailDescriptor;
import org.netbeans.modules.dlight.indicators.TimeSeriesDescriptor;
import org.netbeans.modules.dlight.indicators.impl.TimeSeriesDescriptorAccessor;
import org.netbeans.modules.dlight.util.ui.DLightUIPrefs;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Legend
extends JPanel {
    private final List<TimeSeriesDescriptor> graphs;
    private final List<DetailDescriptor> details;

    public Legend(List<TimeSeriesDescriptor> list, List<DetailDescriptor> list2) {
        this.graphs = list;
        this.details = list2;
        this.init(null);
    }

    private boolean hasInfoToPaint(TimeSeriesDescriptor timeSeriesDescriptor, Collection<DataTableMetadata.Column> collection) {
        TimeSeriesDescriptorAccessor timeSeriesDescriptorAccessor = TimeSeriesDescriptorAccessor.getDefault();
        if (collection == null || collection.isEmpty() || timeSeriesDescriptorAccessor.getSourceColumns(timeSeriesDescriptor) == null || timeSeriesDescriptorAccessor.getSourceColumns(timeSeriesDescriptor).isEmpty()) {
            return true;
        }
        ArrayList<DataTableMetadata.Column> arrayList = new ArrayList<DataTableMetadata.Column>(collection);
        arrayList.retainAll(timeSeriesDescriptorAccessor.getSourceColumns(timeSeriesDescriptor));
        return !arrayList.isEmpty();
    }

    private void init(Collection<DataTableMetadata.Column> collection) {
        GridBagConstraints gridBagConstraints;
        JLabel jLabel;
        this.removeAll();
        this.setLayout(new GridBagLayout());
        Font font = DLightUIPrefs.getFont((String)"indicator.legend.font");
        this.setBackground(DLightUIPrefs.getColor((String)"indicator.legend.bgcolor"));
        this.setBorder(BorderFactory.createLineBorder(DLightUIPrefs.getColor((String)"indicator.border.color")));
        Dimension dimension = new Dimension(DLightUIPrefs.getInt((String)"indicator.legend.width"), DLightUIPrefs.getInt((String)"indicator.legend.width"));
        this.setSize(dimension);
        this.setMinimumSize(dimension);
        this.setPreferredSize(dimension);
        this.setOpaque(true);
        TimeSeriesDescriptorAccessor timeSeriesDescriptorAccessor = TimeSeriesDescriptorAccessor.getDefault();
        for (TimeSeriesDescriptor object : this.graphs) {
            if (!this.hasInfoToPaint(object, collection)) continue;
            jLabel = new JLabel(timeSeriesDescriptorAccessor.getDisplayName(object), new ColorIcon(font.getSize(), timeSeriesDescriptorAccessor.getColor(object)), 10);
            jLabel.setFont(font);
            jLabel.setForeground(DLightUIPrefs.getColor((String)"indicator.legend.font.color"));
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(4, 4, 0, 4);
            this.add((Component)jLabel, gridBagConstraints);
        }
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add(Box.createVerticalStrut(4), gridBagConstraints);
        if (this.details != null) {
            for (DetailDescriptor detailDescriptor : this.details) {
                jLabel = new JLabel(detailDescriptor.getDisplayName());
                jLabel.setFont(font);
                jLabel.setForeground(DLightUIPrefs.getColor((String)"indicator.legend.font.color"));
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.anchor = 17;
                gridBagConstraints.fill = 2;
                gridBagConstraints.insets = new Insets(0, 4, 4, 4);
                this.add((Component)jLabel, gridBagConstraints);
                JLabel jLabel2 = new JLabel(detailDescriptor.getDefaultValue());
                jLabel2.setName(detailDescriptor.getName());
                jLabel2.setForeground(DLightUIPrefs.getColor((String)"indicator.legend.font.color"));
                jLabel2.setFont(font.deriveFont(1));
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.anchor = 17;
                gridBagConstraints.fill = 2;
                gridBagConstraints.gridwidth = 0;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.insets = new Insets(0, 0, 4, 4);
                this.add((Component)jLabel2, gridBagConstraints);
            }
        }
    }

    public void updateDetail(final String string, final String string2) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.updateDetailImpl(string, string2);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    Legend.this.updateDetailImpl(string, string2);
                }
            });
        }
    }

    public final void updateWithInfoProvided(Collection<DataTableMetadata.Column> collection) {
        this.init(collection);
        this.repaint();
    }

    private void updateDetailImpl(String string, String string2) {
        for (int i = 0; i < this.getComponentCount(); ++i) {
            Component component = this.getComponent(i);
            if (!(component instanceof JLabel) || !string.equals(component.getName())) continue;
            ((JLabel)component).setText(string2);
            this.repaint();
            break;
        }
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        if (this.isEnabled()) {
            super.paintComponent(graphics);
        } else {
            graphics.setColor(DLightUIPrefs.getColor((String)"indicator.legend.bgcolor"));
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
    }

    @Override
    protected void paintChildren(Graphics graphics) {
        if (this.isEnabled()) {
            super.paintChildren(graphics);
        }
    }

    private static class ColorIcon
    implements Icon {
        private final int size;
        private final Color color;

        public ColorIcon(int n, Color color) {
            this.size = n;
            this.color = color;
        }

        public int getIconWidth() {
            return this.size;
        }

        public int getIconHeight() {
            return this.size;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            graphics.setColor(this.color);
            graphics.fillRect(n, n2, this.size - 1, this.size - 1);
            graphics.setColor(DLightUIPrefs.getColor((String)"indicator.border.color"));
            graphics.drawRect(n, n2, this.size - 1, this.size - 1);
        }
    }
}

