/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.indicators.impl;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.netbeans.modules.dlight.api.indicator.IndicatorConfiguration;
import org.netbeans.modules.dlight.api.indicator.IndicatorMetadata;
import org.netbeans.modules.dlight.api.storage.DataRow;
import org.netbeans.modules.dlight.api.storage.DataTableMetadata;
import org.netbeans.modules.dlight.indicators.BarIndicatorConfiguration;
import org.netbeans.modules.dlight.spi.indicator.Indicator;
import org.openide.util.Lookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BarIndicator
extends Indicator<BarIndicatorConfiguration> {
    private final NumberFormat nf = NumberFormat.getNumberInstance();
    private BarIndicatorPanel panel;
    private Number[] barData;
    private int count = 0;
    private final BarIndicatorConfiguration configuration;

    public BarIndicator(BarIndicatorConfiguration barIndicatorConfiguration) {
        super((IndicatorConfiguration)barIndicatorConfiguration);
        this.configuration = barIndicatorConfiguration;
        for (DataTableMetadata.Column column : this.getMetadata().getColumns()) {
            if (column.getColumnClass().getSuperclass() == Number.class) continue;
            throw new IllegalArgumentException("BarIndicator could be based on Number data only!");
        }
        this.nf.setMinimumFractionDigits(2);
        this.nf.setMaximumFractionDigits(2);
        this.panel = new BarIndicatorPanel(this.getMetadata());
        this.barData = new Number[this.getMetadata().getColumnsCount()];
    }

    public JComponent getComponent() {
        return this.panel;
    }

    public void updated(List<DataRow> list) {
        if (list.isEmpty()) {
            return;
        }
        int n = this.count + list.size();
        DataRow dataRow = list.get(list.size() - 1);
        int n2 = 0;
        for (DataTableMetadata.Column column : this.getMetadataColumns()) {
            String string = dataRow.getStringValue(column.getColumnName());
            this.barData[n2] = this.count == 0 ? Double.valueOf(string) : Double.valueOf(string);
            ++n2;
        }
        this.count = n;
        this.panel.update();
    }

    protected void tick() {
    }

    protected void repairNeeded(boolean bl) {
    }

    public void reset() {
    }

    public void setIndicatorActionsProviderContext(Lookup lookup) {
    }

    private class BarIndicatorPanel
    extends JPanel {
        List<JLabel> barLabels = new ArrayList<JLabel>();

        public BarIndicatorPanel(IndicatorMetadata indicatorMetadata) {
            this.setLayout(new GridBagLayout());
            int n = 0;
            for (DataTableMetadata.Column column : indicatorMetadata.getColumns()) {
                JLabel jLabel = new JLabel(column.getColumnUName() + ": ");
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = n;
                gridBagConstraints.insets = new Insets(2, 2, 2, 2);
                this.add((Component)jLabel, gridBagConstraints);
                JLabel jLabel2 = new JLabel("--");
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 1;
                gridBagConstraints.gridy = n++;
                gridBagConstraints.insets = new Insets(2, 2, 2, 2);
                this.add((Component)jLabel2, gridBagConstraints);
                this.barLabels.add(jLabel2);
            }
        }

        private void update() {
            int n = 0;
            for (JLabel jLabel : this.barLabels) {
                jLabel.setText(BarIndicator.this.nf.format(BarIndicator.this.barData[n++]));
            }
        }
    }
}

