/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.attach.providers;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.platform.Specification;
import org.netbeans.modules.profiler.attach.providers.TargetPlatformEnum;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.modules.SpecificationVersion;

public class TargetPlatform {
    private static List supportedPlatforms = null;
    private SpecificationVersion version;
    private String displayName;
    private String javaHome;
    private boolean defaultFlag;
    private boolean validFlag;

    public TargetPlatform(JavaPlatform javaPlatform) {
        this(javaPlatform, false);
    }

    public TargetPlatform(JavaPlatform javaPlatform, boolean bl) {
        this.defaultFlag = bl;
        try {
            this.displayName = javaPlatform.getDisplayName();
            this.version = javaPlatform.getSpecification().getVersion();
            FileObject fileObject = (FileObject)javaPlatform.getInstallFolders().iterator().next();
            String string = System.getProperty("os.name");
            this.javaHome = URLDecoder.decode(fileObject.getURL().getPath(), "utf8");
            if (this.javaHome.endsWith("/")) {
                this.javaHome = this.javaHome.substring(0, this.javaHome.length() - 1);
            }
            if (string.contains("Windows") && this.javaHome.startsWith("/")) {
                this.javaHome = this.javaHome.substring(1).replace('/', '\\');
            }
            this.validFlag = true;
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            this.validFlag = false;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.validFlag = false;
        }
        catch (Exception exception) {
            this.validFlag = false;
        }
    }

    public static final List getPlatformList(boolean bl) {
        List list = TargetPlatform.getSupportedPlatforms(bl);
        return list;
    }

    public static final List getPlatformList(TargetPlatformFilter targetPlatformFilter, boolean bl) {
        List list = TargetPlatform.getSupportedPlatforms(bl);
        Vector<TargetPlatform> vector = new Vector<TargetPlatform>();
        for (TargetPlatform targetPlatform : list) {
            if (!targetPlatformFilter.isSupported(targetPlatform)) continue;
            vector.add(targetPlatform);
        }
        return vector;
    }

    public static void refresh() {
        TargetPlatform.getSupportedPlatforms(false);
    }

    public TargetPlatformEnum getAsEnum() {
        if (this.version.toString().startsWith("1.5") || this.version.toString().startsWith("5")) {
            return TargetPlatformEnum.JDK5;
        }
        if (this.version.toString().startsWith("1.6") || this.version.toString().startsWith("6")) {
            return TargetPlatformEnum.JDK6;
        }
        if (this.version.toString().startsWith("1.7") || this.version.toString().startsWith("7")) {
            return TargetPlatformEnum.JDK7;
        }
        return TargetPlatformEnum.JDK5;
    }

    public boolean isDefault() {
        return this.defaultFlag;
    }

    public String getHomePath() {
        return this.javaHome;
    }

    public String getName() {
        return this.getAsEnum().toString();
    }

    public boolean isValid() {
        return this.validFlag;
    }

    public boolean equals(Object object) {
        if (this.getHomePath() == null || object == null) {
            return false;
        }
        if (object instanceof String) {
            return this.getHomePath().equals(object) || this.toString().equals(object);
        }
        if (!(object instanceof TargetPlatform)) {
            return false;
        }
        return this.getHomePath().equals(((TargetPlatform)object).getHomePath());
    }

    public int hashCode() {
        return this.getHomePath().hashCode();
    }

    public String toString() {
        return this.displayName;
    }

    private static List getSupportedPlatforms(boolean bl) {
        if (supportedPlatforms == null || !bl) {
            JavaPlatform[] javaPlatformArray;
            supportedPlatforms = new LinkedList();
            try {
                javaPlatformArray = JavaPlatformManager.getDefault().getDefaultPlatform();
                if (javaPlatformArray != null) {
                    supportedPlatforms.add(new TargetPlatform((JavaPlatform)javaPlatformArray, true));
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            javaPlatformArray = JavaPlatformManager.getDefault().getPlatforms(null, new Specification("j2se", null));
            for (int i = 0; i < javaPlatformArray.length; ++i) {
                TargetPlatform targetPlatform = new TargetPlatform(javaPlatformArray[i]);
                if (!targetPlatform.isValid() || supportedPlatforms.contains(targetPlatform)) continue;
                supportedPlatforms.add(targetPlatform);
            }
        }
        return supportedPlatforms;
    }

    public static interface TargetPlatformFilter {
        public boolean isSupported(TargetPlatform var1);
    }
}

