/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.lexer;

import org.netbeans.api.lexer.PartType;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.cnd.api.lexer.CndLexerUtilities;
import org.netbeans.cnd.api.lexer.Filter;
import org.netbeans.cnd.api.lexer.FortranTokenId;
import org.netbeans.spi.lexer.Lexer;
import org.netbeans.spi.lexer.LexerInput;
import org.netbeans.spi.lexer.LexerRestartInfo;
import org.netbeans.spi.lexer.TokenFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FortranLexer
implements Lexer<FortranTokenId> {
    protected static final int EOF = -1;
    private final LexerInput input;
    private final TokenFactory<FortranTokenId> tokenFactory;
    private boolean fortranFreeFormat = true;
    private int maximumTextWidth = 132;
    private final Filter<FortranTokenId> lexerFilter;
    private static final int INIT = -1;
    private static final int AFTER_SLASH = 1;
    private static final int AFTER_EQ = 2;
    private static final int AFTER_STAR = 3;
    private static final int AFTER_LESSTHAN = 4;
    private static final int AFTER_GREATERTHAN = 5;
    private static final int AFTER_B = 6;
    private static final int AFTER_O = 7;
    private static final int AFTER_Z = 8;
    private static final int AFTER_DOT = 9;
    private static final int IN_STRING = 10;
    private static final int IN_STRING_AFTER_BSLASH = 11;
    private static final int IN_LINE_COMMENT = 12;
    private static final int IN_IDENTIFIER = 13;
    private static final int IN_DOT_IDENTIFIER = 14;
    private static final int IN_WHITESPACE = 15;
    private static final int IN_INT = 16;
    private static final int IN_BINARY = 17;
    private static final int IN_OCTAL = 18;
    private static final int IN_HEX = 19;
    private static final int IN_REAL = 20;
    private static final int IN_APOSTROPHE_CHAR = 21;
    private boolean stringInDoubleQuote = true;
    private boolean lineCommentFree = true;
    private boolean hasNumericUnderscore = false;
    private int state = -1;
    private int lineColomn = 0;

    public FortranLexer(Filter<FortranTokenId> filter, LexerRestartInfo<FortranTokenId> lexerRestartInfo) {
        this.input = lexerRestartInfo.input();
        this.tokenFactory = lexerRestartInfo.tokenFactory();
        Filter<FortranTokenId> filter2 = (Filter<FortranTokenId>)lexerRestartInfo.getAttributeValue((Object)"lexer-filter");
        this.lexerFilter = filter2 != null ? filter2 : filter;
        Object object = lexerRestartInfo.getAttributeValue((Object)"fortran-maximum-text-width");
        if (object != null) {
            this.maximumTextWidth = (Integer)object;
        }
        if ((object = lexerRestartInfo.getAttributeValue((Object)"fortran-free-format")) != null) {
            this.fortranFreeFormat = (Boolean)object;
        }
        this.setState((State)lexerRestartInfo.state());
    }

    public Object state() {
        return this.getState();
    }

    public void release() {
    }

    public Token<FortranTokenId> nextToken() {
        int n;
        while ((n = this.read()) != -1) {
            block0 : switch (this.state) {
                case -1: {
                    int n2;
                    if (this.isLineBeyondLimit()) {
                        this.backup(1);
                        break;
                    }
                    switch (n) {
                        case 35: {
                            return this.finishSharp();
                        }
                        case 10: {
                            this.lineColomn = 0;
                            return this.token(FortranTokenId.NEW_LINE);
                        }
                        case 66: 
                        case 98: {
                            this.state = 6;
                            break block0;
                        }
                        case 79: 
                        case 111: {
                            this.state = 7;
                            break block0;
                        }
                        case 90: 
                        case 122: {
                            this.state = 8;
                            break block0;
                        }
                        case 34: {
                            this.state = 10;
                            this.stringInDoubleQuote = true;
                            break block0;
                        }
                        case 39: {
                            this.state = 10;
                            this.stringInDoubleQuote = false;
                            break block0;
                        }
                        case 47: {
                            this.state = 1;
                            break block0;
                        }
                        case 61: {
                            this.state = 2;
                            break block0;
                        }
                        case 43: {
                            return this.token(FortranTokenId.OP_PLUS);
                        }
                        case 45: {
                            return this.token(FortranTokenId.OP_MINUS);
                        }
                        case 42: {
                            this.state = 3;
                            break block0;
                        }
                        case 33: {
                            this.lineCommentFree = true;
                            this.state = 12;
                            break block0;
                        }
                        case 67: 
                        case 99: {
                            if (this.lineColomn == 1 && !this.fortranFreeFormat) {
                                this.lineCommentFree = false;
                                this.state = 12;
                                break block0;
                            }
                            this.backup(1);
                            this.state = 13;
                            break block0;
                        }
                        case 60: {
                            this.state = 4;
                            break block0;
                        }
                        case 62: {
                            this.state = 5;
                            break block0;
                        }
                        case 46: {
                            this.state = 9;
                            break block0;
                        }
                        case 44: {
                            return this.token(FortranTokenId.COMMA);
                        }
                        case 58: {
                            n2 = this.read();
                            if (n2 == 58) {
                                return this.token(FortranTokenId.DOUBLECOLON);
                            }
                            this.backup(1);
                            return this.token(FortranTokenId.COLON);
                        }
                        case 37: {
                            return this.token(FortranTokenId.PERCENT);
                        }
                        case 38: {
                            return this.token(FortranTokenId.AMPERSAND);
                        }
                        case 40: {
                            return this.token(FortranTokenId.LPAREN);
                        }
                        case 41: {
                            return this.token(FortranTokenId.RPAREN);
                        }
                        case 59: {
                            return this.token(FortranTokenId.SEMICOLON);
                        }
                        case 63: {
                            return this.token(FortranTokenId.QUESTION_MARK);
                        }
                        case 36: {
                            return this.token(FortranTokenId.CURRENCY);
                        }
                    }
                    if (Character.isWhitespace(n)) {
                        this.state = 15;
                        break;
                    }
                    if (Character.isDigit(n)) {
                        this.state = 16;
                        break;
                    }
                    if (CndLexerUtilities.isFortranIdentifierPart(n)) {
                        this.state = 13;
                        this.backup(1);
                        break;
                    }
                    return this.token(FortranTokenId.ERR_INVALID_CHAR);
                }
                case 15: {
                    if (this.isLineBeyondLimit()) {
                        this.backup(1);
                        return this.token(FortranTokenId.WHITESPACE);
                    }
                    if (Character.isWhitespace(n) && n != 10) break;
                    this.state = -1;
                    this.backup(1);
                    return this.token(FortranTokenId.WHITESPACE);
                }
                case 6: {
                    int n2;
                    if (this.isLineBeyondLimit()) {
                        this.backup(1);
                        return this.token(FortranTokenId.IDENTIFIER);
                    }
                    switch (n) {
                        case 34: 
                        case 39: {
                            n2 = this.read();
                            if (!Character.isDigit(n2)) break;
                            this.state = 17;
                            this.backup(1);
                            break block0;
                        }
                    }
                    this.state = 13;
                    this.backup(2);
                    break;
                }
                case 7: {
                    int n2;
                    if (this.isLineBeyondLimit()) {
                        this.backup(1);
                        return this.token(FortranTokenId.IDENTIFIER);
                    }
                    switch (n) {
                        case 34: 
                        case 39: {
                            n2 = this.read();
                            if (!Character.isDigit(n2)) break;
                            this.state = 18;
                            this.backup(1);
                            break block0;
                        }
                    }
                    this.state = 13;
                    this.backup(2);
                    break;
                }
                case 8: {
                    int n2;
                    if (this.isLineBeyondLimit()) {
                        this.backup(1);
                        return this.token(FortranTokenId.IDENTIFIER);
                    }
                    switch (n) {
                        case 34: 
                        case 39: {
                            n2 = this.read();
                            if (!Character.isLetterOrDigit(n2)) break;
                            this.state = 19;
                            this.backup(1);
                            break block0;
                        }
                    }
                    this.state = 13;
                    this.backup(2);
                    break;
                }
                case 12: {
                    switch (n) {
                        case 10: {
                            this.state = -1;
                            if (this.input.readLength() > 1) {
                                this.backup(1);
                                if (this.lineCommentFree) {
                                    return this.token(FortranTokenId.LINE_COMMENT_FREE);
                                }
                                return this.token(FortranTokenId.LINE_COMMENT_FIXED);
                            }
                            this.lineColomn = 0;
                            return this.token(FortranTokenId.NEW_LINE);
                        }
                    }
                    break;
                }
                case 10: {
                    if (this.isLineBeyondLimit()) {
                        this.backup(1);
                        return this.token(FortranTokenId.ERR_INCOMPLETE_STRING_LITERAL);
                    }
                    switch (n) {
                        case 92: {
                            this.state = 11;
                            break block0;
                        }
                        case 10: {
                            this.state = -1;
                            this.backup(1);
                            return this.token(FortranTokenId.STRING_LITERAL);
                        }
                        case 34: {
                            if (!this.stringInDoubleQuote) break;
                            this.state = -1;
                            return this.token(FortranTokenId.STRING_LITERAL);
                        }
                        case 39: {
                            if (this.stringInDoubleQuote) break;
                            this.state = -1;
                            return this.token(FortranTokenId.STRING_LITERAL);
                        }
                    }
                    break;
                }
                case 11: {
                    if (this.isLineBeyondLimit()) {
                        this.backup(1);
                        return this.token(FortranTokenId.ERR_INCOMPLETE_STRING_LITERAL);
                    }
                    switch (n) {
                        case 34: 
                        case 39: 
                        case 92: {
                            break;
                        }
                        default: {
                            this.backup(1);
                        }
                    }
                    this.state = 10;
                    break;
                }
                case 1: {
                    if (this.isLineBeyondLimit()) {
                        this.backup(1);
                        return this.token(FortranTokenId.OP_DIV);
                    }
                    switch (n) {
                        case 47: {
                            this.state = -1;
                            return this.token(FortranTokenId.OP_CONCAT);
                        }
                        case 61: {
                            this.state = -1;
                            return this.token(FortranTokenId.OP_NOT_EQ);
                        }
                    }
                    this.state = -1;
                    this.backup(1);
                    return this.token(FortranTokenId.OP_DIV);
                }
                case 2: {
                    if (this.isLineBeyondLimit()) {
                        this.backup(1);
                        return this.token(FortranTokenId.EQ);
                    }
                    switch (n) {
                        case 61: {
                            this.state = -1;
                            return this.token(FortranTokenId.OP_LOG_EQ);
                        }
                    }
                    this.state = -1;
                    this.backup(1);
                    return this.token(FortranTokenId.EQ);
                }
                case 3: {
                    if (this.isLineBeyondLimit()) {
                        this.backup(1);
                        return this.token(FortranTokenId.OP_MUL);
                    }
                    switch (n) {
                        case 42: {
                            this.state = -1;
                            return this.token(FortranTokenId.OP_POWER);
                        }
                    }
                    this.state = -1;
                    this.backup(1);
                    return this.token(FortranTokenId.OP_MUL);
                }
                case 4: {
                    if (this.isLineBeyondLimit()) {
                        this.backup(1);
                        return this.token(FortranTokenId.OP_LT);
                    }
                    switch (n) {
                        case 61: {
                            this.state = -1;
                            return this.token(FortranTokenId.OP_LT_EQ);
                        }
                        case 62: {
                            this.state = -1;
                            return this.token(FortranTokenId.OP_LT_GT);
                        }
                    }
                    this.state = -1;
                    this.backup(1);
                    return this.token(FortranTokenId.OP_LT);
                }
                case 5: {
                    if (this.isLineBeyondLimit()) {
                        this.backup(1);
                        return this.token(FortranTokenId.OP_GT);
                    }
                    switch (n) {
                        case 61: {
                            this.state = -1;
                            return this.token(FortranTokenId.OP_GT_EQ);
                        }
                    }
                    this.state = -1;
                    this.backup(1);
                    return this.token(FortranTokenId.OP_GT);
                }
                case 13: {
                    Token<FortranTokenId> token = this.keywordOrIdentifier(n);
                    this.state = -1;
                    n = this.read();
                    this.backup(1);
                    if (n == 39) {
                        this.state = 21;
                    }
                    return token;
                }
                case 17: {
                    if (this.isLineBeyondLimit()) {
                        this.backup(1);
                        return this.token(FortranTokenId.ERR_INVALID_BINARY_LITERAL);
                    }
                    if (n == 39 || n == 34) {
                        this.state = -1;
                        return this.token(FortranTokenId.NUM_LITERAL_BINARY);
                    }
                    if ((!Character.isDigit(n) || n <= 49) && Character.isDigit(n)) break;
                    this.state = -1;
                    this.backup(1);
                    return this.token(FortranTokenId.ERR_INVALID_BINARY_LITERAL);
                }
                case 18: {
                    if (this.isLineBeyondLimit()) {
                        this.backup(1);
                        return this.token(FortranTokenId.ERR_INVALID_OCTAL_LITERAL);
                    }
                    if (n == 39 || n == 34) {
                        this.state = -1;
                        return this.token(FortranTokenId.NUM_LITERAL_OCTAL);
                    }
                    if ((!Character.isDigit(n) || n <= 55) && Character.isDigit(n)) break;
                    this.state = -1;
                    this.backup(1);
                    return this.token(FortranTokenId.ERR_INVALID_OCTAL_LITERAL);
                }
                case 19: {
                    if (this.isLineBeyondLimit()) {
                        this.backup(1);
                        return this.token(FortranTokenId.ERR_INVALID_HEX_LITERAL);
                    }
                    if (n == 39 || n == 34) {
                        this.state = -1;
                        return this.token(FortranTokenId.NUM_LITERAL_HEX);
                    }
                    if (Character.isDigit(n) || Character.toLowerCase(n) >= 97 && Character.toLowerCase(n) <= 102) break;
                    this.state = -1;
                    this.backup(1);
                    return this.token(FortranTokenId.ERR_INVALID_HEX_LITERAL);
                }
                case 16: {
                    if (this.isLineBeyondLimit()) {
                        this.backup(1);
                        return this.token(FortranTokenId.NUM_LITERAL_INT);
                    }
                    switch (n) {
                        case 95: {
                            this.hasNumericUnderscore = true;
                            break block0;
                        }
                        case 46: {
                            if (this.hasNumericUnderscore) {
                                this.state = -1;
                                this.hasNumericUnderscore = false;
                                return this.token(FortranTokenId.ERR_INVALID_INTEGER);
                            }
                            this.state = 20;
                            break block0;
                        }
                        case 68: 
                        case 69: 
                        case 100: 
                        case 101: {
                            if (this.hasNumericUnderscore) break block0;
                            this.state = 20;
                            break block0;
                        }
                    }
                    if ((!this.hasNumericUnderscore || Character.isLetterOrDigit(n)) && (this.hasNumericUnderscore || Character.isDigit(n))) break;
                    this.state = -1;
                    this.hasNumericUnderscore = false;
                    this.backup(1);
                    return this.token(FortranTokenId.NUM_LITERAL_INT);
                }
                case 20: {
                    if (this.isLineBeyondLimit()) {
                        this.backup(1);
                        return this.token(FortranTokenId.NUM_LITERAL_REAL);
                    }
                    switch (n) {
                        case 95: {
                            this.hasNumericUnderscore = true;
                            break block0;
                        }
                        case 68: 
                        case 69: 
                        case 100: 
                        case 101: {
                            if (!this.hasNumericUnderscore) break block0;
                        }
                        default: {
                            if ((!this.hasNumericUnderscore || Character.isLetterOrDigit(n)) && (this.hasNumericUnderscore || Character.isDigit(n))) break block0;
                            this.state = -1;
                            this.hasNumericUnderscore = false;
                            this.backup(1);
                            return this.token(FortranTokenId.NUM_LITERAL_REAL);
                        }
                    }
                }
                case 9: {
                    if (this.isLineBeyondLimit()) {
                        this.backup(1);
                        return this.token(FortranTokenId.DOT);
                    }
                    if (Character.isDigit(n)) {
                        this.state = 20;
                        break;
                    }
                    if (CndLexerUtilities.isFortranIdentifierPart(n)) {
                        this.backup(2);
                        this.state = 14;
                        break;
                    }
                    this.state = -1;
                    this.backup(1);
                    return this.token(FortranTokenId.DOT);
                }
                case 14: {
                    this.state = -1;
                    Token<FortranTokenId> token = this.keywordOperator(n);
                    if (token != null) {
                        return token;
                    }
                    return this.token(FortranTokenId.DOT);
                }
                case 21: {
                    this.state = -1;
                    return this.token(FortranTokenId.APOSTROPHE_CHAR);
                }
            }
        }
        if (this.input.readLength() > 0) {
            switch (this.state) {
                case 15: {
                    this.state = -1;
                    return this.token(FortranTokenId.WHITESPACE);
                }
                case 6: 
                case 7: 
                case 8: {
                    this.state = -1;
                    return this.token(FortranTokenId.IDENTIFIER);
                }
                case 17: {
                    this.state = -1;
                    return this.token(FortranTokenId.ERR_INVALID_BINARY_LITERAL);
                }
                case 18: {
                    this.state = -1;
                    return this.token(FortranTokenId.ERR_INVALID_OCTAL_LITERAL);
                }
                case 19: {
                    this.state = -1;
                    return this.token(FortranTokenId.ERR_INVALID_HEX_LITERAL);
                }
                case 10: 
                case 11: {
                    return this.token(FortranTokenId.STRING_LITERAL);
                }
                case 1: {
                    this.state = -1;
                    return this.token(FortranTokenId.OP_DIV);
                }
                case 2: {
                    this.state = -1;
                    return this.token(FortranTokenId.EQ);
                }
                case 3: {
                    this.state = -1;
                    return this.token(FortranTokenId.OP_MUL);
                }
                case 12: {
                    if (this.lineCommentFree) {
                        return this.token(FortranTokenId.LINE_COMMENT_FREE);
                    }
                    return this.token(FortranTokenId.LINE_COMMENT_FIXED);
                }
                case 4: {
                    this.state = -1;
                    return this.token(FortranTokenId.OP_LT);
                }
                case 5: {
                    this.state = -1;
                    return this.token(FortranTokenId.OP_GT);
                }
                case 16: {
                    this.state = -1;
                    return this.token(FortranTokenId.NUM_LITERAL_INT);
                }
                case 20: {
                    this.state = -1;
                    return this.token(FortranTokenId.NUM_LITERAL_REAL);
                }
                case 9: {
                    this.state = -1;
                    return this.token(FortranTokenId.DOT);
                }
            }
        }
        switch (this.state) {
            case 15: {
                return this.token(FortranTokenId.WHITESPACE);
            }
        }
        return null;
    }

    protected final int read() {
        ++this.lineColomn;
        int n = this.input.read();
        return n;
    }

    protected final void backup(int n) {
        this.lineColomn -= n;
        this.input.backup(n);
    }

    private boolean isLineBeyondLimit() {
        if (this.lineColomn > this.maximumTextWidth && this.state != 12) {
            this.lineCommentFree = true;
            this.state = 12;
            return true;
        }
        return false;
    }

    private Token<FortranTokenId> keywordOrIdentifier(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(Character.toLowerCase((char)n));
        while (true) {
            if ((n = this.read()) == -1 || !CndLexerUtilities.isFortranIdentifierPart(n) || this.isLineBeyondLimit()) {
                this.backup(n >= 65536 ? 2 : 1);
                FortranTokenId fortranTokenId = this.getKeywordOrIdentifierID(stringBuilder.toString());
                assert (fortranTokenId != null) : "must be valid id for " + stringBuilder;
                return this.token(fortranTokenId);
            }
            stringBuilder.append(Character.toLowerCase((char)n));
        }
    }

    private Token<FortranTokenId> keywordOperator(int n) {
        int n2 = 0;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(Character.toLowerCase((char)n));
        while (true) {
            n = this.read();
            ++n2;
            if (n == 46) {
                stringBuilder.append(Character.toLowerCase((char)n));
                FortranTokenId fortranTokenId = this.getKeywordOperatorID(stringBuilder.toString());
                if (fortranTokenId != null) {
                    return this.token(fortranTokenId);
                }
                this.backup(n2);
                return null;
            }
            if (n == -1 || !CndLexerUtilities.isFortranIdentifierPart(n) || this.isLineBeyondLimit()) {
                this.backup(n2);
                return null;
            }
            stringBuilder.append(Character.toLowerCase((char)n));
        }
    }

    private FortranTokenId getKeywordOrIdentifierID(CharSequence charSequence) {
        FortranTokenId fortranTokenId = this.lexerFilter.check(charSequence);
        return fortranTokenId != null ? fortranTokenId : FortranTokenId.IDENTIFIER;
    }

    private FortranTokenId getKeywordOperatorID(CharSequence charSequence) {
        return this.lexerFilter.check(charSequence);
    }

    protected Token<FortranTokenId> finishSharp() {
        while (true) {
            switch (this.read()) {
                case 13: {
                    this.input.consumeNewline();
                }
                case -1: 
                case 10: {
                    return this.token(FortranTokenId.PREPROCESSOR_DIRECTIVE);
                }
            }
        }
    }

    protected final Token<FortranTokenId> token(FortranTokenId fortranTokenId) {
        return this.token(fortranTokenId, fortranTokenId.fixedText(), PartType.COMPLETE);
    }

    protected final Token<FortranTokenId> tokenPart(FortranTokenId fortranTokenId, PartType partType) {
        return this.token(fortranTokenId, null, partType);
    }

    private Token<FortranTokenId> token(FortranTokenId fortranTokenId, String string, PartType partType) {
        assert (fortranTokenId != null) : "id must be not null";
        Token token = null;
        token = string != null ? this.tokenFactory.getFlyweightToken((TokenId)fortranTokenId, string) : (partType != PartType.COMPLETE ? this.tokenFactory.createToken((TokenId)fortranTokenId, this.input.readLength(), partType) : this.tokenFactory.createToken((TokenId)fortranTokenId));
        assert (token != null) : "token must be created as result for " + (Object)((Object)fortranTokenId);
        return token;
    }

    private State getState() {
        if (this.state != -1 || this.lineColomn != 0) {
            State state = new State();
            state.lexerState = this.state;
            state.lineColomn = this.lineColomn;
            return state;
        }
        return null;
    }

    private void setState(State state) {
        if (state != null) {
            this.state = state.lexerState;
            this.lineColomn = state.lineColomn;
        } else {
            this.state = -1;
            this.lineColomn = 0;
        }
    }

    private static class State {
        int lexerState;
        int lineColomn;

        private State() {
        }
    }
}

