/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.j2se;

import java.text.MessageFormat;
import java.util.ResourceBundle;
import org.netbeans.lib.profiler.common.AttachSettings;
import org.netbeans.lib.profiler.common.integration.IntegrationUtils;
import org.netbeans.modules.profiler.attach.providers.AbstractIntegrationProvider;
import org.netbeans.modules.profiler.attach.providers.IntegrationCategorizer;
import org.netbeans.modules.profiler.attach.providers.TargetPlatformEnum;
import org.netbeans.modules.profiler.attach.spi.IntegrationProvider;
import org.netbeans.modules.profiler.attach.wizard.steps.NullWizardStep;

public class JavaApplicationIntegrationProvider
extends AbstractIntegrationProvider {
    private static final ResourceBundle messages = ResourceBundle.getBundle("org.netbeans.modules.profiler.j2se.Bundle");
    private static final String MANUAL_REMOTE_STEP3_MESSAGE = messages.getString("JavaApplicationIntegrationProvider_ManualRemoteStep3Message");
    private static final String MANUAL_REMOTE_STEP4_MESSAGE = messages.getString("JavaApplicationIntegrationProvider_ManualRemoteStep4Message");
    private static final String MANUAL_REMOTE_HINT_MESSAGE = messages.getString("JavaApplicationIntegrationProvider_ManualRemoteHintMessage");
    private static final String MANUAL_DIRECT_STEP1_MESSAGE = messages.getString("JavaApplicationIntegrationProvider_ManualDirectStep1Message");
    private static final String MANUAL_DIRECT_STEP2_MESSAGE = messages.getString("JavaApplicationIntegrationProvider_ManualDirectStep2Message");
    private static final String MANUAL_DYNAMIC_STEP1_MESSAGE = messages.getString("JavaApplicationIntegrationProvider_ManualDynamicStep1Message");
    private static final String MANUAL_DYNAMIC_STEP2_MESSAGE = messages.getString("JavaApplicationIntegrationProvider_ManualDynamicStep2Message");
    private static final String DYNAMIC_WARNING_MESSAGE = messages.getString("JavaApplicationIntegrationProvider_DynamicWarningMessage");
    private static final String APPLICATION_TITLE = messages.getString("JavaApplicationIntegrationProvider_Title");

    public JavaApplicationIntegrationProvider() {
        this.attachedWizard = new NullWizardStep();
    }

    public IntegrationProvider.IntegrationHints getAfterInstallationHints(AttachSettings attachSettings, boolean bl) {
        return null;
    }

    public IntegrationProvider.IntegrationHints getIntegrationReview(AttachSettings attachSettings) {
        return null;
    }

    public IntegrationProvider.IntegrationHints getModificationHints(AttachSettings attachSettings) {
        IntegrationProvider.IntegrationHints integrationHints = null;
        integrationHints = attachSettings.isRemote() ? this.getManualRemoteIntegrationStepsInstructions(attachSettings.getHostOS(), attachSettings) : (attachSettings.isDirect() ? this.getManualLocalDirectIntegrationStepsInstructions(attachSettings.getHostOS(), attachSettings) : this.getManualLocalDynamicIntegrationStepsInstructions(attachSettings.getHostOS(), attachSettings));
        return integrationHints;
    }

    public String getTitle() {
        return APPLICATION_TITLE;
    }

    public void categorize(IntegrationCategorizer integrationCategorizer) {
        integrationCategorizer.addApplication((IntegrationProvider)this, this.getAttachWizardPriority());
    }

    public void modify(AttachSettings attachSettings) {
    }

    public boolean supportsJVM(TargetPlatformEnum targetPlatformEnum, AttachSettings attachSettings) {
        if (attachSettings.isRemote() && targetPlatformEnum.equals((Object)TargetPlatformEnum.JDK_CVM) && (attachSettings.getHostOS() == IntegrationUtils.PLATFORM_LINUX_OS || attachSettings.getHostOS() == IntegrationUtils.PLATFORM_WINDOWS_OS)) {
            return true;
        }
        return super.supportsJVM(targetPlatformEnum, attachSettings);
    }

    public void run(AttachSettings attachSettings) {
    }

    public boolean supportsAutomation() {
        return false;
    }

    protected int getAttachWizardPriority() {
        return 10;
    }

    private IntegrationProvider.IntegrationHints getManualLocalDirectIntegrationStepsInstructions(String string, AttachSettings attachSettings) {
        IntegrationProvider.IntegrationHints integrationHints = new IntegrationProvider.IntegrationHints();
        integrationHints.addStep(MessageFormat.format(MANUAL_DIRECT_STEP1_MESSAGE, IntegrationUtils.getJavaPlatformName((String)this.getTargetJava()), IntegrationUtils.getProfilerAgentCommandLineArgs((String)string, (String)this.getTargetJava(), (boolean)attachSettings.isRemote(), (int)attachSettings.getPort())));
        integrationHints.addStep(MANUAL_DIRECT_STEP2_MESSAGE);
        if (IntegrationUtils.isWindowsPlatform((String)string)) {
            integrationHints.addWarning(this.SPACES_IN_PATH_WARNING_MSG);
        }
        integrationHints.addHint(this.REDUCE_OVERHEAD_MSG);
        return integrationHints;
    }

    private IntegrationProvider.IntegrationHints getManualLocalDynamicIntegrationStepsInstructions(String string, AttachSettings attachSettings) {
        IntegrationProvider.IntegrationHints integrationHints = new IntegrationProvider.IntegrationHints();
        integrationHints.addStep(MessageFormat.format(MANUAL_DYNAMIC_STEP1_MESSAGE, IntegrationUtils.getJavaPlatformName((String)this.getTargetJava())));
        integrationHints.addStep(MANUAL_DYNAMIC_STEP2_MESSAGE);
        if (IntegrationUtils.isWindowsPlatform((String)string)) {
            integrationHints.addWarning(this.SPACES_IN_PATH_WARNING_MSG);
        }
        integrationHints.addHint(this.REDUCE_OVERHEAD_MSG);
        integrationHints.addWarning(MessageFormat.format(DYNAMIC_WARNING_MESSAGE, IntegrationUtils.getJavaPlatformName((String)this.getTargetJava()), IntegrationUtils.getProfilerAgentCommandLineArgs((String)string, (String)this.getTargetJava(), (boolean)attachSettings.isRemote(), (int)attachSettings.getPort())));
        return integrationHints;
    }

    private IntegrationProvider.IntegrationHints getManualRemoteIntegrationStepsInstructions(String string, AttachSettings attachSettings) {
        IntegrationProvider.IntegrationHints integrationHints = new IntegrationProvider.IntegrationHints();
        integrationHints.addStep(this.getManualRemoteStep1(string));
        integrationHints.addStep(this.getManualRemoteStep2(string));
        integrationHints.addStep(MessageFormat.format(MANUAL_REMOTE_STEP3_MESSAGE, IntegrationUtils.getJavaPlatformName((String)this.getTargetJava()), IntegrationUtils.getProfilerAgentCommandLineArgs((String)string, (String)this.getTargetJava(), (boolean)attachSettings.isRemote(), (int)attachSettings.getPort()), this.REMOTE_ABSOLUTE_PATH_HINT));
        integrationHints.addStep(MANUAL_REMOTE_STEP4_MESSAGE);
        if (IntegrationUtils.isWindowsPlatform((String)string)) {
            integrationHints.addWarning(this.SPACES_IN_PATH_WARNING_MSG);
        }
        integrationHints.addHint(MessageFormat.format(MANUAL_REMOTE_HINT_MESSAGE, IntegrationUtils.getRemoteProfileCommandString((String)string)));
        integrationHints.addHint(this.REDUCE_OVERHEAD_MSG);
        return integrationHints;
    }
}

