/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.common.nodes.actions;

import java.util.concurrent.Future;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.glassfish.common.nodes.actions.RefreshModulesCookie;
import org.netbeans.modules.glassfish.common.nodes.actions.UndeployModuleCookie;
import org.netbeans.modules.glassfish.spi.GlassfishModule;
import org.netbeans.modules.glassfish.spi.ServerUtilities;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.NodeAction;

public class UndeployModuleAction
extends NodeAction {
    protected void performAction(Node[] nodeArray) {
        if (nodeArray == null || nodeArray.length < 1) {
            return;
        }
        for (Node node : nodeArray) {
            UndeployModuleCookie undeployModuleCookie = (UndeployModuleCookie)node.getCookie(UndeployModuleCookie.class);
            if (undeployModuleCookie == null) continue;
            final Future<GlassfishModule.OperationState> future = undeployModuleCookie.undeploy();
            final Node node2 = node.getParentNode().getParentNode();
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    try {
                        future.get(15000L, ServerUtilities.ACTION_TIMEOUT_UNIT);
                        if (node2 != null) {
                            Node[] nodeArray;
                            for (Node node : nodeArray = node2.getChildren().getNodes()) {
                                RefreshModulesCookie refreshModulesCookie = (RefreshModulesCookie)node.getCookie(RefreshModulesCookie.class);
                                if (refreshModulesCookie == null) continue;
                                refreshModulesCookie.refresh();
                            }
                        }
                    }
                    catch (TimeoutException timeoutException) {
                        Logger.getLogger("glassfish").log(Level.WARNING, "Timeout waiting on undeploy.", timeoutException);
                    }
                    catch (Exception exception) {
                        Logger.getLogger("glassfish").log(Level.INFO, exception.getLocalizedMessage(), exception);
                    }
                }
            });
        }
    }

    protected boolean enable(Node[] nodeArray) {
        for (Node node : nodeArray) {
            UndeployModuleCookie undeployModuleCookie = (UndeployModuleCookie)node.getCookie(UndeployModuleCookie.class);
            if (undeployModuleCookie != null && !undeployModuleCookie.isRunning()) continue;
            return false;
        }
        return true;
    }

    public String getName() {
        return NbBundle.getMessage(UndeployModuleAction.class, (String)"LBL_UndeployAction");
    }

    protected boolean asynchronous() {
        return false;
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }
}

