/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.common.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.net.ServerSocket;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.glassfish.common.GlassfishInstanceProvider;
import org.netbeans.modules.glassfish.common.Util;
import org.netbeans.modules.glassfish.spi.GlassfishModule;
import org.netbeans.modules.glassfish.spi.JrePicker;
import org.netbeans.modules.glassfish.spi.RegisteredDerbyServer;
import org.openide.awt.Mnemonics;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class VmCustomizer
extends JPanel {
    GlassfishModule gm;
    JrePicker picker = null;
    private JTextField addressValue;
    private ButtonGroup buttonGroup1;
    private JPanel debugSettingsPanel;
    private JTextField javaExecutableField;
    private JLabel javaInstallLabel;
    private JButton openDirectoryBrowser;
    private JPanel pickerPanel;
    private JCheckBox useIDEProxyInfo;
    private JRadioButton useSharedMemRB;
    private JRadioButton useSocketRB;
    private JCheckBox useUserDefinedAddress;

    public VmCustomizer(GlassfishModule glassfishModule) {
        this.gm = glassfishModule;
        this.initComponents();
    }

    private void initFields() {
        if (null != this.picker) {
            throw new UnsupportedOperationException("not implemented yet");
        }
        this.javaExecutableField.setText(this.gm.getInstanceProperties().get("java.platform"));
        String string = this.gm.getInstanceProperties().get("debugPort");
        if (null == string || "".equals(string)) {
            this.useUserDefinedAddress.setSelected(false);
            this.addressValue.setEditable(false);
        } else {
            this.useUserDefinedAddress.setSelected(true);
            this.addressValue.setEditable(true);
            this.addressValue.setText(string);
        }
        if (!"/".equals(File.separator)) {
            this.useSharedMemRB.setSelected("true".equals(this.gm.getInstanceProperties().get("use.shared.mem")));
            this.useSocketRB.setSelected(!"true".equals(this.gm.getInstanceProperties().get("use.shared.mem")));
        } else {
            this.useSharedMemRB.setEnabled(false);
            this.useSharedMemRB.setSelected(false);
            this.useSocketRB.setSelected(true);
        }
        this.useIDEProxyInfo.setSelected("true".equals(this.gm.getInstanceProperties().get("useIDEProxyOn")));
        boolean bl = this.gm.getInstanceProperties().get("domainsfolder") != null;
        this.javaExecutableField.setEnabled(bl);
        this.useIDEProxyInfo.setEnabled(bl);
        this.useSharedMemRB.setEnabled(bl);
    }

    private void persistFields() {
        if (null == this.picker) {
            File file;
            File file2;
            File file3;
            this.gm.setEnvironmentProperty("java.platform", this.javaExecutableField.getText(), true);
            RegisteredDerbyServer registeredDerbyServer = (RegisteredDerbyServer)Lookup.getDefault().lookup(RegisteredDerbyServer.class);
            if (null != registeredDerbyServer && (file3 = new File(this.javaExecutableField.getText().trim())).exists() && file3.canRead() && (file2 = new File(file = file3.getParentFile().getParentFile(), "db")).exists() && file2.isDirectory() && file2.canRead()) {
                registeredDerbyServer.initialize(file2.getAbsolutePath());
            }
        } else {
            throw new UnsupportedOperationException("not implemented yet");
        }
        this.gm.setEnvironmentProperty("use.shared.mem", Boolean.toString(this.useSharedMemRB.isSelected()), true);
        this.gm.setEnvironmentProperty("useIDEProxyOn", Boolean.toString(this.useIDEProxyInfo.isSelected()), true);
        this.gm.setEnvironmentProperty("debugPort", this.addressValue.getText().trim(), true);
    }

    public void addNotify() {
        super.addNotify();
        this.initFields();
    }

    public void removeNotify() {
        super.removeNotify();
        this.persistFields();
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.debugSettingsPanel = new JPanel();
        this.useSocketRB = new JRadioButton();
        this.useSharedMemRB = new JRadioButton();
        this.useUserDefinedAddress = new JCheckBox();
        this.addressValue = new JTextField();
        this.pickerPanel = new JPanel();
        this.javaInstallLabel = new JLabel();
        this.openDirectoryBrowser = new JButton();
        this.javaExecutableField = new JTextField();
        this.useIDEProxyInfo = new JCheckBox();
        this.setName(NbBundle.getMessage(VmCustomizer.class, (String)"VmCustomizer.name"));
        this.debugSettingsPanel.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(VmCustomizer.class, (String)"VmCustomizer.debugSettingsPanel.border.title.text")));
        this.buttonGroup1.add(this.useSocketRB);
        Mnemonics.setLocalizedText((AbstractButton)this.useSocketRB, (String)NbBundle.getMessage(VmCustomizer.class, (String)"VmCustomizer.useSocketRB.text"));
        this.buttonGroup1.add(this.useSharedMemRB);
        Mnemonics.setLocalizedText((AbstractButton)this.useSharedMemRB, (String)NbBundle.getMessage(VmCustomizer.class, (String)"VmCustomizer.useSharedMemRB.text"));
        this.useUserDefinedAddress.setText(NbBundle.getMessage(VmCustomizer.class, (String)"VmCustomizer.useUserDefinedAddress.text", (Object[])new Object[0]));
        this.useUserDefinedAddress.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                VmCustomizer.this.toggleAddressUsage(actionEvent);
            }
        });
        this.addressValue.setText(NbBundle.getMessage(VmCustomizer.class, (String)"VmCustomizer.addressValue.text", (Object[])new Object[0]));
        GroupLayout groupLayout = new GroupLayout((Container)this.debugSettingsPanel);
        this.debugSettingsPanel.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.useSharedMemRB).add((Component)this.useSocketRB).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.useUserDefinedAddress).addPreferredGap(0).add((Component)this.addressValue, -1, 404, Short.MAX_VALUE))).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.useSharedMemRB).addPreferredGap(0).add((Component)this.useSocketRB).add(8, 8, 8).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.useUserDefinedAddress).add((Component)this.addressValue, -2, -1, -2)).addContainerGap()));
        this.javaInstallLabel.setLabelFor(this.javaExecutableField);
        Mnemonics.setLocalizedText((JLabel)this.javaInstallLabel, (String)NbBundle.getMessage(VmCustomizer.class, (String)"VmCustomizer.javaInstallLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.openDirectoryBrowser, (String)NbBundle.getMessage(VmCustomizer.class, (String)"VmCustomizer.openDirectoryBrowser.text"));
        this.openDirectoryBrowser.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                VmCustomizer.this.openInstallChooser(actionEvent);
            }
        });
        this.javaExecutableField.setText(NbBundle.getMessage(VmCustomizer.class, (String)"VmCustomizer.javaExecutableField.text"));
        GroupLayout groupLayout2 = new GroupLayout((Container)this.pickerPanel);
        this.pickerPanel.setLayout((LayoutManager)groupLayout2);
        groupLayout2.setHorizontalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().addContainerGap().add((Component)this.javaInstallLabel).addPreferredGap(0).add((Component)this.javaExecutableField, -2, 308, -2).addPreferredGap(0).add((Component)this.openDirectoryBrowser).addContainerGap()));
        groupLayout2.setVerticalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout2.createParallelGroup(3).add((Component)this.javaInstallLabel).add((Component)this.javaExecutableField, -2, -1, -2).add((Component)this.openDirectoryBrowser)).addContainerGap()));
        this.useIDEProxyInfo.setText(NbBundle.getMessage(VmCustomizer.class, (String)"VmCustomizer.useIDEProxyInfo.text"));
        GroupLayout groupLayout3 = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout3);
        groupLayout3.setHorizontalGroup((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((GroupLayout.Group)groupLayout3.createSequentialGroup().add((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((Component)this.pickerPanel, -2, -1, -2).add((GroupLayout.Group)groupLayout3.createSequentialGroup().addContainerGap().add((Component)this.useIDEProxyInfo)).add((Component)this.debugSettingsPanel, -2, -1, Short.MAX_VALUE)).addContainerGap()));
        groupLayout3.setVerticalGroup((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((GroupLayout.Group)groupLayout3.createSequentialGroup().add((Component)this.pickerPanel, -2, -1, -2).add(9, 9, 9).add((Component)this.debugSettingsPanel, -1, 113, Short.MAX_VALUE).addPreferredGap(1).add((Component)this.useIDEProxyInfo).addContainerGap()));
    }

    private void openInstallChooser(ActionEvent actionEvent) {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setSelectedFile(new File(this.javaExecutableField.getText()));
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.setMultiSelectionEnabled(false);
        final String string = File.separatorChar == '/' ? "java" : "java.exe";
        jFileChooser.setFileFilter(new FileFilter(){

            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                if (file.getName().equalsIgnoreCase(string)) {
                    if (VmCustomizer.this.gm.getInstanceProvider().equals(GlassfishInstanceProvider.getEe6())) {
                        return Util.appearsToBeJdk6OrBetter(file);
                    }
                    return true;
                }
                return false;
            }

            public String getDescription() {
                return NbBundle.getMessage(VmCustomizer.class, (String)"VmCustomizer.filechooser.description");
            }
        });
        int n = jFileChooser.showOpenDialog(this);
        if (n == 0) {
            this.javaExecutableField.setText(jFileChooser.getSelectedFile().getAbsolutePath());
        }
    }

    private void toggleAddressUsage(ActionEvent actionEvent) {
        if (this.useUserDefinedAddress.isSelected()) {
            this.addressValue.setEnabled(true);
            int n = 9009;
            try {
                ServerSocket serverSocket = new ServerSocket(0);
                n = serverSocket.getLocalPort();
                serverSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.addressValue.setText(Integer.toString(n));
            this.addressValue.setEditable(true);
        } else {
            this.addressValue.setEditable(false);
            this.addressValue.setText("");
            this.addressValue.setEnabled(false);
        }
    }
}

