/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.actions;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowStateListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.openide.util.Utilities;
import org.openide.windows.WindowManager;

public final class PopupUtil {
    private static final String CLOSE_KEY = "CloseKey";
    private static final Action CLOSE_ACTION = new CloseAction();
    private static final KeyStroke ESC_KEY_STROKE = KeyStroke.getKeyStroke(27, 0);
    private static final String POPUP_NAME = "popupComponent";
    private static JDialog popupWindow;
    private static HideAWTListener hideListener;
    private static final int X_INSET = 10;
    private static final int Y_INSET = 10;

    private PopupUtil() {
    }

    public static boolean isPopupShowing() {
        return popupWindow != null;
    }

    public static void showPopup(JComponent jComponent, String string) {
        PopupUtil.showPopup(jComponent, string, -1, -1, false);
    }

    public static void showPopup(JComponent jComponent, String string, int n, int n2, boolean bl) {
        PopupUtil.showPopup(jComponent, string, n, n2, false, -1);
    }

    public static void showPopup(JComponent jComponent, String string, int n, int n2, boolean bl, int n3) {
        String string2;
        if (popupWindow != null) {
            return;
        }
        Toolkit.getDefaultToolkit().addAWTEventListener(hideListener, 16L);
        popupWindow = new JDialog(PopupUtil.getMainWindow());
        popupWindow.setName(POPUP_NAME);
        popupWindow.setUndecorated(bl);
        popupWindow.getRootPane().getInputMap(1).put(ESC_KEY_STROKE, CLOSE_KEY);
        popupWindow.getRootPane().getActionMap().put(CLOSE_KEY, CLOSE_ACTION);
        String string3 = jComponent.getAccessibleContext().getAccessibleName();
        if (string3 != null && !string3.equals("")) {
            popupWindow.getAccessibleContext().setAccessibleName(string3);
        }
        if ((string2 = jComponent.getAccessibleContext().getAccessibleDescription()) != null && !string2.equals("")) {
            popupWindow.getAccessibleContext().setAccessibleDescription(string2);
        }
        if (string != null) {
            // empty if block
        }
        popupWindow.getContentPane().add(jComponent);
        WindowManager.getDefault().getMainWindow().addWindowStateListener(hideListener);
        WindowManager.getDefault().getMainWindow().addComponentListener(hideListener);
        PopupUtil.resizePopup();
        if (n != -1) {
            Point point = PopupUtil.fitToScreen(n, n2, n3);
            popupWindow.setLocation(point.x, point.y);
        }
        popupWindow.setVisible(true);
        jComponent.requestFocus();
        jComponent.requestFocusInWindow();
    }

    public static void hidePopup() {
        if (popupWindow != null) {
            Toolkit.getDefaultToolkit().removeAWTEventListener(hideListener);
            popupWindow.setVisible(false);
            popupWindow.dispose();
        }
        WindowManager.getDefault().getMainWindow().removeWindowStateListener(hideListener);
        WindowManager.getDefault().getMainWindow().removeComponentListener(hideListener);
        popupWindow = null;
    }

    private static void resizePopup() {
        popupWindow.pack();
        Point point = new Point(0, 0);
        SwingUtilities.convertPointToScreen(point, PopupUtil.getMainWindow());
        popupWindow.setLocation(point.x + (PopupUtil.getMainWindow().getWidth() - popupWindow.getWidth()) / 2, point.y + (PopupUtil.getMainWindow().getHeight() - popupWindow.getHeight()) / 3);
    }

    private static Point fitToScreen(int n, int n2, int n3) {
        Rectangle rectangle = Utilities.getUsableScreenBounds();
        Point point = new Point(n, n2);
        if (point.x + popupWindow.getWidth() > rectangle.x + rectangle.width - 10) {
            point.x = rectangle.x + rectangle.width - 10 - popupWindow.getWidth();
        }
        if (point.y + popupWindow.getHeight() > rectangle.y + rectangle.height - 10) {
            point.y = point.y - popupWindow.getHeight() - n3;
        }
        return point;
    }

    private static Frame getMainWindow() {
        return WindowManager.getDefault().getMainWindow();
    }

    static {
        hideListener = new HideAWTListener();
    }

    private static class CloseAction
    extends AbstractAction {
        private CloseAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            PopupUtil.hidePopup();
        }
    }

    private static class MyFocusListener
    implements FocusListener {
        private MyFocusListener() {
        }

        public void focusLost(FocusEvent focusEvent) {
            System.out.println(focusEvent);
        }

        public void focusGained(FocusEvent focusEvent) {
            System.out.println(focusEvent);
        }
    }

    private static class HideAWTListener
    extends ComponentAdapter
    implements AWTEventListener,
    WindowStateListener {
        private HideAWTListener() {
        }

        public void eventDispatched(AWTEvent aWTEvent) {
            MouseEvent mouseEvent;
            if (aWTEvent instanceof MouseEvent && (mouseEvent = (MouseEvent)aWTEvent).getID() == 500 && mouseEvent.getClickCount() > 0) {
                if (!(aWTEvent.getSource() instanceof Component)) {
                    PopupUtil.hidePopup();
                    return;
                }
                Component component = (Component)aWTEvent.getSource();
                Container container = SwingUtilities.getAncestorNamed(PopupUtil.POPUP_NAME, component);
                if (container == null) {
                    PopupUtil.hidePopup();
                }
            }
        }

        public void windowStateChanged(WindowEvent windowEvent) {
            if (popupWindow != null) {
                int n = windowEvent.getOldState();
                int n2 = windowEvent.getNewState();
                if ((n & 1) == 0 && (n2 & 1) == 1) {
                    PopupUtil.hidePopup();
                }
            }
        }

        public void componentResized(ComponentEvent componentEvent) {
            if (popupWindow != null) {
                PopupUtil.resizePopup();
            }
        }

        public void componentMoved(ComponentEvent componentEvent) {
            if (popupWindow != null) {
                PopupUtil.resizePopup();
            }
        }
    }
}

