/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.index;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.csl.api.Modifier;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.php.editor.index.FunctionElement;
import org.netbeans.modules.php.editor.index.IndexedFullyQualified;
import org.netbeans.modules.php.editor.index.PHPIndex;
import org.netbeans.modules.php.editor.model.Parameter;
import org.netbeans.modules.php.editor.model.QualifiedName;
import org.netbeans.modules.php.editor.model.impl.ParameterImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexedFunction
extends IndexedFullyQualified
implements FunctionElement {
    List<Parameter> parameters;
    private String namespaceName;
    private String returnType;

    public IndexedFunction(String string, String string2, PHPIndex pHPIndex, String string3, List<Parameter> list, int n, int n2, ElementKind elementKind) {
        this(string, string2, null, pHPIndex, string3, list, n, n2, elementKind);
    }

    public IndexedFunction(String string, String string2, String string3, PHPIndex pHPIndex, String string4, List<Parameter> list, int n, int n2, ElementKind elementKind) {
        super(string, string2 != null ? string2 : string3, pHPIndex, string4, n, n2, elementKind);
        this.namespaceName = string3;
        this.parameters = list;
    }

    public IndexedFunction(String string, String string2, PHPIndex pHPIndex, String string3, String string4, int n, int n2, ElementKind elementKind) {
        this(string, string2, null, pHPIndex, string3, string4, n, n2, elementKind);
    }

    public IndexedFunction(String string, String string2, String string3, PHPIndex pHPIndex, String string4, String string5, int n, int n2, ElementKind elementKind) {
        super(string, string2 != null ? string2 : string3, pHPIndex, string4, n, n2, elementKind);
        this.namespaceName = string3;
        String[] stringArray = string5.split(",");
        this.parameters = new ArrayList<Parameter>();
        for (String string6 : stringArray) {
            this.parameters.add(new ParameterImpl(string6, null, null, OffsetRange.NONE));
        }
    }

    public String toString() {
        return this.getSignature();
    }

    @Override
    public String getSignature() {
        return this.getSignatureImpl(true, true);
    }

    public String getFunctionSignature(boolean bl) {
        return this.getSignatureImpl(false, bl);
    }

    private String getSignatureImpl(boolean bl, boolean bl2) {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.in != null && bl) {
            stringBuilder.append(this.in);
            stringBuilder.append('.');
        }
        stringBuilder.append(this.name);
        stringBuilder.append("(");
        List<Parameter> list = this.getParameters();
        if (list.size() > 0) {
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                List<QualifiedName> list2;
                if (i > 0) {
                    stringBuilder.append(", ");
                }
                Parameter parameter = list.get(i);
                if (bl2) {
                    list2 = parameter.getTypes();
                    if (list2.size() > 1) {
                        stringBuilder.append("mixed ");
                    } else {
                        for (QualifiedName qualifiedName : list2) {
                            stringBuilder.append(qualifiedName.toString()).append(' ');
                        }
                    }
                }
                stringBuilder.append(parameter.getName());
                if (!bl2 || (list2 = parameter.getDefaultValue()) == null) continue;
                stringBuilder.append(" = ").append((String)((Object)list2));
            }
        }
        stringBuilder.append(")");
        this.textSignature = stringBuilder.toString();
        return this.textSignature;
    }

    @Override
    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public boolean isDeprecated() {
        return false;
    }

    @Override
    public String getDisplayName() {
        String string = this.getModifiersString();
        return string.length() == 0 ? this.getSignature() : this.getModifiersString() + " " + this.getSignature();
    }

    @Override
    public Set<Modifier> getModifiers() {
        return super.getModifiers();
    }

    public int[] getOptionalArgs() {
        List<Parameter> list = this.getParameters();
        for (int i = 0; i < list.size(); ++i) {
            Parameter parameter = list.get(i);
            String string = parameter.getDefaultValue();
            if (string == null) continue;
            int[] nArray = new int[list.size() - i];
            for (int j = 0; j < nArray.length; ++j) {
                nArray[j] = i + j;
            }
            return nArray;
        }
        return new int[0];
    }

    @CheckForNull
    public String getReturnType() {
        return this.returnType;
    }

    void setReturnType(String string) {
        if (string != null && string.length() == 0) {
            throw new IllegalArgumentException("returnType cannot be empty string!");
        }
        this.returnType = string;
    }

    @Override
    public String getNamespaceName() {
        String string = this.namespaceName;
        return string != null ? string : "";
    }

    @Override
    public String getFullyQualifiedName() {
        QualifiedName qualifiedName = QualifiedName.createFullyQualified(this.name, this.namespaceName);
        return qualifiedName.toString();
    }
}

