/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.index;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.parsing.spi.indexing.support.IndexResult;
import org.netbeans.modules.parsing.spi.indexing.support.QuerySupport;
import org.netbeans.modules.php.api.util.Pair;
import org.netbeans.modules.php.editor.NamespaceIndexFilter;
import org.netbeans.modules.php.editor.index.IndexedClass;
import org.netbeans.modules.php.editor.index.IndexedClassMember;
import org.netbeans.modules.php.editor.index.IndexedConstant;
import org.netbeans.modules.php.editor.index.IndexedElement;
import org.netbeans.modules.php.editor.index.IndexedFunction;
import org.netbeans.modules.php.editor.index.IndexedInterface;
import org.netbeans.modules.php.editor.index.IndexedNamespace;
import org.netbeans.modules.php.editor.index.IndexedType;
import org.netbeans.modules.php.editor.index.IndexedVariable;
import org.netbeans.modules.php.editor.index.PHPIndexer;
import org.netbeans.modules.php.editor.index.Signature;
import org.netbeans.modules.php.editor.model.Parameter;
import org.netbeans.modules.php.editor.model.PhpKind;
import org.netbeans.modules.php.editor.model.QualifiedName;
import org.netbeans.modules.php.editor.model.impl.ParameterImpl;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.project.api.PhpSourcePath;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.Exceptions;
import org.openide.util.Parameters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PHPIndex {
    private static Collection<IndexedNamespace> namespacesCache = null;
    private static final Logger LOG = Logger.getLogger(PHPIndex.class.getName());
    public static final int ANY_ATTR = -1;
    private static String clusterUrl = null;
    private static final String CLUSTER_URL = "cluster:";
    private static final String[] TOP_LEVEL_TERMS = new String[]{"base", "const", "clz", "iface", "var", "ns"};
    private final QuerySupport index;
    private WeakHashMap<PHPParseResult, HashMap<String, Collection<String>>> includesCache = new WeakHashMap();
    private WeakHashMap<PHPParseResult, HashMap<String, Boolean>> isReachableCache = new WeakHashMap();
    private WeakHashMap<PHPParseResult, HashMap<String, Boolean>> isSystemFileCache = new WeakHashMap();

    private PHPIndex(QuerySupport querySupport) {
        this.index = querySupport;
    }

    public static PHPIndex get(Collection<FileObject> collection) {
        try {
            return new PHPIndex(QuerySupport.forRoots((String)"php", (int)10, (FileObject[])collection.toArray(new FileObject[collection.size()])));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return new PHPIndex(null);
        }
    }

    public static PHPIndex get(ParserResult parserResult) {
        return PHPIndex.get(QuerySupport.findRoots((FileObject)parserResult.getSnapshot().getSource().getFileObject(), Collections.singleton("classpath/php-source"), Collections.singleton("classpath/php-boot"), Collections.emptySet()));
    }

    public Collection<IndexedElement> getAllTopLevel(PHPParseResult pHPParseResult, String string, QuerySupport.Kind kind) {
        return this.getAllTopLevel(pHPParseResult, string, kind, EnumSet.allOf(PhpKind.class));
    }

    public Collection<IndexedElement> getAllTopLevel(PHPParseResult pHPParseResult, String string, QuerySupport.Kind kind, EnumSet<PhpKind> enumSet) {
        ArrayList<IndexedElement> arrayList = new ArrayList<IndexedElement>();
        ArrayList<IndexedFunction> arrayList2 = new ArrayList<IndexedFunction>();
        ArrayList<IndexedConstant> arrayList3 = new ArrayList<IndexedConstant>();
        ArrayList<IndexedClass> arrayList4 = new ArrayList<IndexedClass>();
        ArrayList<IndexedInterface> arrayList5 = new ArrayList<IndexedInterface>();
        ArrayList<IndexedVariable> arrayList6 = new ArrayList<IndexedVariable>();
        Collection<? extends IndexResult> collection = this.search("top", string.toLowerCase(), QuerySupport.Kind.PREFIX, TOP_LEVEL_TERMS);
        if (enumSet.contains((Object)PhpKind.FUNCTION)) {
            this.findFunctions(collection, kind, string, arrayList2);
        }
        if (enumSet.contains((Object)PhpKind.CONSTANT)) {
            this.findConstants(collection, kind, string, arrayList3);
        }
        if (enumSet.contains((Object)PhpKind.CLASS)) {
            this.findClasses(collection, kind, string, arrayList4);
        }
        if (enumSet.contains((Object)PhpKind.IFACE)) {
            this.findInterfaces(collection, kind, string, arrayList5);
        }
        if (enumSet.contains((Object)PhpKind.VARIABLE)) {
            this.findTopVariables(collection, kind, string, arrayList6);
        }
        arrayList.addAll(arrayList2);
        arrayList.addAll(arrayList3);
        arrayList.addAll(arrayList4);
        arrayList.addAll(arrayList5);
        arrayList.addAll(arrayList6);
        return arrayList;
    }

    protected void findInterfaces(Collection<? extends IndexResult> collection, QuerySupport.Kind kind, String string, Collection<IndexedInterface> collection2) {
        for (IndexResult indexResult : collection) {
            String[] stringArray = indexResult.getValues("iface");
            if (stringArray == null) continue;
            for (String string2 : stringArray) {
                String string3;
                Signature signature = Signature.get(string2);
                String string4 = signature.string(1);
                if (kind == QuerySupport.Kind.PREFIX || kind == QuerySupport.Kind.CASE_INSENSITIVE_PREFIX ? !string4.toLowerCase().startsWith(string.toLowerCase()) : kind == QuerySupport.Kind.EXACT && !string4.toLowerCase().equals(string.toLowerCase())) continue;
                int n = signature.integer(2);
                List<Object> list = Collections.emptyList();
                if (signature.string(3) != null && signature.string(3).trim().length() > 0) {
                    list = Arrays.asList(signature.string(3).split(","));
                }
                boolean bl = (string3 = signature.string(4)) != null && !"".equalsIgnoreCase(string3);
                IndexedInterface indexedInterface = new IndexedInterface(string4, bl ? string3 : null, this, indexResult.getUrl().toString(), list.toArray(new String[list.size()]), n, 0);
                collection2.add(indexedInterface);
            }
        }
    }

    protected void findClasses(Collection<? extends IndexResult> collection, QuerySupport.Kind kind, String string, Collection<IndexedClass> collection2) {
        for (IndexResult indexResult : collection) {
            String[] stringArray = indexResult.getValues("clz");
            if (stringArray == null) continue;
            for (String string2 : stringArray) {
                Signature signature = Signature.get(string2);
                String string3 = signature.string(1);
                if (kind == QuerySupport.Kind.PREFIX || kind == QuerySupport.Kind.CASE_INSENSITIVE_PREFIX ? !string3.toLowerCase().startsWith(string.toLowerCase()) : kind == QuerySupport.Kind.EXACT && !string3.toLowerCase().equals(string.toLowerCase())) continue;
                int n = signature.integer(2);
                String string4 = signature.string(3);
                string4 = string4.length() == 0 ? null : string4;
                String string5 = signature.string(4);
                boolean bl = string5 != null && !"".equalsIgnoreCase(string5);
                List<String> list = Collections.emptyList();
                if (signature.string(5) != null && signature.string(5).trim().length() > 0) {
                    list = Arrays.asList(signature.string(5).split(","));
                }
                IndexedClass indexedClass = new IndexedClass(string3, bl ? string5 : null, this, indexResult.getUrl().toString(), string4, list, n, 0);
                collection2.add(indexedClass);
            }
        }
    }

    protected void findConstants(Collection<? extends IndexResult> collection, QuerySupport.Kind kind, String string, Collection<IndexedConstant> collection2) {
        for (IndexResult indexResult : collection) {
            String[] stringArray = indexResult.getValues("const");
            if (stringArray == null) continue;
            for (String string2 : stringArray) {
                Signature signature = Signature.get(string2);
                String string3 = signature.string(1);
                if (kind == QuerySupport.Kind.PREFIX || kind == QuerySupport.Kind.CASE_INSENSITIVE_PREFIX ? !string3.toLowerCase().startsWith(string.toLowerCase()) : kind == QuerySupport.Kind.EXACT && !string3.toLowerCase().equals(string.toLowerCase())) continue;
                int n = signature.integer(2);
                String string4 = signature.string(3);
                boolean bl = string4 != null && !"".equalsIgnoreCase(string4);
                IndexedConstant indexedConstant = new IndexedConstant(string3, null, bl ? string4 : null, this, indexResult.getUrl().toString(), n, 0, null, ElementKind.CONSTANT);
                collection2.add(indexedConstant);
            }
        }
    }

    protected void findFunctions(Collection<? extends IndexResult> collection, QuerySupport.Kind kind, String string, Collection<IndexedFunction> collection2) {
        for (IndexResult indexResult : collection) {
            String[] stringArray = indexResult.getValues("base");
            if (stringArray == null) continue;
            for (String string2 : stringArray) {
                Signature signature = Signature.get(string2);
                String string3 = signature.string(1);
                if (kind == QuerySupport.Kind.PREFIX || kind == QuerySupport.Kind.CASE_INSENSITIVE_PREFIX ? !string3.startsWith(string) : kind == QuerySupport.Kind.EXACT && !string3.equalsIgnoreCase(string)) continue;
                int n = signature.integer(2);
                String string4 = signature.string(3);
                List<Parameter> list = ParameterImpl.toParameters(string4);
                String string5 = signature.string(5);
                boolean bl = string5 != null && !"".equalsIgnoreCase(string5);
                IndexedFunction indexedFunction = new IndexedFunction(string3, null, bl ? string5 : null, this, indexResult.getUrl().toString(), list, n, 0, ElementKind.METHOD);
                collection2.add(indexedFunction);
                String string6 = signature.string(4);
                string6 = string6.length() == 0 ? null : string6;
                indexedFunction.setReturnType(string6);
            }
        }
    }

    protected void findTopVariables(Collection<? extends IndexResult> collection, QuerySupport.Kind kind, String string, Collection<IndexedVariable> collection2) {
        for (IndexResult indexResult : collection) {
            String[] stringArray = indexResult.getValues("var");
            if (stringArray == null) continue;
            for (String string2 : stringArray) {
                Signature signature = Signature.get(string2);
                String string3 = signature.string(1);
                if (kind != QuerySupport.Kind.PREFIX && kind != QuerySupport.Kind.CASE_INSENSITIVE_PREFIX ? kind == QuerySupport.Kind.EXACT && !string3.equals(string) : !string3.startsWith(string)) continue;
                String string4 = signature.string(2);
                string4 = string4.length() == 0 ? null : string4;
                int n = signature.integer(3);
                IndexedVariable indexedVariable = new IndexedVariable(string3, null, this, indexResult.getUrl().toString(), n, 0, string4);
                collection2.add(indexedVariable);
            }
        }
    }

    private Collection<? extends IndexResult> search(String string, String string2, QuerySupport.Kind kind, String ... stringArray) {
        try {
            Collection collection = this.index.query(string, string2, kind, stringArray);
            if (LOG.isLoggable(Level.FINE)) {
                String string3 = "PHPIndex.search(" + string + ", " + string2 + ", " + kind + ", " + (stringArray == null || stringArray.length == 0 ? "no terms" : Arrays.asList(stringArray)) + ")";
                LOG.fine(string3);
                if (LOG.isLoggable(Level.FINEST)) {
                    LOG.log(Level.FINEST, null, new Throwable(string3));
                }
                for (IndexResult indexResult : collection) {
                    LOG.fine("Fields in " + indexResult + " (" + indexResult.getFile().getPath() + "):");
                    for (String string4 : PHPIndexer.ALL_FIELDS) {
                        String string5 = indexResult.getValue(string4);
                        if (string5 == null) continue;
                        LOG.fine(" <" + string4 + "> = <" + string5 + ">");
                    }
                    LOG.fine("----");
                }
                LOG.fine("====");
            }
            return collection;
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
            return Collections.emptySet();
        }
    }

    public static void setClusterUrl(String string) {
        clusterUrl = string;
    }

    static String getPreindexUrl(String string) {
        String string2 = PHPIndex.getClusterUrl();
        if (string.startsWith(string2)) {
            return CLUSTER_URL + string.substring(string2.length());
        }
        return string;
    }

    public static FileObject getFileObject(String string) {
        try {
            if (string.startsWith(CLUSTER_URL)) {
                string = PHPIndex.getClusterUrl() + string.substring(CLUSTER_URL.length());
            }
            URL uRL = new URL(string);
            return URLMapper.findFileObject((URL)uRL);
        }
        catch (MalformedURLException malformedURLException) {
            Exceptions.printStackTrace((Throwable)malformedURLException);
            return null;
        }
    }

    static String getClusterUrl() {
        if (clusterUrl == null) {
            File file = InstalledFileLocator.getDefault().locate("modules/org-netbeans-modules-php-editor.jar", null, false);
            if (file == null) {
                throw new RuntimeException("Can't find cluster");
            }
            file = new File(file.getParentFile().getParentFile().getAbsolutePath());
            try {
                file = file.getCanonicalFile();
                clusterUrl = file.toURI().toURL().toExternalForm();
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        return clusterUrl;
    }

    public Collection<IndexedClassMember<IndexedConstant>> getAllTypeConstants(PHPParseResult pHPParseResult, QualifiedName qualifiedName, String string, QuerySupport.Kind kind) {
        NamespaceIndexFilter namespaceIndexFilter = new NamespaceIndexFilter(qualifiedName.toString());
        String string2 = namespaceIndexFilter.getName();
        ArrayList<IndexedClassMember<IndexedConstant>> arrayList = new ArrayList<IndexedClassMember<IndexedConstant>>();
        FileObject fileObject = pHPParseResult != null ? pHPParseResult.getSnapshot().getSource().getFileObject() : null;
        Collection<IndexedType> collection = this.getTypeAncestors(pHPParseResult, string2);
        if (fileObject != null) {
            collection = PHPIndex.preferTypeElementsFromCurrentFile(fileObject, collection);
        }
        for (IndexedType object2 : collection) {
            arrayList.addAll(this.getTypeConstants(pHPParseResult, object2, string, kind));
        }
        arrayList = qualifiedName.getKind().isUnqualified() ? arrayList : namespaceIndexFilter.filter(arrayList, true);
        HashSet hashSet = new HashSet();
        HashSet<IndexedClassMember<IndexedConstant>> hashSet2 = new HashSet<IndexedClassMember<IndexedConstant>>();
        for (IndexedClassMember indexedClassMember : arrayList) {
            IndexedConstant indexedConstant = (IndexedConstant)indexedClassMember.getMember();
            IndexedType indexedType = indexedClassMember.getType();
            String string3 = indexedConstant.getName();
            if (hashSet.contains(string3) && !indexedType.getName().equals(string2)) continue;
            hashSet.add(string3);
            hashSet2.add(indexedClassMember);
        }
        return hashSet2;
    }

    public Collection<IndexedClassMember<IndexedConstant>> getAllTypeConstants(PHPParseResult pHPParseResult, String string, String string2, QuerySupport.Kind kind) {
        return this.getAllTypeConstants(pHPParseResult, QualifiedName.create(string), string2, kind);
    }

    public Collection<IndexedClassMember<IndexedFunction>> getAllMethods(PHPParseResult pHPParseResult, QualifiedName qualifiedName, String string, QuerySupport.Kind kind, int n) {
        NamespaceIndexFilter namespaceIndexFilter = new NamespaceIndexFilter(qualifiedName.toString());
        String string2 = namespaceIndexFilter.getName();
        String string3 = qualifiedName.toFullyQualified().toString();
        ArrayList<IndexedClassMember<IndexedFunction>> arrayList = new ArrayList<IndexedClassMember<IndexedFunction>>();
        FileObject fileObject = pHPParseResult != null ? pHPParseResult.getSnapshot().getSource().getFileObject() : null;
        Collection<IndexedType> collection = this.getTypeAncestors(pHPParseResult, string2);
        if (fileObject != null) {
            collection = PHPIndex.preferTypeElementsFromCurrentFile(fileObject, collection);
        }
        for (IndexedType object2 : collection) {
            int n2 = object2.getName().equals(string2) ? n : n & 0xFFFFFFFD;
            arrayList.addAll(this.getMethods(pHPParseResult, object2, string, kind, n2));
        }
        arrayList = qualifiedName.getKind().isUnqualified() ? arrayList : namespaceIndexFilter.filter(arrayList, true);
        HashSet hashSet = new HashSet();
        HashSet<IndexedClassMember<IndexedFunction>> hashSet2 = new HashSet<IndexedClassMember<IndexedFunction>>();
        for (IndexedClassMember indexedClassMember : arrayList) {
            IndexedFunction indexedFunction = (IndexedFunction)indexedClassMember.getMember();
            IndexedType indexedType = indexedClassMember.getType();
            String string4 = indexedFunction.getName();
            if (hashSet.contains(string4) && !indexedType.getFullyQualifiedName().equalsIgnoreCase(string3)) continue;
            hashSet.add(string4);
            hashSet2.add(indexedClassMember);
        }
        return hashSet2;
    }

    public Collection<IndexedClassMember<IndexedFunction>> getAllMethods(PHPParseResult pHPParseResult, String string, String string2, QuerySupport.Kind kind, int n) {
        return this.getAllMethods(pHPParseResult, QualifiedName.create(string), string2, kind, n);
    }

    public Collection<IndexedClassMember<IndexedConstant>> getAllFields(PHPParseResult pHPParseResult, QualifiedName qualifiedName, String string, QuerySupport.Kind kind, int n) {
        NamespaceIndexFilter namespaceIndexFilter = new NamespaceIndexFilter(qualifiedName.toString());
        String string2 = namespaceIndexFilter.getName();
        ArrayList<IndexedClassMember<IndexedConstant>> arrayList = new ArrayList<IndexedClassMember<IndexedConstant>>();
        FileObject fileObject = pHPParseResult != null ? pHPParseResult.getSnapshot().getSource().getFileObject() : null;
        Collection<IndexedType> collection = this.getClassAncestors(pHPParseResult, string2);
        if (fileObject != null) {
            collection = PHPIndex.preferTypeElementsFromCurrentFile(fileObject, collection);
        }
        for (IndexedType object2 : collection) {
            int n2 = object2.getName().equals(string2) ? n : n & 0xFFFFFFFD;
            arrayList.addAll(this.getFields(pHPParseResult, object2, string, kind, n2));
        }
        arrayList = qualifiedName.getKind().isUnqualified() ? arrayList : namespaceIndexFilter.filter(arrayList, true);
        HashSet hashSet = new HashSet();
        HashSet<IndexedClassMember<IndexedConstant>> hashSet2 = new HashSet<IndexedClassMember<IndexedConstant>>();
        for (IndexedClassMember indexedClassMember : arrayList) {
            IndexedConstant indexedConstant = (IndexedConstant)indexedClassMember.getMember();
            IndexedType indexedType = indexedClassMember.getType();
            String string3 = indexedConstant.getName();
            if (hashSet.contains(string3) && !indexedType.getName().equals(string2)) continue;
            hashSet.add(string3);
            hashSet2.add(indexedClassMember);
        }
        return hashSet2;
    }

    public Collection<IndexedClassMember<IndexedConstant>> getAllFields(PHPParseResult pHPParseResult, String string, String string2, QuerySupport.Kind kind, int n) {
        return this.getAllFields(pHPParseResult, QualifiedName.create(string), string2, kind, n);
    }

    public static <T extends IndexedElement> Collection<T> toMembers(Collection<? extends IndexedClassMember<T>> collection) {
        ArrayList<T> arrayList = new ArrayList<T>();
        for (IndexedClassMember<T> indexedClassMember : collection) {
            arrayList.add(indexedClassMember.getMember());
        }
        return arrayList;
    }

    private static <T extends IndexedType> Collection<T> preferTypeElementsFromCurrentFile(FileObject fileObject, Collection<T> collection) {
        FileObject fileObject2;
        Parameters.notNull((CharSequence)"fileObject", (Object)fileObject);
        ArrayList<IndexedType> arrayList = new ArrayList<IndexedType>();
        HashSet<String> hashSet = new HashSet<String>();
        for (IndexedType indexedType : collection) {
            assert (indexedType instanceof IndexedClass || indexedType instanceof IndexedInterface);
            fileObject2 = indexedType.getFileObject();
            if (fileObject2 == null || !fileObject2.equals(fileObject)) continue;
            hashSet.add(indexedType.getFullyQualifiedName());
        }
        for (IndexedType indexedType : collection) {
            if (hashSet.contains(indexedType.getFullyQualifiedName())) {
                fileObject2 = indexedType.getFileObject();
                if (fileObject2 != null && !fileObject2.equals(fileObject)) continue;
                arrayList.add(indexedType);
                continue;
            }
            arrayList.add(indexedType);
        }
        return arrayList;
    }

    public Collection<IndexedType> getTypeAncestors(PHPParseResult pHPParseResult, String string) {
        ArrayList<IndexedType> arrayList = new ArrayList<IndexedType>();
        arrayList.addAll(this.getClassAncestors(pHPParseResult, string));
        arrayList.addAll(this.getInterfaceAncestors(pHPParseResult, string));
        return arrayList;
    }

    @NonNull
    public Collection<IndexedType> getClassAncestors(PHPParseResult pHPParseResult, String string) {
        return this.getClassAncestors(pHPParseResult, string, new TreeSet<String>());
    }

    @NonNull
    private Collection<IndexedType> getClassAncestors(PHPParseResult pHPParseResult, String string, Collection<String> collection) {
        Object object;
        ArrayList<IndexedType> arrayList = new ArrayList<IndexedType>();
        List<Object> list = Collections.emptyList();
        if (collection.contains(string)) {
            return Collections.emptyList();
        }
        collection.add(string);
        LinkedList<Object> linkedList = new LinkedList<Object>();
        Collection<IndexedClass> collection2 = this.getClasses(pHPParseResult, string, QuerySupport.Kind.EXACT);
        if (collection2 != null) {
            for (IndexedClass object2 : collection2) {
                arrayList.add(object2);
                object = object2.getSuperClass();
                list = object2.getInterfaces();
                if (object == null) continue;
                linkedList.add(object);
            }
        }
        for (String string2 : linkedList) {
            arrayList.addAll(this.getClassAncestors(pHPParseResult, string2, collection));
        }
        for (String string3 : list) {
            object = this.getInterfaceAncestors(pHPParseResult, string3);
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                IndexedInterface indexedInterface = (IndexedInterface)iterator.next();
                arrayList.add(indexedInterface);
            }
        }
        return arrayList;
    }

    public Collection<IndexedInterface> getInterfaceAncestors(PHPParseResult pHPParseResult, String string) {
        return this.getInterfaceAncestors(pHPParseResult, string, new LinkedHashMap<String, IndexedInterface>());
    }

    private Collection<IndexedInterface> getInterfaceAncestors(PHPParseResult pHPParseResult, String string, Map<String, IndexedInterface> map) {
        for (IndexedInterface indexedInterface : this.getInterfaces(pHPParseResult, string, QuerySupport.Kind.EXACT)) {
            IndexedInterface indexedInterface2 = map.put(indexedInterface.getName(), indexedInterface);
            if (indexedInterface2 != null) continue;
            for (String string2 : indexedInterface.getInterfaces()) {
                this.getInterfaceAncestors(pHPParseResult, string2, map);
            }
        }
        return map.values();
    }

    public Collection<IndexedClassMember<IndexedConstant>> getTypeConstants(PHPParseResult pHPParseResult, IndexedType indexedType, String string, QuerySupport.Kind kind) {
        ArrayList<IndexedClassMember<IndexedConstant>> arrayList = new ArrayList<IndexedClassMember<IndexedConstant>>();
        Collection<IndexedConstant> collection = this.getTypeConstants(pHPParseResult, indexedType.getName(), string, kind);
        for (IndexedConstant indexedConstant : collection) {
            String string2;
            String string3 = indexedType.getName();
            if (!string3.equals(string2 = indexedConstant.getIn())) continue;
            FileObject fileObject = indexedType.getFileObject();
            FileObject fileObject2 = indexedConstant.getFileObject();
            if (fileObject != null && fileObject2 != null && fileObject != fileObject2) continue;
            arrayList.add(new IndexedClassMember<IndexedConstant>(indexedType, indexedConstant));
        }
        return arrayList;
    }

    public Collection<IndexedConstant> getTypeConstants(PHPParseResult pHPParseResult, String string, String string2, QuerySupport.Kind kind) {
        String[] stringArray;
        String[] stringArray2;
        int n;
        ArrayList<IndexedConstant> arrayList = new ArrayList<IndexedConstant>();
        List<Object> list = null;
        if (string != null) {
            list = this.getTypeSpecificSignatures(string, "clz.const", string2, kind);
        } else {
            list = new ArrayList();
            Iterator<Object> iterator = this.search("clz.const", string2, QuerySupport.Kind.CASE_INSENSITIVE_PREFIX, "clz.const", "clz").iterator();
            while (iterator.hasNext()) {
                n = 0;
                IndexResult pair = (IndexResult)iterator.next();
                stringArray2 = pair.getValues("clz");
                stringArray = stringArray2;
                int string4 = stringArray.length;
                if (n < string4) {
                    String string3 = stringArray[n];
                    string = PHPIndex.getSignatureItem(string3, 1);
                }
                for (String string5 : pair.getValues("clz.const")) {
                    String string6 = PHPIndex.getSignatureItem(string5, 0);
                    if (string6 == null || !(kind == QuerySupport.Kind.CASE_INSENSITIVE_PREFIX && string6.toLowerCase().startsWith(string2.toLowerCase()) || kind == QuerySupport.Kind.PREFIX && string6.startsWith(string2)) && (kind != QuerySupport.Kind.EXACT || !string6.equals(string2))) continue;
                    list.add(Pair.of((Object)string5, (Object)pair));
                }
            }
        }
        for (Pair pair : list) {
            stringArray2 = (String[])pair.first;
            stringArray = Signature.get((String)stringArray2);
            String string7 = stringArray.string(1);
            n = stringArray.integer(2);
            IndexedConstant indexedConstant = new IndexedConstant(string7, string, this, ((IndexResult)pair.second).getUrl().toString(), n, 0, null);
            arrayList.add(indexedConstant);
        }
        return arrayList;
    }

    public Collection<IndexedFunction> getConstructors(PHPParseResult pHPParseResult, String string) {
        QuerySupport.Kind kind = QuerySupport.Kind.CASE_INSENSITIVE_PREFIX;
        ArrayList<IndexedFunction> arrayList = new ArrayList<IndexedFunction>();
        String string2 = string;
        int n = -1;
        List<Pair<String, IndexResult>> list = this.getTypeSpecificSignatures(string, "constructor", string2, kind, true);
        for (Pair<String, IndexResult> pair : list) {
            String string3 = (String)pair.first;
            Signature signature = Signature.get(string3);
            int n2 = signature.integer(5);
            if ((n2 & 7) == 0) {
                n2 |= 1;
            }
            if ((n2 & n) == 0) continue;
            String string4 = signature.string(1);
            String string5 = signature.string(3);
            List<Parameter> list2 = ParameterImpl.toParameters(string5);
            int n3 = signature.integer(2);
            IndexedFunction indexedFunction = new IndexedFunction(string4, string4, signature.string(6), this, ((IndexResult)pair.second).getUrl().toString(), list2, n3, n2, ElementKind.METHOD);
            String string6 = signature.string(4);
            string6 = string6.length() == 0 ? null : string6;
            indexedFunction.setReturnType(string6);
            arrayList.add(indexedFunction);
        }
        return arrayList;
    }

    public Collection<IndexedClassMember<IndexedFunction>> getConstructors(PHPParseResult pHPParseResult, IndexedType indexedType) {
        ArrayList<IndexedClassMember<IndexedFunction>> arrayList = new ArrayList<IndexedClassMember<IndexedFunction>>();
        Collection<IndexedFunction> collection = this.getConstructors(pHPParseResult, indexedType.getName());
        for (IndexedFunction indexedFunction : collection) {
            String string;
            String string2 = indexedType.getName();
            if (!string2.equals(string = indexedFunction.getIn())) continue;
            FileObject fileObject = indexedType.getFileObject();
            FileObject fileObject2 = indexedFunction.getFileObject();
            if (fileObject != null && fileObject2 != null && fileObject != fileObject2) continue;
            arrayList.add(new IndexedClassMember<IndexedFunction>(indexedType, indexedFunction));
        }
        return arrayList;
    }

    public Collection<IndexedClassMember<IndexedFunction>> getMethods(PHPParseResult pHPParseResult, IndexedType indexedType, String string, QuerySupport.Kind kind, int n) {
        ArrayList<IndexedClassMember<IndexedFunction>> arrayList = new ArrayList<IndexedClassMember<IndexedFunction>>();
        Collection<IndexedFunction> collection = this.getMethods(pHPParseResult, indexedType.getName(), string, kind, n);
        for (IndexedFunction indexedFunction : collection) {
            String string2;
            String string3 = indexedType.getName();
            if (!string3.equals(string2 = indexedFunction.getIn())) continue;
            FileObject fileObject = indexedType.getFileObject();
            FileObject fileObject2 = indexedFunction.getFileObject();
            if (fileObject != null && fileObject2 != null && fileObject != fileObject2) continue;
            arrayList.add(new IndexedClassMember<IndexedFunction>(indexedType, indexedFunction));
        }
        return arrayList;
    }

    public Collection<IndexedFunction> getMethods(PHPParseResult pHPParseResult, String string, String string2, QuerySupport.Kind kind, int n) {
        Object object;
        String string32;
        int n2;
        String[] stringArray;
        String[] stringArray2;
        ArrayList<IndexedFunction> arrayList = new ArrayList<IndexedFunction>();
        List<Object> list = null;
        if (string != null) {
            list = this.getTypeSpecificSignatures(string, "method", string2, kind);
        } else {
            list = new ArrayList();
            Iterator<Object> iterator = this.search("method", string2, QuerySupport.Kind.CASE_INSENSITIVE_PREFIX, "method", "clz").iterator();
            while (iterator.hasNext()) {
                int string4 = 0;
                IndexResult pair = (IndexResult)iterator.next();
                stringArray2 = pair.getValues("clz");
                stringArray = stringArray2;
                n2 = stringArray.length;
                if (string4 < n2) {
                    string32 = stringArray[string4];
                    string = PHPIndex.getSignatureItem(string32, 1);
                }
                for (String string32 : pair.getValues("method")) {
                    object = PHPIndex.getSignatureItem(string32, 0);
                    if (object == null || !(kind == QuerySupport.Kind.CASE_INSENSITIVE_PREFIX && ((String)object).toLowerCase().startsWith(string2.toLowerCase()) || kind == QuerySupport.Kind.PREFIX && ((String)object).startsWith(string2)) && (kind != QuerySupport.Kind.EXACT || !((String)object).equals(string2))) continue;
                    list.add(Pair.of((Object)string32, (Object)pair));
                }
            }
        }
        for (Pair pair : list) {
            stringArray2 = (String[])pair.first;
            stringArray = Signature.get((String)stringArray2);
            n2 = stringArray.integer(5);
            if ((n2 & 7) == 0) {
                n2 |= 1;
            }
            if ((n2 & n) == 0) continue;
            String string4 = stringArray.string(1);
            string32 = stringArray.string(3);
            object = ParameterImpl.toParameters(string32);
            int n3 = stringArray.integer(2);
            IndexedFunction indexedFunction = new IndexedFunction(string4, string, this, ((IndexResult)pair.second).getUrl().toString(), (List<Parameter>)object, n3, n2, ElementKind.METHOD);
            String string5 = stringArray.string(4);
            string5 = string5.length() == 0 ? null : string5;
            indexedFunction.setReturnType(string5);
            arrayList.add(indexedFunction);
        }
        return arrayList;
    }

    public Collection<IndexedClassMember<IndexedConstant>> getFields(PHPParseResult pHPParseResult, IndexedType indexedType, String string, QuerySupport.Kind kind, int n) {
        ArrayList<IndexedClassMember<IndexedConstant>> arrayList = new ArrayList<IndexedClassMember<IndexedConstant>>();
        Collection<IndexedConstant> collection = this.getFields(pHPParseResult, indexedType.getName(), string, kind, n);
        for (IndexedConstant indexedConstant : collection) {
            String string2;
            String string3 = indexedType.getName();
            if (!string3.equals(string2 = indexedConstant.getIn())) continue;
            FileObject fileObject = indexedType.getFileObject();
            FileObject fileObject2 = indexedConstant.getFileObject();
            if (fileObject != null && fileObject2 != null && fileObject != fileObject2) continue;
            arrayList.add(new IndexedClassMember<IndexedConstant>(indexedType, indexedConstant));
        }
        return arrayList;
    }

    public Collection<IndexedConstant> getFields(PHPParseResult pHPParseResult, String string, String string2, QuerySupport.Kind kind, int n) {
        String string3;
        int n2;
        String[] stringArray;
        String[] stringArray2;
        ArrayList<IndexedConstant> arrayList = new ArrayList<IndexedConstant>();
        List<Object> list = null;
        if (string != null) {
            list = this.getTypeSpecificSignatures(string, "field", string2, kind);
        } else {
            list = new ArrayList();
            Iterator<Object> iterator = this.search("field", string2, QuerySupport.Kind.CASE_INSENSITIVE_PREFIX, "field", "clz").iterator();
            while (iterator.hasNext()) {
                int string5 = 0;
                IndexResult pair = (IndexResult)iterator.next();
                stringArray2 = pair.getValues("clz");
                stringArray = stringArray2;
                n2 = stringArray.length;
                if (string5 < n2) {
                    String n4 = stringArray[string5];
                    string = PHPIndex.getSignatureItem(n4, 1);
                }
                for (String n4 : pair.getValues("field")) {
                    string3 = PHPIndex.getSignatureItem(n4, 1);
                    if (string3 == null || !(kind == QuerySupport.Kind.CASE_INSENSITIVE_PREFIX && string3.toLowerCase().startsWith(string2.toLowerCase()) || kind == QuerySupport.Kind.PREFIX && string3.startsWith(string2)) && (kind != QuerySupport.Kind.EXACT || !string3.equals(string2))) continue;
                    list.add(Pair.of((Object)n4, (Object)pair));
                }
            }
        }
        for (Pair pair : list) {
            stringArray2 = (String[])pair.first;
            stringArray = Signature.get((String)stringArray2);
            n2 = stringArray.integer(3);
            if ((n2 & 7) == 0) {
                n2 |= 1;
            }
            if ((n2 & n) == 0) continue;
            String string4 = "$" + stringArray.string(1);
            int n3 = stringArray.integer(2);
            string3 = stringArray.string(4);
            if (string3.length() == 0) {
                string3 = null;
            }
            IndexedConstant indexedConstant = new IndexedConstant(string4, string, null, this, ((IndexResult)pair.second).getUrl().toString(), n3, n2, string3, ElementKind.FIELD);
            arrayList.add(indexedConstant);
        }
        return arrayList;
    }

    private List<Pair<String, IndexResult>> getTypeSpecificSignatures(String string, String string2, String string3, QuerySupport.Kind kind) {
        return this.getTypeSpecificSignatures(string, string2, string3, kind, false);
    }

    private List<Pair<String, IndexResult>> getTypeSpecificSignatures(String string, String string2, String string3, QuerySupport.Kind kind, boolean bl) {
        String[] stringArray;
        String[] stringArray2;
        ArrayList<Pair<String, IndexResult>> arrayList = new ArrayList<Pair<String, IndexResult>>();
        if (bl) {
            String[] stringArray3 = new String[1];
            stringArray2 = stringArray3;
            stringArray3[0] = "clz";
        } else {
            String[] stringArray4 = new String[2];
            stringArray4[0] = "clz";
            stringArray2 = stringArray4;
            stringArray4[1] = "iface";
        }
        for (String string4 : stringArray = stringArray2) {
            String[] stringArray5;
            String string5 = string.toLowerCase();
            if (bl) {
                String[] stringArray6 = new String[3];
                stringArray6[0] = string4;
                stringArray6[1] = string2;
                stringArray5 = stringArray6;
                stringArray6[2] = "constructor";
            } else {
                String[] stringArray7 = new String[3];
                stringArray7[0] = string4;
                stringArray7[1] = string2;
                stringArray5 = stringArray7;
                stringArray7[2] = "base";
            }
            Collection<? extends IndexResult> collection = this.search(string4, string5, QuerySupport.Kind.PREFIX, stringArray5);
            for (IndexResult indexResult : collection) {
                String[] stringArray8 = indexResult.getValues(string4);
                String[] stringArray9 = indexResult.getValues(string2);
                if (stringArray8 == null || stringArray9 == null) continue;
                String string6 = stringArray8.length > 0 ? PHPIndex.getSignatureItem(stringArray8[0], 1) : null;
                String string7 = string6 = string6 != null ? string6.toLowerCase() : null;
                if (bl ? string6 != null && string != null && !string6.startsWith(string.toLowerCase()) : string6 != null && string != null && !string.toLowerCase().equals(string6)) continue;
                for (String string8 : stringArray9) {
                    String string9 = PHPIndex.getSignatureItem(string8, bl ? 0 : 1);
                    if (string9 == null || !(kind == QuerySupport.Kind.CASE_INSENSITIVE_PREFIX && string9.toLowerCase().startsWith(string3.toLowerCase()) || kind == QuerySupport.Kind.PREFIX && string9.startsWith(string3)) && (kind != QuerySupport.Kind.EXACT || !string9.equals(string3))) continue;
                    arrayList.add((Pair<String, IndexResult>)Pair.of((Object)string8, (Object)indexResult));
                }
            }
        }
        return arrayList;
    }

    @CheckForNull
    static String getSignatureItem(String string, int n) {
        int n2 = 0;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (n2 == n) {
                for (int j = i; j < string.length(); ++j) {
                    c = string.charAt(j);
                    if (c != ';') continue;
                    return string.substring(i, j);
                }
            }
            if (c != ';') continue;
            ++n2;
        }
        return null;
    }

    public Collection<IndexedFunction> getFunctions(PHPParseResult pHPParseResult, String string, QuerySupport.Kind kind) {
        ArrayList<IndexedFunction> arrayList = new ArrayList<IndexedFunction>();
        Collection<? extends IndexResult> collection = this.search("base", string.toLowerCase(), QuerySupport.Kind.PREFIX, "base");
        this.findFunctions(collection, kind, string, arrayList);
        return arrayList;
    }

    public Collection<IndexedVariable> getTopLevelVariables(PHPParseResult pHPParseResult, String string, QuerySupport.Kind kind) {
        ArrayList<IndexedVariable> arrayList = new ArrayList<IndexedVariable>();
        Collection<? extends IndexResult> collection = this.search("var", string.toLowerCase(), QuerySupport.Kind.PREFIX, "var");
        this.findTopVariables(collection, kind, string, arrayList);
        return arrayList;
    }

    public Collection<IndexedConstant> getConstants(PHPParseResult pHPParseResult, String string, QuerySupport.Kind kind) {
        ArrayList<IndexedConstant> arrayList = new ArrayList<IndexedConstant>();
        Collection<? extends IndexResult> collection = this.search("const", string.toLowerCase(), QuerySupport.Kind.PREFIX, "const");
        this.findConstants(collection, kind, string, arrayList);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearNamespaceCache() {
        String string = CLUSTER_URL;
        synchronized (CLUSTER_URL) {
            namespacesCache = null;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<IndexedNamespace> getNamespaces(PHPParseResult pHPParseResult, String string) {
        ArrayList<IndexedNamespace> arrayList = new ArrayList<IndexedNamespace>();
        String string2 = CLUSTER_URL;
        synchronized (CLUSTER_URL) {
            if (namespacesCache == null) {
                LinkedHashMap linkedHashMap = new LinkedHashMap();
                for (IndexedNamespace indexedNamespace : this.getNamespacesImpl(pHPParseResult, "", QuerySupport.Kind.CASE_INSENSITIVE_PREFIX)) {
                    String string3 = indexedNamespace.getFullyQualifiedName();
                    IndexedNamespace indexedNamespace2 = null;
                    QualifiedName qualifiedName = QualifiedName.create(string3);
                    while (indexedNamespace2 == null && !qualifiedName.isDefaultNamespace()) {
                        indexedNamespace2 = linkedHashMap.put(qualifiedName.toFullyQualified().toString().toLowerCase(), new IndexedNamespace(qualifiedName.toName().toString(), qualifiedName.toNamespaceName().toString()));
                        qualifiedName = qualifiedName.toNamespaceName();
                    }
                }
                namespacesCache = linkedHashMap.values();
            }
            // ** MonitorExit[string2] (shouldn't be in output)
            string2 = string.toLowerCase();
            for (IndexedNamespace indexedNamespace : namespacesCache) {
                if (!indexedNamespace.getName().toLowerCase().startsWith(string2)) continue;
                arrayList.add(indexedNamespace);
            }
            return arrayList;
        }
    }

    public Collection<IndexedNamespace> getNamespacesImpl(PHPParseResult pHPParseResult, String string, QuerySupport.Kind kind) {
        ArrayList<IndexedNamespace> arrayList = new ArrayList<IndexedNamespace>();
        Collection<? extends IndexResult> collection = this.search("ns", string.toLowerCase(), QuerySupport.Kind.PREFIX, "ns");
        for (IndexResult indexResult : collection) {
            String[] stringArray = indexResult.getValues("ns");
            if (stringArray == null) continue;
            for (String string2 : stringArray) {
                Signature signature = Signature.get(string2);
                String string3 = signature.string(1);
                if (kind == QuerySupport.Kind.PREFIX || kind == QuerySupport.Kind.CASE_INSENSITIVE_PREFIX ? !string3.startsWith(string) : kind == QuerySupport.Kind.EXACT && !string3.toLowerCase().equals(string.toLowerCase())) continue;
                String string4 = signature.string(2);
                IndexedNamespace indexedNamespace = new IndexedNamespace(string3, string4);
                arrayList.add(indexedNamespace);
            }
        }
        return arrayList;
    }

    public Set<FileObject> filesWithIdentifiers(String string) {
        HashSet<FileObject> hashSet = new HashSet<FileObject>();
        Collection<? extends IndexResult> collection = this.search("identifier_used", string.toLowerCase(), QuerySupport.Kind.PREFIX, "base");
        for (IndexResult indexResult : collection) {
            URL uRL = indexResult.getUrl();
            FileObject fileObject = null;
            try {
                fileObject = "file".equals(uRL.getProtocol()) ? FileUtil.toFileObject((File)new File(uRL.toURI())) : URLMapper.findFileObject((URL)uRL);
            }
            catch (URISyntaxException uRISyntaxException) {
                Exceptions.printStackTrace((Throwable)uRISyntaxException);
            }
            if (fileObject == null) continue;
            hashSet.add(fileObject);
        }
        return hashSet;
    }

    public Collection<IndexedClass> getClasses(PHPParseResult pHPParseResult, String string, QuerySupport.Kind kind) {
        ArrayList<IndexedClass> arrayList = new ArrayList<IndexedClass>();
        Collection<? extends IndexResult> collection = this.search("clz", string.toLowerCase(), QuerySupport.Kind.PREFIX, new String[0]);
        this.findClasses(collection, kind, string, arrayList);
        return arrayList;
    }

    public Collection<IndexedInterface> getInterfaces(PHPParseResult pHPParseResult, String string, QuerySupport.Kind kind) {
        Collection<? extends IndexResult> collection = null;
        ArrayList<IndexedInterface> arrayList = new ArrayList<IndexedInterface>();
        collection = string != null && string.trim().length() > 0 ? this.search("iface", string.toLowerCase(), QuerySupport.Kind.PREFIX, new String[0]) : this.search("iface", string.toLowerCase(), QuerySupport.Kind.PREFIX, new String[0]);
        for (IndexResult indexResult : collection) {
            String[] stringArray = indexResult.getValues("iface");
            if (stringArray == null) continue;
            for (String string2 : stringArray) {
                Signature signature = Signature.get(string2);
                String string3 = signature.string(1);
                if (kind == QuerySupport.Kind.PREFIX ? !string3.toLowerCase().startsWith(string.toLowerCase()) : kind == QuerySupport.Kind.EXACT && !string3.toLowerCase().equals(string.toLowerCase())) continue;
                int n = signature.integer(2);
                String[] stringArray2 = signature.string(3).trim().length() == 0 ? new String[]{} : signature.string(3).split(",");
                String string4 = signature.string(4);
                boolean bl = string4 != null && !"".equalsIgnoreCase(string4);
                IndexedInterface indexedInterface = new IndexedInterface(string3, bl ? string4 : null, this, indexResult.getUrl().toString(), stringArray2, n, 0);
                arrayList.add(indexedInterface);
            }
        }
        return arrayList;
    }

    public Collection<String> getDirectIncludes(PHPParseResult pHPParseResult, String string) {
        assert (!string.startsWith("file:"));
        ArrayList<String> arrayList = new ArrayList<String>();
        Collection<? extends IndexResult> collection = this.search("filename", "file:" + string, QuerySupport.Kind.EXACT, new String[0]);
        for (IndexResult indexResult : collection) {
            String[] stringArray = indexResult.getValues("include");
            if (stringArray == null) continue;
            for (String string2 : stringArray) {
                for (String string3 : string2.split(";")) {
                    if (string3.length() <= 0) continue;
                    arrayList.add(string3);
                }
            }
        }
        return arrayList;
    }

    public Collection<String> getAllIncludes(PHPParseResult pHPParseResult, String string) {
        return this.getAllIncludes(pHPParseResult, string, new TreeSet<String>());
    }

    private Collection<String> getAllIncludes(PHPParseResult pHPParseResult, String string, Collection<String> collection) {
        Collection<String> collection2;
        HashMap<String, Collection<String>> hashMap = this.includesCache.get((Object)pHPParseResult);
        if (hashMap != null) {
            collection2 = hashMap.get(string);
            if (collection2 != null) {
                return collection2;
            }
        } else {
            hashMap = new HashMap();
            this.includesCache.put(pHPParseResult, hashMap);
        }
        collection2 = this.getAllIncludesImpl(pHPParseResult, string, collection);
        hashMap.put(string, collection2);
        return collection2;
    }

    private Collection<String> getAllIncludesImpl(PHPParseResult pHPParseResult, String string, Collection<String> collection) {
        TreeSet<String> treeSet = new TreeSet<String>();
        Collection<String> collection2 = this.getDirectIncludes(pHPParseResult, string);
        for (String string2 : collection2) {
            if (collection.contains(string2)) continue;
            collection.add(string2);
            treeSet.add(string2);
            treeSet.addAll(this.getAllIncludes(pHPParseResult, string2, collection));
        }
        return Collections.unmodifiableCollection(treeSet);
    }

    public boolean isReachable(PHPParseResult pHPParseResult, String string) {
        HashMap<String, Boolean> hashMap = this.isReachableCache.get((Object)pHPParseResult);
        if (hashMap != null) {
            Boolean bl = hashMap.get(string);
            if (bl != null) {
                return bl;
            }
        } else {
            hashMap = new HashMap();
            this.isReachableCache.put(pHPParseResult, hashMap);
        }
        boolean bl = this.isReachableImpl(pHPParseResult, string);
        hashMap.put(string, new Boolean(bl));
        return bl;
    }

    private boolean isReachableImpl(PHPParseResult pHPParseResult, String string) {
        if (this.isSystemFile(pHPParseResult, string)) {
            return true;
        }
        String string2 = null;
        try {
            string2 = pHPParseResult.getSnapshot().getSource().getFileObject().getURL().toExternalForm();
            if (string.equals(string2)) {
                return true;
            }
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            Exceptions.printStackTrace((Throwable)fileStateInvalidException);
        }
        Collection<String> collection = this.getAllIncludes(pHPParseResult, PHPIndex.fileURLToAbsPath(string2));
        return collection.contains(PHPIndex.fileURLToAbsPath(string));
    }

    private boolean isSystemFile(PHPParseResult pHPParseResult, String string) {
        HashMap<String, Boolean> hashMap = this.isSystemFileCache.get((Object)pHPParseResult);
        if (hashMap != null) {
            Boolean bl = hashMap.get(string);
            if (bl != null) {
                return bl;
            }
        } else {
            hashMap = new HashMap();
            this.isSystemFileCache.put(pHPParseResult, hashMap);
        }
        boolean bl = this.isSystemFileImpl(pHPParseResult, string);
        hashMap.put(string, new Boolean(bl));
        return bl;
    }

    private boolean isSystemFileImpl(PHPParseResult pHPParseResult, String string) {
        try {
            File file = new File(new URI(string));
            if (!file.exists()) {
                return false;
            }
            FileObject fileObject = FileUtil.toFileObject((File)file);
            PhpSourcePath.FileType fileType = PhpSourcePath.getFileType((FileObject)fileObject);
            if (fileType == PhpSourcePath.FileType.INTERNAL || fileType == PhpSourcePath.FileType.INCLUDE) {
                return true;
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            Exceptions.printStackTrace((Throwable)uRISyntaxException);
        }
        return false;
    }

    private static String fileURLToAbsPath(String string) {
        assert (string.startsWith("file:")) : string + " doesn't start with 'file:'";
        return string.substring("file:".length());
    }

    static String resolveRelativeURL(String string, String string2) {
        String string3;
        if (string2.startsWith("/")) {
            string3 = "/";
            string2 = string2.substring(1);
        } else {
            if (string == null || !string.startsWith("/")) {
                throw new IllegalArgumentException();
            }
            int n = (string = PHPIndex.resolveRelativeURL(null, string)).lastIndexOf(47);
            if (n == -1) {
                throw new IllegalArgumentException();
            }
            string3 = string.substring(0, n + 1);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "/", true);
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken();
            if (string4.equals("/")) {
                if (string3.endsWith("/")) continue;
                string3 = string3 + "/";
                continue;
            }
            if (string4.equals("") || string4.equals(".")) continue;
            if (string4.equals("..")) {
                String string5 = string3.substring(0, string3.length() - 1);
                int n = string5.lastIndexOf("/");
                if (n == -1) continue;
                string3 = string5.substring(0, n + 1);
                continue;
            }
            string3 = string3 + string4;
        }
        return string3;
    }

    private int[] extractOptionalArgs(String string) {
        if (string.length() == 0) {
            return new int[0];
        }
        String[] stringArray = string.split(",");
        int[] nArray = new int[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                nArray[i] = Integer.parseInt(stringArray[i]);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                System.err.println(String.format("*** couldnt parse '%s', part %d", string, i));
            }
        }
        return nArray;
    }
}

