/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.model;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.TreeSet;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.php.editor.index.PHPIndex;
import org.netbeans.modules.php.editor.model.Model;
import org.netbeans.modules.php.editor.model.ModelElement;
import org.netbeans.modules.php.editor.model.ModelFactory;
import org.netbeans.modules.php.editor.model.Occurence;
import org.netbeans.modules.php.editor.model.impl.ModelVisitor;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FindUsageSupport {
    private Set<FileObject> files;
    private ModelElement element;

    public static FindUsageSupport getInstance(PHPIndex pHPIndex, ModelElement modelElement) {
        return new FindUsageSupport(pHPIndex, modelElement);
    }

    private FindUsageSupport(PHPIndex pHPIndex, ModelElement modelElement) {
        this.element = modelElement;
        this.files = new LinkedHashSet<FileObject>();
        this.files.add(modelElement.getFileObject());
        String string = modelElement.getName();
        if (string.startsWith("$")) {
            string = string.substring(1);
        }
        this.files.addAll(pHPIndex.filesWithIdentifiers(string));
    }

    @CheckForNull
    public Collection<Occurence> occurences(FileObject fileObject) {
        final TreeSet<Occurence> treeSet = new TreeSet<Occurence>(new Comparator<Occurence>(){

            @Override
            public int compare(Occurence occurence, Occurence occurence2) {
                return occurence.getOccurenceRange().compareTo(occurence2.getOccurenceRange());
            }
        });
        try {
            ParserManager.parse(Collections.singleton(Source.create((FileObject)fileObject)), (UserTask)new UserTask(){

                public void run(ResultIterator resultIterator) throws Exception {
                    ParserResult parserResult = (ParserResult)resultIterator.getParserResult();
                    Model model = ModelFactory.getModel(parserResult);
                    ModelVisitor modelVisitor = model.getModelVisitor(FindUsageSupport.this.element);
                    Occurence occurence = modelVisitor.getOccurence(FindUsageSupport.this.element);
                    if (occurence != null) {
                        treeSet.addAll(occurence.getAllOccurences());
                    }
                }
            });
        }
        catch (ParseException parseException) {
            Exceptions.printStackTrace((Throwable)parseException);
        }
        return treeSet;
    }

    public Set<FileObject> inFiles() {
        return this.files;
    }

    public ModelElement elementToFind() {
        return this.element;
    }
}

