/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.model.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.php.editor.CodeUtils;
import org.netbeans.modules.php.editor.PredefinedSymbols;
import org.netbeans.modules.php.editor.index.IndexedVariable;
import org.netbeans.modules.php.editor.model.ClassScope;
import org.netbeans.modules.php.editor.model.FieldElement;
import org.netbeans.modules.php.editor.model.IndexScope;
import org.netbeans.modules.php.editor.model.MethodScope;
import org.netbeans.modules.php.editor.model.ModelElement;
import org.netbeans.modules.php.editor.model.ModelUtils;
import org.netbeans.modules.php.editor.model.PhpKind;
import org.netbeans.modules.php.editor.model.Scope;
import org.netbeans.modules.php.editor.model.TypeScope;
import org.netbeans.modules.php.editor.model.VariableName;
import org.netbeans.modules.php.editor.model.VariableScope;
import org.netbeans.modules.php.editor.model.impl.AssignmentImpl;
import org.netbeans.modules.php.editor.model.impl.FieldAssignmentImpl;
import org.netbeans.modules.php.editor.model.impl.FieldElementImpl;
import org.netbeans.modules.php.editor.model.impl.ScopeImpl;
import org.netbeans.modules.php.editor.model.impl.VarAssignmentImpl;
import org.netbeans.modules.php.editor.model.impl.VariousUtils;
import org.netbeans.modules.php.editor.model.nodes.ASTNodeInfo;
import org.netbeans.modules.php.editor.parser.astnodes.ArrayAccess;
import org.netbeans.modules.php.editor.parser.astnodes.Assignment;
import org.netbeans.modules.php.editor.parser.astnodes.Expression;
import org.netbeans.modules.php.editor.parser.astnodes.FieldAccess;
import org.netbeans.modules.php.editor.parser.astnodes.Variable;
import org.openide.filesystems.FileObject;
import org.openide.util.Union2;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class VariableNameImpl
extends ScopeImpl
implements VariableName {
    List<LazyFieldAssignment> assignmentDatas = new ArrayList<LazyFieldAssignment>();
    private TypeResolutionKind typeResolutionKind = TypeResolutionKind.LAST_ASSIGNMENT;
    private boolean globallyVisible;

    VariableNameImpl(IndexScope indexScope, IndexedVariable indexedVariable) {
        this((Scope)indexScope, indexedVariable.getName(), (Union2<String, FileObject>)Union2.createFirst((Object)indexedVariable.getFilenameUrl()), new OffsetRange(indexedVariable.getOffset(), indexedVariable.getOffset() + indexedVariable.getName().length()), true);
    }

    VarAssignmentImpl createAssignment(Scope scope, OffsetRange offsetRange, OffsetRange offsetRange2, Assignment assignment, Map<String, AssignmentImpl> map) {
        VarAssignmentImpl varAssignmentImpl = new VarAssignmentImpl(this, scope, offsetRange, offsetRange2, assignment, map);
        return varAssignmentImpl;
    }

    VariableNameImpl(Scope scope, Variable variable, boolean bl) {
        this(scope, VariableNameImpl.toName(variable), scope.getFile(), VariableNameImpl.toOffsetRange(variable), bl);
    }

    VariableNameImpl(Scope scope, String string, Union2<String, FileObject> union2, OffsetRange offsetRange, boolean bl) {
        super(scope, string, union2, offsetRange, PhpKind.VARIABLE);
        this.globallyVisible = bl;
    }

    void setTypeResolutionKind(TypeResolutionKind typeResolutionKind) {
        this.typeResolutionKind = typeResolutionKind;
    }

    static String toName(Variable variable) {
        return CodeUtils.extractVariableName(variable);
    }

    static OffsetRange toOffsetRange(Variable variable) {
        Expression expression = variable.getName();
        while (expression instanceof Variable) {
            Variable variable2;
            while (expression instanceof ArrayAccess) {
                variable2 = (ArrayAccess)expression;
                expression = ((ArrayAccess)variable2).getName();
            }
            if (!(expression instanceof Variable)) continue;
            variable2 = (Variable)expression;
            expression = variable2.getName();
        }
        return new OffsetRange(expression.getStartOffset(), expression.getEndOffset());
    }

    public List<? extends VarAssignmentImpl> getVarAssignments() {
        Collection collection = VariableNameImpl.filter(this.getElements(), new ScopeImpl.ElementFilter(){

            public boolean isAccepted(ModelElement modelElement) {
                return modelElement instanceof VarAssignmentImpl;
            }
        });
        return new ArrayList(collection);
    }

    private List<? extends FieldAssignmentImpl> getFieldAssignments() {
        Collection collection = VariableNameImpl.filter(this.getElements(), new ScopeImpl.ElementFilter(){

            public boolean isAccepted(ModelElement modelElement) {
                return modelElement instanceof FieldAssignmentImpl;
            }
        });
        return new ArrayList(collection);
    }

    AssignmentImpl findVarAssignment(int n) {
        return this.findAssignment(n, true, null);
    }

    AssignmentImpl findFieldAssignment(int n, FieldElement fieldElement) {
        return this.findAssignment(n, false, fieldElement);
    }

    String findFieldType(int n, String string) {
        String string2 = null;
        int n2 = -1;
        if (this.assignmentDatas.isEmpty() && (this.isGloballyVisible() || this.representsThis())) {
            VariableName variableName;
            VariableScope object;
            List<? extends VariableName> list;
            Object object2 = this.getInScope();
            if (object2 != null) {
                object2 = object2.getInScope();
            }
            if (object2 instanceof VariableScope && !(list = ModelUtils.filter((object = (VariableScope)object2).getDeclaredVariables(), this.getName())).isEmpty() && (variableName = ModelUtils.getFirst(list)) instanceof VariableNameImpl) {
                return ((VariableNameImpl)variableName).findFieldType(n, string);
            }
        }
        for (LazyFieldAssignment lazyFieldAssignment : this.assignmentDatas) {
            if (!lazyFieldAssignment.scope.getBlockRange().containsInclusive(n) || string2 != null && n2 > lazyFieldAssignment.startOffset || lazyFieldAssignment.startOffset >= n) continue;
            if (string.equals(lazyFieldAssignment.fldName)) {
                string2 = lazyFieldAssignment.typeName;
                continue;
            }
            if (lazyFieldAssignment.fldName.length() <= 0 || !string.equals(lazyFieldAssignment.fldName.substring(1))) continue;
            string2 = lazyFieldAssignment.typeName;
        }
        return string2;
    }

    AssignmentImpl findAssignment(int n, boolean bl, FieldElement fieldElement) {
        Object object;
        List<AssignmentImpl> list;
        AssignmentImpl scope = null;
        List<AssignmentImpl> list2 = list = bl ? this.getVarAssignments() : this.getFieldAssignments();
        if (list.size() == 1) {
            object = (AssignmentImpl)list.iterator().next();
            if (fieldElement == null || fieldElement.equals(((AssignmentImpl)object).getContainer())) {
                scope = object;
            }
        }
        if (scope == null) {
            if (list.isEmpty() && (this.isGloballyVisible() || this.representsThis())) {
                VariableName variableName;
                VariableScope scope2;
                List<? extends VariableName> list3;
                object = this.getInScope();
                if (object != null) {
                    object = object.getInScope();
                }
                if (object instanceof VariableScope && !(list3 = ModelUtils.filter((scope2 = (VariableScope)object).getDeclaredVariables(), this.getName())).isEmpty() && (variableName = ModelUtils.getFirst(list3)) instanceof VariableNameImpl) {
                    return ((VariableNameImpl)variableName).findAssignment(n, true, null);
                }
            }
            for (AssignmentImpl assignmentImpl : list) {
                if (!assignmentImpl.getBlockRange().containsInclusive(n) || scope != null && scope.getOffset() > assignmentImpl.getOffset() || assignmentImpl.getOffset() >= n || fieldElement != null && !fieldElement.equals(assignmentImpl.getContainer())) continue;
                scope = assignmentImpl;
            }
        }
        return scope;
    }

    @Override
    public String getNormalizedName() {
        Scope scope = this.getInScope();
        if (scope instanceof MethodScope) {
            String string = this.representsThis() ? "" : scope.getName();
            scope = scope.getInScope();
            return scope != null && !this.isGloballyVisible() ? scope.getName() + string + this.getName() : this.getName();
        }
        return scope != null && !this.isGloballyVisible() ? scope.getName() + this.getName() : this.getName();
    }

    @Override
    public Collection<? extends String> getTypeNames(int n) {
        return this.getTypeNamesImpl(n, false);
    }

    public Collection<? extends String> getArrayAccessTypeNames(int n) {
        return this.getTypeNamesImpl(n, true);
    }

    @Override
    public Collection<? extends TypeScope> getArrayAccessTypes(int n) {
        return this.getTypesImpl(n, true);
    }

    @Override
    public Collection<? extends TypeScope> getTypes(int n) {
        return this.getTypesImpl(n, false);
    }

    private Collection<? extends String> getTypeNamesImpl(int n, boolean bl) {
        TypeResolutionKind typeResolutionKind;
        if (this.representsThis()) {
            ClassScope classScope = (ClassScope)this.getInScope();
            return Collections.singletonList(classScope.getName());
        }
        Collection<Object> collection = Collections.emptyList();
        TypeResolutionKind typeResolutionKind2 = typeResolutionKind = bl ? TypeResolutionKind.MERGE_ASSIGNMENTS : this.typeResolutionKind;
        if (typeResolutionKind.equals((Object)TypeResolutionKind.LAST_ASSIGNMENT)) {
            AssignmentImpl assignmentImpl = this.findVarAssignment(n);
            while (assignmentImpl != null) {
                Collection<String> collection2 = assignmentImpl.getTypeNames();
                if (collection2.isEmpty() || assignmentImpl.isArrayAccess()) {
                    AssignmentImpl assignmentImpl2;
                    if (assignmentImpl.isArrayAccess()) {
                        collection = Collections.singleton("array");
                    }
                    if ((assignmentImpl2 = this.findVarAssignment(assignmentImpl.getOffset() - 1)) == null || assignmentImpl2.equals(assignmentImpl)) break;
                    assignmentImpl = assignmentImpl2;
                    continue;
                }
                return collection2;
            }
            return collection;
        }
        HashSet<String> hashSet = new HashSet<String>();
        List<? extends VarAssignmentImpl> list = this.getVarAssignments();
        for (VarAssignmentImpl varAssignmentImpl : list) {
            hashSet.addAll(varAssignmentImpl.getTypeNames());
        }
        return hashSet;
    }

    private Collection<? extends TypeScope> getTypesImpl(int n, boolean bl) {
        TypeResolutionKind typeResolutionKind;
        if (this.representsThis()) {
            ClassScope classScope = (ClassScope)this.getInScope();
            return Collections.singletonList(classScope);
        }
        TypeResolutionKind typeResolutionKind2 = typeResolutionKind = bl ? TypeResolutionKind.MERGE_ASSIGNMENTS : this.typeResolutionKind;
        if (typeResolutionKind.equals((Object)TypeResolutionKind.LAST_ASSIGNMENT)) {
            AssignmentImpl assignmentImpl = this.findVarAssignment(n);
            while (assignmentImpl != null) {
                Collection<TypeScope> collection = assignmentImpl.getTypes();
                if (collection.isEmpty() || assignmentImpl.isArrayAccess()) {
                    AssignmentImpl assignmentImpl2 = this.findVarAssignment(assignmentImpl.getOffset() - 1);
                    if (assignmentImpl2 != null && !assignmentImpl2.equals(assignmentImpl)) {
                        assignmentImpl = assignmentImpl2;
                        continue;
                    }
                    break;
                }
                return collection;
            }
        } else {
            HashSet<TypeScope> hashSet = new HashSet<TypeScope>();
            List<? extends VarAssignmentImpl> list = this.getVarAssignments();
            for (VarAssignmentImpl varAssignmentImpl : list) {
                hashSet.addAll(varAssignmentImpl.getTypes());
            }
            return hashSet;
        }
        return Collections.emptyList();
    }

    @Override
    public boolean isGloballyVisible() {
        String string = this.getName();
        if (string.startsWith("$")) {
            string = string.substring(1);
        }
        return this.globallyVisible || PredefinedSymbols.SUPERGLOBALS.contains(string);
    }

    void setGloballyVisible(boolean bl) {
        this.globallyVisible = bl;
    }

    @Override
    public boolean representsThis() {
        Scope scope = this.getInScope();
        return scope instanceof ClassScope && this.getName().equals("$this");
    }

    @Override
    public String getIndexSignature() {
        StringBuilder stringBuilder = new StringBuilder();
        String string = this.getName();
        stringBuilder.append(string.toLowerCase()).append(";");
        stringBuilder.append(string).append(";");
        stringBuilder.append(";");
        stringBuilder.append(this.getOffset()).append(";");
        return stringBuilder.toString();
    }

    void createLazyFieldAssignment(FieldAccess fieldAccess, Assignment assignment, Scope scope) {
        String string = CodeUtils.extractVariableName(fieldAccess.getField());
        if (string != null && !string.startsWith("$")) {
            string = "$" + string;
        }
        String string2 = VariousUtils.extractVariableTypeFromAssignment(assignment, Collections.<String, AssignmentImpl>emptyMap());
        ASTNodeInfo<FieldAccess> aSTNodeInfo = ASTNodeInfo.create(fieldAccess);
        OffsetRange offsetRange = aSTNodeInfo.getRange();
        int n = fieldAccess.getStartOffset();
        this.assignmentDatas.add(new LazyFieldAssignment(string2, string, offsetRange, n, scope));
    }

    @Override
    public Collection<? extends TypeScope> getFieldTypes(FieldElement fieldElement, int n) {
        this.processFieldAssignments();
        AssignmentImpl assignmentImpl = this.findFieldAssignment(n, fieldElement);
        return assignmentImpl != null ? assignmentImpl.getTypes() : fieldElement.getTypes(n);
    }

    void processFieldAssignments() {
        if (!this.assignmentDatas.isEmpty()) {
            for (LazyFieldAssignment lazyFieldAssignment : this.assignmentDatas) {
                lazyFieldAssignment.process();
            }
            this.assignmentDatas = Collections.emptyList();
        }
    }

    private class LazyFieldAssignment {
        private final String typeName;
        private final String fldName;
        private final OffsetRange range;
        private final int startOffset;
        private final Scope scope;

        private LazyFieldAssignment(String string, String string2, OffsetRange offsetRange, int n, Scope scope) {
            this.typeName = string;
            this.fldName = string2;
            this.range = offsetRange;
            this.startOffset = n;
            this.scope = scope;
        }

        void process() {
            Collection<? extends TypeScope> collection = VariableNameImpl.this.getTypes(this.startOffset);
            FieldElementImpl fieldElementImpl = null;
            TypeScope typeScope = ModelUtils.getFirst(collection);
            if (typeScope instanceof ClassScope) {
                ClassScope classScope = (ClassScope)typeScope;
                fieldElementImpl = (FieldElementImpl)ModelUtils.getFirst(classScope.findDeclaredFields(this.fldName, -1));
                if (fieldElementImpl != null) {
                    FieldAssignmentImpl fieldAssignmentImpl = new FieldAssignmentImpl(VariableNameImpl.this, fieldElementImpl, this.scope, this.scope.getBlockRange(), this.range, this.typeName);
                    VariableNameImpl.this.addElement(fieldAssignmentImpl);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum TypeResolutionKind {
        LAST_ASSIGNMENT,
        MERGE_ASSIGNMENTS;

    }
}

