/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.hyperlink;

import java.awt.Toolkit;
import java.util.EnumSet;
import java.util.Set;
import javax.swing.text.Document;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.lib.editor.hyperlink.spi.HyperlinkProviderExt;
import org.netbeans.lib.editor.hyperlink.spi.HyperlinkType;
import org.netbeans.modules.apisupport.project.spi.NbModuleProvider;
import org.openide.cookies.EditCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManifestHyperlinkProvider
implements HyperlinkProviderExt {
    public Set<HyperlinkType> getSupportedHyperlinkTypes() {
        return EnumSet.of(HyperlinkType.GO_TO_DECLARATION);
    }

    public boolean isHyperlinkPoint(Document document, int n, HyperlinkType hyperlinkType) {
        return this.getHyperlinkSpan(document, n, hyperlinkType) != null;
    }

    public int[] getHyperlinkSpan(Document document, int n, HyperlinkType hyperlinkType) {
        return ManifestHyperlinkProvider.getIdentifierSpan(document, n, null);
    }

    public void performClickAction(Document document, int n, HyperlinkType hyperlinkType) {
        EditCookie editCookie = this.getEditorCookie(document, n);
        if (editCookie != null) {
            editCookie.edit();
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    public String getTooltipText(Document document, int n, HyperlinkType hyperlinkType) {
        return null;
    }

    private EditCookie getEditorCookie(Document document, int n) {
        String string;
        TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)document);
        TokenSequence tokenSequence = tokenHierarchy.tokenSequence(Language.find((String)"text/x-manifest"));
        if (tokenSequence == null) {
            return null;
        }
        tokenSequence.move(n);
        if (!tokenSequence.moveNext()) {
            return null;
        }
        Token token = tokenSequence.token();
        FileObject fileObject = ManifestHyperlinkProvider.getFileObject(document);
        FileObject fileObject2 = ManifestHyperlinkProvider.findFile(fileObject, string = token.toString());
        if (fileObject2 != null) {
            try {
                DataObject dataObject = DataObject.find((FileObject)fileObject2);
                return (EditCookie)dataObject.getLookup().lookup(EditCookie.class);
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                Exceptions.printStackTrace((Throwable)dataObjectNotFoundException);
            }
        }
        return null;
    }

    private static FileObject findFile(FileObject fileObject, String string) {
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        if (project == null) {
            return null;
        }
        Sources sources = (Sources)project.getLookup().lookup(Sources.class);
        SourceGroup[] sourceGroupArray = sources.getSourceGroups("java");
        if (sourceGroupArray.length == 0) {
            return null;
        }
        ClassPath classPath = ClassPath.getClassPath((FileObject)sourceGroupArray[0].getRootFolder(), (String)"classpath/source");
        string = string.trim();
        return classPath.findResource(string);
    }

    public static int[] getIdentifierSpan(Document document, int n, Token[] tokenArray) {
        FileObject fileObject = ManifestHyperlinkProvider.getFileObject(document);
        if (fileObject == null) {
            return null;
        }
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        if (project == null) {
            return null;
        }
        NbModuleProvider nbModuleProvider = (NbModuleProvider)project.getLookup().lookup(NbModuleProvider.class);
        if (nbModuleProvider == null) {
            return null;
        }
        TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)document);
        TokenSequence tokenSequence = tokenHierarchy.tokenSequence(Language.find((String)"text/x-manifest"));
        if (tokenSequence == null) {
            return null;
        }
        tokenSequence.move(n);
        if (!tokenSequence.moveNext()) {
            return null;
        }
        Token token = tokenSequence.token();
        if (ManifestHyperlinkProvider.findFile(fileObject, token.toString()) != null) {
            return new int[]{tokenSequence.offset(), tokenSequence.offset() + token.length()};
        }
        return null;
    }

    private static FileObject getFileObject(Document document) {
        DataObject dataObject = (DataObject)document.getProperty("stream");
        return dataObject != null ? dataObject.getPrimaryFile() : null;
    }
}

