/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.queries;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.apisupport.project.NbModuleProject;
import org.netbeans.modules.apisupport.project.Util;
import org.netbeans.spi.java.classpath.ClassPathFactory;
import org.netbeans.spi.java.classpath.ClassPathImplementation;
import org.netbeans.spi.java.classpath.ClassPathProvider;
import org.netbeans.spi.java.classpath.PathResourceImplementation;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.java.project.classpath.support.ProjectClassPathSupport;
import org.netbeans.spi.project.support.ant.AntProjectEvent;
import org.netbeans.spi.project.support.ant.AntProjectListener;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.util.WeakListeners;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ClassPathProviderImpl
implements ClassPathProvider {
    private final NbModuleProject project;
    private ClassPath boot;
    private ClassPath source;
    private ClassPath compile;
    private ClassPath execute;
    private ClassPath testSource;
    private ClassPath testCompile;
    private ClassPath testExecute;
    private ClassPath funcTestSource;
    private ClassPath funcTestCompile;
    private ClassPath funcTestExecute;
    private Map<FileObject, ClassPath> extraCompilationUnitsCompile = null;
    private Map<FileObject, ClassPath> extraCompilationUnitsExecute = null;
    private static Logger LOG = Logger.getLogger(ClassPathProviderImpl.class.getName());

    public ClassPathProviderImpl(NbModuleProject nbModuleProject) {
        this.project = nbModuleProject;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ClassPath findClassPath(FileObject fileObject, String string) {
        FileObject fileObject2;
        if (string.equals("classpath/boot")) {
            if (this.boot != null) return this.boot;
            this.boot = ClassPathFactory.createClassPath((ClassPathImplementation)this.createPathFromProperty("nbjdk.bootclasspath"));
            return this.boot;
        }
        FileObject fileObject3 = this.project.getSourceDirectory();
        FileObject fileObject4 = this.project.getTestSourceDirectory("unit");
        FileObject fileObject5 = this.project.getTestSourceDirectory("qa-functional");
        File file = this.project.getClassesDirectory();
        file = file == null ? null : FileUtil.normalizeFile((File)file);
        FileObject fileObject6 = file == null || !file.exists() ? null : FileUtil.toFileObject((File)file);
        file = this.project.getTestClassesDirectory("unit");
        file = file == null ? null : FileUtil.normalizeFile((File)file);
        FileObject fileObject7 = fileObject2 = file == null || !file.exists() ? null : FileUtil.toFileObject((File)file);
        if (fileObject3 != null && (FileUtil.isParentOf((FileObject)fileObject3, (FileObject)fileObject) || fileObject == fileObject3)) {
            if (string.equals("classpath/compile")) {
                if (this.compile != null) return this.compile;
                this.compile = ClassPathFactory.createClassPath((ClassPathImplementation)this.createCompileClasspath());
                LOG.log(Level.FINE, "compile/execute-time classpath for file '" + fileObject.getPath() + "' (prj: " + this.project + "): " + this.compile);
                return this.compile;
            }
            if (string.equals("classpath/execute") || string.equals("classpath/processor")) {
                if (this.execute != null) return this.execute;
                this.execute = ClassPathFactory.createClassPath((ClassPathImplementation)this.createExecuteClasspath());
                return this.execute;
            }
            if (!string.equals("classpath/source")) return null;
            if (this.source != null) return this.source;
            this.source = ClassPathSupport.createClassPath((FileObject[])new FileObject[]{fileObject3});
            return this.source;
        }
        if (fileObject4 != null && (FileUtil.isParentOf((FileObject)fileObject4, (FileObject)fileObject) || fileObject == fileObject4)) {
            if (string.equals("classpath/compile")) {
                if (this.testCompile != null) return this.testCompile;
                this.testCompile = ClassPathFactory.createClassPath((ClassPathImplementation)this.createTestCompileClasspath("unit"));
                LOG.log(Level.FINE, "compile-time classpath for tests for file '" + fileObject.getPath() + "' (prj: " + this.project + "): " + this.testCompile);
                return this.testCompile;
            }
            if (string.equals("classpath/execute") || string.equals("classpath/processor")) {
                if (this.testExecute != null) return this.testExecute;
                this.testExecute = ClassPathFactory.createClassPath((ClassPathImplementation)this.createTestExecuteClasspath("unit"));
                LOG.log(Level.FINE, "runtime classpath for tests for file '" + fileObject.getPath() + "' (prj: " + this.project + "): " + this.testExecute);
                return this.testExecute;
            }
            if (!string.equals("classpath/source")) return null;
            if (this.testSource != null) return this.testSource;
            this.testSource = ClassPathSupport.createClassPath((FileObject[])new FileObject[]{fileObject4});
            return this.testSource;
        }
        if (fileObject5 != null && (FileUtil.isParentOf((FileObject)fileObject5, (FileObject)fileObject) || fileObject == fileObject5)) {
            if (string.equals("classpath/source")) {
                if (this.funcTestSource != null) return this.funcTestSource;
                this.funcTestSource = ClassPathSupport.createClassPath((FileObject[])new FileObject[]{fileObject5});
                return this.funcTestSource;
            }
            if (string.equals("classpath/compile")) {
                if (this.funcTestCompile != null) return this.funcTestCompile;
                this.funcTestCompile = ClassPathFactory.createClassPath((ClassPathImplementation)this.createTestCompileClasspath("qa-functional"));
                LOG.log(Level.FINE, "compile-time classpath for func tests for file '" + fileObject.getPath() + "' (prj: " + this.project + "): " + this.funcTestCompile);
                return this.funcTestCompile;
            }
            if (!string.equals("classpath/execute") && !string.equals("classpath/processor")) return null;
            if (this.funcTestExecute != null) return this.funcTestExecute;
            this.funcTestExecute = ClassPathFactory.createClassPath((ClassPathImplementation)this.createTestExecuteClasspath("qa-functional"));
            return this.funcTestExecute;
        }
        if (fileObject6 != null && (fileObject6.equals(fileObject) || FileUtil.isParentOf((FileObject)fileObject6, (FileObject)fileObject))) {
            if (!"classpath/execute".equals(string)) return null;
            try {
                ArrayList<PathResourceImplementation> arrayList = new ArrayList<PathResourceImplementation>();
                arrayList.add(ClassPathSupport.createResource((URL)fileObject6.getURL()));
                arrayList.addAll(this.createCompileClasspath().getResources());
                return ClassPathSupport.createClassPath(arrayList);
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                ErrorManager.getDefault().notify((Throwable)fileStateInvalidException);
                return null;
            }
        }
        if (fileObject2 != null && (fileObject2.equals(fileObject) || FileUtil.isParentOf((FileObject)fileObject2, (FileObject)fileObject))) {
            if (!"classpath/execute".equals(string)) return null;
            if (this.testExecute != null) return this.testExecute;
            this.testExecute = ClassPathFactory.createClassPath((ClassPathImplementation)this.createTestExecuteClasspath("unit"));
            LOG.log(Level.FINE, "runtime classpath for tests for file '" + fileObject.getPath() + "' (prj: " + this.project + "): " + this.testExecute);
            return this.testExecute;
        }
        if (FileUtil.getArchiveFile((FileObject)fileObject) != null && fileObject.equals(FileUtil.getArchiveRoot((FileObject)FileUtil.getArchiveFile((FileObject)fileObject)))) {
            File file2 = this.project.getModuleJarLocation();
            if (FileUtil.toFile((FileObject)FileUtil.getArchiveFile((FileObject)fileObject)).equals(file2)) {
                if (!"classpath/execute".equals(string)) return null;
                ArrayList<PathResourceImplementation> arrayList = new ArrayList<PathResourceImplementation>();
                arrayList.add(ClassPathSupport.createResource((URL)FileUtil.urlForArchiveOrDir((File)file2)));
                arrayList.addAll(this.createCompileClasspath().getResources());
                return ClassPathSupport.createClassPath(arrayList);
            }
        }
        this.calculateExtraCompilationUnits();
        for (Map.Entry<FileObject, ClassPath> entry : this.extraCompilationUnitsCompile.entrySet()) {
            FileObject fileObject8 = entry.getKey();
            if (!FileUtil.isParentOf((FileObject)fileObject8, (FileObject)fileObject) && fileObject != fileObject8) continue;
            if (string.equals("classpath/compile")) {
                return entry.getValue();
            }
            if (string.equals("classpath/execute")) {
                return this.extraCompilationUnitsExecute.get(fileObject8);
            }
            if (!string.equals("classpath/source")) return null;
            return ClassPathSupport.createClassPath((FileObject[])new FileObject[]{fileObject8});
        }
        return null;
    }

    private ClassPathImplementation createPathFromProperty(String string) {
        return ProjectClassPathSupport.createPropertyBasedClassPathImplementation((File)this.project.getProjectDirectoryFile(), (PropertyEvaluator)this.project.evaluator(), (String[])new String[]{string});
    }

    private ClassPathImplementation createCompileClasspath() {
        return this.createPathFromProperty("cp");
    }

    private void addPathFromProjectEvaluated(List<PathResourceImplementation> list, String string) {
        if (string != null) {
            for (String string2 : PropertyUtils.tokenizePath((String)string)) {
                URL uRL = FileUtil.urlForArchiveOrDir((File)this.project.getHelper().resolveFile(string2));
                if (uRL == null) continue;
                list.add(ClassPathSupport.createResource((URL)uRL));
            }
        }
    }

    private ClassPathImplementation createTestCompileClasspath(String string) {
        return this.createPathFromProperty("test." + string + ".cp");
    }

    private ClassPathImplementation createTestExecuteClasspath(String string) {
        return this.createPathFromProperty("test." + string + ".run.cp");
    }

    private ClassPathImplementation createExecuteClasspath() {
        return this.createPathFromProperty("run.cp");
    }

    private void calculateExtraCompilationUnits() {
        if (this.extraCompilationUnitsCompile != null) {
            return;
        }
        this.extraCompilationUnitsCompile = new HashMap<FileObject, ClassPath>();
        this.extraCompilationUnitsExecute = new HashMap<FileObject, ClassPath>();
        for (Map.Entry<FileObject, Element> entry : this.project.getExtraCompilationUnits().entrySet()) {
            final FileObject fileObject = entry.getKey();
            Element element = entry.getValue();
            Element element2 = Util.findElement(element, "classpath", "http://www.netbeans.org/ns/nb-module-project/3");
            assert (element2 != null) : "no <classpath> in " + element;
            final String string = Util.findText(element2);
            if (string == null) {
                this.extraCompilationUnitsCompile.put(fileObject, ClassPathSupport.createClassPath((URL[])new URL[0]));
                this.extraCompilationUnitsExecute.put(fileObject, ClassPathSupport.createClassPath((URL[])new URL[0]));
                continue;
            }
            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            class CPI
            implements ClassPathImplementation,
            PropertyChangeListener,
            AntProjectListener {
                final Set<String> relevantProperties = new HashSet<String>();
                final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
                String cpS = string;

                CPI() {
                    ClassPathProviderImpl.this.project.evaluator().addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)ClassPathProviderImpl.this.project.evaluator()));
                    ClassPathProviderImpl.this.project.getHelper().addAntProjectListener((AntProjectListener)WeakListeners.create(AntProjectListener.class, (EventListener)this, (Object)ClassPathProviderImpl.this.project.getHelper()));
                    Matcher matcher = Pattern.compile("\\$\\{([^{}]+)\\}").matcher(this.cpS);
                    while (matcher.find()) {
                        this.relevantProperties.add(matcher.group(1));
                    }
                }

                public List<? extends PathResourceImplementation> getResources() {
                    ArrayList arrayList = new ArrayList();
                    ClassPathProviderImpl.this.addPathFromProjectEvaluated(arrayList, ClassPathProviderImpl.this.project.evaluator().evaluate(this.cpS));
                    return arrayList;
                }

                public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
                    this.pcs.addPropertyChangeListener(propertyChangeListener);
                }

                public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
                    this.pcs.removePropertyChangeListener(propertyChangeListener);
                }

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (this.relevantProperties.contains(propertyChangeEvent.getPropertyName())) {
                        this.pcs.firePropertyChange("resources", null, null);
                    }
                }

                public void configurationXmlChanged(AntProjectEvent antProjectEvent) {
                    Element element = ClassPathProviderImpl.this.project.getExtraCompilationUnits().get(fileObject);
                    Element element2 = Util.findElement(element, "classpath", "http://www.netbeans.org/ns/nb-module-project/3");
                    assert (element2 != null) : "no <classpath> in " + element;
                    this.cpS = Util.findText(element2);
                    this.pcs.firePropertyChange("resources", null, null);
                }

                public void propertiesChanged(AntProjectEvent antProjectEvent) {
                }
            }
            CPI cPI = new CPI();
            this.extraCompilationUnitsCompile.put(fileObject, ClassPathFactory.createClassPath((ClassPathImplementation)cPI));
            ArrayList<PathResourceImplementation> arrayList = new ArrayList<PathResourceImplementation>();
            for (Element element3 : Util.findSubElements(element)) {
                if (!element3.getLocalName().equals("built-to")) continue;
                String string2 = Util.findText(element3);
                assert (string2 != null) : "Null content for <built-to> in " + this.project;
                String string3 = this.project.evaluator().evaluate(string2);
                if (string3 == null) continue;
                this.addPathFromProjectEvaluated(arrayList, string3);
            }
            this.extraCompilationUnitsExecute.put(fileObject, ClassPathFactory.createClassPath((ClassPathImplementation)ClassPathSupport.createProxyClassPathImplementation((ClassPathImplementation[])new ClassPathImplementation[]{cPI, ClassPathSupport.createClassPathImplementation(arrayList)})));
        }
    }

    public ClassPath[] getProjectClassPaths(String string) {
        Object object;
        if ("classpath/boot".equals(string) && (object = this.project.getSourceDirectory()) != null) {
            return new ClassPath[]{this.findClassPath((FileObject)object, "classpath/boot")};
        }
        object = new ArrayList(3);
        if ("classpath/compile".equals(string)) {
            FileObject fileObject;
            FileObject fileObject2;
            FileObject fileObject3 = this.project.getSourceDirectory();
            if (fileObject3 != null) {
                object.add(this.findClassPath(fileObject3, "classpath/compile"));
            }
            if ((fileObject2 = this.project.getTestSourceDirectory("unit")) != null) {
                object.add(this.findClassPath(fileObject2, "classpath/compile"));
            }
            if ((fileObject = this.project.getTestSourceDirectory("qa-functional")) != null) {
                object.add(this.findClassPath(fileObject, "classpath/compile"));
            }
            this.calculateExtraCompilationUnits();
            object.addAll(this.extraCompilationUnitsCompile.values());
        } else if ("classpath/execute".equals(string)) {
            FileObject fileObject;
            FileObject fileObject4;
            FileObject fileObject5 = this.project.getSourceDirectory();
            if (fileObject5 != null) {
                object.add(this.findClassPath(fileObject5, "classpath/execute"));
            }
            if ((fileObject4 = this.project.getTestSourceDirectory("unit")) != null) {
                object.add(this.findClassPath(fileObject4, "classpath/execute"));
            }
            if ((fileObject = this.project.getTestSourceDirectory("qa-functional")) != null) {
                object.add(this.findClassPath(fileObject, "classpath/execute"));
            }
            this.calculateExtraCompilationUnits();
            object.addAll(this.extraCompilationUnitsExecute.values());
        } else if ("classpath/source".equals(string)) {
            FileObject fileObject;
            FileObject fileObject6;
            FileObject fileObject7 = this.project.getSourceDirectory();
            if (fileObject7 != null) {
                object.add(this.findClassPath(fileObject7, "classpath/source"));
            }
            if ((fileObject6 = this.project.getTestSourceDirectory("unit")) != null) {
                object.add(this.findClassPath(fileObject6, "classpath/source"));
            }
            if ((fileObject = this.project.getTestSourceDirectory("qa-functional")) != null) {
                object.add(this.findClassPath(fileObject, "classpath/source"));
            }
            this.calculateExtraCompilationUnits();
            for (FileObject fileObject8 : this.extraCompilationUnitsCompile.keySet()) {
                object.add(ClassPathSupport.createClassPath((FileObject[])new FileObject[]{fileObject8}));
            }
        }
        return object.toArray(new ClassPath[object.size()]);
    }
}

